/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.evac.Evac;
import pyrosim.domain.evac.Pers;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class EvacRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Evac.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Map map;
        Evac evac = (Evac)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("EVAC");
        fDSRenderRecord.setValue("ID", evac.getName());
        fDSRenderRecord.setValue("FYI", evac.getProp("FYI"), false);
        UnitDouble[] unitDoubleArray = (UnitDouble[])evac.getProp("XB");
        UnitAABox unitAABox = new UnitAABox(new UnitPoint3D(unitDoubleArray[0], unitDoubleArray[2], unitDoubleArray[4]), new UnitPoint3D(unitDoubleArray[1], unitDoubleArray[3], unitDoubleArray[5]));
        EvacRenderer.renderXB(fDSRenderRecord, "XB", unitAABox.getMin(), unitAABox.getMax());
        Grid grid = (Grid)evac.getProp("MESH_ID");
        if (grid != null) {
            fDSRenderRecord.setValue("MESH_ID", grid.getName());
        }
        fDSRenderRecord.setValue("NUMBER_INITIAL_PERSONS", evac.getProp("NUMBER_INITIAL_PERSONS"));
        Pers pers = (Pers)evac.getProp("PERS_ID");
        if (pers != null) {
            fDSRenderRecord.setValue("PERS_ID", pers.getName());
        }
        fDSRenderRecord.setValue("ANGLE", evac.getProp("ANGLE"));
        EvacRenderer.renderColor(fDSRenderRecord, true, (Color)evac.getProp("AVATAR_RGB"), "AVATAR_RGB", "AVATAR_COLOR", null);
        Grid grid2 = (Grid)evac.getProp("FLOW_FIELD_ID");
        if (grid2 != null) {
            fDSRenderRecord.setValue("FLOW_FIELD_ID", grid2.getName());
        }
        if ((map = (Map)evac.getProp("KNOWN_DOOR_PROBS")) != null && !map.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList arrayList2 = new ArrayList();
            for (NamedPyroObject namedPyroObject : map.keySet()) {
                arrayList.add(namedPyroObject.getName());
                arrayList2.add(map.get(namedPyroObject));
            }
            fDSRenderRecord.setValue("KNOWN_DOOR_NAMES", arrayList);
            fDSRenderRecord.setValue("KNOWN_DOOR_PROBS", arrayList2);
        }
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

