/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.evac.Entr;
import pyrosim.domain.evac.Pers;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class EntrRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Entr.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Entr entr = (Entr)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("ENTR");
        fDSRenderRecord.setValue("ID", entr.getName());
        fDSRenderRecord.setValue("FYI", entr.getProp("FYI"), false);
        UnitDouble[] unitDoubleArray = (UnitDouble[])entr.getProp("XB");
        UnitAABox unitAABox = new UnitAABox(new UnitPoint3D(unitDoubleArray[0], unitDoubleArray[2], unitDoubleArray[4]), new UnitPoint3D(unitDoubleArray[1], unitDoubleArray[3], unitDoubleArray[5]));
        EntrRenderer.renderXB(fDSRenderRecord, "XB", unitAABox.getMin(), unitAABox.getMax());
        Grid grid = (Grid)entr.getProp("MESH_ID");
        if (grid != null) {
            fDSRenderRecord.setValue("MESH_ID", grid.getName());
        }
        fDSRenderRecord.setValue("IOR", entr.getProp("IOR"), false);
        fDSRenderRecord.setValue("MAX_FLOW", entr.getProp("MAX_FLOW"), false);
        fDSRenderRecord.setValue("MAX_HUMANS", entr.getProp("MAX_HUMANS"), false);
        fDSRenderRecord.setValue("TIME_START", entr.getProp("TIME_START"), false);
        fDSRenderRecord.setValue("TIME_STOP", entr.getProp("TIME_STOP"), false);
        Pers pers = (Pers)entr.getProp("PERS_ID");
        if (pers != null) {
            fDSRenderRecord.setValue("PERS_ID", pers.getName());
        }
        EntrRenderer.renderColor(fDSRenderRecord, true, (Color)entr.getProp("AVATAR_RGB"), "AVATAR_RGB", "AVATAR_COLOR", null);
        Map map = (Map)entr.getProp("KNOWN_DOOR_PROBS");
        if (map != null && !map.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList arrayList2 = new ArrayList();
            for (NamedPyroObject namedPyroObject : map.keySet()) {
                arrayList.add(namedPyroObject.getName());
                arrayList2.add(map.get(namedPyroObject));
            }
            fDSRenderRecord.setValue("KNOWN_DOOR_NAMES", arrayList);
            fDSRenderRecord.setValue("KNOWN_DOOR_PROBS", arrayList2);
        }
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

