/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.evac.Door;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class DoorRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Door.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Grid grid;
        Serializable serializable;
        Door door = (Door)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("DOOR");
        fDSRenderRecord.setValue("ID", door.getName());
        fDSRenderRecord.setValue("FYI", door.getProp("FYI"), false);
        UnitDouble[] unitDoubleArray = (UnitDouble[])door.getProp("XB");
        UnitAABox unitAABox = new UnitAABox(new UnitPoint3D(unitDoubleArray[0], unitDoubleArray[2], unitDoubleArray[4]), new UnitPoint3D(unitDoubleArray[1], unitDoubleArray[3], unitDoubleArray[5]));
        DoorRenderer.renderXB(fDSRenderRecord, "XB", unitAABox.getMin(), unitAABox.getMax());
        UnitDouble[] unitDoubleArray2 = (UnitDouble[])door.getProp("XYZ");
        if (unitDoubleArray2 != null) {
            serializable = new UnitPoint3D(unitDoubleArray2[0], unitDoubleArray2[1], unitDoubleArray2[2]);
            AFDS6Renderer.renderLoc(fDSRenderRecord, "XYZ", (UnitPoint3D)serializable);
        }
        if ((serializable = (Grid)door.getProp("MESH_ID")) != null) {
            fDSRenderRecord.setValue("MESH_ID", serializable.getName());
        }
        Integer n = (Integer)door.getProp("IOR");
        fDSRenderRecord.setValue("IOR", n, false);
        NamedPyroObject namedPyroObject = (NamedPyroObject)door.getProp("TO_NODE");
        if (namedPyroObject != null) {
            fDSRenderRecord.setValue("TO_NODE", namedPyroObject.getName());
        }
        Boolean bl = (Boolean)door.getProp("EXIT_SIGN");
        fDSRenderRecord.setValue("EXIT_SIGN", bl, false);
        Boolean bl2 = (Boolean)door.getProp("KEEP_XY");
        fDSRenderRecord.setValue("KEEP_XY", bl2, false);
        Grid grid2 = (Grid)door.getProp("VENT_FFIELD");
        if (grid2 != null) {
            fDSRenderRecord.setValue("VENT_FFIELD", grid2.getName());
        }
        if ((grid = (Grid)door.getProp("FLOW_FIELD_ID")) != null) {
            fDSRenderRecord.setValue("FLOW_FIELD_ID", grid.getName());
        }
        Color color = (Color)door.getProp("RGB");
        DoorRenderer.renderColor(fDSRenderRecord, true, color, "RGB", "COLOR", null);
        UnitDouble unitDouble = (UnitDouble)door.getProp("TIME_OPEN");
        fDSRenderRecord.setValue("TIME_OPEN", unitDouble);
        UnitDouble unitDouble2 = (UnitDouble)door.getProp("TIME_CLOSE");
        fDSRenderRecord.setValue("TIME_CLOSE", unitDouble2);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

