/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Grid;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ALogicOp;
import pyrosim.domain.controls.AndOp;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.NotOp;
import pyrosim.domain.controls.OrOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.devices.ASourceDevice;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IBeamDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IDeviceModel;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.simctrl.ISimCtrlDevice;
import pyrosim.domain.devices.simctrl.KillDevice;
import pyrosim.domain.devices.simctrl.RestartFileDevc;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.ISprayer;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.common.GeomUtil;
import pyrosim.io.fds.v6.renderers.AFDS6UniqueRenderer;
import pyrosim.io.fds.v6.renderers.ControlRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.io.fds.v6.renderers.TableRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class DeviceRenderer
extends AFDS6UniqueRenderer {
    private final ControlRenderer d_ctrlRenderer;
    private final PinConnectionRenderer d_pinConnections;
    private final QuantityMap d_quantityMap;
    private final Map<PropHasher, FDSRenderRecord> d_propMap;
    private final Map<FDSRenderRecord, PropHasher> d_revPropMap;
    private final List<Pair<IPyroObject, FDSRenderRecord>> d_devices;
    private final List<Pair<IPyroObject, FDSRenderRecord>> d_aspSamplers;
    private final List<Pair<IPyroObject, FDSRenderRecord>> d_asps;
    private final Map<AspiratorSampler, List<ReverseSamplerLine>> d_aspSampAspMap;
    private final Map<String, Ramp> d_ramps;
    private final Map<String, List<List<Double>>> d_tables;
    private final Map<DryPipe, DryPipeCtrl> d_dryPipeCtrlMap;
    private final List<IControl> d_addedControls;
    private final List<Grid> d_grids;
    private final Deque<IDevice> d_devcStack;

    public DeviceRenderer(FDSNameMap fDSNameMap, PinConnectionRenderer pinConnectionRenderer, QuantityMap quantityMap, ControlRenderer controlRenderer) {
        super(fDSNameMap);
        this.d_pinConnections = pinConnectionRenderer;
        this.d_ctrlRenderer = controlRenderer;
        this.d_propMap = new LinkedHashMap<PropHasher, FDSRenderRecord>();
        this.d_revPropMap = new LinkedIdentityHashMap<FDSRenderRecord, PropHasher>();
        this.d_quantityMap = quantityMap;
        this.d_devices = new ArrayList<Pair<IPyroObject, FDSRenderRecord>>();
        this.d_aspSamplers = new ArrayList<Pair<IPyroObject, FDSRenderRecord>>();
        this.d_asps = new ArrayList<Pair<IPyroObject, FDSRenderRecord>>();
        this.d_aspSampAspMap = new IdentityHashMap<AspiratorSampler, List<ReverseSamplerLine>>();
        this.d_ramps = new LinkedHashMap<String, Ramp>();
        this.d_tables = new LinkedHashMap<String, List<List<Double>>>();
        this.d_dryPipeCtrlMap = new IdentityHashMap<DryPipe, DryPipeCtrl>();
        this.d_addedControls = new ArrayList<IControl>();
        this.d_grids = new ArrayList<Grid>();
        this.d_devcStack = new ArrayDeque<IDevice>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(IDevice.class);
        set.add(IDeviceModel.class);
        set.add(Grid.class);
    }

    @Override
    public boolean markDependency(DepSnapshot depSnapshot, IPyroObject iPyroObject, boolean bl) {
        if (bl) {
            return true;
        }
        return !(iPyroObject instanceof IDeviceModel);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        for (Aspirator aDevice : theUtil.filter(collection, Aspirator.class)) {
            for (Aspirator.SamplerLine samplerLine : aDevice.getSamplerLines()) {
                List<ReverseSamplerLine> list = this.d_aspSampAspMap.get(samplerLine.d_sampler);
                if (list == null) {
                    list = new ArrayList<ReverseSamplerLine>();
                    this.d_aspSampAspMap.put(samplerLine.d_sampler, list);
                }
                list.add(new ReverseSamplerLine(aDevice, samplerLine));
            }
            this.renderAspirator(aDevice);
        }
        for (AspiratorSampler aspiratorSampler : theUtil.filter(collection, AspiratorSampler.class)) {
            this.renderAspiratorSampler(aspiratorSampler);
        }
        for (DryPipe dryPipe : theUtil.filter(collection, DryPipe.class)) {
            this.d_dryPipeCtrlMap.put(dryPipe, new DryPipeCtrl(dryPipe));
        }
        return super.render(iFDSRecordRenderer, collection) || !this.d_asps.isEmpty() || !this.d_aspSamplers.isEmpty();
    }

    @Override
    protected void doneRendering(IFDSRecordRenderer iFDSRecordRenderer) {
        this.d_ctrlRenderer.render(iFDSRecordRenderer, this.d_addedControls);
        iFDSRecordRenderer.props().pushProps();
        for (FDSRenderRecord fDSRenderRecord : this.d_propMap.values()) {
            iFDSRecordRenderer.props().setRenderMultiLine(fDSRenderRecord.getProperties().size() > 3);
            iFDSRecordRenderer.render(fDSRenderRecord, null);
        }
        iFDSRecordRenderer.props().popProps();
        if (!this.d_ramps.isEmpty()) {
            RampRenderer.render(iFDSRecordRenderer, this.d_ramps, this.d_pinConnections);
        }
        if (!this.d_tables.isEmpty()) {
            TableRenderer.render(iFDSRecordRenderer, this.d_tables);
        }
        Consumer<Pair> consumer = pair -> {
            if (pair.v1 instanceof IFreezable) {
                this.d_pinConnections.markForInputRetrieval(((IFreezable)pair.v1).getFreezePin(), (FDSRenderRecord)pair.v2, "NO_UPDATE_CTRL_ID", "NO_UPDATE_DEVC_ID");
            } else {
                iFDSRecordRenderer.render((FDSRenderRecord)pair.v2, (IPyroObject)pair.v1);
            }
        };
        this.d_aspSamplers.forEach(consumer);
        this.d_asps.forEach(consumer);
        this.d_devices.forEach(consumer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        if (iPyroObject instanceof Grid) {
            this.d_grids.add((Grid)iPyroObject);
            return false;
        }
        if (iPyroObject instanceof IDeviceModel) {
            if (iPyroObject instanceof SmokeLinkModel) {
                this.renderSmokeLinkModel(null, (SmokeLinkModel)iPyroObject);
                return true;
            } else if (iPyroObject instanceof SprinklerLinkModel) {
                this.renderSprinklerLinkModel(null, (SprinklerLinkModel)iPyroObject);
                return true;
            } else if (iPyroObject instanceof HeatLinkModel) {
                this.renderHeatLinkModel(null, (HeatLinkModel)iPyroObject);
                return true;
            } else {
                if (!(iPyroObject instanceof SprayModel)) return true;
                this.renderSprayModel(null, (SprayModel)iPyroObject);
            }
            return true;
        }
        IDevice iDevice = (IDevice)iPyroObject;
        if (iDevice instanceof LayerMeasurer) {
            this.renderLayerMsr((LayerMeasurer)iDevice);
            return false;
        } else if (iDevice instanceof ISimCtrlDevice) {
            FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("CTRL");
            String string = this.getNameMap().mapToName("CTRL", iDevice);
            fDSRenderRecord.setValue("ID", string);
            fDSRenderRecord.setValue("LATCH", false, false);
            this.d_pinConnections.markForInputRetrieval(((ISimCtrlDevice)iDevice).getInputPin(), fDSRenderRecord, "INPUT_ID", "INPUT_ID");
            DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, iDevice);
            if (iDevice instanceof KillDevice) {
                this.renderKillDevice(fDSRenderRecord, (KillDevice)iDevice);
                return false;
            } else {
                if (!(iDevice instanceof RestartFileDevc)) return false;
                this.renderRestartFileDevice(fDSRenderRecord, (RestartFileDevc)iDevice);
            }
            return false;
        } else if (iDevice instanceof ISprayer) {
            if (iDevice instanceof Nozzle) {
                this.renderNozzle(this.d_ramps, this.d_tables, (Nozzle)iDevice);
                return false;
            } else {
                if (!(iDevice instanceof Sprinkler)) return false;
                this.renderSprinkler(this.d_ramps, this.d_tables, (Sprinkler)iDevice);
            }
            return false;
        } else if (iDevice instanceof IDetector) {
            if (iDevice instanceof SprinklerLink) {
                this.renderSprinklerLink(this.d_ramps, this.d_tables, (SprinklerLink)iDevice);
                return false;
            } else if (iDevice instanceof HeatDetector) {
                this.renderHeatDetector(this.d_ramps, this.d_tables, (HeatDetector)iDevice);
                return false;
            } else if (iDevice instanceof SmokeDetector) {
                this.renderSmokeDetector(this.d_ramps, this.d_tables, (SmokeDetector)iDevice);
                return false;
            } else {
                if (!(iDevice instanceof Timer)) return false;
                this.renderTimer((Timer)iDevice);
            }
            return false;
        } else if (iDevice instanceof GasPointMeasurer) {
            if (iDevice instanceof Clock) {
                this.renderClock((Clock)iDevice);
                return false;
            } else if (iDevice instanceof Thermocouple) {
                this.renderThemocouple((Thermocouple)iDevice);
                return false;
            } else {
                this.renderGasPointMeasurer((GasPointMeasurer)iDevice);
            }
            return false;
        } else if (iDevice instanceof SolidPointMeasurer) {
            if (iDevice instanceof PressureCoeffMeasurer) {
                this.renderPressCoeffMsr((PressureCoeffMeasurer)iDevice);
                return false;
            } else if (iDevice instanceof InnerTempMeasurer) {
                this.renderInnerTempMsr((InnerTempMeasurer)iDevice);
                return false;
            } else if (iDevice instanceof GaugeHeatFluxMeasurer) {
                this.renderGaugeHeatFluxMsr((GaugeHeatFluxMeasurer)iDevice);
                return false;
            } else if (iDevice instanceof SolidDensityMeasurer) {
                this.renderSolidDensityMsr((SolidDensityMeasurer)iDevice);
                return false;
            } else {
                SolidPointMeasurer solidPointMeasurer = (SolidPointMeasurer)iDevice;
                FDSRenderRecord fDSRenderRecord = this.newDevcRecord(solidPointMeasurer.getOutputPins());
                this.renderSolidPointMeasurer(fDSRenderRecord, (SolidPointMeasurer)iDevice);
                this.addDevice(solidPointMeasurer, fDSRenderRecord);
            }
            return false;
        } else if (iDevice instanceof PathObscurationMeasurer) {
            this.renderPathObscurationMsr((PathObscurationMeasurer)iDevice);
            return false;
        } else if (iDevice instanceof FlowMeasurer) {
            this.renderFlowMeasurer((FlowMeasurer)iDevice);
            return false;
        } else if (iDevice instanceof AABoxMeasurer) {
            this.renderAABoxMeasurer((AABoxMeasurer)iDevice);
            return false;
        } else {
            if (!(iDevice instanceof HvacDevice)) return false;
            this.renderHvacDevice((HvacDevice)iDevice);
        }
        return false;
    }

    private FDSRenderRecord newDevcRecord(Collection<? extends IOutPin> collection) {
        return this.newDevcRecord(collection, false);
    }

    private FDSRenderRecord newDevcRecord(Collection<? extends IOutPin> collection, boolean bl) {
        return (FDSRenderRecord)this.d_pinConnections.generateRecord((String)"DEVC", (String)"ID", (IOutPin[])collection.toArray(new IOutPin[collection.size()])).v1;
    }

    private FDSRenderRecord newDevcRecord(IOutPin iOutPin) {
        Pair<FDSRenderRecord, Boolean> pair = this.d_pinConnections.generateRecord("DEVC", "ID", iOutPin);
        return (Boolean)pair.v2 != false ? (FDSRenderRecord)pair.v1 : null;
    }

    private FDSRenderRecord newDevcRecord(IDevice iDevice) {
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("DEVC");
        String string = this.getNameMap().generateName("DEVC", iDevice.getName());
        fDSRenderRecord.setValue("ID", string);
        return fDSRenderRecord;
    }

    private void renderQuantity(FDSRenderRecord fDSRenderRecord, IQuantity iQuantity) {
        this.d_quantityMap.renderQuantity(fDSRenderRecord, "QUANTITY", "PART_ID", "SPEC_ID", "MATL_ID", "DUCT_ID", "NODE_ID", iQuantity);
    }

    private void pushNestedDevc(IDevice iDevice) {
        this.d_devcStack.addLast(iDevice);
    }

    private void popNestedDevc(IDevice iDevice) {
        this.d_devcStack.removeLast();
    }

    private void addDevice(IPyroObject iPyroObject, FDSRenderRecord fDSRenderRecord) {
        if (iPyroObject instanceof ICustomFDSPropsContainer) {
            DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, (ICustomFDSPropsContainer)((Object)iPyroObject));
        }
        IPyroObject iPyroObject2 = !this.d_devcStack.isEmpty() ? (IPyroObject)this.d_devcStack.getFirst() : iPyroObject;
        this.d_devices.add(new Pair<IPyroObject, FDSRenderRecord>(iPyroObject2, fDSRenderRecord));
    }

    private void renderLayerMsr(LayerMeasurer layerMeasurer) {
        if (layerMeasurer.measureHeight()) {
            this.addLayerRec(layerMeasurer, Quantity.LAYER_HEIGHT, layerMeasurer.getHeightInfo());
        }
        if (layerMeasurer.measureLowerTemp()) {
            this.addLayerRec(layerMeasurer, Quantity.LOWER_TEMPERATURE, layerMeasurer.getLowerTempInfo());
        }
        if (layerMeasurer.measureUpperTemp()) {
            this.addLayerRec(layerMeasurer, Quantity.UPPER_TEMPERATURE, layerMeasurer.getUpperTempInfo());
        }
    }

    private void addLayerRec(IBeamDevice iBeamDevice, Quantity quantity, MeasureOutInfo measureOutInfo) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(measureOutInfo.getPins());
        this.renderQuantity(fDSRenderRecord, quantity.create());
        DeviceRenderer.renderXB(fDSRenderRecord, "XB", iBeamDevice.getBeam().getP1(), iBeamDevice.getBeam().getP2());
        this.renderAlarm(fDSRenderRecord, measureOutInfo.getPin().getUnitType(), measureOutInfo.getAlarmInfo());
        this.addDevice(iBeamDevice, fDSRenderRecord);
    }

    private void renderPathObscurationMsr(PathObscurationMeasurer pathObscurationMeasurer) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(pathObscurationMeasurer.getOutputPins());
        this.renderQuantity(fDSRenderRecord, pathObscurationMeasurer.getQuantity());
        DeviceRenderer.renderXB(fDSRenderRecord, "XB", pathObscurationMeasurer.getBeam().getP1(), pathObscurationMeasurer.getBeam().getP2());
        this.renderAlarm(fDSRenderRecord, pathObscurationMeasurer.getQuantity(), pathObscurationMeasurer.getMsrInfo().getAlarmInfo());
        this.addDevice(pathObscurationMeasurer, fDSRenderRecord);
    }

    private void renderFlowMeasurer(FlowMeasurer flowMeasurer) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(flowMeasurer.getOutputPins());
        this.renderQuantity(fDSRenderRecord, flowMeasurer.getQuantity());
        Integer n = null;
        String string = fDSRenderRecord.getString("QUANTITY");
        if (flowMeasurer.getQuantity().get().quantityType == QuantityType.GAS) {
            switch (flowMeasurer.getFlowDir()) {
                case 1: {
                    string = string + " -";
                    break;
                }
                case 0: {
                    string = string + " +";
                }
            }
        } else {
            AARectangle aARectangle = flowMeasurer.getRect();
            block4 : switch (flowMeasurer.getFlowDir()) {
                case 0: {
                    switch (aARectangle.d_plane) {
                        case 0: {
                            n = 1;
                            break;
                        }
                        case 1: {
                            n = 2;
                            break;
                        }
                        case 2: {
                            n = 3;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (aARectangle.d_plane) {
                        case 0: {
                            n = -1;
                            break block4;
                        }
                        case 1: {
                            n = -2;
                            break block4;
                        }
                        case 2: {
                            n = -3;
                        }
                    }
                }
            }
        }
        fDSRenderRecord.setValue("QUANTITY", string);
        if (n != null) {
            fDSRenderRecord.setValue("IOR", n);
        }
        DeviceRenderer.renderAARectangle(fDSRenderRecord, "XB", flowMeasurer.getRect());
        this.renderAlarm(fDSRenderRecord, flowMeasurer.getQuantity(), flowMeasurer.getMsrInfo().getAlarmInfo());
        this.addDevice(flowMeasurer, fDSRenderRecord);
    }

    private void renderAABoxMeasurer(AABoxMeasurer aABoxMeasurer) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(aABoxMeasurer.getOutputPins());
        this.renderQuantity(fDSRenderRecord, aABoxMeasurer.getQuantity());
        DeviceRenderer.renderAABox(fDSRenderRecord, "XB", aABoxMeasurer.getBox());
        this.renderAlarm(fDSRenderRecord, aABoxMeasurer.getQuantity(), aABoxMeasurer.getMsrInfo().getAlarmInfo());
        this.addDevice(aABoxMeasurer, fDSRenderRecord);
    }

    private void renderHvacDevice(HvacDevice hvacDevice) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(hvacDevice);
        this.renderQuantity(fDSRenderRecord, hvacDevice.getQuantity());
        this.addDevice(hvacDevice, fDSRenderRecord);
    }

    private void renderRestartFileDevice(FDSRenderRecord fDSRenderRecord, RestartFileDevc restartFileDevc) {
        fDSRenderRecord.setValue("FUNCTION_TYPE", "RESTART");
    }

    private void renderKillDevice(FDSRenderRecord fDSRenderRecord, KillDevice killDevice) {
        fDSRenderRecord.setValue("FUNCTION_TYPE", "KILL");
    }

    private void renderTripFlags(FDSRenderRecord fDSRenderRecord, int n) {
        fDSRenderRecord.setValue("INITIAL_STATE", TripFlags.initiallyOn(n), false);
        fDSRenderRecord.setValue("LATCH", TripFlags.latch(n), false);
    }

    private void renderAlarm(FDSRenderRecord fDSRenderRecord, IQuantity iQuantity, AlarmInfo alarmInfo) {
        this.renderAlarm(fDSRenderRecord, iQuantity.get().unitType, alarmInfo);
    }

    private void renderAlarm(FDSRenderRecord fDSRenderRecord, int n, AlarmInfo alarmInfo) {
        if (alarmInfo != null) {
            fDSRenderRecord.setValue("SETPOINT", alarmInfo.setpoint.getValue(SIUS.unit(n)), true);
            this.renderTripFlags(fDSRenderRecord, alarmInfo.tripFlags);
        } else {
            this.renderDefDeviceProps(fDSRenderRecord);
        }
    }

    private void renderAspirator(Aspirator aspirator) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(aspirator.getOutputPins());
        fDSRenderRecord.setValue("QUANTITY", "ASPIRATION");
        this.renderFreePointLoc(fDSRenderRecord, aspirator.getLocation());
        fDSRenderRecord.setValue("BYPASS_FLOWRATE", aspirator.getBypassFlowrate(), true);
        this.renderAlarm(fDSRenderRecord, aspirator.getQuantity(), aspirator.getMsrInfo().getAlarmInfo());
        this.d_asps.add(new Pair<Aspirator, FDSRenderRecord>(aspirator, fDSRenderRecord));
        DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, aspirator);
    }

    private void renderAspiratorSampler(AspiratorSampler aspiratorSampler) {
        ObjectQuantity objectQuantity = Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT"));
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(aspiratorSampler.getOutputPins());
        this.renderQuantity(fDSRenderRecord, objectQuantity);
        this.renderFreePointLoc(fDSRenderRecord, aspiratorSampler.getLocation());
        this.renderAlarm(fDSRenderRecord, objectQuantity, aspiratorSampler.getMsrInfo().getAlarmInfo());
        this.d_aspSamplers.add(new Pair<AspiratorSampler, FDSRenderRecord>(aspiratorSampler, fDSRenderRecord));
        DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, aspiratorSampler);
        List<ReverseSamplerLine> list = this.d_aspSampAspMap.get(aspiratorSampler);
        if (list != null) {
            assert (!list.isEmpty());
            ReverseSamplerLine reverseSamplerLine = list.get(0);
            fDSRenderRecord.setValue("DEVC_ID", this.d_pinConnections.getID(reverseSamplerLine.d_aspirator.getOutputPins().get(0)));
            fDSRenderRecord.setValue("FLOWRATE", reverseSamplerLine.d_line.d_flowrate, true);
            fDSRenderRecord.setValue("DELAY", reverseSamplerLine.d_line.d_delay, true);
            for (int i = 1; i < list.size(); ++i) {
                FDSRenderRecord fDSRenderRecord2 = (FDSRenderRecord)fDSRenderRecord.clone();
                String string = this.getNameMap().generateName("DEVC", aspiratorSampler.getName());
                fDSRenderRecord2.setValue("ID", string);
                reverseSamplerLine = list.get(i);
                fDSRenderRecord2.setValue("DEVC_ID", this.d_pinConnections.getID(reverseSamplerLine.d_aspirator.getOutputPins().get(0)));
                fDSRenderRecord2.setValue("FLOWRATE", reverseSamplerLine.d_line.d_flowrate, true);
                fDSRenderRecord2.setValue("DELAY", reverseSamplerLine.d_line.d_delay, true);
                this.d_aspSamplers.add(new Pair<AspiratorSampler, FDSRenderRecord>(aspiratorSampler, fDSRenderRecord2));
            }
        }
    }

    private void renderThemocouple(Thermocouple thermocouple) {
        Consumer<FDSRenderRecord> consumer = fDSRenderRecord -> {
            fDSRenderRecord.setValue("BEAD_DIAMETER", thermocouple.getBeadDiameter(), false);
            fDSRenderRecord.setValue("BEAD_EMISSIVITY", thermocouple.getEmissivity(), false);
            fDSRenderRecord.setValue("BEAD_DENSITY", thermocouple.getBeadDensity(), false);
            fDSRenderRecord.setValue("BEAD_SPECIFIC_HEAT", thermocouple.getBeadSpecHeat(), false);
        };
        FDSRenderRecord fDSRenderRecord2 = this.getPropRecord(consumer, thermocouple, String.format(Intl.intl("%s props"), thermocouple.getName()), new Thermocouple[]{thermocouple});
        FDSRenderRecord fDSRenderRecord3 = this.newDevcRecord(thermocouple.getOutputPins());
        this.renderPropRef(fDSRenderRecord3, fDSRenderRecord2);
        this.renderGasPointMeasurer(fDSRenderRecord3, thermocouple);
        this.addDevice(thermocouple, fDSRenderRecord3);
    }

    private void renderClock(Clock clock) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(clock.getOutputPins());
        this.renderQuantity(fDSRenderRecord, clock.getQuantity());
        this.renderFreePointLoc(fDSRenderRecord, this.getTimeLoc());
        this.renderAlarm(fDSRenderRecord, clock.getQuantity(), clock.getMsrInfo().getAlarmInfo());
        this.addDevice(clock, fDSRenderRecord);
    }

    private void renderGasPointMeasurer(GasPointMeasurer gasPointMeasurer) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(gasPointMeasurer.getOutputPins());
        this.renderGasPointMeasurer(gasPointMeasurer, fDSRenderRecord);
    }

    private void renderGasPointMeasurer(GasPointMeasurer gasPointMeasurer, FDSRenderRecord fDSRenderRecord) {
        this.renderGasPointMeasurer(fDSRenderRecord, gasPointMeasurer);
        this.addDevice(gasPointMeasurer, fDSRenderRecord);
    }

    private void renderGasPointMeasurer(FDSRenderRecord fDSRenderRecord, GasPointMeasurer gasPointMeasurer) {
        this.renderQuantity(fDSRenderRecord, gasPointMeasurer.getQuantity());
        this.renderFreePointLoc(fDSRenderRecord, gasPointMeasurer.getLocation());
        this.renderAlarm(fDSRenderRecord, gasPointMeasurer.getQuantity(), gasPointMeasurer.getMsrInfo().getAlarmInfo());
    }

    private void renderGaugeHeatFluxMsr(GaugeHeatFluxMeasurer gaugeHeatFluxMeasurer) {
        FDSRenderRecord fDSRenderRecord2 = this.newDevcRecord(gaugeHeatFluxMeasurer.getOutputPins());
        Consumer<FDSRenderRecord> consumer = fDSRenderRecord -> {
            if (gaugeHeatFluxMeasurer.getGaugeTemperature() != null) {
                fDSRenderRecord.setValue("GAUGE_TEMPERATURE", gaugeHeatFluxMeasurer.getGaugeTemperature(), false);
            }
            fDSRenderRecord.setValue("GAUGE_EMISSIVITY", gaugeHeatFluxMeasurer.getGaugeEmissivity(), false);
        };
        FDSRenderRecord fDSRenderRecord3 = this.getPropRecord(consumer, gaugeHeatFluxMeasurer, String.format(Intl.intl("%s props"), gaugeHeatFluxMeasurer.getName()), new GaugeHeatFluxMeasurer[]{gaugeHeatFluxMeasurer});
        this.renderPropRef(fDSRenderRecord2, fDSRenderRecord3);
        this.renderSolidPointMeasurer(fDSRenderRecord2, gaugeHeatFluxMeasurer);
        this.addDevice(gaugeHeatFluxMeasurer, fDSRenderRecord2);
    }

    private void renderInnerTempMsr(InnerTempMeasurer innerTempMeasurer) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(innerTempMeasurer.getOutputPins());
        fDSRenderRecord.setValue("DEPTH", innerTempMeasurer.getDepth(), false);
        this.renderSolidPointMeasurer(fDSRenderRecord, innerTempMeasurer);
        this.addDevice(innerTempMeasurer, fDSRenderRecord);
    }

    private void renderSolidDensityMsr(SolidDensityMeasurer solidDensityMeasurer) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(solidDensityMeasurer.getOutputPins());
        fDSRenderRecord.setValue("DEPTH", solidDensityMeasurer.getDepth(), false);
        this.renderSolidPointMeasurer(fDSRenderRecord, solidDensityMeasurer);
        this.addDevice(solidDensityMeasurer, fDSRenderRecord);
    }

    private void renderPressCoeffMsr(PressureCoeffMeasurer pressureCoeffMeasurer) {
        Consumer<FDSRenderRecord> consumer = fDSRenderRecord -> fDSRenderRecord.setValue("CHARACTERISTIC_VELOCITY", pressureCoeffMeasurer.getCharacteristicVel(), false);
        FDSRenderRecord fDSRenderRecord2 = this.getPropRecord(consumer, pressureCoeffMeasurer, String.format(Intl.intl("%s props"), pressureCoeffMeasurer.getName()), new PressureCoeffMeasurer[]{pressureCoeffMeasurer});
        FDSRenderRecord fDSRenderRecord3 = this.newDevcRecord(pressureCoeffMeasurer.getOutputPins());
        this.renderPropRef(fDSRenderRecord3, fDSRenderRecord2);
        this.renderSolidPointMeasurer(fDSRenderRecord3, pressureCoeffMeasurer);
        this.addDevice(pressureCoeffMeasurer, fDSRenderRecord3);
    }

    private void renderSolidPointMeasurer(FDSRenderRecord fDSRenderRecord, SolidPointMeasurer solidPointMeasurer) {
        this.renderQuantity(fDSRenderRecord, solidPointMeasurer.getQuantity());
        this.renderAttachedPointLoc(fDSRenderRecord, solidPointMeasurer.getAttachedLocation());
        this.renderAlarm(fDSRenderRecord, solidPointMeasurer.getQuantity(), solidPointMeasurer.getMsrInfo().getAlarmInfo());
    }

    private FreePointLoc getTimeLoc() {
        if (this.d_grids.isEmpty()) {
            return new FreePointLoc();
        }
        Grid grid = this.d_grids.get(0);
        UnitPoint3D unitPoint3D = grid.getMinPoint();
        return new FreePointLoc(new Point(unitPoint3D.getPoint3dValue(Geometry.LU)));
    }

    private void renderTimer(Timer timer) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(timer.getOutputPins().get(0));
        if (fDSRenderRecord == null) {
            return;
        }
        this.renderQuantity(fDSRenderRecord, Quantity.TIME.create());
        FreePointLoc freePointLoc = this.getTimeLoc();
        this.renderFreePointLoc(fDSRenderRecord, freePointLoc);
        this.renderAlarm(fDSRenderRecord, Quantity.TIME.create(), timer.getAlarmInfo());
        this.addDevice(timer, fDSRenderRecord);
    }

    private void renderSmokeDetector(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, SmokeDetector smokeDetector) {
        FDSRenderRecord fDSRenderRecord = this.renderSmokeLinkModel(smokeDetector, smokeDetector.getModel());
        FDSRenderRecord fDSRenderRecord2 = this.newDevcRecord(smokeDetector.getOutputPins());
        this.renderPropRef(fDSRenderRecord2, fDSRenderRecord);
        this.renderFreePointLoc(fDSRenderRecord2, smokeDetector.getLocation());
        this.renderTripFlags(fDSRenderRecord2, smokeDetector.getTripFlags());
        this.addDevice(smokeDetector, fDSRenderRecord2);
    }

    private FDSRenderRecord renderSmokeLinkModel(IDevice iDevice, SmokeLinkModel smokeLinkModel) {
        Consumer<FDSRenderRecord> consumer = fDSRenderRecord -> {
            fDSRenderRecord.setValue("QUANTITY", "CHAMBER OBSCURATION");
            this.renderSmokeLinkModel((FDSRenderRecord)fDSRenderRecord, this.d_ramps, this.d_tables, smokeLinkModel);
        };
        return this.getPropRecord(consumer, iDevice, new SmokeLinkModel[]{smokeLinkModel});
    }

    private void renderSmokeLinkModel(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Map<String, List<List<Double>>> map2, SmokeLinkModel smokeLinkModel) {
        SmokeLinkModel.ISpec iSpec;
        fDSRenderRecord.setValue("ACTIVATION_OBSCURATION", smokeLinkModel.getActivationObscuration(), false);
        if (smokeLinkModel.getSmokeSpecies() != null) {
            fDSRenderRecord.setValue("SPEC_ID", smokeLinkModel.getSmokeSpecies().getName());
        }
        if ((iSpec = smokeLinkModel.getSpec()) instanceof SmokeLinkModel.Cleary) {
            SmokeLinkModel.Cleary cleary = (SmokeLinkModel.Cleary)iSpec;
            fDSRenderRecord.setValue("ALPHA_E", cleary.d_eAlpha, true);
            fDSRenderRecord.setValue("BETA_E", cleary.d_eBeta, true);
            fDSRenderRecord.setValue("ALPHA_C", cleary.d_cAlpha, true);
            fDSRenderRecord.setValue("BETA_C", cleary.d_cBeta, true);
        } else if (iSpec instanceof SmokeLinkModel.Heskestad) {
            SmokeLinkModel.Heskestad heskestad = (SmokeLinkModel.Heskestad)iSpec;
            fDSRenderRecord.setValue("LENGTH", heskestad.d_length, true);
        }
        DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, smokeLinkModel);
    }

    private void renderHeatDetector(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, HeatDetector heatDetector) {
        FDSRenderRecord fDSRenderRecord = this.renderHeatLinkModel(heatDetector, heatDetector.getModel());
        FDSRenderRecord fDSRenderRecord2 = this.newDevcRecord(heatDetector.getOutputPins());
        this.renderPropRef(fDSRenderRecord2, fDSRenderRecord);
        this.renderFreePointLoc(fDSRenderRecord2, heatDetector.getLocation());
        this.renderTripFlags(fDSRenderRecord2, heatDetector.getTripFlags());
        this.addDevice(heatDetector, fDSRenderRecord2);
    }

    private FDSRenderRecord renderHeatLinkModel(IDevice iDevice, HeatLinkModel heatLinkModel) {
        Consumer<FDSRenderRecord> consumer = fDSRenderRecord -> {
            fDSRenderRecord.setValue("QUANTITY", "LINK TEMPERATURE");
            this.renderHeatLinkModel((FDSRenderRecord)fDSRenderRecord, this.d_ramps, this.d_tables, heatLinkModel);
        };
        FDSRenderRecord fDSRenderRecord2 = this.getPropRecord(consumer, iDevice, new HeatLinkModel[]{heatLinkModel});
        return fDSRenderRecord2;
    }

    private void renderHeatLinkModel(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Map<String, List<List<Double>>> map2, HeatLinkModel heatLinkModel) {
        if (heatLinkModel.getInitialTemp() != null) {
            fDSRenderRecord.setValue("INITIAL_TEMPERATURE", heatLinkModel.getInitialTemp(), false);
        }
        fDSRenderRecord.setValue("ACTIVATION_TEMPERATURE", heatLinkModel.getActivationTemp(), true);
        fDSRenderRecord.setValue("RTI", heatLinkModel.getRti(), false);
        DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, heatLinkModel);
    }

    private void renderSprinklerLink(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, SprinklerLink sprinklerLink) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(sprinklerLink.getOutputPins());
        this.renderSprinklerLink(map, map2, sprinklerLink, fDSRenderRecord);
    }

    private void renderSprinklerLink(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, SprinklerLink sprinklerLink, FDSRenderRecord fDSRenderRecord) {
        FDSRenderRecord fDSRenderRecord2 = this.renderSprinklerLinkModel(sprinklerLink, sprinklerLink.getModel());
        this.renderPropRef(fDSRenderRecord, fDSRenderRecord2);
        this.renderFreePointLoc(fDSRenderRecord, sprinklerLink.getLocation());
        this.renderTripFlags(fDSRenderRecord, sprinklerLink.getTripFlags());
        this.addDevice(sprinklerLink, fDSRenderRecord);
    }

    private void renderSprinkler(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, Sprinkler sprinkler) {
        if (sprinkler.getDryPipe() != null) {
            this.renderSprinklerPreAct(map, map2, sprinkler);
        } else {
            this.renderSprinklerSimple(map, map2, sprinkler);
        }
    }

    private void renderSprinklerSimple(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, Sprinkler sprinkler) {
        FDSRenderRecord fDSRenderRecord;
        Object object;
        Object object2;
        Serializable serializable;
        Sprinkler.LinkModel linkModel = sprinkler.getLinkModel();
        SprayModel sprayModel = sprinkler.getSprayModel();
        if (linkModel instanceof Sprinkler.TraditionalModel) {
            serializable = (Sprinkler.TraditionalModel)linkModel;
            object2 = arg_0 -> this.lambda$renderSprinklerSimple$596(map, map2, (Sprinkler.TraditionalModel)serializable, sprayModel, arg_0);
            object = ((Sprinkler.TraditionalModel)serializable).d_link.getName().equals(sprayModel.getName()) ? sprayModel.getName() : null;
            fDSRenderRecord = this.getPropRecord((Consumer)object2, sprinkler, (String)object, new NamedPyroObject[]{((Sprinkler.TraditionalModel)serializable).d_link, sprayModel});
        } else {
            fDSRenderRecord = this.renderSprayModel(sprinkler, sprayModel);
        }
        serializable = this.newDevcRecord(sprinkler.getOutputPins());
        this.renderPropRef((FDSRenderRecord)serializable, fDSRenderRecord);
        this.renderFreePointLoc((FDSRenderRecord)serializable, sprinkler.getLocation());
        ((FDSRecord)serializable).setValue("INITIAL_STATE", linkModel.d_initState, false);
        ((FDSRecord)serializable).setValue("LATCH", linkModel.d_latch, false);
        if (linkModel instanceof Sprinkler.QuantityModel) {
            object2 = (Sprinkler.QuantityModel)linkModel;
            this.renderQuantity((FDSRenderRecord)serializable, ((Sprinkler.QuantityModel)object2).d_quantity);
            object = SIUS.unit(((Sprinkler.QuantityModel)object2).d_quantity.get().unitType);
            double d = ((Sprinkler.QuantityModel)object2).d_setPoint.getValue((Unit)object);
            ((FDSRecord)serializable).setValue("SETPOINT", d, false);
        }
        this.addDevice(sprinkler, (FDSRenderRecord)serializable);
    }

    private void copyCustomRecords(ICustomFDSPropsContainer iCustomFDSPropsContainer, ICustomFDSPropsContainer iCustomFDSPropsContainer2) {
        HashSet<String> hashSet = new HashSet<String>(iCustomFDSPropsContainer2.getCustomFDSTypes());
        for (String string : iCustomFDSPropsContainer.getCustomFDSTypes()) {
            if (!hashSet.contains(string)) continue;
            iCustomFDSPropsContainer2.setCustomFDSProps(string, iCustomFDSPropsContainer.getCustomFDSProps(string));
        }
    }

    private void renderSprinklerPreAct(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, Sprinkler sprinkler) {
        ASourceDevice aSourceDevice;
        Object object;
        Object object2;
        Nozzle nozzle = new Nozzle(String.format(Intl.intl("%s_NOZZLE"), sprinkler.getName()), sprinkler.getSprayModel(), sprinkler.getLocation());
        Sprinkler.LinkModel linkModel = sprinkler.getLinkModel();
        String string = String.format("%s_%s", sprinkler.getName(), sprinkler.getLinkAlarmPin().getName());
        IOutPin iOutPin = sprinkler.getLinkAlarmPin();
        if (linkModel instanceof Sprinkler.TraditionalModel) {
            object2 = ((Sprinkler.TraditionalModel)linkModel).d_link;
            object = new SprinklerLink(string, (SprinklerLinkModel)object2, sprinkler.getLocation());
            aSourceDevice = object;
        } else {
            object2 = (Sprinkler.QuantityModel)linkModel;
            object = new GasPointMeasurer(string, ((Sprinkler.QuantityModel)object2).d_quantity, sprinkler.getLocation());
            ((AMeasuringDevc)object).getMsrInfo().setAlarmInfo(new AlarmInfo(((Sprinkler.QuantityModel)object2).d_setPoint));
            aSourceDevice = object;
        }
        if (aSourceDevice instanceof IFreezable) {
            object2 = (IFreezable)((Object)aSourceDevice);
            for (IOutPin cloneable2 : sprinkler.getFreezePin().getConnections()) {
                assert (object2.getInputPin().canConnect(cloneable2));
                object2.getInputPin().connect(cloneable2);
            }
        }
        this.copyCustomRecords(sprinkler, aSourceDevice);
        if (linkModel.d_latch) {
            object2 = new LatchCtrl();
            ((AControl)object2).setName(String.format(Intl.intl("%s_latch"), aSourceDevice.getName()));
            ((LatchCtrl)object2).getInputPin().connect(iOutPin);
            iOutPin = ((LatchCtrl)object2).getOutputPins().get(0);
            this.d_addedControls.add((IControl)object2);
        }
        if (linkModel.d_initState) {
            object2 = new NotOp();
            ((AControl)object2).setName(String.format(Intl.intl("%s_invert"), aSourceDevice.getName()));
            ((NotOp)object2).getInputPin().connect(iOutPin);
            iOutPin = ((NotOp)object2).getOutputPins().get(0);
            this.d_addedControls.add((IControl)object2);
        }
        assert (sprinkler.getDryPipe() != null);
        object2 = this.d_dryPipeCtrlMap.get(sprinkler.getDryPipe());
        ((DryPipeCtrl)object2).getInputPin().connect(iOutPin);
        object = new AndOp();
        ((AControl)object).setName(String.format(Intl.intl("%s_input"), nozzle.getName()));
        ((ALogicOp)object).getInputPin().connect(((DryPipeCtrl)object2).getOutputPins().get(0));
        ((ALogicOp)object).getInputPin().connect(iOutPin);
        nozzle.getInputPin().connect(((ALogicOp)object).getOutputPins().get(0));
        this.d_addedControls.add((IControl)object);
        this.pushNestedDevc(sprinkler);
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(Arrays.asList(sprinkler.getLinkAlarmPin(), sprinkler.getLinkQuantityPin()), false);
        if (aSourceDevice instanceof SprinklerLink) {
            this.renderSprinklerLink(map, map2, (SprinklerLink)aSourceDevice, fDSRenderRecord);
        } else {
            this.renderGasPointMeasurer((GasPointMeasurer)aSourceDevice, fDSRenderRecord);
        }
        FDSRenderRecord fDSRenderRecord2 = this.newDevcRecord(Collections.singletonList(sprinkler.getNozzleAlarmPin()), false);
        this.renderNozzle(map, map2, nozzle, fDSRenderRecord2);
        this.popNestedDevc(sprinkler);
    }

    private void renderNozzle(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, Nozzle nozzle) {
        FDSRenderRecord fDSRenderRecord = this.newDevcRecord(nozzle.getOutputPins());
        this.renderNozzle(map, map2, nozzle, fDSRenderRecord);
    }

    private void renderNozzle(Map<String, Ramp> map, Map<String, List<List<Double>>> map2, Nozzle nozzle, FDSRenderRecord fDSRenderRecord) {
        FDSRenderRecord fDSRenderRecord2 = this.renderSprayModel(nozzle, nozzle.getSprayModel());
        this.renderPropRef(fDSRenderRecord, fDSRenderRecord2);
        this.renderFreePointLoc(fDSRenderRecord, nozzle.getLocation());
        Set<IOutPin> set = PinConnectionRenderer.finalizeInputs(nozzle.getInputPin());
        if (!set.isEmpty()) {
            this.renderDefDeviceProps(fDSRenderRecord);
            IOutPin iOutPin = set.iterator().next();
            if (iOutPin.getAttachedSource() instanceof Timer) {
                Timer timer = (Timer)iOutPin.getAttachedSource();
                fDSRenderRecord.setValue("QUANTITY", "TIME");
                fDSRenderRecord.setValue("SETPOINT", timer.getAlarmInfo().setpoint.getValue(SI.SECOND));
                this.renderTripFlags(fDSRenderRecord, timer.getTripFlags());
                this.addDevice(nozzle, fDSRenderRecord);
            } else {
                fDSRenderRecord.setValue("LATCH", false, false);
                fDSRenderRecord.setValue("QUANTITY", "CONTROL");
                if (iOutPin.getAttachedSource() instanceof IDevice) {
                    LatchCtrl latchCtrl = new LatchCtrl();
                    latchCtrl.getInputPin().connect(iOutPin);
                    Pair<FDSRenderRecord, Boolean> pair = this.d_pinConnections.generateRecord("CTRL", "ID", latchCtrl.getOutputPins().get(0));
                    if (((Boolean)pair.v2).booleanValue()) {
                        ((FDSRenderRecord)pair.v1).setValue("FUNCTION_TYPE", "ALL");
                        ((FDSRenderRecord)pair.v1).setValue("LATCH", false, false);
                        ((FDSRenderRecord)pair.v1).setValue("INITIAL_STATE", false, false);
                        fDSRenderRecord.setValue("CTRL_ID", ((FDSRenderRecord)pair.v1).getString("ID"));
                    }
                    this.d_pinConnections.markForInputRetrieval(latchCtrl.getInputPin(), (FDSRenderRecord)pair.v1, "INPUT_ID", "INPUT_ID");
                    this.addDevice(nozzle, fDSRenderRecord);
                } else {
                    this.d_pinConnections.markForInputRetrieval(nozzle.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
                    DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, nozzle);
                }
            }
        } else {
            fDSRenderRecord.setValue("QUANTITY", "TIME");
            fDSRenderRecord.setValue("SETPOINT", 0.0);
            this.addDevice(nozzle, fDSRenderRecord);
        }
    }

    private FDSRenderRecord renderSprinklerLinkModel(IDevice iDevice, SprinklerLinkModel sprinklerLinkModel) {
        Consumer<FDSRenderRecord> consumer = fDSRenderRecord -> {
            fDSRenderRecord.setValue("QUANTITY", "SPRINKLER LINK TEMPERATURE");
            this.renderSprinklerLinkModel((FDSRenderRecord)fDSRenderRecord, this.d_ramps, this.d_tables, sprinklerLinkModel, true);
        };
        FDSRenderRecord fDSRenderRecord2 = this.getPropRecord(consumer, iDevice, new SprinklerLinkModel[]{sprinklerLinkModel});
        return fDSRenderRecord2;
    }

    private void renderSprinklerLinkModel(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Map<String, List<List<Double>>> map2, SprinklerLinkModel sprinklerLinkModel, boolean bl) {
        if (sprinklerLinkModel.getInitialTemp() != null) {
            fDSRenderRecord.setValue("INITIAL_TEMPERATURE", sprinklerLinkModel.getInitialTemp(), false);
        }
        fDSRenderRecord.setValue("ACTIVATION_TEMPERATURE", sprinklerLinkModel.getActivationTemp(), true);
        fDSRenderRecord.setValue("RTI", sprinklerLinkModel.getRti(), false);
        fDSRenderRecord.setValue("C_FACTOR", sprinklerLinkModel.getCFactor(), false);
        if (bl) {
            DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, sprinklerLinkModel);
        }
    }

    private FDSRenderRecord renderSprayModel(IDevice iDevice, SprayModel sprayModel) {
        Consumer<FDSRenderRecord> consumer = fDSRenderRecord -> this.renderSprayModel((FDSRenderRecord)fDSRenderRecord, this.d_ramps, this.d_tables, sprayModel, true);
        FDSRenderRecord fDSRenderRecord2 = this.getPropRecord(consumer, iDevice, new SprayModel[]{sprayModel});
        return fDSRenderRecord2;
    }

    private void renderSprayModel(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Map<String, List<List<Double>>> map2, SprayModel sprayModel, boolean bl) {
        String string = (String)fDSRenderRecord.get("ID");
        fDSRenderRecord.setValue("PART_ID", this.getNameMap().getName(sprayModel.getParticle()));
        fDSRenderRecord.setValue("OFFSET", sprayModel.getSprayOffset(), false);
        fDSRenderRecord.setValue("PARTICLES_PER_SECOND", sprayModel.getDropsPerSecond(), false);
        this.renderFlowRate(fDSRenderRecord, string, map, sprayModel.getFlowRate());
        this.renderJets(fDSRenderRecord, string, map2, sprayModel.getJets());
        if (bl) {
            DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, sprayModel);
        }
    }

    private void renderFlowRate(FDSRenderRecord fDSRenderRecord, String string, Map<String, Ramp> map, SprayModel.FlowRate flowRate) {
        if (flowRate instanceof SprayModel.ExplicitFlowRate) {
            SprayModel.ExplicitFlowRate explicitFlowRate = (SprayModel.ExplicitFlowRate)flowRate;
            fDSRenderRecord.setValue("FLOW_RATE", explicitFlowRate.d_rate);
        } else if (flowRate instanceof SprayModel.PressurizedFlowRate) {
            SprayModel.PressurizedFlowRate pressurizedFlowRate = (SprayModel.PressurizedFlowRate)flowRate;
            fDSRenderRecord.setValue("K_FACTOR", pressurizedFlowRate.d_kFactor, true);
            fDSRenderRecord.setValue("OPERATING_PRESSURE", pressurizedFlowRate.d_opPressure, true);
        } else if (flowRate instanceof SprayModel.VaryingFlowRate) {
            SprayModel.VaryingFlowRate varyingFlowRate = (SprayModel.VaryingFlowRate)flowRate;
            String string2 = RampRenderer.createID(this.getNameMap(), string, "PRESSURE_RAMP");
            map.put(string2, varyingFlowRate.d_pressureRamp);
            fDSRenderRecord.setValue("PRESSURE_RAMP", string2, false);
            if (varyingFlowRate.d_kFactor != null) {
                fDSRenderRecord.setValue("K_FACTOR", varyingFlowRate.d_kFactor, true);
            }
            if (varyingFlowRate.d_opPressure != null) {
                fDSRenderRecord.setValue("OPERATING_PRESSURE", varyingFlowRate.d_opPressure, true);
            }
            if (varyingFlowRate.d_rate != null) {
                fDSRenderRecord.setValue("FLOW_RATE", varyingFlowRate.d_rate, true);
            }
        }
        DeviceRenderer.renderTimeFunc(fDSRenderRecord, this.getNameMap(), map, string, flowRate.d_ramp, "FLOW_RAMP", "FLOW_TAU");
    }

    private void renderJets(FDSRenderRecord fDSRenderRecord, String string, Map<String, List<List<Double>>> map, List<SprayModel.Jet> list) {
        if (list.size() == 1) {
            SprayModel.Jet jet = list.get(0);
            if (jet.d_velocity != null) {
                assert (jet.d_orificeDiam == null);
                fDSRenderRecord.setValue("PARTICLE_VELOCITY", jet.d_velocity, true);
            } else {
                assert (jet.d_orificeDiam != null);
                fDSRenderRecord.setValue("ORIFICE_DIAMETER", jet.d_orificeDiam, true);
            }
            FDSArray<UnitDouble> fDSArray = new FDSArray<UnitDouble>(FDS6Const.PROP_SPRAY_ANGLE_DIMENSIONS);
            if (jet.isConicalSpray()) {
                fDSArray.set(0, jet.d_lat1, jet.d_lat2);
            } else {
                fDSArray.set(0, jet.d_lat1, jet.d_lat2, jet.d_long1, jet.d_long2);
            }
            fDSRenderRecord.setValue("SPRAY_ANGLE", fDSArray);
        } else if (!list.isEmpty()) {
            String string2 = TableRenderer.createID(this.getNameMap(), string, "SPRAY_PATTERN_TABLE");
            ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>(list.size());
            for (SprayModel.Jet jet : list) {
                List<Double> list2 = Arrays.asList(jet.d_lat1.getValue(NonSI.DEGREE_ANGLE), jet.d_lat2.getValue(NonSI.DEGREE_ANGLE), jet.d_long1.getValue(NonSI.DEGREE_ANGLE), jet.d_long2.getValue(NonSI.DEGREE_ANGLE), jet.d_velocity.getValue(SIUS.unit(8)), jet.d_flowFrac);
                arrayList.add(list2);
            }
            map.put(string2, arrayList);
            fDSRenderRecord.setValue("SPRAY_PATTERN_TABLE", string2);
        }
    }

    private void renderDefDeviceProps(FDSRenderRecord fDSRenderRecord) {
        fDSRenderRecord.setValue("INITIAL_STATE", false, false);
    }

    private void renderFreePointLoc(FDSRenderRecord fDSRenderRecord, FreePointLoc freePointLoc) {
        IGeom iGeom = freePointLoc.d_geom;
        assert (iGeom instanceof Point);
        DeviceRenderer.renderLoc(fDSRenderRecord, "XYZ", new UnitPoint3D(((Point)iGeom).loc, Geometry.LU));
        Vector3d vector3d = freePointLoc.d_orientation;
        FDSArray<Object> fDSArray = new FDSArray<Object>(vector3d.x, vector3d.y, vector3d.z);
        fDSRenderRecord.setValue("ORIENTATION", fDSArray, false);
        fDSRenderRecord.setValue("ROTATION", freePointLoc.d_rotation, false);
    }

    private void renderAttachedPointLoc(FDSRenderRecord fDSRenderRecord, AttachedPointLoc attachedPointLoc) {
        DeviceRenderer.renderLoc(fDSRenderRecord, "XYZ", attachedPointLoc.d_location);
        int n = GeomUtil.toFDSVec(attachedPointLoc.d_faceNormal);
        fDSRenderRecord.setValue("IOR", n, false);
        fDSRenderRecord.setValue("ROTATION", attachedPointLoc.d_rotation, false);
    }

    private <T extends INamed> FDSRenderRecord getPropRecord(Consumer<FDSRenderRecord> consumer, IDevice iDevice, T ... TArray) {
        return this.getPropRecord(consumer, iDevice, null, (INamed[])TArray);
    }

    private <T extends INamed> FDSRenderRecord getPropRecord(Consumer<FDSRenderRecord> consumer, IDevice iDevice, String string, T ... TArray) {
        Map<String, String> map = Collections.emptyMap();
        if (iDevice != null && iDevice.getCustomFDSTypes().contains("PROP")) {
            map = iDevice.getCustomFDSProps("PROP").getProps();
        }
        PropHasher propHasher = new PropHasher(map, TArray);
        return this.d_propMap.computeIfAbsent(propHasher, propHasher2 -> {
            String string2;
            FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("PROP");
            if (string != null) {
                string2 = string;
            } else {
                string2 = "";
                for (INamed iNamed : TArray) {
                    if (string2.length() != 0) {
                        string2 = string2 + "_";
                    }
                    string2 = string2 + iNamed.getName();
                }
            }
            String string3 = this.getNameMap().generateName("PROP", string2);
            fDSRenderRecord.setValue("ID", string3);
            consumer.accept(fDSRenderRecord);
            if (iDevice != null) {
                DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, iDevice);
            }
            this.d_revPropMap.put(fDSRenderRecord, propHasher);
            return fDSRenderRecord;
        });
    }

    private boolean arePropsSet(FDSRenderRecord fDSRenderRecord) {
        Map<String, Object> map = fDSRenderRecord.getProperties();
        List<FDSRecord.UnknownProp> list = fDSRenderRecord.getUnknownProps();
        boolean bl = list.isEmpty() && (map.size() == 0 || map.size() == 1 && map.keySet().iterator().next().equals("ID"));
        return !bl;
    }

    private void renderPropRef(FDSRenderRecord fDSRenderRecord, FDSRenderRecord fDSRenderRecord2) {
        if (this.arePropsSet(fDSRenderRecord2)) {
            fDSRenderRecord.setValue("PROP_ID", fDSRenderRecord2.get("ID"));
        } else {
            PropHasher propHasher = this.d_revPropMap.remove(fDSRenderRecord2);
            this.d_propMap.remove(propHasher);
        }
    }

    private /* synthetic */ void lambda$renderSprinklerSimple$596(Map map, Map map2, Sprinkler.TraditionalModel traditionalModel, SprayModel sprayModel, FDSRenderRecord fDSRenderRecord) {
        fDSRenderRecord.setValue("QUANTITY", "SPRINKLER LINK TEMPERATURE");
        this.renderSprinklerLinkModel(fDSRenderRecord, map, map2, traditionalModel.d_link, false);
        this.renderSprayModel(fDSRenderRecord, map, map2, sprayModel, false);
        CustomFDSProps customFDSProps = CustomFDSProps.union(traditionalModel.d_link.getCustomFDSProps("PROP"), sprayModel.getCustomFDSProps("PROP"));
        DeviceRenderer.renderCustomFDSProps(fDSRenderRecord, customFDSProps);
    }

    private class DryPipeCtrl {
        private final OrOp or = new OrOp();
        private final TimeDelayCtrl timeDelay;
        private final IOutPin d_outPin;
        private final IInPin d_inPin;

        public DryPipeCtrl(DryPipe dryPipe) {
            this.or.setName(String.format(Intl.intl("%s_inputs"), dryPipe.getName()));
            this.d_inPin = this.or.getInputPin();
            this.timeDelay = new TimeDelayCtrl(dryPipe.getDelay());
            this.timeDelay.setName(String.format(Intl.intl("%s_delay"), dryPipe.getName()));
            this.timeDelay.getInputPin().connect(this.or.getOutputPins().get(0));
            this.d_outPin = this.timeDelay.getOutputPins().get(0);
            DeviceRenderer.this.d_addedControls.add(this.or);
            DeviceRenderer.this.d_addedControls.add(this.timeDelay);
        }

        public List<? extends IOutPin> getOutputPins() {
            return Arrays.asList(this.d_outPin);
        }

        public IInPin getInputPin() {
            return this.d_inPin;
        }
    }

    private static class PropHasher<T> {
        private final Map<String, String> d_customProps;
        private final T[] d_objs;

        public PropHasher(Map<String, String> map, T ... TArray) {
            assert (TArray.length > 0);
            this.d_customProps = map;
            this.d_objs = TArray;
        }

        public int hashCode() {
            int n = this.d_customProps.hashCode();
            for (T t : this.d_objs) {
                n += t.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PropHasher)) {
                return false;
            }
            PropHasher propHasher = (PropHasher)object;
            if (!this.d_customProps.equals(propHasher.d_customProps)) {
                return false;
            }
            if (this.d_objs.length != propHasher.d_objs.length) {
                return false;
            }
            for (int i = 0; i < this.d_objs.length; ++i) {
                if (this.d_objs[i] == propHasher.d_objs[i]) continue;
                return false;
            }
            return true;
        }
    }

    private static class ReverseSamplerLine {
        public final Aspirator d_aspirator;
        public final Aspirator.SamplerLine d_line;

        public ReverseSamplerLine(Aspirator aspirator, Aspirator.SamplerLine samplerLine) {
            this.d_line = samplerLine;
            this.d_aspirator = aspirator;
        }
    }
}

