/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.evac.Corr;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class CorrRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Corr.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        UnitDouble unitDouble;
        Object object;
        Object object2;
        UnitDouble[] unitDoubleArray;
        NamedPyroObject namedPyroObject;
        Corr corr = (Corr)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("CORR");
        fDSRenderRecord.setValue("ID", corr.getName());
        fDSRenderRecord.setValue("FYI", corr.getProp("FYI"), false);
        Integer n = (Integer)corr.getProp("MAX_HUMANS_INSIDE");
        if (n != null) {
            fDSRenderRecord.setValue("MAX_HUMANS_INSIDE", n);
        }
        if ((namedPyroObject = (NamedPyroObject)corr.getProp("TO_NODE")) != null) {
            fDSRenderRecord.setValue("TO_NODE", namedPyroObject.getName(), false);
        }
        if ((unitDoubleArray = (UnitDouble[])corr.getProp("XB1")) != null) {
            object2 = new UnitAABox(new UnitPoint3D(unitDoubleArray[0], unitDoubleArray[2], unitDoubleArray[4]), new UnitPoint3D(unitDoubleArray[1], unitDoubleArray[3], unitDoubleArray[5]));
            object = corr.getProp("XB2") == null ? "XB" : "XB1";
            CorrRenderer.renderXB(fDSRenderRecord, (String)object, ((UnitAABox)object2).getMin(), ((UnitAABox)object2).getMax());
        }
        if ((object2 = (UnitDouble[])corr.getProp("XB2")) != null) {
            object = new UnitAABox(new UnitPoint3D(object2[0], object2[2], object2[4]), new UnitPoint3D(object2[1], object2[3], object2[5]));
            CorrRenderer.renderXB(fDSRenderRecord, "XB2", ((UnitAABox)object).getMin(), ((UnitAABox)object).getMax());
        }
        if ((object = (Double)corr.getProp("FAC_SPEED")) != null) {
            fDSRenderRecord.setValue("FAC_SPEED", object, false);
        }
        if ((unitDouble = (UnitDouble)corr.getProp("EFF_LENGTH")) != null) {
            fDSRenderRecord.setValue("EFF_LENGTH", unitDouble, false);
        }
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

