/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.ADblCompareOp;
import pyrosim.domain.controls.AIntCompareOp;
import pyrosim.domain.controls.AndOp;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DblGreaterThanOp;
import pyrosim.domain.controls.DblLessThanOp;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.IntEqualOp;
import pyrosim.domain.controls.IntGreaterThanOp;
import pyrosim.domain.controls.IntLessThanOp;
import pyrosim.domain.controls.IntNotEqualOp;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.ManualCtrl;
import pyrosim.domain.controls.NotOp;
import pyrosim.domain.controls.OrOp;
import pyrosim.domain.controls.SumOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.renderers.AFDS6UniqueRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ControlRenderer
extends AFDS6UniqueRenderer {
    private final PinConnectionRenderer d_pinConnections;

    public ControlRenderer(FDSNameMap fDSNameMap, PinConnectionRenderer pinConnectionRenderer) {
        super(fDSNameMap);
        this.d_pinConnections = pinConnectionRenderer;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(IControl.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        IControl iControl = (IControl)iPyroObject;
        if (iControl.isWire() || iControl instanceof SumOp) {
            return false;
        }
        if (iControl instanceof ManualCtrl) {
            this.renderManualCtrl(iFDSRecordRenderer, (ManualCtrl)iControl);
        } else {
            String string = iControl.getName();
            if (string != null) {
                LinkedHashMap<String, Ramp> linkedHashMap = new LinkedHashMap<String, Ramp>();
                FDSRenderRecord fDSRenderRecord = this.newControlRec(iControl);
                if (fDSRenderRecord != null) {
                    this.render(fDSRenderRecord, iControl, linkedHashMap);
                }
                RampRenderer.render(iFDSRecordRenderer, linkedHashMap, this.d_pinConnections);
            }
        }
        return false;
    }

    private boolean render(FDSRenderRecord fDSRenderRecord, IControl iControl, Map<String, Ramp> map) {
        if (!(iControl instanceof SumOp)) {
            if (iControl instanceof IntGreaterThanOp) {
                this.renderIntGreaterThanOp(fDSRenderRecord, (IntGreaterThanOp)iControl);
            } else if (iControl instanceof IntLessThanOp) {
                this.renderIntLessThanOp(fDSRenderRecord, (IntLessThanOp)iControl);
            } else if (iControl instanceof IntEqualOp) {
                this.renderIntEqualOp(fDSRenderRecord, (IntEqualOp)iControl);
            } else if (iControl instanceof IntNotEqualOp) {
                this.renderIntNotEqualOp(fDSRenderRecord, (IntNotEqualOp)iControl);
            } else if (iControl instanceof DblGreaterThanOp) {
                this.renderDblCompareOp(fDSRenderRecord, map, (DblGreaterThanOp)iControl, false);
            } else if (iControl instanceof DblLessThanOp) {
                this.renderDblCompareOp(fDSRenderRecord, map, (DblLessThanOp)iControl, true);
            } else if (iControl instanceof AndOp) {
                this.renderAndOp(fDSRenderRecord, (AndOp)iControl);
            } else if (iControl instanceof OrOp) {
                this.renderOrOp(fDSRenderRecord, (OrOp)iControl);
            } else if (iControl instanceof NotOp) {
                this.renderNotOp(fDSRenderRecord, (NotOp)iControl, map);
            } else if (iControl instanceof LatchCtrl) {
                this.renderLatchCtrl(fDSRenderRecord, (LatchCtrl)iControl, map);
            } else if (iControl instanceof CustomCtrl) {
                this.renderCustomCtrl(fDSRenderRecord, map, (CustomCtrl)iControl);
            } else if (iControl instanceof TimeDelayCtrl) {
                this.renderTimeDelayCtrl(fDSRenderRecord, (TimeDelayCtrl)iControl);
            } else if (iControl instanceof DeadbandCtrl) {
                this.renderDeadbandCtrl(fDSRenderRecord, (DeadbandCtrl)iControl);
            } else assert (false);
        }
        return false;
    }

    public void renderManualCtrl(IFDSRecordRenderer iFDSRecordRenderer, ManualCtrl manualCtrl) {
        FDSRenderRecord fDSRenderRecord = this.newControlRec(manualCtrl);
        if (fDSRenderRecord != null) {
            fDSRenderRecord.setCustomText(manualCtrl.getFDSText());
            iFDSRecordRenderer.render(fDSRenderRecord, manualCtrl);
        }
    }

    public void renderDeadbandCtrl(FDSRenderRecord fDSRenderRecord, DeadbandCtrl deadbandCtrl) {
        Object object;
        fDSRenderRecord.setValue("FUNCTION_TYPE", "DEADBAND");
        IDoubleOutPin iDoubleOutPin = this.getDoubleInput(deadbandCtrl);
        if (iDoubleOutPin != null) {
            object = SIUS.unit(iDoubleOutPin.getUnitType());
            FDSArray<Object> fDSArray = new FDSArray<Object>(deadbandCtrl.getLowerBound().getValue((Unit)object), deadbandCtrl.getUpperBound().getValue((Unit)object));
            fDSRenderRecord.setValue("SETPOINT", fDSArray, false);
        }
        object = deadbandCtrl.getTripDirection() == 0 ? "LOWER" : "UPPER";
        fDSRenderRecord.setValue("ON_BOUND", object);
        fDSRenderRecord.setValue("INITIAL_STATE", false, false);
        fDSRenderRecord.setValue("LATCH", false, false);
        this.markInputs(fDSRenderRecord, deadbandCtrl);
    }

    public void renderTimeDelayCtrl(FDSRenderRecord fDSRenderRecord, TimeDelayCtrl timeDelayCtrl) {
        fDSRenderRecord.setValue("FUNCTION_TYPE", "TIME_DELAY");
        fDSRenderRecord.setValue("DELAY", timeDelayCtrl.getTimeDelay());
        fDSRenderRecord.setValue("LATCH", false, false);
        fDSRenderRecord.setValue("INITIAL_STATE", false, false);
        this.markInputs(fDSRenderRecord, timeDelayCtrl);
    }

    public void renderCustomCtrl(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, CustomCtrl customCtrl) {
        Ramp ramp = this.newCustomRamp(customCtrl, !customCtrl.getInitialState(), customCtrl.getTripValues());
        this.renderCustomRecord(fDSRenderRecord, customCtrl, ramp, map);
    }

    public void renderDblCompareOp(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, ADblCompareOp aDblCompareOp, boolean bl) {
        Ramp ramp = this.newCustomRamp(aDblCompareOp, !bl, Arrays.asList(aDblCompareOp.getN()));
        this.renderCustomRecord(fDSRenderRecord, aDblCompareOp, ramp, map);
    }

    private FDSRenderRecord renderCustomRecord(FDSRenderRecord fDSRenderRecord, IControl iControl, Ramp ramp, Map<String, Ramp> map) {
        fDSRenderRecord.setValue("FUNCTION_TYPE", "CUSTOM");
        if (ramp != null) {
            String string = RampRenderer.createID(this.getNameMap(), (String)fDSRenderRecord.get("ID"), "RAMP");
            map.put(string, ramp);
            fDSRenderRecord.setValue("RAMP_ID", string);
        }
        fDSRenderRecord.setValue("LATCH", false, false);
        fDSRenderRecord.setValue("INITIAL_STATE", false, false);
        this.markInputs(fDSRenderRecord, iControl);
        return fDSRenderRecord;
    }

    private IDoubleOutPin getDoubleInput(IControl iControl) {
        Set<? extends IOutPin> set = iControl.getInputPin().getConnections();
        if (set.size() != 1 || !(set.iterator().next() instanceof IDoubleOutPin)) {
            return null;
        }
        return (IDoubleOutPin)set.iterator().next();
    }

    private Ramp newCustomRamp(IControl iControl, boolean bl, Collection<UnitDouble> collection) {
        double d;
        if (collection.isEmpty()) {
            return null;
        }
        IDoubleOutPin iDoubleOutPin = this.getDoubleInput(iControl);
        if (iDoubleOutPin == null) {
            return null;
        }
        final int n = iDoubleOutPin.getUnitType();
        Unit unit = SIUS.unit(n);
        IRampInput iRampInput = new IRampInput(){
            private static final long serialVersionUID = 2846399992315901851L;

            @Override
            public String getName() {
                return "";
            }

            @Override
            public int getUnitType() {
                return n;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        };
        double d2 = 0.25;
        if (collection.size() == 1) {
            d = collection.iterator().next().getValue(unit);
            float f = theUtil.floatResolution((float)d);
            if (f > (float)d2) {
                d2 = (double)f * 4.0;
            }
        } else {
            d = 1.0;
            Iterator<UnitDouble> iterator = collection.iterator();
            double d3 = iterator.next().getValue(unit);
            while (iterator.hasNext()) {
                double d4 = iterator.next().getValue(unit);
                double d5 = d4 - d3;
                assert (d5 > 0.0);
                if (d5 < d) {
                    d = d5;
                }
                d3 = d4;
            }
            d2 = d * 0.25;
        }
        boolean bl2 = !bl;
        ArrayList<Ramp.Entry> arrayList = new ArrayList<Ramp.Entry>(collection.size() * 2);
        for (UnitDouble unitDouble : collection) {
            double d6 = unitDouble.getValue(unit);
            UnitDouble unitDouble2 = this.customStateToRampVal(bl2);
            arrayList.add(new Ramp.Entry(new UnitDouble(d6 - d2, unit), unitDouble2));
            bl2 = !bl2;
            UnitDouble unitDouble3 = this.customStateToRampVal(bl2);
            arrayList.add(new Ramp.Entry(new UnitDouble(d6 + d2, unit), unitDouble3));
        }
        return new Ramp(arrayList, iRampInput, 28);
    }

    private UnitDouble customStateToRampVal(boolean bl) {
        return bl ? new UnitDouble(1.0, Unit.ONE) : new UnitDouble(-1.0, Unit.ONE);
    }

    public void renderIntGreaterThanOp(FDSRenderRecord fDSRenderRecord, IntGreaterThanOp intGreaterThanOp) {
        this.renderIntCompareOp(fDSRenderRecord, intGreaterThanOp, "AT_LEAST", intGreaterThanOp.getN() + 1, false);
    }

    public void renderIntLessThanOp(FDSRenderRecord fDSRenderRecord, IntLessThanOp intLessThanOp) {
        this.renderIntCompareOp(fDSRenderRecord, intLessThanOp, "AT_LEAST", intLessThanOp.getN(), true);
    }

    public void renderIntEqualOp(FDSRenderRecord fDSRenderRecord, IntEqualOp intEqualOp) {
        this.renderIntCompareOp(fDSRenderRecord, intEqualOp, "ONLY", intEqualOp.getN(), false);
    }

    public void renderIntNotEqualOp(FDSRenderRecord fDSRenderRecord, IntNotEqualOp intNotEqualOp) {
        this.renderIntCompareOp(fDSRenderRecord, intNotEqualOp, "ONLY", intNotEqualOp.getN(), true);
    }

    private void renderIntCompareOp(FDSRenderRecord fDSRenderRecord, AIntCompareOp aIntCompareOp, String string, int n, boolean bl) {
        fDSRenderRecord.setValue("FUNCTION_TYPE", string);
        fDSRenderRecord.setValue("N", n, true);
        fDSRenderRecord.setValue("LATCH", false, false);
        fDSRenderRecord.setValue("INITIAL_STATE", bl, false);
        Set<ISignalSource> set = aIntCompareOp.getInputPin().getConnectedSources();
        if (set.size() == 1) {
            ISignalSource iSignalSource = set.iterator().next();
            if (!(iSignalSource instanceof SumOp)) assert (false);
            SumOp sumOp = (SumOp)iSignalSource;
            this.markInputs(fDSRenderRecord, sumOp);
        }
    }

    public void renderAndOp(FDSRenderRecord fDSRenderRecord, AndOp andOp) {
        this.renderLogicRecord(fDSRenderRecord, andOp, "ALL");
    }

    public void renderOrOp(FDSRenderRecord fDSRenderRecord, OrOp orOp) {
        this.renderLogicRecord(fDSRenderRecord, orOp, "ANY");
    }

    public void renderNotOp(FDSRenderRecord fDSRenderRecord, NotOp notOp, Map<String, Ramp> map) {
        this.renderLogicRecord(fDSRenderRecord, notOp, "ALL");
        fDSRenderRecord.setValue("INITIAL_STATE", true);
    }

    public void renderLatchCtrl(FDSRenderRecord fDSRenderRecord, LatchCtrl latchCtrl, Map<String, Ramp> map) {
        this.renderLogicRecord(fDSRenderRecord, latchCtrl, "ALL");
        fDSRenderRecord.setValue("LATCH", true);
    }

    private FDSRenderRecord renderLogicRecord(FDSRenderRecord fDSRenderRecord, IControl iControl, String string) {
        fDSRenderRecord.setValue("FUNCTION_TYPE", string);
        fDSRenderRecord.setValue("INITIAL_STATE", false, false);
        fDSRenderRecord.setValue("LATCH", false, false);
        this.markInputs(fDSRenderRecord, iControl);
        return fDSRenderRecord;
    }

    private void markInputs(FDSRenderRecord fDSRenderRecord, ISignalSink iSignalSink) {
        this.d_pinConnections.markForInputRetrieval(iSignalSink.getInputPin(), fDSRenderRecord, "INPUT_ID", "INPUT_ID");
    }

    private FDSRenderRecord newControlRec(ISignalSource iSignalSource) {
        IOutPin iOutPin = iSignalSource.getOutputPins().get(0);
        Pair<FDSRenderRecord, Boolean> pair = this.d_pinConnections.generateRecord("CTRL", "ID", iOutPin);
        if (!((Boolean)pair.v2).booleanValue()) {
            return null;
        }
        return (FDSRenderRecord)pair.v1;
    }
}

