/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;

public class BoundariesRenderer
extends AFDS6Renderer {
    private final QuantityMap d_quantityMap;
    private final FDSNameMap d_nameMap;

    public BoundariesRenderer(QuantityMap quantityMap, FDSNameMap fDSNameMap) {
        this.d_quantityMap = quantityMap;
        this.d_nameMap = fDSNameMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Boundaries.class);
    }

    private static IQuantity sQuantity(Quantity quantity) {
        return quantity.create();
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Boundaries boundaries = (Boundaries)iPyroObject;
        boolean bl = false;
        boolean bl2 = false;
        FDSRenderRecord fDSRenderRecord = null;
        String string = null;
        if (boundaries.getQuantities().contains(BoundariesRenderer.sQuantity(Quantity.PRESSURE_COEFFICIENT)) || boundaries.getQuantities().contains(BoundariesRenderer.sQuantity(Quantity.GAUGE_HEAT_FLUX))) {
            fDSRenderRecord = FDS6Const.newRenderRecord("PROP");
            if (boundaries.getQuantities().contains(BoundariesRenderer.sQuantity(Quantity.PRESSURE_COEFFICIENT)) && boundaries.getPressCoeffCharVel() != null) {
                fDSRenderRecord.setValue("CHARACTERISTIC_VELOCITY", boundaries.getPressCoeffCharVel(), false);
                bl = fDSRenderRecord.contains("CHARACTERISTIC_VELOCITY");
            }
            if (boundaries.getQuantities().contains(BoundariesRenderer.sQuantity(Quantity.GAUGE_HEAT_FLUX))) {
                if (boundaries.getGaugeEmissivity() != 0.9) {
                    fDSRenderRecord.setValue("GAUGE_EMISSIVITY", boundaries.getGaugeEmissivity(), false);
                }
                if (boundaries.getGaugeTemperature() != null) {
                    fDSRenderRecord.setValue("GAUGE_TEMPERATURE", boundaries.getGaugeTemperature(), false);
                }
                boolean bl3 = bl2 = fDSRenderRecord.contains("GAUGE_EMISSIVITY") || fDSRenderRecord.contains("GAUGE_TEMPERATURE");
            }
            if (fDSRenderRecord.empty()) {
                fDSRenderRecord = null;
            } else {
                string = this.d_nameMap.generateName("PROP", "BNDF_PROP");
                fDSRenderRecord.setValue("ID", string);
            }
        }
        for (IQuantity iQuantity : boundaries.getQuantities()) {
            FDSRenderRecord fDSRenderRecord2 = FDS6Const.newRenderRecord("BNDF");
            this.d_quantityMap.renderQuantity(fDSRenderRecord2, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, iQuantity);
            if (fDSRenderRecord != null && (iQuantity.equals(BoundariesRenderer.sQuantity(Quantity.PRESSURE_COEFFICIENT)) && bl || iQuantity.equals(BoundariesRenderer.sQuantity(Quantity.GAUGE_HEAT_FLUX)) && bl2)) {
                fDSRenderRecord2.setValue("PROP_ID", string);
            }
            iFDSRecordRenderer.render(fDSRenderRecord2, boundaries);
        }
        if (fDSRenderRecord != null) {
            iFDSRecordRenderer.render(fDSRenderRecord, boundaries);
        }
        return !boundaries.getQuantities().isEmpty();
    }
}

