/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.util.Pair;

public abstract class AFDSObjRenderer<T extends FDSObject>
extends AFDS6Renderer {
    private final FDSRasterization d_raster;

    public AFDSObjRenderer(FDSRasterization fDSRasterization) {
        this.d_raster = fDSRasterization;
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        RasterizationOptions rasterizationOptions = this.d_raster.getRastOptions();
        if (rasterizationOptions.mergeIdentical) {
            return this.renderMerged(iFDSRecordRenderer, collection);
        }
        return super.render(iFDSRecordRenderer, collection);
    }

    protected abstract boolean renderBlock(IFDSRecordRenderer var1, T var2);

    protected abstract boolean renderBlock(IFDSRecordRenderer var1, AABoxGeom var2, Collection<T> var3, FaceProps[] var4);

    private boolean renderMerged(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        boolean bl = false;
        ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>();
        FDSObjectRasterization[] fDSObjectRasterizationArray = collection.iterator();
        while (fDSObjectRasterizationArray.hasNext()) {
            FDSObjectRasterization[] fDSObjectRasterizationArray2 = fDSObjectRasterizationArray.next();
            FDSObject fDSObject2 = (FDSObject)fDSObjectRasterizationArray2;
            if (!this.d_raster.shouldRasterize(fDSObject2)) {
                bl |= this.renderBlock(iFDSRecordRenderer, fDSObject2);
                continue;
            }
            arrayList.add(fDSObject2);
        }
        for (FDSObjectRasterization fDSObjectRasterization : fDSObjectRasterizationArray = this.d_raster.rasterize(arrayList)) {
            List list = fDSObjectRasterization.sources.stream().map(fDSObject -> fDSObject).collect(Collectors.toList());
            for (Pair<IGeom, FaceProps[]> pair : fDSObjectRasterization.geoms) {
                bl |= this.renderBlock(iFDSRecordRenderer, AFDSObjRenderer.toBlock((IGeom)pair.v1), list, (FaceProps[])pair.v2);
            }
        }
        return bl;
    }

    @Override
    protected boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        FDSObject fDSObject = (FDSObject)iPyroObject;
        if (!this.d_raster.shouldRasterize(fDSObject)) {
            return this.renderBlock(iFDSRecordRenderer, fDSObject);
        }
        boolean bl = false;
        FDSObjectRasterization fDSObjectRasterization = this.d_raster.rasterize(fDSObject);
        Set<FDSObject> set = Collections.singleton(fDSObject);
        for (Pair<IGeom, FaceProps[]> pair : fDSObjectRasterization.geoms) {
            bl |= this.renderBlock(iFDSRecordRenderer, AFDSObjRenderer.toBlock((IGeom)pair.v1), set, (FaceProps[])pair.v2);
        }
        return bl;
    }

    protected static AABoxGeom toBlock(IGeom iGeom) {
        if (iGeom instanceof AABoxGeom) {
            return (AABoxGeom)iGeom;
        }
        AABox aABox = iGeom.getBoundingBox(new AABox());
        return new AABoxGeom(aABox.getMin(), aABox.getMax(), 0);
    }
}

