/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.vecmath.Point3d;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Colors;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.IFDS6Renderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import pyrosim.legacy_2006_2.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public abstract class AFDS6Renderer
implements IFDS6Renderer {
    @Override
    public boolean markDependency(DepSnapshot depSnapshot, IPyroObject iPyroObject, boolean bl) {
        return true;
    }

    @Override
    public Collection<IPyroObject> sortPyroObjects(Collection<IPyroObject> collection) {
        return collection;
    }

    protected void doneRendering(IFDSRecordRenderer iFDSRecordRenderer) {
    }

    public void fillSingletonRecords(SingletonRecords singletonRecords, IPyroObject ... iPyroObjectArray) {
        this.fillSingletonRecords(singletonRecords, Arrays.asList(iPyroObjectArray));
    }

    @Override
    public void fillSingletonRecords(SingletonRecords singletonRecords, Collection<? extends IPyroObject> collection) {
        for (IPyroObject iPyroObject : collection) {
            this.fillSingletonRecords(singletonRecords, iPyroObject);
        }
    }

    protected void fillSingletonRecords(SingletonRecords singletonRecords, IPyroObject iPyroObject) {
    }

    public void render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject ... iPyroObjectArray) {
        this.render(iFDSRecordRenderer, Arrays.asList(iPyroObjectArray));
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        boolean bl = false;
        for (IPyroObject iPyroObject : collection) {
            bl |= this.render(iFDSRecordRenderer, iPyroObject);
        }
        this.doneRendering(iFDSRecordRenderer);
        return bl;
    }

    protected boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        return false;
    }

    protected static void renderEvac(FDSRenderRecord fDSRenderRecord, String string, String string2, EvacProps evacProps) {
        switch (evacProps.evacuation) {
            case 2: {
                fDSRenderRecord.setValue(string, true);
                break;
            }
            case 1: {
                fDSRenderRecord.setValue(string, false);
            }
        }
        if (evacProps.mesh != null) {
            fDSRenderRecord.setValue(string2, evacProps.mesh.getName());
        }
    }

    protected static void renderColor(FDSRenderRecord fDSRenderRecord, boolean bl, Color color, String string, String string2, String string3) {
        if (!bl) {
            fDSRenderRecord.setValue(string2, "INVISIBLE");
            return;
        }
        if (color != null) {
            Object object;
            boolean bl2 = false;
            if (string2 != null && (object = FDS6Colors.getName(color)) != null) {
                fDSRenderRecord.setValue(string2, object, false);
                bl2 = true;
            }
            if (!bl2 && string != null) {
                object = new FDSArray<Object>(color.getRed(), color.getGreen(), color.getBlue());
                fDSRenderRecord.setValue(string, object, false);
            }
            if (string3 != null) {
                double d = (double)color.getAlpha() / 255.0;
                fDSRenderRecord.setValue(string3, d, false);
            }
        }
    }

    protected static void renderAABox(FDSRenderRecord fDSRenderRecord, String string, AABox aABox) {
        AFDS6Renderer.renderXB(fDSRenderRecord, string, aABox.getMin(), aABox.getMax());
    }

    protected static void renderAABox(FDSRenderRecord fDSRenderRecord, String string, UnitAABox unitAABox) {
        AFDS6Renderer.renderXB(fDSRenderRecord, string, unitAABox.getMin(), unitAABox.getMax());
    }

    protected static void renderXB(FDSRenderRecord fDSRenderRecord, String string, Point3d point3d, Point3d point3d2) {
        FDSArray<Object> fDSArray = new FDSArray<Object>(AFDS6Renderer.lv(point3d.x), AFDS6Renderer.lv(point3d2.x), AFDS6Renderer.lv(point3d.y), AFDS6Renderer.lv(point3d2.y), AFDS6Renderer.lv(point3d.z), AFDS6Renderer.lv(point3d2.z));
        fDSRenderRecord.setValue(string, fDSArray);
    }

    private static UnitDouble lv(double d) {
        return new UnitDouble(d, Geometry.GEOM_LENGTH_UNIT);
    }

    protected static void renderXB(FDSRenderRecord fDSRenderRecord, String string, UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        FDSArray<Object> fDSArray = new FDSArray<Object>(unitPoint3D.xu(), unitPoint3D2.xu(), unitPoint3D.yu(), unitPoint3D2.yu(), unitPoint3D.zu(), unitPoint3D2.zu());
        fDSRenderRecord.setValue(string, fDSArray);
    }

    protected static void renderTextureOrigin(FDSRenderRecord fDSRenderRecord, String string, FDSObject fDSObject, TexOrigin texOrigin) {
        UnitPoint3D unitPoint3D = texOrigin.getWorld(fDSObject);
        if (!unitPoint3D.equals(TexOrigin.DEF_LOC)) {
            AFDS6Renderer.renderLoc(fDSRenderRecord, string, unitPoint3D, true);
        }
    }

    protected static void renderLoc(FDSRenderRecord fDSRenderRecord, String string, UnitPoint3D unitPoint3D) {
        AFDS6Renderer.renderLoc(fDSRenderRecord, string, unitPoint3D, true);
    }

    protected static void renderLoc(FDSRenderRecord fDSRenderRecord, String string, UnitPoint3D unitPoint3D, boolean bl) {
        FDSArray<Object> fDSArray = new FDSArray<Object>(unitPoint3D.xu(), unitPoint3D.yu(), unitPoint3D.zu());
        fDSRenderRecord.setValue(string, fDSArray, bl);
    }

    protected static void renderTVal(FDSRenderRecord fDSRenderRecord, FDSNameMap fDSNameMap, Map<String, Ramp> map, String string, TimeBasedValue timeBasedValue, String string2, String string3, String string4, boolean bl) {
        fDSRenderRecord.setValue(string2, timeBasedValue.val, bl);
        AFDS6Renderer.renderTimeFunc(fDSRenderRecord, fDSNameMap, map, string, timeBasedValue.func, string3, string4);
    }

    protected static void renderTimeFunc(FDSRenderRecord fDSRenderRecord, FDSNameMap fDSNameMap, Map<String, Ramp> map, String string, TimeFunction timeFunction, String string2, String string3) {
        if (timeFunction instanceof TimeFunction.TanH) {
            if (string3 != null) {
                fDSRenderRecord.setValue(string3, timeFunction.val, false);
            }
        } else if (timeFunction instanceof TimeFunction.TSquared) {
            UnitDouble unitDouble = (UnitDouble)((TimeFunction.TSquared)timeFunction).val;
            fDSRenderRecord.setValue(string3, unitDouble.negate(), false);
        } else {
            assert (string2 != null);
            assert (timeFunction instanceof TimeFunction.Custom);
            Ramp ramp = (Ramp)timeFunction.val;
            String string4 = RampRenderer.createID(fDSNameMap, string, string2);
            map.put(string4, ramp);
            fDSRenderRecord.setValue(string2, string4, false);
        }
    }

    protected void renderVariant(IFDSRecordRenderer iFDSRecordRenderer, FDSRenderRecord fDSRenderRecord, FDSNameMap fDSNameMap, Map<String, Ramp> map, String string, Variant variant, String string2, String string3) {
        if (variant.isRamp() && string3 != null) {
            String string4 = RampRenderer.createID(fDSNameMap, string, string3);
            map.put(string4, (Ramp)variant.val);
            fDSRenderRecord.setValue(string3, string4, false);
        } else if (variant.isConstant() && string2 != null) {
            fDSRenderRecord.setValue(string2, (UnitDouble)variant.val);
        }
    }

    protected void renderSimpleVariant(FDSRenderRecord fDSRenderRecord, String string, Variant variant) {
        this.renderVariant(null, fDSRenderRecord, null, null, null, variant, string, null);
    }

    protected static void renderAARectangle(FDSRenderRecord fDSRenderRecord, String string, AARectangle aARectangle) {
        AABox aABox = aARectangle.getBoundingBox(new AABox());
        AFDS6Renderer.renderAABox(fDSRenderRecord, string, aABox);
    }

    protected static Integer renderVelocitySign(VelocitySign velocitySign) {
        switch (velocitySign) {
            case ALWAYS_POSITIVE: {
                return null;
            }
            case MATCH_U: {
                return 1;
            }
            case MATCH_V: {
                return 2;
            }
            case MATCH_W: {
                return 3;
            }
        }
        return null;
    }

    protected static void renderCustomFDSProps(FDSRenderRecord fDSRenderRecord, ICustomFDSPropsContainer iCustomFDSPropsContainer) {
        AFDS6Renderer.renderCustomFDSProps(fDSRenderRecord, iCustomFDSPropsContainer.getCustomFDSProps(fDSRenderRecord.getType()));
    }

    protected static void renderCustomFDSProps(FDSRenderRecord fDSRenderRecord, CustomFDSProps customFDSProps) {
        for (Map.Entry<String, String> entry : customFDSProps.getProps().entrySet()) {
            fDSRenderRecord.addUnknownProp(entry.getKey(), Arrays.asList(entry.getValue()));
        }
    }

    protected static Color resolveSurfaceColor(Color color, Surface surface) {
        Color color2 = color;
        if (surface != null && surface.getAppearance() != null && surface.getAppearance().getAttributes().getTexture(MatChannel.DIFFUSE) == null) {
            return surface.getAppearance().getAttributes().getDiffuseColorWithOpacity();
        }
        return color2;
    }
}

