/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.GridUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.tasks.AddGridBoundaryVentsTask;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.AFDSObjParser;
import pyrosim.io.fds.v6.parsers.ExSpecParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class VentParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;
    private final ExSpecParser d_specParser;
    private Map<FDSParseRecord, Vent> d_ventMap;
    private Map<Grid, GridMergeUtil.BoundaryInfo> d_gridFaces;

    public VentParser(FDS6ParsingInfo fDS6ParsingInfo, PinConnParser pinConnParser, ExSpecParser exSpecParser) {
        super(fDS6ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_specParser = exSpecParser;
        this.d_ventMap = new LinkedHashMap<FDSParseRecord, Vent>();
        this.d_gridFaces = null;
    }

    public Map<FDSParseRecord, Vent> getVentMap() {
        return this.d_ventMap;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("VENT");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("L_EDDY", "UNSUPPORTED");
        map.put("L_EDDY_IJ", "UNSUPPORTED");
        map.put("MULT_ID", "UNSUPPORTED");
        map.put("N_EDDY", "UNSUPPORTED");
        map.put("REYNOLDS_STRESS", "UNSUPPORTED");
        map.put("TMP_EXTERIOR_RAMP", "UNSUPPORTED");
        map.put("VEL_RMS", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("SURF_ID", false);
        Surface surface = this.getSurfaceSafe(fDSParseRecord, string, Vent.getSurfaceFilter());
        this.d_ventMap.put(fDSParseRecord, null);
        String string2 = this.generateName(fDSParseRecord, "ID", Intl.intl("Vent"));
        if (fDSParseRecord.contains("XB")) {
            UnitPoint3D[] unitPoint3DArray = VentParser.parseXB(fDSParseRecord, "VENT", "XB", true);
            if (VentParser.countDimensions(unitPoint3DArray[0], unitPoint3DArray[1]) > 2) {
                throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Vents must be specified as two-dimensional objects."));
            }
            Vent vent = new Vent(string2, surface, AARectangle.construct(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU), false));
            if (fDSParseRecord.contains("IOR")) {
                vent.setNormal(pyrosim.io.fds.v6.common.GeomUtil.toWorldVec(fDSParseRecord.getInteger("IOR", false)));
            }
            this.addVent(fDSParseRecord, vent);
            this.addObject(vent);
        } else if (fDSParseRecord.contains("PBX")) {
            double d = fDSParseRecord.getUnitDouble("PBX", false).getValue(Geometry.LU);
            Plane3d plane3d = new Plane3d(1.0, 0.0, 0.0, -d);
            this.addVentsAlongPlane(fDSParseRecord, string2, surface, plane3d);
        } else if (fDSParseRecord.contains("PBY")) {
            double d = fDSParseRecord.getUnitDouble("PBY", false).getValue(Geometry.LU);
            Plane3d plane3d = new Plane3d(0.0, 1.0, 0.0, -d);
            this.addVentsAlongPlane(fDSParseRecord, string2, surface, plane3d);
        } else if (fDSParseRecord.contains("PBZ")) {
            double d = fDSParseRecord.getUnitDouble("PBZ", false).getValue(Geometry.LU);
            Plane3d plane3d = new Plane3d(0.0, 0.0, 1.0, -d);
            this.addVentsAlongPlane(fDSParseRecord, string2, surface, plane3d);
        } else {
            if (fDSParseRecord.contains("MB")) {
                FDS6Const.VentMB ventMB = VentParser.getMB(fDSParseRecord);
                return this.addVentsForGridFace(fDSParseRecord, surface, ventMB);
            }
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Vents must have geometry specified."));
        }
        return true;
    }

    private void addVent(FDSParseRecord fDSParseRecord, Vent vent) throws FDSRecordFormatException {
        AABox aABox = vent.getGeom().getBoundingBox(new AABox());
        TexOrigin texOrigin = VentParser.parseTexLoc(fDSParseRecord, aABox.getMin(), "VENT", "TEXTURE_ORIGIN");
        vent.setTextureOrigin(texOrigin);
        Pair<UnitPoint3D, UnitDouble> pair = this.parseFireSpread(fDSParseRecord, vent.getSurface(), aABox);
        if (pair != null) {
            vent.setFireSpreadRate((UnitDouble)pair.v2);
            vent.setCenterPoint((UnitPoint3D)pair.v1);
        }
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("RADIUS");
        vent.setRadius(unitDouble);
        Color color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", false);
        this.applyColor(vent, color);
        VentParser.markSingleInputForRetrieval(fDSParseRecord, vent, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        vent.setOptions(1, fDSParseRecord.getBoolean("OUTLINE", true));
        vent.setEvac(this.parseEvac(fDSParseRecord, "EVACUATION", "MESH_ID"));
        Vent.OpenProps openProps = this.parseOpenProps(fDSParseRecord);
        if (openProps != null) {
            if (vent.getSurface().isPredefined(PredefSurf.OPEN)) {
                vent.setOpenProps(openProps);
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("OPEN vent properties specified for a non-OPEN vent."), Intl.intl("Ignoring OPEN vent properties"));
            }
        }
        vent.setLouver(this.parseLouver(fDSParseRecord));
        this.parseCustomFDSProps(vent, fDSParseRecord);
        this.d_ventMap.put(fDSParseRecord, vent);
        this.flagObjectAdded(vent);
    }

    private Vector3d parseLouver(FDSParseRecord fDSParseRecord) {
        if (!fDSParseRecord.contains("UVW")) {
            return null;
        }
        FDSArray fDSArray = fDSParseRecord.getArray("UVW", true);
        return new Vector3d((Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2));
    }

    private Vent.OpenProps parseOpenProps(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (!(fDSParseRecord.contains("TMP_EXTERIOR") || fDSParseRecord.contains("PRESSURE_RAMP") || fDSParseRecord.contains("DYNAMIC_PRESSURE"))) {
            return null;
        }
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("TMP_EXTERIOR", true);
        if (fDSParseRecord.contains("PRESSURE_RAMP") && !fDSParseRecord.contains("DYNAMIC_PRESSURE")) {
            this.addWarning(fDSParseRecord, Intl.intl("PRESSURE_RAMP specified without DYNAMIC_PRESSURE"), "");
        }
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("DYNAMIC_PRESSURE", true);
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, (String)null, "PRESSURE_RAMP");
        TimeBasedValue<UnitDouble> timeBasedValue = new TimeBasedValue<UnitDouble>(unitDouble2, timeFunction);
        return new Vent.OpenProps(unitDouble, timeBasedValue);
    }

    private Pair<UnitPoint3D, UnitDouble> parseFireSpread(FDSParseRecord fDSParseRecord, Surface surface, AABox aABox) throws FDSRecordFormatException {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("SPREAD_RATE");
        if (unitDouble != null && unitDouble.getValueNoUnit() > 0.0) {
            if (!Vent.isValidFireSpreadSurf(surface)) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a valid surface for spreading a fire on a vent."), surface.getName()), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            UnitPoint3D unitPoint3D = VentParser.parseLoc(fDSParseRecord, Intl.intl("Vent"), "XYZ", false, false);
            if (unitPoint3D == null) {
                this.addWarning(fDSParseRecord, Intl.intl("Vent with a fire spread rate did not specify a spread origin."), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            UnitPoint3D unitPoint3D2 = new UnitPoint3D(aABox.getMin(), Geometry.LU);
            UnitPoint3D unitPoint3D3 = new UnitPoint3D(aABox.getMax(), Geometry.LU);
            if (unitPoint3D2.xu().compareTo(unitPoint3D.xu()) > 0 || unitPoint3D3.xu().compareTo(unitPoint3D.xu()) < 0 || unitPoint3D2.yu().compareTo(unitPoint3D.yu()) > 0 || unitPoint3D3.yu().compareTo(unitPoint3D.yu()) < 0 || unitPoint3D2.zu().compareTo(unitPoint3D.zu()) > 0 || unitPoint3D3.zu().compareTo(unitPoint3D.zu()) < 0) {
                this.addWarning(fDSParseRecord, Intl.intl("The fire spread origin must lie on the vent."), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            return new Pair<UnitPoint3D, UnitDouble>(unitPoint3D, unitDouble);
        }
        return null;
    }

    private boolean addVentsForGridFace(FDSParseRecord fDSParseRecord, Surface surface, FDS6Const.VentMB ventMB) throws FDSRecordFormatException {
        Map<Grid, GridMergeUtil.BoundaryInfo> map = this.getGridFaces();
        if (map.isEmpty()) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to match vent to mesh boundaries."), Intl.intl("Adding vent to Additional Records"));
            return false;
        }
        GridUtil.GridFace gridFace = null;
        switch (ventMB) {
            case XMIN: {
                gridFace = GridUtil.GridFace.XMIN;
                break;
            }
            case XMAX: {
                gridFace = GridUtil.GridFace.XMAX;
                break;
            }
            case YMIN: {
                gridFace = GridUtil.GridFace.YMIN;
                break;
            }
            case YMAX: {
                gridFace = GridUtil.GridFace.YMAX;
                break;
            }
            case ZMIN: {
                gridFace = GridUtil.GridFace.ZMIN;
                break;
            }
            case ZMAX: {
                gridFace = GridUtil.GridFace.ZMAX;
            }
        }
        List<Pair<Grid, List<Vent>>> list = GridUtil.constructVents(this.getContainer().getGridManager().flatten(), map, surface, gridFace);
        for (Pair<Grid, List<Vent>> pair : list) {
            for (Vent vent : (List)pair.v2) {
                this.addVent(fDSParseRecord, vent);
            }
        }
        new AddGridBoundaryVentsTask(this.getContainer(), list).run();
        return true;
    }

    private void addVentsAlongPlane(FDSParseRecord fDSParseRecord, String string, Surface surface, final Plane3d plane3d) throws FDSRecordFormatException {
        Object object;
        final ArrayList<AARectangle> arrayList2 = new ArrayList<AARectangle>();
        Map<Grid, GridMergeUtil.BoundaryInfo> map = this.getGridFaces();
        for (Map.Entry<Grid, GridMergeUtil.BoundaryInfo> object22 : map.entrySet()) {
            for (Face face : object22.getValue().faces) {
                AARectangle aARectangle;
                if (!VentParser.equal(face.plane, plane3d, 1.0E-9) || (aARectangle = AARectangle.construct(((AABox)(object = face.getBounds())).getMin(), ((AABox)object).getMax(), false)) == null) continue;
                arrayList2.add(aARectangle);
            }
        }
        ITest<AABox> iTest = new ITest<AABox>(){

            @Override
            public Containment test(AABox aABox) {
                int n = 0;
                int n2 = 0;
                for (Point3d point3d : aABox.getVerts()) {
                    double d = plane3d.dot(point3d);
                    if (theUtil.eq0(d, 1.0E-9)) {
                        return Containment.INTERSECTS;
                    }
                    if (theUtil.gt0(d, 1.0E-9)) {
                        ++n;
                    } else {
                        ++n2;
                    }
                    if (n <= 0 || n2 <= 0) continue;
                    return Containment.INTERSECTS;
                }
                return Containment.OUTSIDE;
            }
        };
        IResult<IDisplayableGeomSrc> iResult = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc iDisplayableGeomSrc, Containment containment) {
                if (!(iDisplayableGeomSrc instanceof IObstruction)) {
                    return;
                }
                IObstruction iObstruction = (IObstruction)iDisplayableGeomSrc;
                IGeom iGeom = iObstruction.getGeom().flatten().getLocalGeom();
                if (iGeom.isShell() && !iObstruction.getOptions(1)) {
                    return;
                }
                for (IPolygon iPolygon : GeomUtil.explode(iGeom, IPolygon.class)) {
                    AARectangle aARectangle = VentParser.rectFromFace(iPolygon, plane3d);
                    if (aARectangle == null) continue;
                    arrayList2.add(aARectangle);
                }
            }
        };
        this.getContainer().getGeomLocator().updateDirty();
        this.getContainer().getGeomLocator().find(iTest, (IResult<? super IDisplayableGeomSrc>)iResult, true);
        if (arrayList2.isEmpty()) {
            String n = Intl.intl("Vent does not intersect any solid obstructions.");
            String string2 = Intl.intl("Skipping vent.");
            this.addWarning(new FDSParseWarning(fDSParseRecord, n, string2));
        } else {
            int n = 0;
            ArrayList<Vent> arrayList = new ArrayList<Vent>(arrayList2.size());
            for (AARectangle aARectangle : arrayList2) {
                String string3 = arrayList2.size() > 1 ? String.format("%s[%d]", string, n++) : string;
                Vent vent = new Vent(string3, surface, aARectangle);
                this.addVent(fDSParseRecord, vent);
                arrayList.add(vent);
            }
            if (arrayList.size() == 1) {
                this.addObject((IPyroObject)arrayList.get(0));
            } else {
                object = new ModelComposite(string);
                ((Composite)object).addAll(arrayList);
                this.getContainer().getObstructions().add((IPyroObject)object);
            }
        }
    }

    private static AARectangle rectFromFace(IFace iFace, Plane3d plane3d) {
        if (!(iFace instanceof IPolygon)) {
            return null;
        }
        IPolygon iPolygon = (IPolygon)iFace;
        if (!VentParser.equal(iPolygon.getPlane(true), plane3d, 1.0E-9)) {
            return null;
        }
        AABox aABox = iFace.getBoundingBox(new AABox());
        return AARectangle.construct(aABox.getMin(), aABox.getMax(), false);
    }

    private void applyColor(Vent vent, Color color) {
        if (color == INVISIBLE_COLOR) {
            vent.setVisible(false);
            vent.setColors(new Color[]{null});
        } else {
            vent.setColors(color);
        }
    }

    protected static FDS6Const.VentMB getMB(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = fDSParseRecord.getString("MB", false);
        if (string == null) {
            return null;
        }
        for (FDS6Const.VentMB ventMB : FDS6Const.VentMB.values()) {
            if (!string.equals(ventMB.fdsName)) continue;
            return ventMB;
        }
        throw new FDSRecordFormatException(String.format(Intl.intl("Unrecognized value for %1$S: %2$s"), "MB", string));
    }

    protected Map<Grid, GridMergeUtil.BoundaryInfo> getGridFaces() {
        if (this.d_gridFaces == null) {
            this.d_gridFaces = GridMergeUtil.mergeGrids(this.getContainer().getGridManager().flatten(), (Collection<? extends IPyroGeomSrc>)Collections.EMPTY_LIST).faces;
        }
        return this.d_gridFaces;
    }

    protected static boolean equal(Plane3d plane3d, Plane3d plane3d2, double d) {
        return plane3d.epsilonEquals(plane3d2, d) || plane3d.epsilonEquals(plane3d2.negate(), d);
    }
}

