/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.util.Lists;

public class TableParser
extends AFDS6Parser {
    public TableParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("TABL");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("ID");
        if (string == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Table entry has no ID."), Intl.intl("Adding table entry to additional records section."));
            return false;
        }
        List<Double> list = fDSParseRecord.getList("TABLE_DATA", false);
        if (list == null || list.isEmpty()) {
            this.addWarning(fDSParseRecord, Intl.intl("Table entry has no values."), Intl.intl("Ignoring table entry."));
            return true;
        }
        if (Lists.containsNull(list)) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Null values are not allowed in table entries."));
        }
        this.getParsingInfo().addTableRow(string, list);
        return true;
    }
}

