/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.Iterator;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.ramp.Ramp;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.ParseTest;
import pyrosim.io.fds.v6.FDS6Colors;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.ExSpecParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.MaterialParser;
import pyrosim.io.fds.v6.parsers.ParticleParser;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.RampParser;
import pyrosim.io.fds.v6.parsers.SurfaceParser;
import pyrosim.io.fds.v6.parsers.ZoneParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class SurfaceParserTest
extends ParseTest {
    private PyroMod d_mod;
    private FDS6ParsingInfo d_pinfo;
    private SurfaceParser d_surfParser;
    private ExSpecParser d_exSpecParser;

    public SurfaceParserTest(String string) {
        super(string, FDS6Const.getRecordSpecs());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.d_mod = new PyroMod();
        this.d_pinfo = new FDS6ParsingInfo(null, this.d_mod, this.d_mod);
        this.d_exSpecParser = new ExSpecParser(this.d_pinfo);
        ZoneParser zoneParser = new ZoneParser(this.d_pinfo);
        this.d_surfParser = new SurfaceParser(this.d_pinfo, zoneParser);
    }

    public void testSurfaceParse_ID_COLOR() {
        String string = "&SURF ";
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            SurfaceParserTest.assertTrue((boolean)this.d_surfParser.getParsingInfo().getParseResult().warningReport.isEmpty());
            string = "&SURF ID='SURF02' COLOR='GRAY 80' ADIABATIC=.TRUE./";
            SurfaceParserTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(string, true)));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertFalse((boolean)surface.isPredefined());
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 80"), (Object)surface.getColor());
            string = "&SURF ID='SURF03' COLOR='GRAY 90' /";
            SurfaceParserTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(string, true)));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceParserTest.assertFalse((boolean)surface.isPredefined());
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 90"), (Object)surface.getColor());
            string = "&SURF ID='SURF04' ADIABATIC=.TRUE./";
            SurfaceParserTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(string, true)));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceParserTest.assertFalse((boolean)surface.isPredefined());
            SurfaceParserTest.assertNotNull((Object)surface.getColor());
            string = "&SURF ID='SURF05'/";
            SurfaceParserTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(string, true)));
            SurfaceParserTest.assertEquals((int)(n + 4), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF05");
            SurfaceParserTest.assertFalse((boolean)surface.isPredefined());
            SurfaceParserTest.assertNotNull((Object)surface.getColor());
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof SurfDescStatic));
            string = "&SURF ID=''/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)1, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)2, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    public void testSurfaceParse_same_name() {
        String string = "&SURF ID='SURF02' COLOR='GRAY 90'/";
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertTrue((boolean)this.d_surfParser.getParsingInfo().getParseResult().warningReport.isEmpty());
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 90"), (Object)surface.getColor());
            string = "&SURF ID='SURF02' COLOR='GRAY 80'/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            SurfaceParserTest.assertEquals((int)1, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            // empty catch block
        }
    }

    public void testSurfaceParse_heat_release() {
        String string = "&SURF ID='SURF02' COLOR='GRAY 90'HRRPUA=60.00 TAU_Q=-25.00 E_COEFFICIENT=20.00/";
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 90"), (Object)surface.getColor());
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BurnerSurfDesc));
            BurnerSurfDesc burnerSurfDesc = (BurnerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(burnerSurfDesc.d_heatRelease.d_type instanceof HeatRelease.HRRType));
            SurfaceParserTest.assertEquals((Object)60.0, (Object)((UnitDouble)((HeatRelease.HRRType)burnerSurfDesc.d_heatRelease.d_type).val).getValue(SIUS.unit(22)));
            SurfaceParserTest.assertTrue((boolean)(((HeatRelease.HRRType)burnerSurfDesc.d_heatRelease.d_type).func.val instanceof UnitDouble));
            SurfaceParserTest.assertTrue((boolean)(((HeatRelease.HRRType)burnerSurfDesc.d_heatRelease.d_type).func instanceof TimeFunction.TSquared));
            SurfaceParserTest.assertEquals((Object)25.0, (Object)((UnitDouble)((HeatRelease.HRRType)burnerSurfDesc.d_heatRelease.d_type).func.val).getValue(SIUS.unit(2)));
            SurfaceParserTest.assertEquals((Object)20.0, (Object)burnerSurfDesc.d_heatRelease.d_extingCoeff.getValue(SIUS.unit(21)));
            string = "&SURF ID='SURF03' COLOR='GRAY 90'HRRPUA TAU_Q=-25.00 E_COEFFICIENT=20.00/";
            SurfaceParserTest.assertNull((Object)this.parseRecord(string, false));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            SurfaceParserTest.assertNull(this.d_mod.getSurfaceMgr().get("SURF03"));
            string = "&SURF ID='SURF04' COLOR='GRAY 90'HRRPUA=60.00 TAU_Q E_COEFFICIENT=20.00/";
            SurfaceParserTest.assertNull((Object)this.parseRecord(string, false));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            SurfaceParserTest.assertNull(this.d_mod.getSurfaceMgr().get("SURF04"));
            string = "&SURF ID='SURF05' COLOR='GRAY 90'HRRPUA=60.00 TAU_Q=-25.00 E_COEFFICIENT/";
            SurfaceParserTest.assertNull((Object)this.parseRecord(string, false));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            SurfaceParserTest.assertNull(this.d_mod.getSurfaceMgr().get("SURF05"));
            string = "&SURF ID='SURF06' COLOR='GRAY 70'MLRPUA=60.00 TAU_Q=25.00 E_COEFFICIENT=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF06");
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 70"), (Object)surface.getColor());
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BurnerSurfDesc));
            burnerSurfDesc = (BurnerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(burnerSurfDesc.d_heatRelease.d_type instanceof HeatRelease.MLRType));
            SurfaceParserTest.assertEquals((Object)60.0, (Object)((UnitDouble)((HeatRelease.MLRType)burnerSurfDesc.d_heatRelease.d_type).val).getValue(SIUS.unit(44)));
            SurfaceParserTest.assertTrue((boolean)(((HeatRelease.MLRType)burnerSurfDesc.d_heatRelease.d_type).func instanceof TimeFunction.TanH));
            SurfaceParserTest.assertTrue((boolean)(((HeatRelease.MLRType)burnerSurfDesc.d_heatRelease.d_type).func.val instanceof UnitDouble));
            SurfaceParserTest.assertEquals((Object)25.0, (Object)((UnitDouble)((HeatRelease.MLRType)burnerSurfDesc.d_heatRelease.d_type).func.val).getValue(SIUS.unit(2)));
            SurfaceParserTest.assertEquals((Object)21.0, (Object)burnerSurfDesc.d_heatRelease.d_extingCoeff.getValue(SIUS.unit(21)));
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF07' COLOR='GRAY 50'MLRPUA=60.00 HRRPUA=60.00 /";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF07");
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 50"), (Object)surface.getColor());
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BurnerSurfDesc));
            burnerSurfDesc = (BurnerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(burnerSurfDesc.d_heatRelease.d_type instanceof HeatRelease.HRRType));
            SurfaceParserTest.assertEquals((Object)60.0, (Object)((UnitDouble)((HeatRelease.HRRType)burnerSurfDesc.d_heatRelease.d_type).val).getValue(SIUS.unit(22)));
            SurfaceParserTest.assertEquals((int)1, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    public void testSurfaceParse_part_injection() {
        ParticleParser particleParser = new ParticleParser(this.d_pinfo, new PinConnParser(this.d_pinfo));
        String string = "&SURF ID='SURF02' COLOR='GRAY 90'HRRPUA=500.00 PART_ID='PART' NPPC=15 PARTICLE_MASS_FLUX=20.00/";
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            this.d_exSpecParser.process(this.parseRecord("&SPEC ID='OXYGEN'/", true));
            particleParser.process(this.parseRecord("&PART ID='PART' SPEC_ID='OXYGEN'/", true));
            particleParser.process(this.parseRecord("&PART ID='PARTMASSLESS' MASSLESS=.TRUE./", true));
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 90"), (Object)surface.getColor());
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BurnerSurfDesc));
            BurnerSurfDesc burnerSurfDesc = (BurnerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(burnerSurfDesc.d_heatRelease.d_type instanceof HeatRelease.HRRType));
            SurfaceParserTest.assertEquals((Object)500.0, (Object)((UnitDouble)((HeatRelease.HRRType)burnerSurfDesc.d_heatRelease.d_type).val).getValue(SIUS.unit(22)));
            SurfaceParserTest.assertNotNull((Object)burnerSurfDesc.d_partInj);
            SurfaceParserTest.assertEquals((int)15, (int)burnerSurfDesc.d_partInj.d_numPartsPerCell);
            SurfaceParserTest.assertEquals((Object)20.0, (Object)((UnitDouble)burnerSurfDesc.d_partInj.getMassFlux().val).getValue(SIUS.unit(45)));
            SurfaceParserTest.assertEquals((String)"PART", (String)burnerSurfDesc.d_partInj.getParticle().getName());
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF03' COLOR='GRAY 40'HRRPUA=500.00 PART_ID='NotThere' NPPC=15 PARTICLE_MASS_FLUX=20.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 40"), (Object)surface.getColor());
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BurnerSurfDesc));
            burnerSurfDesc = (BurnerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(burnerSurfDesc.d_heatRelease.d_type instanceof HeatRelease.HRRType));
            SurfaceParserTest.assertNull((Object)burnerSurfDesc.d_partInj);
            SurfaceParserTest.assertEquals((int)1, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF04' COLOR='GRAY 30'HRRPUA=500.00 PART_ID='PARTMASSLESS' NPPC=15 PARTICLE_MASS_FLUX=20.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 30"), (Object)surface.getColor());
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BurnerSurfDesc));
            burnerSurfDesc = (BurnerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(burnerSurfDesc.d_heatRelease.d_type instanceof HeatRelease.HRRType));
            SurfaceParserTest.assertNotNull((Object)burnerSurfDesc.d_partInj);
            SurfaceParserTest.assertEquals((int)15, (int)burnerSurfDesc.d_partInj.d_numPartsPerCell);
            SurfaceParserTest.assertNull(burnerSurfDesc.d_partInj.getMassFlux());
            SurfaceParserTest.assertEquals((int)2, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    public void testSurfaceParse_air_flow() {
        String string = "&SURF ID='SURF02' COLOR='GRAY 90' VEL=-20.00/";
        RampParser rampParser = new RampParser(this.d_pinfo);
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertEquals((Object)FDS6Colors.getColor("GRAY 90"), (Object)surface.getColor());
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BlowerSurfDesc));
            BlowerSurfDesc blowerSurfDesc = (BlowerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)blowerSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)20.0, (Object)((AirFlow.ValRate)blowerSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_profile instanceof AirFlow.TopHatProf));
            string = "&SURF ID='SURF03'VEL=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
            InFlowSurfDesc inFlowSurfDesc = (InFlowSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)inFlowSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)21.0, (Object)((AirFlow.ValRate)inFlowSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_profile instanceof AirFlow.TopHatProf));
            FDSParseRecord fDSParseRecord = this.parseRecord("&RAMP ID='SURF02_RAMP_V' T=0.00 F=0.50/", true);
            rampParser.process(fDSParseRecord);
            fDSParseRecord = this.parseRecord("&RAMP ID='SURF02_RAMP_V' T=2.00 F=0.60/", true);
            rampParser.process(fDSParseRecord);
            string = "&SURF ID='SURF04' VOLUME_FLUX=-50.00 RAMP_V='SURF02_RAMP_V' VEL_T=21.00,22.00 PROFILE='ATMOSPHERIC' PLE=0.50 Z0=0.60/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BlowerSurfDesc));
            blowerSurfDesc = (BlowerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)blowerSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_profile instanceof AirFlow.AtmosphericProf));
            SurfaceParserTest.assertEquals((Object)0.5, (Object)((AirFlow.AtmosphericProf)blowerSurfDesc.d_airFlow.d_profile).d_exponent);
            SurfaceParserTest.assertEquals((Object)0.6, (Object)((AirFlow.AtmosphericProf)blowerSurfDesc.d_airFlow.d_profile).d_origin.getValue(SIUS.unit(0)));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.VolumeFlux));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)50.0, (Object)((AirFlow.ValRate)blowerSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(24)));
            SurfaceParserTest.assertEquals((Object)21.0, (Object)blowerSurfDesc.d_airFlow.d_rate.tanVelU.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertEquals((Object)22.0, (Object)blowerSurfDesc.d_airFlow.d_rate.tanVelV.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate.func instanceof TimeFunction.Custom));
            Iterator<Ramp.Entry> iterator = ((Ramp)((TimeFunction.Custom)blowerSurfDesc.d_airFlow.d_rate.func).val).getRecords().iterator();
            Ramp.Entry entry = iterator.next();
            SurfaceParserTest.assertEquals((Object)0.0, (Object)entry.t.getValue(SIUS.unit(2)));
            SurfaceParserTest.assertEquals((Object)0.5, (Object)entry.f.getValue(SIUS.unit(28)));
            entry = iterator.next();
            SurfaceParserTest.assertEquals((Object)2.0, (Object)entry.t.getValue(SIUS.unit(2)));
            SurfaceParserTest.assertEquals((Object)0.6, (Object)entry.f.getValue(SIUS.unit(28)));
            string = "&SURF ID='SURF05' MASS_FLUX_TOTAL=63.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 4), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF05");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
            InFlowSurfDesc inFlowSurfDesc2 = (InFlowSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)inFlowSurfDesc2.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc2.d_airFlow.d_rate instanceof AirFlow.TotalMassFlux));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc2.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)63.0, (Object)((AirFlow.ValRate)inFlowSurfDesc2.d_airFlow.d_rate).val.getValue(SIUS.unit(45)));
            string = "&SURF ID='SURF06' VEL=-20.00 VOLUME_FLUX=50.00 MASS_FLUX_TOTAL=63.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 5), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF06");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BlowerSurfDesc));
            blowerSurfDesc = (BlowerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)blowerSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)20.0, (Object)((AirFlow.ValRate)blowerSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_profile instanceof AirFlow.TopHatProf));
            SurfaceParserTest.assertEquals((int)2, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF07' MASS_FLUX_TOTAL=63.00 VOLUME_FLUX=50.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 6), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF07");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
            inFlowSurfDesc2 = (InFlowSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)inFlowSurfDesc2.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc2.d_airFlow.d_rate instanceof AirFlow.VolumeFlux));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc2.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)50.0, (Object)((AirFlow.ValRate)inFlowSurfDesc2.d_airFlow.d_rate).val.getValue(SIUS.unit(24)));
            SurfaceParserTest.assertEquals((int)4, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            FDSParseRecord fDSParseRecord2 = this.parseRecord("&SPEC ID='AIR'/", true);
            this.d_exSpecParser.process(fDSParseRecord2);
            string = "&SURF ID='SURF08' SPEC_ID='AIR' MASS_FLUX(1)=0.80 TAU_MF(1)=1.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 7), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF08");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BlowerSurfDesc));
            blowerSurfDesc = (BlowerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)blowerSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.ExSpecMassFlux));
            SurfaceParserTest.assertEquals((int)0, (int)((AirFlow.ExSpecMassFlux)blowerSurfDesc.d_airFlow.d_rate).specInj.injType);
            SurfaceParserTest.assertEquals((Object)0.8, (Object)((UnitDouble)((AirFlow.ExSpecMassFlux)blowerSurfDesc.d_airFlow.d_rate).specInj.getInjections().iterator().next().val).getValue(SIUS.unit(45)));
            string = "&SURF ID='SURF10' VEL=-20.00 SPEC_ID='AIR' MASS_FRACTION(1)=0.90 TAU_MF(1)=1.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 8), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF10");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BlowerSurfDesc));
            blowerSurfDesc = (BlowerSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)blowerSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)20.0, (Object)((AirFlow.ValRate)blowerSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertTrue((boolean)(blowerSurfDesc.d_airFlow.d_profile instanceof AirFlow.TopHatProf));
            SurfaceParserTest.assertEquals((int)1, (int)((AirFlow.NormalVel)blowerSurfDesc.d_airFlow.d_rate).specInj.injType);
            SurfaceParserTest.assertEquals((Object)0.9, (Object)((Double)blowerSurfDesc.d_airFlow.d_rate.specInj.getInjections().iterator().next().val));
            SurfaceParserTest.assertEquals((int)4, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    public void testSurfaceParse_airFlow_TimeFunc() {
        String string = "&SURF ID='SURF02' COLOR='GRAY 90' VEL=-20.00/";
        RampParser rampParser = new RampParser(this.d_pinfo);
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            string = "&SURF ID='SURF02' VEL=21.00 TAU_V=11.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
            InFlowSurfDesc inFlowSurfDesc = (InFlowSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)inFlowSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)21.0, (Object)((AirFlow.ValRate)inFlowSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_profile instanceof AirFlow.TopHatProf));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate.func instanceof TimeFunction.TanH));
            SurfaceParserTest.assertEquals((Object)11.0, (Object)((UnitDouble)inFlowSurfDesc.d_airFlow.d_rate.func.val).getValue(SIUS.unit(2)));
            string = "&SURF ID='SURF03' VEL=21.00 TAU_V=-11.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
            inFlowSurfDesc = (InFlowSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)inFlowSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)21.0, (Object)((AirFlow.ValRate)inFlowSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_profile instanceof AirFlow.TopHatProf));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate.func instanceof TimeFunction.TSquared));
            SurfaceParserTest.assertEquals((Object)11.0, (Object)((UnitDouble)inFlowSurfDesc.d_airFlow.d_rate.func.val).getValue(SIUS.unit(2)));
            FDSParseRecord fDSParseRecord = this.parseRecord("&RAMP ID='SURF04_RAMP_V' T=0.00 F=0.50/", true);
            rampParser.process(fDSParseRecord);
            fDSParseRecord = this.parseRecord("&RAMP ID='SURF04_RAMP_V' T=2.00 F=0.60/", true);
            rampParser.process(fDSParseRecord);
            string = "&SURF ID='SURF04' VEL=21.00 RAMP_V='SURF04_RAMP_V'/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
            inFlowSurfDesc = (InFlowSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNotNull((Object)inFlowSurfDesc.d_airFlow);
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.ValRate));
            SurfaceParserTest.assertEquals((Object)21.0, (Object)((AirFlow.ValRate)inFlowSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(8)));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_profile instanceof AirFlow.TopHatProf));
            SurfaceParserTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate.func instanceof TimeFunction.Custom));
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    public void testSurfaceParse_temp_regulation() {
        RampParser rampParser = new RampParser(this.d_pinfo);
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            String string = "&SURF ID='SURF02' TMP_FRONT=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof ConstantTempSurfDesc));
            ConstantTempSurfDesc constantTempSurfDesc = (ConstantTempSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNull((Object)constantTempSurfDesc.d_partInj);
            SurfaceParserTest.assertEquals((Object)21.0, (Object)constantTempSurfDesc.d_tempReg.d_thermalBCs.d_temperature.getValue(SIUS.unit(1)));
            string = "&SURF ID='SURF03' CONVECTIVE_HEAT_FLUX=22.30/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof ConstantTempSurfDesc));
            constantTempSurfDesc = (ConstantTempSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNull((Object)constantTempSurfDesc.d_partInj);
            SurfaceParserTest.assertEquals((Object)22.3, (Object)constantTempSurfDesc.d_tempReg.d_thermalBCs.d_heatFlux.getValue(SIUS.unit(33)));
            SurfaceParserTest.assertTrue((boolean)(constantTempSurfDesc.d_tempReg.d_thermalBCs.d_rampup instanceof TimeFunction.TanH));
            string = "&SURF ID='SURF04' CONVECTIVE_HEAT_FLUX=22.30 TAU_Q=-21.20/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof ConstantTempSurfDesc));
            constantTempSurfDesc = (ConstantTempSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNull((Object)constantTempSurfDesc.d_partInj);
            SurfaceParserTest.assertEquals((Object)22.3, (Object)constantTempSurfDesc.d_tempReg.d_thermalBCs.d_heatFlux.getValue(SIUS.unit(33)));
            SurfaceParserTest.assertTrue((boolean)(constantTempSurfDesc.d_tempReg.d_thermalBCs.d_rampup instanceof TimeFunction.TSquared));
            SurfaceParserTest.assertEquals((Object)21.2, (Object)((UnitDouble)constantTempSurfDesc.d_tempReg.d_thermalBCs.d_rampup.val).getValue(SIUS.unit(2)));
            FDSParseRecord fDSParseRecord = this.parseRecord("&RAMP ID='SURF05_RAMP_T' T=0.00 F=0.50/", true);
            rampParser.process(fDSParseRecord);
            fDSParseRecord = this.parseRecord("&RAMP ID='SURF05_RAMP_T' T=2.00 F=0.60/", true);
            rampParser.process(fDSParseRecord);
            string = "&SURF ID='SURF05' CONVECTIVE_HEAT_FLUX=22.30 RAMP_Q='SURF05_RAMP_T'/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 4), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF05");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof ConstantTempSurfDesc));
            constantTempSurfDesc = (ConstantTempSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertNull((Object)constantTempSurfDesc.d_partInj);
            SurfaceParserTest.assertEquals((Object)22.3, (Object)constantTempSurfDesc.d_tempReg.d_thermalBCs.d_heatFlux.getValue(SIUS.unit(33)));
            SurfaceParserTest.assertTrue((boolean)(constantTempSurfDesc.d_tempReg.d_thermalBCs.d_rampup instanceof TimeFunction.Custom));
            Iterator<Ramp.Entry> iterator = ((Ramp)((TimeFunction.Custom)constantTempSurfDesc.d_tempReg.d_thermalBCs.d_rampup).val).getRecords().iterator();
            Ramp.Entry entry = iterator.next();
            SurfaceParserTest.assertEquals((Object)0.0, (Object)entry.t.getValue(SIUS.unit(2)));
            SurfaceParserTest.assertEquals((Object)0.5, (Object)entry.f.getValue(SIUS.unit(28)));
            entry = iterator.next();
            SurfaceParserTest.assertEquals((Object)2.0, (Object)entry.t.getValue(SIUS.unit(2)));
            SurfaceParserTest.assertEquals((Object)0.6, (Object)entry.f.getValue(SIUS.unit(28)));
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    public void testSurfaceParse_surf_composition() {
        MaterialParser materialParser = new MaterialParser(this.d_pinfo);
        try {
            FDSParseRecord fDSParseRecord = this.parseRecord("&MATL ID='MAT'/", true);
            materialParser.process(fDSParseRecord);
            fDSParseRecord = this.parseRecord("&MATL ID='MAT02'/", true);
            materialParser.process(fDSParseRecord);
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            String string = "&SURF ID='SURF02' MATL_ID(1,1)='MAT' MATL_ID(2,1)='MAT02' MATL_ID(3,1:2)='MAT02','MAT'";
            string = string + "MATL_MASS_FRACTION(1,1)=1.00 MATL_MASS_FRACTION(2,1)=1.00 MATL_MASS_FRACTION(3,1:2)=0.60,0.4000 THICKNESS(1:3)=2.00,5.00,10.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            Iterator<SurfComposition.SurfLayer> iterator = layeredSurfDesc.d_surfComp.d_layers.iterator();
            SurfComposition.SurfLayer surfLayer = iterator.next();
            SurfaceParserTest.assertEquals((Object)2.0, (Object)surfLayer.d_thickness.getValue(SIUS.unit(0)));
            Iterator<SurfComposition.SurfLayer.SurfComponent> iterator2 = surfLayer.getComponents().iterator();
            SurfComposition.SurfLayer.SurfComponent surfComponent = iterator2.next();
            SurfaceParserTest.assertEquals((Object)1.0, (Object)surfComponent.d_massFraction);
            SurfaceParserTest.assertEquals((String)"MAT", (String)surfComponent.d_material.getName());
            surfLayer = iterator.next();
            SurfaceParserTest.assertEquals((Object)5.0, (Object)surfLayer.d_thickness.getValue(SIUS.unit(0)));
            iterator2 = surfLayer.getComponents().iterator();
            surfComponent = iterator2.next();
            SurfaceParserTest.assertEquals((Object)1.0, (Object)surfComponent.d_massFraction);
            SurfaceParserTest.assertEquals((String)"MAT02", (String)surfComponent.d_material.getName());
            surfLayer = iterator.next();
            SurfaceParserTest.assertEquals((Object)10.0, (Object)surfLayer.d_thickness.getValue(SIUS.unit(0)));
            iterator2 = surfLayer.getComponents().iterator();
            surfComponent = iterator2.next();
            if (surfComponent.d_material.getName().equals("MAT02")) {
                SurfaceParserTest.assertEquals((Object)0.6, (Object)surfComponent.d_massFraction);
                surfComponent = iterator2.next();
                SurfaceParserTest.assertEquals((Object)0.4, (Object)surfComponent.d_massFraction);
                SurfaceParserTest.assertEquals((String)"MAT", (String)surfComponent.d_material.getName());
            } else {
                SurfaceParserTest.assertEquals((Object)0.4, (Object)surfComponent.d_massFraction);
                SurfaceParserTest.assertEquals((String)"MAT", (String)surfComponent.d_material.getName());
                surfComponent = iterator2.next();
                SurfaceParserTest.assertEquals((Object)0.6, (Object)surfComponent.d_massFraction);
                SurfaceParserTest.assertEquals((String)"MAT02", (String)surfComponent.d_material.getName());
            }
            string = "&SURF ID='SURF03' BACKING='VOID' TMP_INNER=21.00 TMP_BACK=40.00 MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertEquals((Object)21.0, (Object)layeredSurfDesc.d_surfComp.d_initInnerTemp.getValue(SIUS.unit(1)));
            SurfaceParserTest.assertEquals((Object)40.0, (Object)((Backing.AirGap)layeredSurfDesc.d_surfComp.d_backing).d_airTemp.getValue(SIUS.unit(1)));
            string = "&SURF ID='SURF04' BACKING='EXPOSED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(layeredSurfDesc.d_surfComp.d_backing instanceof Backing.Exposed));
            string = "&SURF ID='SURF05' BACKING='INSULATED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 4), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF05");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(layeredSurfDesc.d_surfComp.d_backing instanceof Backing.Insulated));
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    public void testSurfaceParse_multiple_types_warnings() {
        MaterialParser materialParser = new MaterialParser(this.d_pinfo);
        try {
            FDSParseRecord fDSParseRecord = this.parseRecord("&MATL ID='MAT'/", true);
            materialParser.process(fDSParseRecord);
            fDSParseRecord = this.parseRecord("&MATL ID='MAT02'/", true);
            materialParser.process(fDSParseRecord);
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            String string = "&SURF ID='SURF02' BACKING='INSULATED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00";
            string = string + "VEL=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            SurfaceParserTest.assertEquals((int)1, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF03' BACKING='INSULATED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00";
            string = string + "TMP_FRONT=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            SurfaceParserTest.assertEquals((int)1, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF04' BACKING='INSULATED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00";
            string = string + "TMP_FRONT=21.00 VEL=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            SurfaceParserTest.assertEquals((int)2, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF05' HRRPUA=60.0/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 4), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF05");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BurnerSurfDesc));
            SurfaceParserTest.assertEquals((int)2, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF06' HRRPUA=60.0 VEL=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 5), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF06");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof GeneralSurfDesc));
            SurfaceParserTest.assertEquals((int)2, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            FDSParseRecord fDSParseRecord2 = this.parseRecord("&SPEC ID='AIR'/", true);
            this.d_exSpecParser.process(fDSParseRecord2);
            string = "&SURF ID='SURF08' SPEC_ID='AIR' MASS_FLUX(1)=0.80 HRRPUA=60.0/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 6), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF08");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof GeneralSurfDesc));
            SurfaceParserTest.assertEquals((int)2, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF09' VEL=21.00 TMP_FRONT=21.00 HRRPUA=60.0/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 7), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF09");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof GeneralSurfDesc));
            SurfaceParserTest.assertEquals((int)2, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF10' VEL=21.00 SPEC_ID='AIR' MASS_FLUX(1)=0.80 HRRPUA=60.0/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 8), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF10");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof GeneralSurfDesc));
            SurfaceParserTest.assertEquals((int)3, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF11' VEL=21.00 TMP_FRONT=21.00 SPEC_ID='AIR' MASS_FLUX(1)=0.80 HRRPUA=60.0/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 9), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF11");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof GeneralSurfDesc));
            SurfaceParserTest.assertEquals((int)4, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF12' VEL=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 10), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF12");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
            SurfaceParserTest.assertEquals((int)4, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            string = "&SURF ID='SURF13' VEL=21.00 TMP_FRONT=21.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 11), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF13");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
            SurfaceParserTest.assertEquals((int)4, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    public void testSurfaceParse_Ireaction() {
        MaterialParser materialParser = new MaterialParser(this.d_pinfo);
        try {
            materialParser.process(this.parseRecord("&MATL ID='MAT'/", true));
            materialParser.process(this.parseRecord("&MATL ID='MAT02'/", true));
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
            String string = "&SURF ID='SURF02' BACKING='INSULATED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(layeredSurfDesc.d_iReac instanceof Fuel.MaterialReac));
            string = "&SURF ID='SURF03' HRRPUA=60.0 BACKING='INSULATED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(layeredSurfDesc.d_iReac instanceof Fuel.ManualReac));
            string = "&SURF ID='SURF04' HRRPUA=60.0 BACKING='INSULATED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(layeredSurfDesc.d_iReac instanceof Fuel.ManualReac));
            SurfaceParserTest.assertTrue((boolean)(((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_ignition instanceof Fuel.ManualReac.ImmediateIgnite));
            SurfaceParserTest.assertNull((Object)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatOfVap);
            SurfaceParserTest.assertTrue((boolean)(((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_type instanceof HeatRelease.HRRType));
            SurfaceParserTest.assertEquals((Object)60.0, (Object)((UnitDouble)((HeatRelease.HRRType)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_type).val).getValue(SIUS.unit(22)));
            string = "&SURF ID='SURF05' MLRPUA=12.00 BACKING='INSULATED' MATL_ID(1,1)='MAT' MATL_MASS_FRACTION(1,1)=1.00 THICKNESS(1)=2.00 ";
            string = string + "IGNITION_TEMPERATURE=14.00 HEAT_OF_VAPORIZATION=15.00 E_COEFFICIENT=13.00/";
            this.d_surfParser.process(this.parseRecord(string, true));
            SurfaceParserTest.assertEquals((int)(n + 4), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface = (Surface)this.d_mod.getSurfaceMgr().get("SURF05");
            SurfaceParserTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
            layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            SurfaceParserTest.assertTrue((boolean)(layeredSurfDesc.d_iReac instanceof Fuel.ManualReac));
            SurfaceParserTest.assertTrue((boolean)(((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_ignition instanceof Fuel.ManualReac.TemperatureIgnite));
            SurfaceParserTest.assertEquals((Object)14.0, (Object)((Fuel.ManualReac.TemperatureIgnite)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_ignition).d_temperature.getValue(SIUS.unit(1)));
            SurfaceParserTest.assertEquals((Object)15.0, (Object)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatOfVap.getValue(SIUS.unit(46)));
            SurfaceParserTest.assertTrue((boolean)(((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_type instanceof HeatRelease.MLRType));
            SurfaceParserTest.assertEquals((Object)12.0, (Object)((UnitDouble)((HeatRelease.MLRType)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_type).val).getValue(SIUS.unit(44)));
            SurfaceParserTest.assertEquals((Object)13.0, (Object)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_extingCoeff.getValue(SIUS.unit(21)));
            SurfaceParserTest.assertEquals((int)0, (int)this.d_surfParser.getParsingInfo().getParseResult().warningReport.getWarnings().size());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceParserTest.fail();
        }
    }

    static {
        new PyroSim();
    }
}

