/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.INamed;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialCache;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.zones.Zone;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.ZoneParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.image.IImage;
import thunderheadeng.io.IOUtil;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Lists;

public class SurfaceParser
extends AFDS6Parser {
    private final ZoneParser d_zoneParser;
    private final MaterialCache d_appearanceCache;

    public SurfaceParser(FDS6ParsingInfo fDS6ParsingInfo, ZoneParser zoneParser) {
        super(fDS6ParsingInfo);
        this.d_zoneParser = zoneParser;
        this.d_appearanceCache = new MaterialCache(this.getContainer().getAppearances().flatten());
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("SURF");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("C_FORCED_CONSTANT", "UNSUPPORTED");
        map.put("C_FORCED_RE", "UNSUPPORTED");
        map.put("C_FORCED_PR_EXP", "UNSUPPORTED");
        map.put("C_FORCED_RE_EXP", "UNSUPPORTED");
        map.put("C_HORIZONTAL", "UNSUPPORTED");
        map.put("C_VERTICAL", "UNSUPPORTED");
        map.put("CELL_SIZE_FACTOR", "UNSUPPORTED");
        map.put("CONVECTION_LENGTH_SCALE", "UNSUPPORTED");
        map.put("CONVERT_VOLUME_TO_MASS", "UNSUPPORTED");
        map.put("EMISSIVITY_BACK", "UNSUPPORTED");
        map.put("EVAC_DEFAULT", "UNSUPPORTED");
        map.put("FREE_SLIP", "UNSUPPORTED");
        map.put("HEAT_TRANSFER_COEFFICIENT_BACK", "UNSUPPORTED");
        map.put("INTERNAL_HEAT_SOURCE", "UNSUPPORTED");
        map.put("MASS_FLUX_VAR", "UNSUPPORTED");
        map.put("MASS_TRANSFER_COEFFICIENT", "UNSUPPORTED");
        map.put("MINIMUM_LAYER_THICKNESS", "UNSUPPORTED");
        map.put("N_LAYER_CELLS_MAX", "UNSUPPORTED");
        map.put("NO_SLIP", "UNSUPPORTED");
        map.put("RAMP_T_I", "UNSUPPORTED");
        map.put("RAMP_V_X", "UNSUPPORTED");
        map.put("RAMP_V_Y", "UNSUPPORTED");
        map.put("RAMP_V_Z", "UNSUPPORTED");
        map.put("ROUGHNESS", "UNSUPPORTED");
        map.put("SPREAD_RATE", "UNSUPPORTED");
        map.put("STRETCH_FACTOR", "UNSUPPORTED");
        map.put("TGA_ANALYSIS", "UNSUPPORTED");
        map.put("TGA_FINAL_TEMPERATURE", "UNSUPPORTED");
        map.put("TGA_HEATING_RATE", "UNSUPPORTED");
        map.put("VEL_BULK", "UNSUPPORTED");
        map.put("VEL_GRAD", "UNSUPPORTED");
        map.put("XYZ", "UNSUPPORTED");
        map.put("EXTERNAL_FLUX", "UNSUPPORTED");
        map.put("RAMP_EF", "UNSUPPORTED");
        map.put("TAU_EF", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("ID");
        if (!this.checkName(fDSParseRecord, string)) {
            return false;
        }
        String string2 = (String)fDSParseRecord.get("FYI");
        Boolean bl = (Boolean)fDSParseRecord.get("DEFAULT", true);
        Color color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", true);
        Material material = this.parseAppearance(fDSParseRecord, color);
        ISurfDesc iSurfDesc = this.parseSurfaceDesc(fDSParseRecord);
        Surface surface = new Surface(string, color, material, iSurfDesc);
        if (string2 != null) {
            surface.setFYI(string2);
        }
        this.parseCustomFDSProps(surface, fDSParseRecord);
        int n = this.existsStatus(fDSParseRecord, surface, Surface.class);
        if (n == 2) {
            string = this.parseName(fDSParseRecord, "ID", Surface.class);
            surface.setName(string);
            n = this.existsStatus(fDSParseRecord, surface, Surface.class);
        }
        if (n == 2) {
            Surface surface2;
            if (!surface.isPredefined()) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), fDSParseRecord.getType(), surface.getName()), String.format(Intl.intl("Adding to additional records section."), fDSParseRecord.getType()));
            }
            if ((surface2 = this.findObject(Surface.class, surface.getName())).isPredefined()) {
                if (bl.booleanValue()) {
                    this.addWarning(fDSParseRecord, Intl.intl("Non-inert predefined surfaces should not be set as the Default Surface."), Intl.intl("Ignoring record."));
                    n = 1;
                } else {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), fDSParseRecord.getType(), surface.getName()), String.format(Intl.intl("Adding to additional records section."), fDSParseRecord.getType()));
                }
            }
        }
        if (n != 0) {
            return this.convertToReturn(n);
        }
        this.getContainer().getSurfaceMgr().add(surface);
        if (bl.booleanValue()) {
            this.getContainer().getSimParams().getMisc().setSurfDefault(surface);
        }
        this.flagObjectAdded(surface);
        return true;
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        for (Material material : this.d_appearanceCache.getAddedMaterials()) {
            this.getContainer().getAppearances().add(material);
            this.flagObjectAdded(material);
        }
    }

    private Material parseAppearance(FDSParseRecord fDSParseRecord, Color color) {
        Texture texture = this.parseTexture(fDSParseRecord, "TEXTURE_MAP");
        if (texture == null) {
            return null;
        }
        Color color2 = new Color(255, 255, 255);
        int n = color.getAlpha();
        Color color3 = new Color(n, n, n);
        MatAttrs matAttrs = new MatAttrs(IMatAttrs.DIFFUSE_COLOR, color2, IMatAttrs.DIFFUSE_TEXTURE, texture, IMatAttrs.OPACITY_COLOR, color3);
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("TEXTURE_WIDTH", true);
        UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("TEXTURE_HEIGHT", true);
        String string = texture != null ? new File(texture.image.getFilename()).getName() : fDSParseRecord.getString("ID");
        Material material = new Material(string, matAttrs, unitDouble, unitDouble2);
        material = this.d_appearanceCache.add(material);
        return material;
    }

    private Texture parseTexture(FDSParseRecord fDSParseRecord, String string) {
        String string2 = (String)fDSParseRecord.get(string, false);
        if (string2 == null) {
            return null;
        }
        FDS6ParsingInfo fDS6ParsingInfo = this.getParsingInfo();
        File file = null;
        if (fDS6ParsingInfo.getParsingFile() != null) {
            file = IOUtil.resolvePath(string2, new File(fDS6ParsingInfo.getParsingFile()), true);
        } else {
            file = new File(string2);
            if (!file.exists() || !file.isFile()) {
                file = null;
            }
        }
        if (file == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to resolve texture path: %s"), string2), Intl.intl("Texture Removed"));
            return null;
        }
        IImage iImage = MaterialDB.loadImage(file.getAbsolutePath());
        if (iImage == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to load image for texture: %s"), file.getAbsolutePath()), Intl.intl("Texture Removed"));
            return null;
        }
        return Texture.repeated(iImage, "uvset");
    }

    private ISurfDesc parseSurfaceDesc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        ParticleInjection particleInjection = this.parsePartInj(fDSParseRecord);
        SpecInjList specInjList = this.parseSpeciesInjection(fDSParseRecord);
        HeatRelease heatRelease = this.parseHeatRelease(fDSParseRecord);
        Fuel.IReaction iReaction = this.parseReaction(fDSParseRecord, heatRelease);
        SurfComposition surfComposition = this.parseSurfComposition(fDSParseRecord);
        TempRegulation tempRegulation = this.parseTempRegulation(fDSParseRecord);
        ZonePath zonePath = this.parseZonePath(fDSParseRecord, "LEAK_PATH");
        boolean[] blArray = new boolean[1];
        AirFlow airFlow = this.parseAirFlow(fDSParseRecord, null, blArray, false);
        IGeometry iGeometry = this.parseGeometry(fDSParseRecord);
        if (!surfComposition.d_layers.isEmpty()) {
            if (airFlow != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Forced air flow information cannot be specified on layered surfaces."), Intl.intl("Ignoring forced air flow information."));
            }
            if (tempRegulation == null) {
                tempRegulation = TempRegulation.newDefault();
            }
            assert (iReaction != null);
            boolean bl = (Boolean)fDSParseRecord.get("BURN_AWAY", true);
            return new LayeredSurfDesc(iGeometry, null, iReaction, surfComposition, specInjList, particleInjection, bl, zonePath, tempRegulation);
        }
        if (heatRelease != null && airFlow == null && specInjList == null) {
            if (zonePath != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Burners cannot have a LEAK_PATH."), Intl.intl("Ignoring LEAK_PATH."));
            }
            if (tempRegulation == null) {
                tempRegulation = TempRegulation.newDefault();
            }
            BurnerSurfDesc burnerSurfDesc = new BurnerSurfDesc(heatRelease, particleInjection, tempRegulation, iGeometry);
            return burnerSurfDesc;
        }
        airFlow = this.parseAirFlow(fDSParseRecord, specInjList, blArray, true);
        if (!(airFlow == null || heatRelease != null || blArray[0] && specInjList != null)) {
            if (zonePath != null) {
                this.addWarning(fDSParseRecord, Intl.intl("LEAK_PATH is not allowed on exhaust and supply surfaces."), Intl.intl("Ignoring LEAK_PATH."));
            }
            if (tempRegulation == null) {
                tempRegulation = TempRegulation.newDefault();
            }
            if (blArray[0] && iGeometry.equals(IGeometry.DEFAULT)) {
                return new InFlowSurfDesc(airFlow, tempRegulation);
            }
            if (!blArray[0]) {
                return new BlowerSurfDesc(tempRegulation, airFlow, particleInjection, iGeometry);
            }
        }
        if (tempRegulation != null && heatRelease == null && airFlow == null) {
            if (zonePath != null) {
                this.addWarning(fDSParseRecord, Intl.intl("LEAK_PATH is not allowed on temperature-regulated surfaces."), Intl.intl("Ignoring LEAK_PATH."));
            }
            return new ConstantTempSurfDesc(tempRegulation, particleInjection, iGeometry);
        }
        if (tempRegulation != null || heatRelease != null || airFlow != null || particleInjection != null || specInjList != null) {
            if (tempRegulation == null) {
                tempRegulation = TempRegulation.newDefault();
            }
            return new GeneralSurfDesc(tempRegulation, particleInjection, specInjList, heatRelease, airFlow, iGeometry);
        }
        if (zonePath != null) {
            return new LeakSurfDesc(zonePath);
        }
        return Surface.newBasicDesc();
    }

    private ZonePath parseZonePath(FDSParseRecord fDSParseRecord, String string) {
        int n;
        if (!fDSParseRecord.contains(string)) {
            return null;
        }
        FDSArray fDSArray = fDSParseRecord.getArray(string, true);
        int n2 = (Integer)fDSArray.get(0);
        if (n2 == (n = ((Integer)fDSArray.get(1)).intValue())) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s must specify two different ZONEs."), string), String.format(Intl.intl("Ignoring %s"), string));
            return null;
        }
        Zone zone = this.d_zoneParser.get(n2);
        Zone zone2 = this.d_zoneParser.get(n);
        if (zone == null || zone2 == null) {
            int n3 = zone == null ? n2 : n;
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find ZONE %d."), n3), String.format(Intl.intl("Ignoring %s"), string));
            return null;
        }
        return new ZonePath(zone, zone2);
    }

    private ParticleInjection parsePartInj(FDSParseRecord fDSParseRecord) {
        String string = (String)fDSParseRecord.get("PART_ID");
        if (string == null) {
            return null;
        }
        Particle particle = this.findObject(Particle.class, string);
        if (particle == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("The particle, %s, could not be found in the model."), string), Intl.intl("Ignoring particle."));
            return null;
        }
        int n = (Integer)fDSParseRecord.get("NPPC", true);
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DT_INSERT", true);
        TimeBasedValue<UnitDouble> timeBasedValue = null;
        UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("PARTICLE_MASS_FLUX", false);
        if (unitDouble2 != null && unitDouble2.getValue(SIUS.unit(45)) > 0.0) {
            if (particle.isType(Particle.Type.TRACER)) {
                this.addWarning(fDSParseRecord, Intl.intl("A mass flux is specified for the particle, but the particle is massless."), Intl.intl("Ignoring mass flux."));
                timeBasedValue = null;
            } else {
                TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_PART", "RAMP_PART");
                timeBasedValue = new TimeBasedValue<UnitDouble>(unitDouble2, timeFunction);
            }
        }
        return new ParticleInjection(particle, n, timeBasedValue, unitDouble);
    }

    private SpecInjList parseSpeciesInjection(FDSParseRecord fDSParseRecord) {
        List list = fDSParseRecord.getList("MASS_FRACTION", false);
        List list2 = fDSParseRecord.getList("MASS_FLUX", false);
        List list3 = fDSParseRecord.getList("SPEC_ID", false);
        int n = -1;
        List list4 = null;
        if (list != null && Lists.containsNonNull(list)) {
            list4 = list;
            n = 1;
        } else if (list2 != null && Lists.containsNonNull(list2)) {
            list4 = list2;
            n = 0;
        }
        if (list4 == null) {
            return null;
        }
        Object var7_7 = null;
        List list5 = fDSParseRecord.getList("TAU_MF", list4.size(), false);
        List list6 = fDSParseRecord.getList("RAMP_MF", list4.size(), false);
        ArrayList<SpeciesInjection> arrayList = new ArrayList<SpeciesInjection>();
        for (int i = 0; i < list4.size(); ++i) {
            Object t = list4.get(i);
            if (t == null) continue;
            UnitDouble unitDouble = (UnitDouble)list5.get(i);
            String string = (String)list6.get(i);
            TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, unitDouble, string);
            ExSpec exSpec = this.getContainer().getExSpecList().get((String)list3.get(i));
            if (exSpec == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Species %d could not be found."), i), String.format(Intl.intl("Ignoring species %d."), i));
                continue;
            }
            arrayList.add(new SpeciesInjection(exSpec, t, timeFunction));
        }
        if (var7_7 == null && arrayList.isEmpty()) {
            return null;
        }
        return new SpecInjList(n, arrayList);
    }

    private Backing parseBacking(FDSParseRecord fDSParseRecord) {
        String string = (String)fDSParseRecord.get("BACKING", true);
        if (string.equals("VOID")) {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("TMP_BACK", true);
            return new Backing.AirGap(unitDouble);
        }
        if (string.equals("EXPOSED")) {
            return Backing.EXPOSED;
        }
        if (string.equals("INSULATED")) {
            return Backing.INSULATED;
        }
        this.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a recognized surface backing."), string), String.format(Intl.intl("Ignoring backing."), new Object[0]));
        return Backing.newDefault();
    }

    private HeatRelease parseHeatRelease(FDSParseRecord fDSParseRecord) {
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("HRRPUA", false);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("MLRPUA", false);
        if (unitDouble == null && unitDouble2 == null) {
            return null;
        }
        UnitDouble unitDouble3 = (UnitDouble)fDSParseRecord.get("E_COEFFICIENT", true);
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_Q", "RAMP_Q");
        if (unitDouble != null && unitDouble2 != null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%1$s and %2$s should not both be specified for a surface."), "HRRPUA", "MLRPUA"), String.format(Intl.intl("Ignoring %s."), "MLRPUA"));
        }
        HeatRelease.Type type = unitDouble != null ? new HeatRelease.HRRType(unitDouble, timeFunction) : new HeatRelease.MLRType(unitDouble2, timeFunction);
        return new HeatRelease(type, unitDouble3);
    }

    private IGeometry parseGeometry(FDSParseRecord fDSParseRecord) {
        boolean bl;
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("LENGTH", true);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("WIDTH", true);
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("INNER_RADIUS", false);
        UnitDouble unitDouble4 = fDSParseRecord.getUnitDouble("RADIUS", false);
        boolean bl2 = bl = unitDouble != null || unitDouble2 != null || unitDouble3 != null || unitDouble4 != null;
        if (!bl && !fDSParseRecord.contains("GEOMETRY")) {
            return IGeometry.DEFAULT;
        }
        String string = fDSParseRecord.getString("GEOMETRY");
        if (string == null) {
            string = "CARTESIAN";
        }
        boolean bl3 = fDSParseRecord.contains("THICKNESS");
        if (string.equals("CARTESIAN")) {
            UnitDouble unitDouble5 = null;
            if (bl3 && !fDSParseRecord.contains("MATL_MASS_FRACTION")) {
                FDSArray fDSArray = fDSParseRecord.getArray("THICKNESS", true);
                unitDouble5 = (UnitDouble)fDSArray.get(0);
            }
            if (unitDouble != null && unitDouble2 == null || unitDouble == null && unitDouble2 != null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s and %s should both be specified for a surface with geometry."), "LENGTH", "WIDTH"), Intl.intl("Ignoring geometry for surface."));
                return IGeometry.DEFAULT;
            }
            if (unitDouble != null && unitDouble2 != null && !bl3) {
                this.addWarning(fDSParseRecord, Intl.intl("THICKNESS must be defined for surfaces with CARTESIAN geometry."), Intl.intl("Ignoring geometry for surface."));
                return IGeometry.DEFAULT;
            }
            return new IGeometry.Cartesian(unitDouble, unitDouble2, unitDouble5);
        }
        if (string.equals("SPHERICAL")) {
            if (unitDouble4 != null && unitDouble3 != null) {
                if (fDSParseRecord.contains("THICKNESS")) {
                    this.addWarning(fDSParseRecord, Intl.intl("Only one of INNER_RADIUS and RADIUS needs to be defined for a surface geometry."), Intl.intl("Dropping RADIUS from surface."));
                    unitDouble4 = null;
                } else {
                    this.addWarning(fDSParseRecord, Intl.intl("Only one of INNER_RADIUS and RADIUS needs to be defined for a surface geometry."), Intl.intl("Dropping INNER_RADIUS from surface."));
                    unitDouble3 = null;
                }
            } else if (unitDouble4 == null && unitDouble3 == null) {
                unitDouble3 = fDSParseRecord.getUnitDouble("INNER_RADIUS", true);
            }
            if (unitDouble3 != null && !bl3) {
                this.addWarning(fDSParseRecord, Intl.intl("Thickness must be defined for spherical geometry defined by the inner radius."), Intl.intl("Ignoring geometry for surface."));
                return IGeometry.DEFAULT;
            }
            return new IGeometry.Spherical(unitDouble3, unitDouble4);
        }
        if (string.equals("CYLINDRICAL")) {
            Serializable serializable;
            if (unitDouble4 != null && unitDouble3 != null) {
                if (bl3) {
                    this.addWarning(fDSParseRecord, Intl.intl("Only one of INNER_RADIUS and RADIUS needs to be defined for a surface geometry."), Intl.intl("Dropping RADIUS from surface."));
                    unitDouble4 = null;
                } else {
                    this.addWarning(fDSParseRecord, Intl.intl("Only one of INNER_RADIUS and RADIUS needs to be defined for a surface geometry."), Intl.intl("Dropping INNER_RADIUS from surface."));
                    unitDouble3 = null;
                }
            } else if (unitDouble4 == null && unitDouble3 == null) {
                if (bl3 && !fDSParseRecord.contains("MATL_ID")) {
                    serializable = fDSParseRecord.getArray("THICKNESS", true);
                    unitDouble4 = (UnitDouble)((FDSArray)serializable).get(0);
                }
                if (unitDouble4 == null) {
                    unitDouble3 = fDSParseRecord.getUnitDouble("INNER_RADIUS", true);
                }
            }
            if (unitDouble3 != null && !bl3) {
                this.addWarning(fDSParseRecord, Intl.intl("Thickness must be defined for cylindrical geometry defined by the inner radius."), Intl.intl("Ignoring geometry for surface."));
                return IGeometry.DEFAULT;
            }
            serializable = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
            return new IGeometry.Cylindrical(unitDouble3, unitDouble4, (Variant)serializable);
        }
        return null;
    }

    private TempRegulation parseTempRegulation(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (!(fDSParseRecord.contains("ADIABATIC") || fDSParseRecord.contains("TMP_FRONT") || fDSParseRecord.contains("NET_HEAT_FLUX") || fDSParseRecord.contains("CONVECTIVE_HEAT_FLUX") || fDSParseRecord.contains("HEAT_TRANSFER_MODEL") || fDSParseRecord.contains("EMISSIVITY") || fDSParseRecord.contains("HEAT_TRANSFER_COEFFICIENT"))) {
            return null;
        }
        boolean bl = false;
        if (fDSParseRecord.contains("HEAT_TRANSFER_MODEL") && fDSParseRecord.getString("HEAT_TRANSFER_MODEL").equals("LOGLAW")) {
            bl = true;
        }
        UnitDouble unitDouble = null;
        if (fDSParseRecord.contains("HEAT_TRANSFER_COEFFICIENT")) {
            unitDouble = fDSParseRecord.getUnitDouble("HEAT_TRANSFER_COEFFICIENT", true);
        }
        double d = (Double)fDSParseRecord.get("EMISSIVITY", true);
        boolean bl2 = (Boolean)fDSParseRecord.get("ADIABATIC", true);
        if (bl2) {
            return TempRegulation.newAdiabaticTR(unitDouble, bl);
        }
        if (fDSParseRecord.contains("NET_HEAT_FLUX")) {
            if (fDSParseRecord.contains("CONVECTIVE_HEAT_FLUX")) {
                throw new FDSRecordFormatException(Intl.intl("SURFs may not specify both a NET_HEAT_FLUX and CONVECTIVE_HEAT FLUX"));
            }
            if (fDSParseRecord.contains("TMP_FRONT")) {
                this.addWarning(fDSParseRecord, Intl.intl("SURF records should not specify TMP_FRONT with NET_HEAT_FLUX"), Intl.intl("Ignoring TMP_FRONT and ADIABATIC"));
            }
            UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("NET_HEAT_FLUX", true);
            return TempRegulation.newNetHeatFluxTR(unitDouble2, d, unitDouble, bl);
        }
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("TMP_FRONT", true);
        if (fDSParseRecord.contains("CONVECTIVE_HEAT_FLUX")) {
            if (fDSParseRecord.contains("NET_HEAT_FLUX")) {
                throw new FDSRecordFormatException(Intl.intl("SURFs may not specify both a NET_HEAT_FLUX and CONVECTIVE_HEAT FLUX"));
            }
            UnitDouble unitDouble4 = fDSParseRecord.getUnitDouble("CONVECTIVE_HEAT_FLUX", true);
            String string = "RAMP_T";
            String string2 = "TAU_T";
            if (unitDouble4.getValueNoUnit() != 0.0) {
                string = "RAMP_Q";
                string2 = "TAU_Q";
            }
            TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, string2, string);
            return TempRegulation.newFixedHeatFluxTR(unitDouble3, unitDouble4, timeFunction, d, unitDouble, bl);
        }
        return TempRegulation.newFixedTempTR(unitDouble3, d, unitDouble, bl);
    }

    private AirFlow parseAirFlow(FDSParseRecord fDSParseRecord, SpecInjList specInjList, boolean[] blArray, boolean bl) throws FDSRecordFormatException {
        AirFlow.IProfile iProfile;
        AirFlow.Rate rate;
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("VEL", false);
        UnitDouble unitDouble2 = null;
        if (fDSParseRecord.contains("VOLUME_FLOW")) {
            unitDouble2 = (UnitDouble)fDSParseRecord.get("VOLUME_FLOW", false);
        } else if (fDSParseRecord.contains("VOLUME_FLUX")) {
            unitDouble2 = (UnitDouble)fDSParseRecord.get("VOLUME_FLUX", false);
        }
        UnitDouble unitDouble3 = (UnitDouble)fDSParseRecord.get("MASS_FLUX_TOTAL", false);
        if (unitDouble3 != null && unitDouble3.getValueNoUnit() < 0.0) {
            if (bl) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s cannot be a negative value."), "MASS_FLUX_TOTAL"), String.format(Intl.intl("%s set to 0."), "MASS_FLUX_TOTAL"));
            }
            unitDouble3 = SIUS.newud(0.0, 45);
        }
        if (unitDouble == null && unitDouble2 == null && unitDouble3 == null && specInjList == null) {
            return null;
        }
        int n = 0;
        if (unitDouble != null) {
            ++n;
        }
        if (unitDouble2 != null) {
            ++n;
        }
        if (unitDouble3 != null) {
            ++n;
        }
        if (n > 1) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Only one of %1$s, %2$s, and %3$s can be specified for a surface."), "VEL", "VOLUME_FLUX", "MASS_FLUX_TOTAL"), String.format(Intl.intl("Using %s."), "VEL"));
        }
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_V", "RAMP_V");
        FDSArray fDSArray = fDSParseRecord.getArray("VEL_T", true);
        if (unitDouble != null) {
            unitDouble = this.extractFlowRate(unitDouble, blArray);
            specInjList = this.validateForcedAirSpecInj(fDSParseRecord, specInjList, "VEL", blArray[0]);
            rate = new AirFlow.NormalVel(unitDouble, (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
        } else if (unitDouble2 != null) {
            unitDouble2 = this.extractFlowRate(unitDouble2, blArray);
            specInjList = this.validateForcedAirSpecInj(fDSParseRecord, specInjList, "VOLUME_FLUX", blArray[0]);
            rate = new AirFlow.VolumeFlux(unitDouble2, (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
        } else if (unitDouble3 != null) {
            unitDouble3 = this.extractFlowRate(unitDouble3, blArray);
            specInjList = this.validateForcedAirSpecInj(fDSParseRecord, specInjList, "MASS_FLUX_TOTAL", blArray[0]);
            rate = new AirFlow.TotalMassFlux(unitDouble3, (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
        } else {
            assert (specInjList != null);
            blArray[0] = false;
            if (specInjList.injType == 0) {
                if (!timeFunction.equals(TimeFunction.newDefault())) {
                    timeFunction = TimeFunction.newDefault();
                    if (bl) {
                        this.addWarning(fDSParseRecord, Intl.intl("Ramp Up Time is invalid when specifying mass flux on a per species basis."), Intl.intl("Ignoring Ramp Up Time."));
                    }
                }
                rate = new AirFlow.ExSpecMassFlux((UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
            } else {
                rate = new AirFlow.NormalVel(SIUS.newud(0.0, 8), (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
            }
        }
        String string = (String)fDSParseRecord.get("PROFILE", true);
        if (string == null || string.equals(FDS6Const.TOP_HAT)) {
            iProfile = new AirFlow.TopHatProf();
        } else if (string.equals("PARABOLIC")) {
            iProfile = new AirFlow.ParabolicProf();
        } else if (string.equals("ATMOSPHERIC")) {
            UnitDouble unitDouble4 = (UnitDouble)fDSParseRecord.get("Z0", true);
            double d = (Double)fDSParseRecord.get("PLE", true);
            iProfile = new AirFlow.AtmosphericProf(d, unitDouble4);
        } else {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a recognized wind profile."), string), Intl.intl("Using a top hat wind profile."));
            iProfile = new AirFlow.TopHatProf();
        }
        return new AirFlow(rate, iProfile);
    }

    private UnitDouble extractFlowRate(UnitDouble unitDouble, boolean[] blArray) {
        if (new Double(unitDouble.getValueNoUnit()).compareTo(0.0) < 0) {
            blArray[0] = false;
            return unitDouble.negate();
        }
        blArray[0] = true;
        return unitDouble;
    }

    private SpecInjList validateForcedAirSpecInj(FDSParseRecord fDSParseRecord, SpecInjList specInjList, String string, boolean bl) {
        if (specInjList != null && specInjList.injType == 0) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%1$s cannot be specified with %2$s"), string, "MASS_FLUX"), Intl.intl("Ignoring species for surface."));
            return null;
        }
        return specInjList;
    }

    private static boolean valsEqualZero(UnitDouble ... unitDoubleArray) {
        for (UnitDouble unitDouble : unitDoubleArray) {
            if (unitDouble == null || unitDouble.getValueNoUnit() == 0.0) continue;
            return false;
        }
        return true;
    }

    private Fuel.IReaction parseReaction(FDSParseRecord fDSParseRecord, HeatRelease heatRelease) {
        if (heatRelease == null) {
            return new Fuel.MaterialReac();
        }
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("IGNITION_TEMPERATURE", false);
        Fuel.ManualReac.IIgnition iIgnition = unitDouble != null ? new Fuel.ManualReac.TemperatureIgnite(unitDouble) : new Fuel.ManualReac.ImmediateIgnite();
        UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("HEAT_OF_VAPORIZATION", false);
        return new Fuel.ManualReac(heatRelease, unitDouble2, iIgnition);
    }

    private SurfComposition parseSurfComposition(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        List<SurfComposition.SurfLayer> list = this.parseLayers(fDSParseRecord);
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("TMP_INNER", true);
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_T", "RAMP_T");
        Backing backing = this.parseBacking(fDSParseRecord);
        Double d = fDSParseRecord.getDouble("LAYER_DIVIDE", true);
        if (d != null) {
            String string = Intl.intl("LAYER_DIVIDE should be >= 0 and <= number of layers.");
            if (d < 0.0) {
                d = null;
                this.addWarning(fDSParseRecord, string, Intl.intl("Using the default LAYER_DIVIDE value."));
            } else if (d > (double)list.size()) {
                d = list.size();
                this.addWarning(fDSParseRecord, string, String.format(Intl.intl("Clamped the LAYER_DIVIDE to %d."), list.size()));
            }
        }
        return new SurfComposition(unitDouble, timeFunction, backing, d, list);
    }

    private List<SurfComposition.SurfLayer> parseLayers(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        ArrayList<SurfComposition.SurfLayer> arrayList = new ArrayList<SurfComposition.SurfLayer>();
        FDSArray fDSArray = fDSParseRecord.getArray("MATL_ID", false);
        if (fDSArray == null || !fDSArray.containsNonNull()) {
            return arrayList;
        }
        FDSArray fDSArray2 = fDSParseRecord.getArray("THICKNESS", true);
        FDSArray fDSArray3 = fDSParseRecord.getArray("MATL_MASS_FRACTION", true);
        for (int i = 0; i < FDS6Const.SURF_LAYER_DIMENSIONS[0]; ++i) {
            UnitDouble unitDouble = (UnitDouble)fDSArray2.get(i);
            double d = 0.0;
            ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList2 = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
            ArrayList<pyrosim.domain.boundcond.mat.Material> arrayList3 = new ArrayList<pyrosim.domain.boundcond.mat.Material>();
            for (int j = 0; j < FDS6Const.SURF_LAYER_DIMENSIONS[1]; ++j) {
                String string = (String)fDSArray.get(i, j);
                if (string == null) continue;
                pyrosim.domain.boundcond.mat.Material material = this.findObject(pyrosim.domain.boundcond.mat.Material.class, string);
                if (material == null) {
                    throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Could not find MATL %s."), string));
                }
                Double d2 = (Double)fDSArray3.get(i, j);
                if (d2 == null) {
                    arrayList3.add(material);
                    continue;
                }
                d += d2.doubleValue();
                arrayList2.add(new SurfComposition.SurfLayer.SurfComponent(d2, material));
            }
            if (arrayList2.isEmpty() && arrayList3.isEmpty()) continue;
            if (arrayList2.isEmpty() && arrayList3.size() == 1) {
                arrayList2.add(new SurfComposition.SurfLayer.SurfComponent(1.0, (pyrosim.domain.boundcond.mat.Material)arrayList3.get(0)));
            } else {
                if (d > 1.0000001) {
                    throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Material mass fractions in layer %d add to more than 1."), i + 1));
                }
                if (d < 0.9999999 && arrayList3.isEmpty()) {
                    throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Material mass fractions in layer %d add to less than 1."), i + 1));
                }
                if (!arrayList3.isEmpty()) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("A mass fraction was not specified for every material in layer %d."), i + 1), String.format(Intl.intl("Distributing remaining mass fraction evenly among materials with no specified mass fraction."), i + 1));
                    double d2 = (1.0 - d) / (double)arrayList3.size();
                    if (d2 != 0.0) {
                        for (pyrosim.domain.boundcond.mat.Material material : arrayList3) {
                            arrayList2.add(new SurfComposition.SurfLayer.SurfComponent(d2, material));
                        }
                    }
                }
            }
            arrayList.add(new SurfComposition.SurfLayer(unitDouble, arrayList2));
        }
        return arrayList;
    }

    @Override
    protected <T extends INamed> int existsStatus(FDSParseRecord fDSParseRecord, T t, Class<T> clazz) {
        if (!this.getNames(clazz).isRegistered(t.getName())) {
            return 0;
        }
        T t2 = this.findReplacementObject(clazz, t.getName());
        if (t2 == null) {
            return 0;
        }
        T t3 = this.findObject(clazz, t.getName());
        if (t3 != null && t3.equals(t)) {
            return 1;
        }
        return 2;
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        String string = PyroSimObjectInputStream.migrateBurnerTempRegToAdvanced(this.getParsingInfo().getContainer().getSurfaceMgr().flatten(), null);
        this.getParsingInfo().getContainer().setUnprocessedRecords(this.getParsingInfo().getContainer().getUnprocessedRecords() + string);
    }
}

