/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.AMsrStat;
import pyrosim.domain.output.GasMsrStat;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.SolidMsrStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.common.StatisticMap;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.DeviceParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitPoint3D;

public class StatisticsParser
extends AFDS6Parser {
    private Map<StatHash, Set<Integer>> d_solidStatMap = new LinkedHashMap<StatHash, Set<Integer>>();
    private Map<StatHash, Set<Integer>> d_gasStatMap = new LinkedHashMap<StatHash, Set<Integer>>();

    public StatisticsParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        DeviceParser.getUnsupported(string, map);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("STATISTICS", false);
        boolean bl = fDSParseRecord.contains("POINTS");
        boolean bl2 = fDSParseRecord.getOptional("TIME_HISTORY").orElse(false);
        if (string == null && !bl) {
            return true;
        }
        if (string == null && bl) {
            string = "STEADY STATE";
        } else if (string.equals("RMS") && bl) {
            string = "LINE RMS";
        } else if (bl && (string.equals("COV") || string.equals("CORRCOEF"))) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s statistics are not yet supported."), string), Intl.intl("Adding statistic to additional records section."));
            return false;
        }
        if (bl && bl2) {
            return true;
        }
        Integer n = StatisticMap.getPyroVal(string);
        if (n == null && !bl) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Unrecognized statistic: %s"), string), Intl.intl("Ignoring statistic."));
            return true;
        }
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", "PART_ID", "SPEC_ID", "MATL_ID", "DUCT_ID", "NODE_ID", n, Intl.intl("Ignoring statistic."), true, false);
        if (iQuantity == null) {
            return true;
        }
        if (iQuantity.get().quantityType != QuantityType.GAS && iQuantity.get().quantityType != QuantityType.SOLID || (iQuantity.get().outputTypes & 1) != 1) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Statitistics can only be measured for solid and gas phase quantities."), new Object[0]), Intl.intl("Ignoring statistic."));
            return true;
        }
        if ((iQuantity.get().outputTypes & n) != n) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Invalid statistic for quantity %s."), fDSParseRecord.getString("QUANTITY")), Intl.intl("Ignoring statistic."));
            return true;
        }
        IGeom iGeom = this.parseGeom(fDSParseRecord, iQuantity, string, n);
        if (iGeom == null) {
            return true;
        }
        if (iQuantity.get().quantityType == QuantityType.SOLID) {
            this.parseSolidStat(fDSParseRecord, iQuantity, n, iGeom);
        } else {
            this.parseGasStat(fDSParseRecord, iQuantity, n, iGeom);
        }
        return true;
    }

    private IGeom parseGeom(FDSParseRecord fDSParseRecord, IQuantity iQuantity, String string, int n) throws FDSRecordFormatException {
        Serializable serializable;
        UnitPoint3D unitPoint3D = null;
        UnitPoint3D[] unitPoint3DArray = null;
        UnitPoint3D unitPoint3D2 = null;
        Integer n2 = fDSParseRecord.getInteger("POINTS", false);
        if (fDSParseRecord.contains("XB")) {
            unitPoint3DArray = StatisticsParser.parseXB(fDSParseRecord, Intl.intl("Gas-phase statistics"), "XB", true);
            serializable = Util3D.getMidPoint(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU));
            unitPoint3D2 = new UnitPoint3D((Point3d)serializable, Geometry.LU);
        }
        if (fDSParseRecord.contains("XYZ")) {
            unitPoint3D = StatisticsParser.parseLoc(fDSParseRecord, "DEVC", "XYZ", true);
        }
        if (unitPoint3DArray == null && unitPoint3D == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Statistics must define either an XB or XYZ."), Intl.intl("Ignoring statistic."));
            return null;
        }
        if (n == 0x2000000 || n == 0x40000000) {
            serializable = new StatGeom.LinearArrayGeom(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU), n2);
        } else if (n == 0x400000) {
            AARectangle aARectangle = this.toRect(unitPoint3DArray);
            if (aARectangle == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s statistics must specify an area."), string), Intl.intl("Ignoring statistic."));
                return null;
            }
            serializable = aARectangle;
        } else if (n == 0x1000000 || n == 0x8000000) {
            if (unitPoint3D != null) {
                serializable = new Point(unitPoint3D.getPoint3dValue(Geometry.LU));
            } else {
                assert (unitPoint3D2 != null);
                serializable = new Point(unitPoint3D2.getPoint3dValue(Geometry.LU));
            }
        } else if (unitPoint3DArray != null) {
            serializable = new AABoxGeom(this.toBox(unitPoint3DArray).getValue(Geometry.LU));
        } else {
            Grid grid = this.getGridForPoint(unitPoint3D);
            if (grid == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find grid for point %s."), unitPoint3D.toString()), Intl.intl("Ignoring statistic."));
                return null;
            }
            serializable = new StatGeom.GridGeom(grid);
        }
        return serializable;
    }

    private Map<String, String> getCustomProps(FDSParseRecord fDSParseRecord) {
        CustomFDSProps customFDSProps = this.getCustomVals(fDSParseRecord);
        Map<String, String> map = customFDSProps.getProps();
        String string = fDSParseRecord.getString("PROP_ID");
        if (string != null) {
            map = new HashMap<String, String>(map);
            map.put("PROP_ID", "'" + string + "'");
        }
        return map;
    }

    private void parseGasStat(FDSParseRecord fDSParseRecord, IQuantity iQuantity, int n, IGeom iGeom) throws FDSRecordFormatException {
        StatHash statHash = new StatHash(fDSParseRecord, iGeom, iQuantity, this.getCustomProps(fDSParseRecord));
        this.getParsingInfo().getParseResult().extractedUnsupportedRecs.add(fDSParseRecord);
        Set<Integer> set = this.d_gasStatMap.get(statHash);
        if (set == null) {
            set = new HashSet<Integer>();
            this.d_gasStatMap.put(statHash, set);
        }
        set.add(n);
    }

    private AARectangle toRect(UnitPoint3D[] unitPoint3DArray) {
        return unitPoint3DArray != null ? AARectangle.construct(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU), false) : null;
    }

    private UnitAABox toBox(UnitPoint3D[] unitPoint3DArray) {
        return unitPoint3DArray != null ? new UnitAABox(unitPoint3DArray[0], unitPoint3DArray[1]) : null;
    }

    private void parseSolidStat(FDSParseRecord fDSParseRecord, IQuantity iQuantity, int n, IGeom iGeom) throws FDSRecordFormatException {
        StatHash statHash = new StatHash(fDSParseRecord, iGeom, iQuantity, this.getCustomProps(fDSParseRecord));
        this.getParsingInfo().getParseResult().extractedUnsupportedRecs.add(fDSParseRecord);
        Set<Integer> set = this.d_solidStatMap.get(statHash);
        if (set == null) {
            set = new HashSet<Integer>();
            this.d_solidStatMap.put(statHash, set);
        }
        set.add(n);
    }

    private Grid getGridForPoint(UnitPoint3D unitPoint3D) {
        Point3d point3d = unitPoint3D.getValue(SI.METER);
        for (PyroMod pyroMod : this.getParsingInfo().getSourceContainers()) {
            for (Grid grid : pyroMod.getGridManager().flatten()) {
                Point3d point3d2 = grid.getMinPoint().getValue(SI.METER);
                Point3d point3d3 = grid.getMaxPoint().getValue(SI.METER);
                if (!(point3d.x >= point3d2.x) || !(point3d.x <= point3d3.x) || !(point3d.y >= point3d2.y) || !(point3d.y <= point3d3.y) || !(point3d.z >= point3d2.z) || !(point3d.z <= point3d3.z)) continue;
                return grid;
            }
        }
        return null;
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        AMsrStat aMsrStat2;
        String string;
        StatHash statHash2;
        BiConsumer<StatHash, AMsrStat> biConsumer = (statHash, aMsrStat) -> {
            aMsrStat.setCustomFDSProps(CustomFDSProps.get(statHash.customProps));
            this.getContainer().getMsrStatMgr().add((IPyroObject)aMsrStat);
            this.flagObjectAdded((IPyroObject)aMsrStat);
        };
        for (Map.Entry<StatHash, Set<Integer>> entry : this.d_solidStatMap.entrySet()) {
            statHash2 = entry.getKey();
            string = this.getName(statHash2.rec);
            aMsrStat2 = new SolidMsrStat(string, statHash2.msr, statHash2.geom, Collections.EMPTY_LIST, (Collection<Integer>)entry.getValue());
            biConsumer.accept(statHash2, aMsrStat2);
        }
        for (Map.Entry<StatHash, Set<Integer>> entry : this.d_gasStatMap.entrySet()) {
            statHash2 = entry.getKey();
            string = this.getName(statHash2.rec);
            aMsrStat2 = new GasMsrStat(string, statHash2.msr, statHash2.geom, (Collection<Integer>)entry.getValue());
            biConsumer.accept(statHash2, aMsrStat2);
        }
    }

    private String getName(FDSParseRecord fDSParseRecord) {
        String string;
        String string2 = fDSParseRecord.getString("ID", false);
        String string3 = fDSParseRecord.getString("STATISTICS");
        if (string3 == null) {
            if (fDSParseRecord.contains("POINTS")) {
                string3 = "STEADY STATE";
            } else assert (false);
        }
        if (string2 == null) {
            String string4 = this.getNames(IMeasurementStat.class).generateName();
            this.addWarning(fDSParseRecord, Intl.intl("Statistic has no name."), String.format(Intl.intl("Assigning name to \"%s.\""), string4));
            return string4;
        }
        if (string2.length() > string3.length() + 1 && string2.endsWith("_" + string3)) {
            string2 = string2.substring(0, string2.lastIndexOf("_" + string3));
        }
        if (!(string = this.getNames(IMeasurementStat.class).generateValidName(string2)).equals(string2)) {
            this.addWarning(fDSParseRecord, Intl.intl("Statistic did not have a unique name."), String.format(Intl.intl("Changing name from \"%1$s\" to \"%2$s.\""), string2, string));
        }
        return string;
    }

    private static class StatHash {
        public final FDSParseRecord rec;
        public final IGeom geom;
        public final IQuantity msr;
        public final Map<String, String> customProps;

        public StatHash(FDSParseRecord fDSParseRecord, IGeom iGeom, IQuantity iQuantity, Map<String, String> map) {
            this.rec = fDSParseRecord;
            this.geom = iGeom;
            this.msr = iQuantity;
            this.customProps = map;
        }

        public int hashCode() {
            return this.geom.hashCode() + this.msr.hashCode() + this.customProps.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            StatHash statHash = (StatHash)object;
            return this.geom.equals(statHash.geom) && this.msr.equals(statHash.msr) && this.customProps.equals(statHash.customProps);
        }
    }
}

