/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.NameGenerator;

public class SliceParser
extends AFDS6Parser {
    public SliceParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("SLCF");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("MAXIMUM_VALUE", "UNSUPPORTED");
        map.put("MESH_NUMBER", "UNSUPPORTED");
        map.put("MINIMUM_VALUE", "UNSUPPORTED");
        map.put("QUANTITY2", "UNSUPPORTED");
        map.put("VELO_INDEX", "UNSUPPORTED");
        map.put("AGL_SLICE", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        boolean bl = fDSParseRecord.getBoolean("VECTOR", true);
        boolean bl2 = fDSParseRecord.getBoolean("CELL_CENTERED", true);
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, 128, Intl.intl("SLCF ignored"), true, false);
        if (iQuantity == null) {
            return false;
        }
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("AGL_SLICE");
        if (unitDouble != null) {
            this.addWarning(fDSParseRecord, String.format("%s slices are not yet supported.", "AGL_SLICE"), Intl.intl("Adding slice to additional records section."));
            return false;
        }
        Slice slice = null;
        if (fDSParseRecord.contains("PBX")) {
            slice = new PlanarSlice(0, fDSParseRecord.getUnitDouble("PBX"), iQuantity, bl, bl2);
        } else if (fDSParseRecord.contains("PBY")) {
            slice = new PlanarSlice(1, fDSParseRecord.getUnitDouble("PBY"), iQuantity, bl, bl2);
        } else if (fDSParseRecord.contains("PBZ")) {
            slice = new PlanarSlice(2, fDSParseRecord.getUnitDouble("PBZ"), iQuantity, bl, bl2);
        }
        if (slice != null) {
            SliceList sliceList = this.getContainer().getSlcfList();
            if (sliceList.contains(slice)) {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid SLCF record: Duplicate definition"), Intl.intl("Ignoring duplicate record."));
                return false;
            }
            sliceList.add(slice);
            this.flagObjectAdded(slice);
            return true;
        }
        AABoxGeom aABoxGeom = SliceParser.parseXBGeom(fDSParseRecord, "SLCF", "XB", true);
        if (aABoxGeom != null) {
            NameGenerator nameGenerator = this.getNames(VolumeSlice.class);
            String string = nameGenerator.generateValidName(iQuantity.getDescription());
            slice = new VolumeSlice(string, aABoxGeom, iQuantity, bl, bl2);
            Slice3dList slice3dList = this.getContainer().getSlcf3dList();
            if (slice3dList.contains(slice)) {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid SLCF record: Duplicate definition"), Intl.intl("Ignoring duplicate record."));
                return false;
            }
            slice3dList.add(slice);
            this.flagObjectAdded(slice);
            return true;
        }
        this.addWarning(fDSParseRecord, Intl.intl("Unsupported Slice type encountered."), Intl.intl("Ignoring Slice record."));
        return false;
    }
}

