/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import pyrosim.Intl;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IPropertySet;

public class SimParamsParser
extends AFDS6Parser {
    private int d_obstDefaults = 16;

    public SimParamsParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    public int getObstDefaults() {
        return this.d_obstDefaults;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("HEAD");
        set.add("MISC");
        set.add("TIME");
        set.add("DUMP");
        set.add("RADI");
        set.add("PRES");
        set.add("WIND");
        set.add("COMB");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        if (string.equals("MISC")) {
            map.put("ASSUMED_GAS_TEMPERATURE", "UNSUPPORTED");
            map.put("NOISE", "UNSUPPORTED");
            map.put("SOLID_PHASE_ONLY", "UNSUPPORTED");
            map.put("ALLOW_SURFACE_PARTICLES", "UNSUPPORTED");
            map.put("ASSUMED_GAS_TEMPERATURE_RAMP", "UNSUPPORTED");
            map.put("CNF_CUTOFF", "UNSUPPORTED");
            map.put("CONSTANT_SPECIFIC_HEAT_RATIO", "UNSUPPORTED");
            map.put("CFL_VELOCITY_NORM", "UNSUPPORTED");
            map.put("CHECK_HT", "UNSUPPORTED");
            map.put("CHECK_VN", "UNSUPPORTED");
            map.put("CLIP_MASS_FRACTION", "UNSUPPORTED");
            map.put("C_DEARDORFF", "UNSUPPORTED");
            map.put("C_VREMAN", "UNSUPPORTED");
            map.put("DRIFT_FLUX", "UNSUPPORTED");
            map.put("DT_MEAN_FORCING", "UNSUPPORTED");
            map.put("FLUX_LIMITER", "UNSUPPORTED");
            map.put("FORCE_VECTOR", "UNSUPPORTED");
            map.put("GAMMA", "UNSUPPORTED");
            map.put("GRAVITATIONAL_DEPOSITION", "UNSUPPORTED");
            map.put("GRAVITATIONAL_SETTLING", "UNSUPPORTED");
            map.put("LES_FILTER_WIDTH", "UNSUPPORTED");
            map.put("MAX_LEAK_PATHS", "UNSUPPORTED");
            map.put("MEAN_FORCING", "UNSUPPORTED");
            map.put("MPI_TIMEOUT", "UNSUPPORTED");
            map.put("NOISE_VELOCITY", "UNSUPPORTED");
            map.put("OVERWRITE", "UNSUPPORTED");
            map.put("PARTICLE_CFL", "UNSUPPORTED");
            map.put("PARTICLE_CFL_MAX", "UNSUPPORTED");
            map.put("PROJECTION", "UNSUPPORTED");
            map.put("RICHARDSON_ERROR_TOLERANCE", "UNSUPPORTED");
            map.put("RUN_AVG_FAC", "UNSUPPORTED");
            map.put("SECOND_ORDER_INTERPOLATED_BOUNDARY", "UNSUPPORTED");
            map.put("SHARED_FILE_SYSTEM", "UNSUPPORTED");
            map.put("SMOKE_ALBEDO", "UNSUPPORTED");
            map.put("STRATIFICATION", "UNSUPPORTED");
            map.put("THERMOPHORETIC_DEPOSITION", "UNSUPPORTED");
            map.put("NO_EVACUATION", "UNSUPPORTED");
            map.put("MAX_CHEMISTRY_ITERATIONS", "UNSUPPORTED");
            map.put("TURBULENCE_MODEL", "UNSUPPORTED");
            map.put("TURBULENT_DEPOSITION", "UNSUPPORTED");
            map.put("DT_HVAC", "FDS Version 6.7");
            map.put("EVACUATION_DRILL", "UNSUPPORTED");
            map.put("EVACUATION_MC_MODE", "UNSUPPORTED");
            map.put("EVAC_PRESSURE_ITERATIONS", "UNSUPPORTED");
            map.put("EVAC_SURF_DEFAULT", "UNSUPPORTED");
            map.put("EVAC_TIME_ITERATIONS", "UNSUPPORTED");
        } else if (string.equals("DUMP")) {
            map.put("FLUSH_FILE_BUFFERS", "UNSUPPORTED");
            map.put("CLIP_RESTART_FILES", "UNSUPPORTED");
            map.put("CTRL_COLUMN_LIMIT", "UNSUPPORTED");
            map.put("DEBUG", "UNSUPPORTED");
            map.put("DEVC_COLUMN_LIMIT", "UNSUPPORTED");
            map.put("DT_CTRL", "UNSUPPORTED");
            map.put("DT_DEVC_LINE", "UNSUPPORTED");
            map.put("DT_FLUSH", "UNSUPPORTED");
            map.put("EB_PART_FILE", "UNSUPPORTED");
            map.put("SIG_FIGS", "UNSUPPORTED");
            map.put("SIG_FIGS_EXP", "UNSUPPORTED");
            map.put("STATUS_FILES", "UNSUPPORTED");
            map.put("TIMING", "UNSUPPORTED");
            map.put("UVW_TIMER", "UNSUPPORTED");
            map.put("VELOCITY_ERROR_FILE", "UNSUPPORTED");
        } else if (string.equals("TIME")) {
            map.put("SHRINK_FACTOR", "UNSUPPORTED");
            map.put("SYNCHRONIZE", "FDS Version 6.3");
        } else if (string.equals("RADI")) {
            map.put("BAND_LIMITS", "UNSUPPORTED");
            map.put("MIE_MAXIMUM_DIAMETER", "UNSUPPORTED");
            map.put("MIE_MINIMUM_DIAMETER", "UNSUPPORTED");
            map.put("MIE_NDG", "UNSUPPORTED");
            map.put("RADIATIVE_FRACTION", "FDS Version 6.3");
        } else if (string.equals("PRES")) {
            map.put("CHECK_POISSON", "UNSUPPORTED");
            map.put("FISHPAK_BC", "UNSUPPORTED");
            map.put("MAX_PRESSURE_ITERATIONS", "UNSUPPORTED");
            map.put("PRESSURE_RELAX_TIME", "UNSUPPORTED");
            map.put("RELAXATION_FACTOR", "UNSUPPORTED");
            map.put("VELOCITY_TOLERANCE", "UNSUPPORTED");
        } else if (string.equals("WIND")) {
            map.put("INITIALIZATION_ONLY", "UNSUPPORTED");
            map.put("STRATIFICATION", "UNSUPPORTED");
            map.put("SPONGE_CELLS", "UNSUPPORTED");
            map.put("DT_MEAN_FORCING", "UNSUPPORTED");
        }
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (fDSParseRecord.getType().equals("HEAD")) {
            return this.processHead(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("MISC")) {
            return this.processMisc(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("TIME")) {
            return this.processTime(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("DUMP")) {
            return this.processDump(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("RADI")) {
            return this.processRadi(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("WIND")) {
            return this.processWind(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("COMB")) {
            return this.processComb(fDSParseRecord);
        }
        return true;
    }

    private boolean processHead(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        SimParams simParams = this.getContainer().getSimParams();
        String string = fDSParseRecord.getString("TITLE");
        if (string != null) {
            simParams.setJobTitle(string);
        }
        this.flagObjectAdded(simParams);
        return true;
    }

    private boolean processTime(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), fDSParseRecord);
        SimParams.Time time = this.getContainer().getSimParams().getTime();
        time.setTimeStepLocks(fDSParseRecord.getBoolean("LOCK_TIME_STEP", true), fDSParseRecord.getBoolean("RESTRICT_TIME_STEP", true));
        time.setInitTimeStep(fDSParseRecord.getUnitDouble("DT", true));
        time.setStartTime(fDSParseRecord.getUnitDouble("T_BEGIN", true));
        time.setStopTime(fDSParseRecord.getUnitDouble("T_END", true));
        time.setWallIncrement(fDSParseRecord.getInteger("WALL_INCREMENT", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processMisc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        this.parseCustomFDSProps(this.getContainer().getSimParams(), fDSParseRecord);
        SimParams.Calculations calculations = this.getContainer().getSimParams().getCalculations();
        String string = fDSParseRecord.getString("SIMULATION_MODE", true);
        SimParams.Calculations.SimulationMode simulationMode = null;
        for (SimParams.Calculations.SimulationMode object2 : SimParams.Calculations.SimulationMode.values()) {
            if (!string.equals(object2.simpleName)) continue;
            simulationMode = object2;
            break;
        }
        if (simulationMode == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Unknown value %s entered for field %s."), string, "SIMULATION_MODE"), String.format(Intl.intl("Default value, %s, will be used instead."), "VLES"));
            simulationMode = SimParams.Calculations.SimulationMode.VLES;
        }
        calculations.setSimMode(simulationMode);
        Boolean bl = fDSParseRecord.getBoolean("BAROCLINIC", false);
        SimParams.Calculations.BaroclinicState baroclinicState = SimParams.Calculations.BaroclinicState.AUTO;
        if (bl != null) {
            baroclinicState = bl != false ? SimParams.Calculations.BaroclinicState.TRUE : SimParams.Calculations.BaroclinicState.FALSE;
        }
        calculations.setBaroclinicState(baroclinicState);
        calculations.setCflRange(fDSParseRecord.getDouble("CFL_MIN", true), fDSParseRecord.getDouble("CFL_MAX", true));
        calculations.setCsmag(fDSParseRecord.getDouble("C_SMAGORINSKY", true));
        calculations.setPrandtlNum(fDSParseRecord.getDouble("PR", true));
        calculations.setSchmidtNum(fDSParseRecord.getDouble("SC", true));
        calculations.setVnRange(fDSParseRecord.getDouble("VN_MIN", true), fDSParseRecord.getDouble("VN_MAX", true));
        SimParams.Environment environment = this.getContainer().getSimParams().getEnvironment();
        this.readGravity(environment, fDSParseRecord);
        environment.setGroundLevel(fDSParseRecord.getUnitDouble("GROUND_LEVEL", true));
        environment.setRelHumidity(fDSParseRecord.getUnitDouble("HUMIDITY", true));
        environment.setAmbPressure(fDSParseRecord.getUnitDouble("P_INF", true));
        environment.setAmbTemp(fDSParseRecord.getUnitDouble("TMPA", true));
        environment.setAmbMFO2(fDSParseRecord.getUnitDouble("Y_O2_INFTY", true));
        environment.setAmbMFCO2(fDSParseRecord.getUnitDouble("Y_CO2_INFTY", true));
        environment.setMaxVisibility(fDSParseRecord.getUnitDouble("MAXIMUM_VISIBILITY", true));
        environment.setVisibilityFactor(fDSParseRecord.getDouble("VISIBILITY_FACTOR", true));
        SimParams.Particles particles = this.getContainer().getSimParams().getParticles();
        particles.setPourousFloor(fDSParseRecord.getBoolean("POROUS_FLOOR", true));
        particles.setAllowUndersideDroplets(fDSParseRecord.getBoolean("ALLOW_UNDERSIDE_PARTICLES", true));
        SimParams.Misc misc = this.getContainer().getSimParams().getMisc();
        String string2 = fDSParseRecord.getString("EVAC_SURF_DEFAULT", true);
        if (string2 != null) {
            serializable = this.findObject(Surface.class, string2);
            if (serializable == null) {
                throw new FDSRecordFormatException(fDSParseRecord, "The specified default surface, \"" + string2 + ",\" does not exist.");
            }
            misc.setEvacProp("EVAC_SURF_DEFAULT", serializable);
        }
        if ((serializable = fDSParseRecord.getArray("TEXTURE_ORIGIN", true)) != null) {
            misc.setTextureOrigin(new UnitPoint3D(((FDSArray)serializable).toFlatArray(new UnitDouble[3])));
        }
        boolean bl2 = fDSParseRecord.getBoolean("BNDF_DEFAULT", true);
        boolean bl3 = fDSParseRecord.getBoolean("THICKEN_OBSTRUCTIONS", true);
        this.d_obstDefaults = bl2 ? (this.d_obstDefaults |= 0x10) : (this.d_obstDefaults &= 0xFFFFFFEF);
        this.d_obstDefaults = bl3 ? (this.d_obstDefaults |= 1) : (this.d_obstDefaults &= 0xFFFFFFFE);
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processComb(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        SimParams.Calculations calculations = this.getContainer().getSimParams().getCalculations();
        calculations.setInitUnmixedFraction(fDSParseRecord.getDouble("INITIAL_UNMIXED_FRACTION", true));
        SimParams.Misc misc = this.getContainer().getSimParams().getMisc();
        Boolean bl = fDSParseRecord.getBoolean("SUPPRESSION", false);
        if (bl == null) {
            misc.setSuppression(SimParams.Misc.SUPPRESSION.AUTO);
        } else {
            misc.setSuppression(bl != false ? SimParams.Misc.SUPPRESSION.TRUE : SimParams.Misc.SUPPRESSION.FALSE);
        }
        return true;
    }

    private void readGravity(SimParams.Environment environment, FDSParseRecord fDSParseRecord) {
        Variant[] variantArray = this.parseVectorVariant(fDSParseRecord, "GVEC", "RAMP_GX", "RAMP_GY", "RAMP_GZ", 6, false, false);
        environment.setGravityAccel(variantArray[0], variantArray[1], variantArray[2]);
    }

    private Ramp readRamp(String string, int n, FDSParseRecord fDSParseRecord) {
        Object object;
        String string2 = fDSParseRecord.getString(string);
        FDS6ParsingInfo.RampInfo rampInfo = this.getParsingInfo().getRampInfo(string2);
        Ramp ramp = null;
        if (rampInfo != null && (object = SimParamsParser.getRampInput(rampInfo)) != null) {
            ramp = this.getParsingInfo().getRamp(string2, (IRampInput)object, n, false);
        }
        if (ramp == null) {
            object = String.format(Intl.intl("Unable to read RAMP record \"%s\"."), string2);
            this.addWarning(fDSParseRecord, (String)object, Intl.intl("Ramp Ignored"));
        }
        return ramp;
    }

    private static IRampInput getRampInput(FDS6ParsingInfo.RampInfo rampInfo) {
        if (rampInfo.rec.contains("T")) {
            return RampInputs.TIME;
        }
        if (rampInfo.rec.contains("X")) {
            return RampInputs.XPOS;
        }
        if (rampInfo.rec.contains("Z")) {
            return RampInputs.ZPOS;
        }
        return null;
    }

    private boolean processRadi(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), fDSParseRecord);
        SimParams.RadiationTransport radiationTransport = this.getContainer().getSimParams().getRadiTransport();
        radiationTransport.setRadiationOn(fDSParseRecord.getBoolean("RADIATION", true));
        radiationTransport.setAngleIncrement(fDSParseRecord.getInteger("ANGLE_INCREMENT", true));
        radiationTransport.setConstAbsorptionCoef(fDSParseRecord.getUnitDouble("KAPPA0", true));
        radiationTransport.setNumPolarAngles(fDSParseRecord.getInteger("NMIEANG", true));
        radiationTransport.setNumSolidAngles(fDSParseRecord.getInteger("NUMBER_RADIATION_ANGLES", true));
        radiationTransport.setRadCalcPathLen(fDSParseRecord.getUnitDouble("PATH_LENGTH", true));
        radiationTransport.setAssumedRadSourceTemp(fDSParseRecord.getUnitDouble("RADTMP", true));
        radiationTransport.setTimeStepInc(fDSParseRecord.getInteger("TIME_STEP_INCREMENT", true));
        radiationTransport.setNonGrayGasAssumption(fDSParseRecord.getBoolean("WIDE_BAND_MODEL", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processWind(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), fDSParseRecord);
        SimParams.Wind wind = this.getContainer().getSimParams().getWind();
        this.parseWindProfile(fDSParseRecord, wind);
        this.parseWindSpeed(fDSParseRecord, wind);
        this.parseWindForce(fDSParseRecord, wind);
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private void parseWindForce(FDSParseRecord fDSParseRecord, SimParams.Wind wind) {
        Variant[] variantArray = this.parseVectorVariant(fDSParseRecord, "FORCE_VECTOR", "RAMP_FVX_T", "RAMP_FVY_T", "RAMP_FVZ_T", 92, true, true);
        wind.set(SimParams.Wind.FORCEX, variantArray[0]);
        wind.set(SimParams.Wind.FORCEY, variantArray[1]);
        wind.set(SimParams.Wind.FORCEZ, variantArray[2]);
    }

    private Variant[] parseVectorVariant(FDSParseRecord fDSParseRecord, String string2, String string3, String string4, String string5, int n, boolean bl, boolean bl2) {
        FDSArray<UnitDouble> fDSArray = fDSParseRecord.getArray(string2, false);
        FDSArray fDSArray2 = fDSParseRecord.getArray(string2, true);
        UnitDouble[] unitDoubleArray = fDSArray.toFlatArray(new UnitDouble[3]);
        Variant[] variantArray = new Variant[3];
        BiConsumer<String, Integer> biConsumer = (string, n2) -> {
            Variant variant;
            variantArray[n2.intValue()] = variant = this.parseVecComponent(fDSParseRecord, unitDoubleArray[n2], (UnitDouble)fDSArray2.get((int)n2), (String)string, n, bl, bl2);
        };
        biConsumer.accept(string3, 0);
        biConsumer.accept(string4, 1);
        biConsumer.accept(string5, 2);
        return variantArray;
    }

    private Variant parseVecComponent(FDSParseRecord fDSParseRecord, UnitDouble unitDouble, UnitDouble unitDouble2, String string, int n, boolean bl, boolean bl2) {
        Ramp ramp;
        if (fDSParseRecord.contains(string) && (ramp = this.readRamp(string, bl ? 28 : n, fDSParseRecord)) != null) {
            if (unitDouble == null) {
                unitDouble = unitDouble2;
            }
            if (bl) {
                return Variant.fracRamp(unitDouble, ramp);
            }
            ramp = ramp.scaleF(unitDouble.getValue(SIUS.unit(n)));
            return Variant.ramp(ramp);
        }
        if (unitDouble != null) {
            return Variant.constant(unitDouble);
        }
        if (!bl2) {
            return Variant.constant(unitDouble2);
        }
        return Variant.def();
    }

    private void parseWindProfile(FDSParseRecord fDSParseRecord, SimParams.Wind wind) {
        wind.set(SimParams.Wind.ZREF, fDSParseRecord.getUnitDouble("Z_REF", true));
        wind.set(SimParams.Wind.USTAR, fDSParseRecord.getUnitDouble("U_STAR", true));
        wind.set(SimParams.Wind.THETASTAR, fDSParseRecord.getUnitDouble("THETA_STAR", true));
        wind.set(SimParams.Wind.Z0, fDSParseRecord.getUnitDouble("Z_0", true));
        wind.set(SimParams.Wind.L, fDSParseRecord.getUnitDouble("L", true));
        wind.set(SimParams.Wind.LAPSE_RATE, fDSParseRecord.getUnitDouble("LAPSE_RATE", true));
        wind.set(SimParams.Wind.TMP0Z_RAMP, this.readRampOrDefault(fDSParseRecord, "RAMP_TMP0_Z", 28));
        wind.set(SimParams.Wind.GROUND_LEVEL, fDSParseRecord.getUnitDouble("GROUND_LEVEL", true));
    }

    private void parseWindSpeed(FDSParseRecord fDSParseRecord, SimParams.Wind wind) {
        SimParams.Wind.InitSpeedOptions initSpeedOptions = !fDSParseRecord.contains("U0") && !fDSParseRecord.contains("V0") || fDSParseRecord.getUnitDouble("SPEED", true).gt(SIUS.newud(0.0, 8), 0.0) || fDSParseRecord.contains("U_STAR") && fDSParseRecord.getUnitDouble("U_STAR").gt(SIUS.newud(0.0, 8), 0.0) ? SimParams.Wind.InitSpeedOptions.SPEED : SimParams.Wind.InitSpeedOptions.UV;
        wind.set(SimParams.Wind.INITSPEEDOPT, initSpeedOptions);
        wind.set(SimParams.Wind.SPEED, fDSParseRecord.getUnitDouble("SPEED", true));
        wind.set(SimParams.Wind.SPEED_RAMP, this.readRampOrDefault(fDSParseRecord, "RAMP_SPEED", 8));
        wind.set(SimParams.Wind.DIRECTION, fDSParseRecord.getUnitDouble("DIRECTION", true));
        wind.set(SimParams.Wind.DIRECTION_RAMP, this.readRampOrDefault(fDSParseRecord, "RAMP_DIRECTION", 29));
        this.parseVectorWindComponent(wind, fDSParseRecord, SimParams.Wind.U0, "U0", SimParams.Wind.U0T, "RAMP_U0_T", SimParams.Wind.U0Z, "RAMP_U0_Z");
        this.parseVectorWindComponent(wind, fDSParseRecord, SimParams.Wind.V0, "V0", SimParams.Wind.V0T, "RAMP_V0_T", SimParams.Wind.V0Z, "RAMP_V0_Z");
        this.parseVectorWindComponent(wind, fDSParseRecord, SimParams.Wind.W0, "W0", SimParams.Wind.W0T, "RAMP_W0_T", SimParams.Wind.W0Z, "RAMP_W0_Z");
    }

    private void parseVectorWindComponent(SimParams.Wind wind, FDSParseRecord fDSParseRecord, IPropertySet.Prop<UnitDouble> prop, String string, IPropertySet.Prop<Variant> prop2, String string2, IPropertySet.Prop<Variant> prop3, String string3) {
        wind.set(prop, fDSParseRecord.getUnitDouble(string, true));
        wind.set(prop2, this.readRampOrDefault(fDSParseRecord, string2, 28));
        wind.set(prop3, this.readRampOrDefault(fDSParseRecord, string3, 28));
    }

    private Variant readRampOrDefault(FDSParseRecord fDSParseRecord, String string, int n) {
        Ramp ramp;
        if (fDSParseRecord.contains(string) && (ramp = this.readRamp(string, n, fDSParseRecord)) != null) {
            return Variant.ramp(ramp);
        }
        return Variant.def();
    }

    private boolean processDump(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), fDSParseRecord);
        SimParams.FileOutput fileOutput = this.getContainer().getSimParams().getFileOutput();
        fileOutput.setSuppressDiagnostics(fDSParseRecord.getBoolean("SUPPRESS_DIAGNOSTICS", true));
        fileOutput.setLimitCSVColumns(fDSParseRecord.getBoolean("COLUMN_DUMP_LIMIT", true));
        fileOutput.setDtBoundaryFile(fDSParseRecord.getUnitDouble("DT_BNDF", true));
        fileOutput.setDtDeviceFiles(fDSParseRecord.getUnitDouble("DT_DEVC", true));
        fileOutput.setDtHeatReleaseRateFiles(fDSParseRecord.getUnitDouble("DT_HRR", true));
        fileOutput.setDtIsofFiles(fDSParseRecord.getUnitDouble("DT_ISOF", true));
        fileOutput.setDtMassFiles(fDSParseRecord.getUnitDouble("DT_MASS", true));
        fileOutput.setDtParticleFiles(fDSParseRecord.getUnitDouble("DT_PART", true));
        fileOutput.setDtPlot3dFile(fDSParseRecord.getUnitDouble("DT_PL3D", true));
        fileOutput.setDtProfileDumpInterval(fDSParseRecord.getUnitDouble("DT_PROF", true));
        fileOutput.setDtRestartFile(fDSParseRecord.getUnitDouble("DT_RESTART", true));
        fileOutput.setDtSliceFiles(fDSParseRecord.getUnitDouble("DT_SLCF", true));
        fileOutput.setNumOutputFrames(fDSParseRecord.getInteger("NFRAMES", true));
        fileOutput.setVisualize3dSmoke(fDSParseRecord.getBoolean("SMOKE3D", true));
        fileOutput.setWriteSpeciesMassFile(fDSParseRecord.getBoolean("MASS_FILE", true));
        fileOutput.setDtSlice3dFiles(fDSParseRecord.getUnitDouble("DT_SL3D", true));
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "SMOKE3D_QUANTITY", null, "SMOKE3D_SPEC_ID", null, null, null, 0, Intl.intl("Ignoring custom smoke."), false, false);
        if (iQuantity != null) {
            if (!SimParams.FileOutput.isValidSmokeQuantity(iQuantity.get())) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a valid Smoke3D quantity."), fDSParseRecord.getString("SMOKE3D_QUANTITY")), Intl.intl("Ignoring custom smoke."));
            } else {
                fileOutput.setSmokeQuantity(iQuantity);
            }
        }
        SimParams.Particles particles = this.getContainer().getSimParams().getParticles();
        particles.setMaxParticlesPerMesh(fDSParseRecord.getInteger("MAXIMUM_PARTICLES", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }
}

