/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.ParseTest;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.SimParamsParser;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class SimParamsParseTest
extends ParseTest {
    private SimParamsParser d_simParamsParser;
    private PyroMod d_container;

    public SimParamsParseTest(String string) {
        super(string, FDS6Const.getRecordSpecs());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.d_container = new PyroMod();
        this.d_simParamsParser = new SimParamsParser(new FDS6ParsingInfo(null, this.d_container, this.d_container));
    }

    public void testOutputOn() {
        String string = "&DUMP DT_BNDF=6.00 DT_DEVC=7.00 DT_HRR=8.00 DT_ISOF=9.00 DT_MASS=5.00 COLUMN_DUMP_LIMIT=.TRUE. DT_PART=10.00 DT_PL3D=14.00 DT_PROF=11.00 DT_RESTART=12.00 DT_SLCF=13.00 NFRAMES=4 MASS_FILE=.TRUE. WRITE_XYZ=.TRUE. QUANTITIES='W-VELOCITY', 'HRRPUV', 'TEMPERATURE', 'U-VELOCITY', 'V-VELOCITY'/";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.FileOutput fileOutput = new SimParams(this.d_container.getSurfaceMgr()).getFileOutput();
        fileOutput.setDtBoundaryFile(new UnitDouble(6.0, SI.SECOND));
        fileOutput.setDtDeviceFiles(new UnitDouble(7.0, SI.SECOND));
        fileOutput.setDtHeatReleaseRateFiles(new UnitDouble(8.0, SI.SECOND));
        fileOutput.setDtIsofFiles(new UnitDouble(9.0, SI.SECOND));
        fileOutput.setDtMassFiles(new UnitDouble(5.0, SI.SECOND));
        fileOutput.setDtParticleFiles(new UnitDouble(10.0, SI.SECOND));
        fileOutput.setDtPlot3dFile(new UnitDouble(14.0, SI.SECOND));
        fileOutput.setDtProfileDumpInterval(new UnitDouble(11.0, SI.SECOND));
        fileOutput.setDtRestartFile(new UnitDouble(12.0, SI.SECOND));
        fileOutput.setDtSliceFiles(new UnitDouble(13.0, SI.SECOND));
        fileOutput.setLimitCSVColumns(true);
        fileOutput.setNumOutputFrames(4);
        fileOutput.setVisualize3dSmoke(true);
        fileOutput.setWriteSpeciesMassFile(true);
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.FileOutput fileOutput2 = this.d_container.getSimParams().getFileOutput();
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtBoundaryFile(), (Object)fileOutput.getDtBoundaryFile());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtDeviceFiles(), (Object)fileOutput.getDtDeviceFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtHeatReleaseRateFiles(), (Object)fileOutput.getDtHeatReleaseRateFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtIsofFiles(), (Object)fileOutput.getDtIsofFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtMassFiles(), (Object)fileOutput.getDtMassFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtParticleFiles(), (Object)fileOutput.getDtParticleFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtPlot3dFile(), (Object)fileOutput.getDtPlot3dFile());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtProfileDumpInterval(), (Object)fileOutput.getDtProfileDumpInterval());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtRestartFile(), (Object)fileOutput.getDtRestartFile());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtSliceFiles(), (Object)fileOutput.getDtSliceFiles());
            SimParamsParseTest.assertEquals((int)fileOutput2.getNumOutputFrames(), (int)fileOutput.getNumOutputFrames());
            SimParamsParseTest.assertEquals((boolean)fileOutput2.isLimitCSVColumns(), (boolean)fileOutput.isLimitCSVColumns());
            SimParamsParseTest.assertEquals((boolean)fileOutput2.isVisualize3dSmoke(), (boolean)fileOutput.isVisualize3dSmoke());
            SimParamsParseTest.assertEquals((boolean)fileOutput2.isWriteSpeciesMassFile(), (boolean)fileOutput.isWriteSpeciesMassFile());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testOutputOff() {
        String string = "&DUMP COLUMN_DUMP_LIMIT=.FALSE. SMOKE3D=.FALSE. QUANTITIES='W-VELOCITY', 'HRRPUV', 'TEMPERATURE', 'U-VELOCITY', 'V-VELOCITY'/";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.FileOutput fileOutput = new SimParams(this.d_container.getSurfaceMgr()).getFileOutput();
        fileOutput.setLimitCSVColumns(false);
        fileOutput.setVisualize3dSmoke(false);
        fileOutput.setWriteSpeciesMassFile(false);
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.FileOutput fileOutput2 = this.d_container.getSimParams().getFileOutput();
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtBoundaryFile(), (Object)fileOutput.getDtBoundaryFile());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtDeviceFiles(), (Object)fileOutput.getDtDeviceFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtHeatReleaseRateFiles(), (Object)fileOutput.getDtHeatReleaseRateFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtIsofFiles(), (Object)fileOutput.getDtIsofFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtMassFiles(), (Object)fileOutput.getDtMassFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtParticleFiles(), (Object)fileOutput.getDtParticleFiles());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtPlot3dFile(), (Object)fileOutput.getDtPlot3dFile());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtProfileDumpInterval(), (Object)fileOutput.getDtProfileDumpInterval());
            SimParamsParseTest.assertEquals((Object)fileOutput2.getDtSliceFiles(), (Object)fileOutput.getDtSliceFiles());
            SimParamsParseTest.assertEquals((int)fileOutput2.getNumOutputFrames(), (int)fileOutput.getNumOutputFrames());
            SimParamsParseTest.assertEquals((boolean)fileOutput2.isLimitCSVColumns(), (boolean)fileOutput.isLimitCSVColumns());
            SimParamsParseTest.assertEquals((boolean)fileOutput2.isVisualize3dSmoke(), (boolean)fileOutput.isVisualize3dSmoke());
            SimParamsParseTest.assertEquals((boolean)fileOutput2.isWriteSpeciesMassFile(), (boolean)fileOutput.isWriteSpeciesMassFile());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testTimeOn() {
        String string = "&TIME T_END=2.00 DT=3.00 SYNCHRONIZE=.TRUE./";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Time time = new SimParams(this.d_container.getSurfaceMgr()).getTime();
        time.setInitTimeStep(new UnitDouble(3.0, SI.SECOND));
        time.setStopTime(new UnitDouble(2.0, SI.SECOND));
        try {
            SimParamsParseTest.assertTrue((boolean)this.d_simParamsParser.process(fDSParseRecord));
            SimParams.Time time2 = this.d_container.getSimParams().getTime();
            SimParamsParseTest.assertEquals((Object)time2.getInitTimeStep(), (Object)time.getInitTimeStep());
            SimParamsParseTest.assertEquals((Object)time2.getStopTime(), (Object)time.getStopTime());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testTimeOff() {
        String string = "&HEAD TITLE='Empty'/";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Time time = new SimParams(this.d_container.getSurfaceMgr()).getTime();
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Time time2 = this.d_container.getSimParams().getTime();
            SimParamsParseTest.assertEquals((Object)time2.getInitTimeStep(), (Object)time.getInitTimeStep());
            SimParamsParseTest.assertEquals((Object)time2.getStopTime(), (Object)time.getStopTime());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testEnvironmentOn() {
        String string = "&MISC GVEC=22.00, 23.00, 24.00 HUMIDITY=18.00 LAPSE_RATE=17.00 P_INF=16.00 TMPA=15.00 U0=19.00 V0=20.00 W0=21.00/";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Environment environment = new SimParams(this.d_container.getSurfaceMgr()).getEnvironment();
        environment.setAmbTemp(new UnitDouble(15.0, SI.CELSIUS));
        environment.setAmbPressure(new UnitDouble(16.0, SI.PASCAL));
        environment.setRelHumidity(new UnitDouble(18.0, NonSI.PERCENT));
        environment.setGravityAccel(Variant.constant(22.0, SI.METER.divide(SI.SECOND.pow(2))), Variant.constant(23.0, SI.METER.divide(SI.SECOND.pow(2))), Variant.constant(24.0, SI.METER.divide(SI.SECOND.pow(2))));
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Environment environment2 = this.d_container.getSimParams().getEnvironment();
            SimParamsParseTest.assertEquals((Object)environment2.getRelHumidity(), (Object)environment.getRelHumidity());
            SimParamsParseTest.assertEquals((Object)environment2.getAmbPressure(), (Object)environment.getAmbPressure());
            SimParamsParseTest.assertEquals((Object)environment2.getAmbTemp(), (Object)environment.getAmbTemp());
            SimParamsParseTest.assertEquals((Object)environment2.getGravityX(), (Object)environment.getGravityX());
            SimParamsParseTest.assertEquals((Object)environment2.getGravityY(), (Object)environment.getGravityY());
            SimParamsParseTest.assertEquals((Object)environment2.getGravityZ(), (Object)environment.getGravityZ());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testEnvironmentOff() {
        SimParams.Environment environment = new SimParams(this.d_container.getSurfaceMgr()).getEnvironment();
        String string = "&HEAD TITLE='Empty'/";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Environment environment2 = this.d_container.getSimParams().getEnvironment();
            SimParamsParseTest.assertEquals((Object)environment2.getRelHumidity(), (Object)environment.getRelHumidity());
            SimParamsParseTest.assertEquals((Object)environment2.getAmbPressure(), (Object)environment.getAmbPressure());
            SimParamsParseTest.assertEquals((Object)environment2.getAmbTemp(), (Object)environment.getAmbTemp());
            SimParamsParseTest.assertEquals((Object)environment2.getGravityX(), (Object)environment.getGravityX());
            SimParamsParseTest.assertEquals((Object)environment2.getGravityY(), (Object)environment.getGravityY());
            SimParamsParseTest.assertEquals((Object)environment2.getGravityZ(), (Object)environment.getGravityZ());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testParticlesOn() {
        String string = "&DUMP MAXIMUM_PARTICLES=25/";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Particles particles = new SimParams(this.d_container.getSurfaceMgr()).getParticles();
        particles.setMaxParticlesPerMesh(25);
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Particles particles2 = this.d_container.getSimParams().getParticles();
            SimParamsParseTest.assertEquals((int)particles2.getMaxParticlesPerMesh(), (int)particles.getMaxParticlesPerMesh());
            SimParamsParseTest.assertEquals((boolean)particles2.isPourousFloor(), (boolean)particles.isPourousFloor());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testParticlesOff() {
        String string = "&MISC POROUS_FLOOR=.FALSE./";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Particles particles = new SimParams(this.d_container.getSurfaceMgr()).getParticles();
        particles.setPourousFloor(false);
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Particles particles2 = this.d_container.getSimParams().getParticles();
            SimParamsParseTest.assertEquals((int)particles2.getMaxParticlesPerMesh(), (int)particles.getMaxParticlesPerMesh());
            SimParamsParseTest.assertEquals((boolean)particles2.isPourousFloor(), (boolean)particles.isPourousFloor());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testCalculationsOn() {
        String string = "&MISC CFL_MAX=28.00 CFL_MIN=27.00 C_SMAGORINSKY=26.00 ISOTHERMAL=.TRUE. PR=32.00 SC=31.00 VN_MAX=30.00 VN_MIN=29.00 /";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Calculations calculations = new SimParams(this.d_container.getSurfaceMgr()).getCalculations();
        calculations.setSimMode(SimParams.Calculations.SimulationMode.VLES);
        calculations.setCflRange(27.0, 28.0);
        calculations.setBaroclinicState(SimParams.Calculations.BaroclinicState.AUTO);
        calculations.setCsmag(26.0);
        calculations.setPrandtlNum(32.0);
        calculations.setSchmidtNum(31.0);
        calculations.setVnRange(29.0, 30.0);
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Calculations calculations2 = this.d_container.getSimParams().getCalculations();
            SimParamsParseTest.assertEquals((Object)((Object)calculations2.getSimMode()), (Object)((Object)calculations.getSimMode()));
            SimParamsParseTest.assertEquals((Object)calculations2.getCsmag(), (Object)calculations.getCsmag());
            SimParamsParseTest.assertEquals((Object)calculations2.getPrandtlNum(), (Object)calculations.getPrandtlNum());
            SimParamsParseTest.assertEquals((Object)calculations2.getSchmidtNum(), (Object)calculations.getSchmidtNum());
            SimParamsParseTest.assertEquals((Object)((Object)calculations2.getBaroclinicState()), (Object)((Object)calculations.getBaroclinicState()));
            SimParamsParseTest.assertEquals((Object)calculations2.getCflRange()[0], (Object)calculations.getCflRange()[0]);
            SimParamsParseTest.assertEquals((Object)calculations2.getCflRange()[1], (Object)calculations.getCflRange()[1]);
            SimParamsParseTest.assertEquals((Object)calculations2.getVnRange()[0], (Object)calculations.getVnRange()[0]);
            SimParamsParseTest.assertEquals((Object)calculations2.getVnRange()[1], (Object)calculations.getVnRange()[1]);
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testCalculationsOffLES() {
        String string = "&MISC BAROCLINIC=.TRUE. SUPPRESSION=.FALSE./";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Calculations calculations = new SimParams(this.d_container.getSurfaceMgr()).getCalculations();
        calculations.setBaroclinicState(SimParams.Calculations.BaroclinicState.TRUE);
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Calculations calculations2 = this.d_container.getSimParams().getCalculations();
            SimParamsParseTest.assertEquals((Object)((Object)calculations2.getSimMode()), (Object)((Object)calculations.getSimMode()));
            SimParamsParseTest.assertEquals((Object)calculations2.getCsmag(), (Object)calculations.getCsmag());
            SimParamsParseTest.assertEquals((Object)calculations2.getPrandtlNum(), (Object)calculations.getPrandtlNum());
            SimParamsParseTest.assertEquals((Object)calculations2.getSchmidtNum(), (Object)calculations.getSchmidtNum());
            SimParamsParseTest.assertEquals((boolean)calculations2.getBaroclinicState().getFDSRepresentation(calculations2.getSimMode()), (boolean)calculations.getBaroclinicState().getFDSRepresentation(calculations.getSimMode()));
            SimParamsParseTest.assertEquals((Object)calculations2.getCflRange()[0], (Object)calculations.getCflRange()[0]);
            SimParamsParseTest.assertEquals((Object)calculations2.getCflRange()[1], (Object)calculations.getCflRange()[1]);
            SimParamsParseTest.assertEquals((Object)calculations2.getVnRange()[0], (Object)calculations.getVnRange()[0]);
            SimParamsParseTest.assertEquals((Object)calculations2.getVnRange()[1], (Object)calculations.getVnRange()[1]);
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testCalculationsOffDNS() {
        String string = "&MISC SIMULATION_MODE='DNS' SUPPRESSION=.FALSE./";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Calculations calculations = new SimParams(this.d_container.getSurfaceMgr()).getCalculations();
        calculations.setSimMode(SimParams.Calculations.SimulationMode.DNS);
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Calculations calculations2 = this.d_container.getSimParams().getCalculations();
            SimParamsParseTest.assertEquals((Object)((Object)calculations2.getSimMode()), (Object)((Object)calculations.getSimMode()));
            SimParamsParseTest.assertEquals((Object)calculations2.getCsmag(), (Object)calculations.getCsmag());
            SimParamsParseTest.assertEquals((Object)calculations2.getPrandtlNum(), (Object)calculations.getPrandtlNum());
            SimParamsParseTest.assertEquals((Object)calculations2.getSchmidtNum(), (Object)calculations.getSchmidtNum());
            SimParamsParseTest.assertEquals((Object)((Object)calculations2.getBaroclinicState()), (Object)((Object)calculations.getBaroclinicState()));
            SimParamsParseTest.assertEquals((Object)calculations2.getCflRange()[0], (Object)calculations.getCflRange()[0]);
            SimParamsParseTest.assertEquals((Object)calculations2.getCflRange()[1], (Object)calculations.getCflRange()[1]);
            SimParamsParseTest.assertEquals((Object)calculations2.getVnRange()[0], (Object)calculations.getVnRange()[0]);
            SimParamsParseTest.assertEquals((Object)calculations2.getVnRange()[1], (Object)calculations.getVnRange()[1]);
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testMiscOn() {
        String string = "&MISC CO_PRODUCTION=.TRUE. TEXTURE_ORIGIN=41.00, 42.00, 43.00 BACKGROUND_SPECIES='HYDROGEN'/";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Misc misc = new SimParams(this.d_container.getSurfaceMgr()).getMisc();
        this.d_container.getSurfaceMgr().add(new Surface("blah"));
        misc.setSurfDefault((Surface)this.d_container.getSurfaceMgr().get("blah"));
        misc.setTextureOrigin(new UnitPoint3D(41.0, 42.0, 43.0, SI.METER));
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Misc misc2 = this.d_container.getSimParams().getMisc();
            SimParamsParseTest.assertEquals((Object)misc2.getTextureOrigin(), (Object)misc.getTextureOrigin());
            SimParamsParseTest.assertEquals((boolean)misc2.predictCOProd(), (boolean)misc.predictCOProd());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    public void testMiscOff() {
        String string = "&HEAD TITLE='Empty'/";
        FDSParseRecord fDSParseRecord = this.parseRecord(string);
        SimParams.Misc misc = new SimParams(this.d_container.getSurfaceMgr()).getMisc();
        misc.setSurfDefault(this.d_container.getSurfaceMgr().get(PredefSurf.INERT));
        try {
            this.d_simParamsParser.process(fDSParseRecord);
            SimParams.Misc misc2 = this.d_container.getSimParams().getMisc();
            SimParamsParseTest.assertEquals((Object)misc2.getSurfDefault(), (Object)misc.getSurfDefault());
            SimParamsParseTest.assertEquals((Object)misc2.getTextureOrigin(), (Object)misc.getTextureOrigin());
            SimParamsParseTest.assertEquals((boolean)misc2.predictCOProd(), (boolean)misc.predictCOProd());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SimParamsParseTest.fail((String)"Test failed.");
        }
    }

    static {
        new PyroSim();
    }
}

