/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.units.UnitDouble;

public class ReactionParser
extends AFDS6Parser {
    private Map<FDSParseRecord, Reaction> d_reactions = new HashMap<FDSParseRecord, Reaction>();

    public ReactionParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("REAC");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("EQUATION", "UNSUPPORTED");
        map.put("FUEL_RADCAL_ID", "UNSUPPORTED");
        map.put("HRRPUA_SHEET", "FDS Version 6.3");
        map.put("HRRPUV_AVERAGE", "FDS Version 6.3");
        map.put("A", "UNSUPPORTED");
        map.put("E", "UNSUPPORTED");
        map.put("N_S", "UNSUPPORTED");
        map.put("SPEC_ID_N_S", "UNSUPPORTED");
        map.put("N_T", "UNSUPPORTED");
        map.put("CHECK_ATOM_BALANCE", "UNSUPPORTED");
        map.put("REAC_ATOM_ERROR", "UNSUPPORTED");
        map.put("REAC_MASS_ERROR", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        int n;
        Object object;
        String string2 = this.parseName(fDSParseRecord, "ID", Reaction.class);
        Reaction reaction = new Reaction(string2, false, Reaction.ReacType.SIMPLE);
        reaction.setFYI(fDSParseRecord.getString("FYI", false));
        this.parseCustomFDSProps(reaction, fDSParseRecord);
        this.parseFuel(fDSParseRecord, reaction);
        this.parseSuppression(fDSParseRecord, reaction);
        this.parseByProducts(fDSParseRecord, reaction);
        if (fDSParseRecord.contains("SPEC_ID_NU") && fDSParseRecord.contains("NU")) {
            reaction.setReacType(Reaction.ReacType.COMPLEX);
            ExSpecList exSpecList = this.getContainer().getExSpecList();
            object = fDSParseRecord.getList("SPEC_ID_NU", false);
            List list = fDSParseRecord.getList("NU", false);
            List list2 = ((Stream)object.stream().sequential()).map(string -> ReactionParser.getKnownSpec(exSpecList, string)).collect(Collectors.toList());
            int n2 = 0;
            while (n2 != -1) {
                n2 = list2.indexOf(null);
                if (n2 == -1) continue;
                list2.remove(n2);
                list.remove(n2);
                String string3 = (String)object.remove(n2);
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to parse dependent species %s."), string3), String.format(Intl.intl("Unparsed species, %s, will be dropped from the reaction chemistry."), string3));
            }
            int n3 = Math.min(object.size(), list.size());
            if (object.size() != list.size()) {
                int n4 = Math.abs(object.size() - list.size());
                this.addWarning(fDSParseRecord, String.format(Intl.intl("An inconsistent number of values for %s and %s detected."), "NU", "SPEC_ID_NU"), String.format(Intl.intl("%d mismatched values will be ignored."), n4));
            }
            Map<ExSpec, Double> map = IntStream.range(0, n3).boxed().collect(Collectors.toMap(list2::get, list::get));
            reaction.setComplexStoichiometry(map);
        }
        if ((n = this.existsStatus(fDSParseRecord, reaction, Reaction.class)) != 0) {
            return this.convertToReturn(n);
        }
        object = this.getContainer().getReactions();
        ((ReactionList)object).add(reaction);
        this.flagObjectAdded(reaction);
        ((ReactionList)object).setActiveReaction(reaction);
        this.d_reactions.put(fDSParseRecord, reaction);
        return true;
    }

    private void parseFuel(FDSParseRecord fDSParseRecord, Reaction reaction) {
        HashMap<String, String> hashMap;
        reaction.setFuel(this.getFuelSpec(fDSParseRecord));
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (fDSParseRecord.contains("FORMULA")) {
            hashMap = new HashMap<String, String>();
            String string = fDSParseRecord.getString("FORMULA");
            char[] cArray = string.toCharArray();
            int n = 0;
            while (n < cArray.length) {
                if (Character.isLetter(cArray[n])) {
                    int n2;
                    char c = cArray[n];
                    int n3 = n2 = n + 1;
                    int n4 = n2;
                    while (n4 < string.length() && Character.isDigit(cArray[n4])) {
                        n3 = ++n4;
                    }
                    int n5 = Integer.parseInt(string.substring(n2, n3));
                    hashMap.put((String)((Object)Character.valueOf(c)), (String)((Object)Integer.valueOf(n5)));
                    n = n4;
                    continue;
                }
                ++n;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                if (((Character)entry.getKey()).charValue() == 'H' || ((Character)entry.getKey()).charValue() == 'h') {
                    d = ((Integer)entry.getValue()).intValue();
                    continue;
                }
                if (((Character)entry.getKey()).charValue() == 'C' || ((Character)entry.getKey()).charValue() == 'c') {
                    d2 = ((Integer)entry.getValue()).intValue();
                    continue;
                }
                if (((Character)entry.getKey()).charValue() == 'O' || ((Character)entry.getKey()).charValue() == 'o') {
                    d3 = ((Integer)entry.getValue()).intValue();
                    continue;
                }
                if (((Character)entry.getKey()).charValue() != 'N' && ((Character)entry.getKey()).charValue() != 'n') continue;
                d4 = ((Integer)entry.getValue()).intValue();
            }
        } else {
            d = fDSParseRecord.getDouble("H", true);
            d2 = fDSParseRecord.getDouble("C", true);
            d3 = fDSParseRecord.getDouble("O", true);
            d4 = fDSParseRecord.getDouble("N", true);
        }
        if (!ExSpecList.isPredefinedSpecies(reaction.getFuel().getName())) {
            reaction.setFuelComp(d, d2, d3, d4);
        } else {
            hashMap = new HashMap();
            if (d > 0.0) {
                hashMap.put("H", Double.toString(d));
            }
            if (d2 > 0.0) {
                hashMap.put("C", Double.toString(d2));
            }
            if (d3 > 0.0) {
                hashMap.put("O", Double.toString(d3));
            }
            if (d4 > 0.0) {
                hashMap.put("N", Double.toString(d4));
            }
            reaction.setCustomFDSProps(CustomFDSProps.union(CustomFDSProps.get(hashMap), reaction.getCustomFDSProps()));
        }
    }

    private void parseSuppression(FDSParseRecord fDSParseRecord, Reaction reaction) {
        if (fDSParseRecord.contains("CRITICAL_FLAME_TEMPERATURE") || fDSParseRecord.contains("AUTO_IGNITION_TEMPERATURE")) {
            reaction.setSuppression(true);
        }
        reaction.setCritFlameTemp(fDSParseRecord.getUnitDouble("CRITICAL_FLAME_TEMPERATURE", true));
        reaction.setAutoIgnitionTemp(fDSParseRecord.getUnitDouble("AUTO_IGNITION_TEMPERATURE", true));
    }

    private void parseByProducts(FDSParseRecord fDSParseRecord, Reaction reaction) {
        reaction.setYields(fDSParseRecord.getDouble("CO_YIELD", true), fDSParseRecord.getDouble("SOOT_YIELD", true));
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("HEAT_OF_COMBUSTION", true);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("EPUMO2", true);
        reaction.setEpumo2(unitDouble2);
        if (unitDouble == null) {
            reaction.setHeatOfCombustion(new UnitDouble(0.0, SI.KILO(SI.JOULE).divide(SI.KILOGRAM)));
            reaction.setEnergyType(Reaction.EnergyRelease.EPUMO2);
        } else {
            reaction.setHeatOfCombustion(unitDouble);
            reaction.setEnergyType(Reaction.EnergyRelease.HEAT_OF_COMBUSTION);
        }
        reaction.setSootHFraction(fDSParseRecord.getDouble("SOOT_H_FRACTION", true));
        reaction.setIdeal(fDSParseRecord.getBoolean("IDEAL", true));
    }

    private ExSpec getFuelSpec(FDSParseRecord fDSParseRecord) {
        ExSpecList exSpecList = this.getContainer().getExSpecList();
        String string = fDSParseRecord.getString("FUEL", true);
        if (string == null) {
            return ExSpecList.getDefaultFuel(true);
        }
        ExSpec exSpec = exSpecList.get(string);
        if (exSpec != null) {
            return exSpec;
        }
        boolean bl = ExSpecList.isPredefinedSpecies(string);
        if (bl) {
            ExSpec exSpec2 = new ExSpec(ExSpecList.getPredefinedSpecies(string));
            exSpec2.setType(1);
            exSpecList.add(exSpec2);
            return exSpec2;
        }
        exSpecList.setReacDefaultAlias(string);
        return ExSpecList.getDefaultFuel(this.getContainer().getExSpecList(), this.getContainer().getNames(ExSpec.class), true);
    }

    private static ExSpec getKnownSpec(ExSpecList exSpecList, String string) {
        ExSpec exSpec = exSpecList.get(string);
        if (exSpec != null) {
            return exSpec;
        }
        boolean bl = ExSpecList.isPredefinedSpecies(string);
        if (bl) {
            ExSpec exSpec2 = new ExSpec(ExSpecList.getPredefinedSpecies(string));
            exSpec2.setType(1);
            exSpecList.add(exSpec2);
            return exSpec2;
        }
        return null;
    }

    private void addImplicitSpecs() {
        ExSpecList exSpecList = this.getContainer().getExSpecList();
        exSpecList.addImplicitSpecs();
    }
}

