/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;

public class RampParser
extends AFDS6Parser {
    public RampParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("RAMP");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("CTRL_ID", "UNSUPPORTED");
        map.put("NUMBER_INTERPOLATION_POINTS", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = fDSParseRecord.getString("ID");
        if (string == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Ramp does not have ID."));
        }
        Double d = fDSParseRecord.getDouble("F");
        if (d == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Ramp does not have an F."));
        }
        Double d2 = null;
        Double d3 = fDSParseRecord.getDouble("T");
        Double d4 = fDSParseRecord.getDouble("X");
        Double d5 = fDSParseRecord.getDouble("Z");
        if (d3 == null && d4 == null && d5 == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Ramp does not have a T, X, or Z."));
        }
        if (d3 != null) {
            d2 = d3;
        } else if (d4 != null) {
            d2 = d4;
        } else if (d5 != null) {
            d2 = d5;
        }
        String string2 = fDSParseRecord.getString("DEVC_ID");
        this.getParsingInfo().addRampValue(fDSParseRecord, string, d2, d, string2);
        return true;
    }
}

