/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class ProfParser
extends AFDS6Parser {
    public ProfParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("PROF");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        int n = 0;
        if (!fDSParseRecord.contains("IOR")) {
            n |= 2;
        }
        if (!fDSParseRecord.contains("QUANTITY")) {
            n |= 4;
        }
        if (!fDSParseRecord.contains("XYZ")) {
            n |= 8;
        }
        String string = Intl.intl("PROF Record Ignored");
        if ((n & 2) > 0) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process PROF record: IOR missing"), string);
        }
        if ((n & 4) > 0) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process PROF record: QUANTITY missing"), string);
        }
        if ((n & 8) > 0) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process PROF record: XYZ missing"), string);
        }
        if (n > 0) {
            return false;
        }
        String string2 = this.getValidName(fDSParseRecord, "ID", ProfRec.class);
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", null, null, null, null, null, 256, string, true, false);
        if (iQuantity == null) {
            return false;
        }
        int n2 = fDSParseRecord.getInteger("IOR");
        FDSArray fDSArray = fDSParseRecord.getArray("XYZ", true);
        UnitPoint3D unitPoint3D = new UnitPoint3D((UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), (UnitDouble)fDSArray.get(2));
        ProfRec profRec = new ProfRec(string2, n2, iQuantity, unitPoint3D);
        int n3 = this.existsStatus(fDSParseRecord, profRec, ProfRec.class);
        if (n3 != 0) {
            return this.convertToReturn(n3);
        }
        ProfList profList = this.getContainer().getProfList();
        profList.add(profRec);
        this.flagObjectAdded(profRec);
        return true;
    }
}

