/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;

public class Plot3dParser
extends AFDS6Parser {
    public Plot3dParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("DUMP");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        FDSArray fDSArray = fDSParseRecord.getArray("PLOT3D_QUANTITY", true);
        if (fDSArray == null) {
            return true;
        }
        FDSArray fDSArray2 = fDSParseRecord.getArray("PLOT3D_SPEC_ID", true);
        FDSArray fDSArray3 = fDSParseRecord.getArray("PLOT3D_PART_ID", true);
        FDSArray fDSArray4 = fDSParseRecord.getArray("PLOT3D_VELO_INDEX", true);
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>(5);
        VelocitySign velocitySign = VelocitySign.ALWAYS_POSITIVE;
        for (int i = 0; i < Math.min(fDSArray.getTotalLength(), 5); ++i) {
            String string = (String)fDSArray.get(i);
            if (string == null) continue;
            String string2 = fDSArray2 != null ? (String)fDSArray2.get(i) : null;
            String string3 = fDSArray3 != null ? (String)fDSArray3.get(i) : null;
            Integer n = fDSArray4 != null ? (Integer)fDSArray4.get(i) : null;
            IQuantity iQuantity = this.getQuantityMap().parseQuantity(this.getParsingInfo(), fDSParseRecord, string, string3, string2, null, null, null);
            if (iQuantity == null) continue;
            if (!QuantityUtil.canOutputAll(iQuantity.get(), 64)) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Quantity %s is invalid for Plot3D output."), string), Intl.intl("Quantity ignored"));
                continue;
            }
            arrayList.add(iQuantity);
            if (!iQuantity.get().equals((Object)Quantity.VELOCITY)) continue;
            velocitySign = this.parseVelocitySign(fDSParseRecord, n);
        }
        Plot3d plot3d = this.getContainer().getPlot3d();
        plot3d.setQuantities(arrayList);
        plot3d.setVelocitySign(velocitySign);
        this.flagObjectAdded(plot3d);
        return true;
    }
}

