/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.util.LinkedIdentityHashMap;

public class PinConnParser
extends AFDS6Parser {
    private final Map<String, List<IOutPin>> d_idPinMap = new HashMap<String, List<IOutPin>>();
    private final List<InputRetrieval> d_retrievalList = new ArrayList<InputRetrieval>();
    private final Map<IOutPin, String> d_outPinCtrlNameMap = new LinkedIdentityHashMap<IOutPin, String>();

    public PinConnParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
        for (PyroMod pyroMod : fDS6ParsingInfo.getSourceContainers()) {
            for (IDevice iDevice : pyroMod.getDevices().flatten()) {
                ISignalSource iSignalSource;
                if (iDevice instanceof LayerMeasurer) {
                    iSignalSource = (LayerMeasurer)iDevice;
                    this.addMsrInfoNames(((LayerMeasurer)iSignalSource).getHeightInfo());
                    this.addMsrInfoNames(((LayerMeasurer)iSignalSource).getLowerTempInfo());
                    this.addMsrInfoNames(((LayerMeasurer)iSignalSource).getUpperTempInfo());
                    continue;
                }
                if (!(iDevice instanceof ISignalSource)) continue;
                iSignalSource = (ISignalSource)((Object)iDevice);
                for (IOutPin iOutPin : iSignalSource.getOutputPins()) {
                    this.addOutputName(iOutPin, iDevice.getName());
                }
            }
        }
    }

    private void addMsrInfoNames(MeasureOutInfo measureOutInfo) {
        List<IOutPin> list = measureOutInfo.getPins();
        if (list.isEmpty()) {
            return;
        }
        String string = PinConnectionRenderer.getOutPinName(list.toArray(new IOutPin[list.size()]), "", false);
        for (IOutPin iOutPin : list) {
            this.addOutputName(iOutPin, string);
        }
    }

    public List<InputRetrieval> getRetrievals() {
        return Collections.unmodifiableList(this.d_retrievalList);
    }

    public Map<IOutPin, String> getPinFDSNameMap() {
        return this.d_outPinCtrlNameMap;
    }

    public boolean outputNameExists(String string) {
        return this.d_idPinMap.containsKey(string);
    }

    public boolean addOutputName(IOutPin iOutPin, String string) {
        List<IOutPin> list = this.d_idPinMap.get(string);
        if (list == null) {
            list = new ArrayList<IOutPin>();
            this.d_idPinMap.put(string, list);
        }
        this.d_outPinCtrlNameMap.put(iOutPin, string);
        list.add(iOutPin);
        return true;
    }

    public List<IOutPin> getPins(String string) {
        return this.d_idPinMap.get(string);
    }

    public void markInputForRetrieval(FDSParseRecord fDSParseRecord, IInPin iInPin, List<String> list) {
        if (list == null) {
            list = new ArrayList<String>(0);
        }
        this.d_retrievalList.add(new InputRetrieval(fDSParseRecord, iInPin, list));
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("CTRL");
        set.add("DEVC");
        set.add("OBST");
        set.add("VENT");
        set.add("HOLE");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
    }

    @Override
    public void process(Collection<FDSParseRecord> collection, Collection<FDSParseRecord> collection2) throws FDSRecordFormatException {
        for (InputRetrieval inputRetrieval : this.d_retrievalList) {
            for (String string : inputRetrieval.inputIDs) {
                List<IOutPin> list = this.d_idPinMap.get(string);
                if (list == null) {
                    throw new FDSRecordFormatException(inputRetrieval.rec, String.format(Intl.intl("Could not find control input: %s"), string));
                }
                boolean bl = false;
                for (IOutPin iOutPin : list) {
                    if (!inputRetrieval.inPin.canConnect(iOutPin)) continue;
                    inputRetrieval.inPin.connect(iOutPin);
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new FDSRecordFormatException(inputRetrieval.rec, String.format(Intl.intl("Invalid input, %s."), string));
            }
        }
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        return false;
    }

    public static class InputRetrieval {
        public final FDSParseRecord rec;
        public final IInPin inPin;
        public final List<String> inputIDs;

        public InputRetrieval(FDSParseRecord fDSParseRecord, IInPin iInPin, List<String> list) {
            this.rec = fDSParseRecord;
            this.inPin = iInPin;
            this.inputIDs = list;
        }
    }
}

