/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.signals.ILogicInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.IFDSRecordParser;
import pyrosim.io.fds.v6.parsers.ControlParser;
import pyrosim.io.fds.v6.parsers.PinConnParser;

public class PinConnFinisher
implements IFDSRecordParser {
    private final FDSParsingInfo d_pi;
    private final PinConnParser d_pinConns;
    private final ControlParser d_ctrlParser;

    public PinConnFinisher(FDSParsingInfo fDSParsingInfo, PinConnParser pinConnParser, ControlParser controlParser) {
        this.d_pi = fDSParsingInfo;
        this.d_pinConns = pinConnParser;
        this.d_ctrlParser = controlParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("CTRL");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
    }

    @Override
    public void process(Collection<FDSParseRecord> collection, Collection<FDSParseRecord> collection2) throws FDSRecordFormatException {
        Object object;
        ArrayList arrayList;
        Object object2;
        this.d_ctrlParser.finish();
        IdentityHashMap<ILogicOutPin, Object> identityHashMap = new IdentityHashMap<ILogicOutPin, Object>();
        for (PinConnParser.InputRetrieval object3 : this.d_pinConns.getRetrievals()) {
            object2 = object3.inPin.getConnections();
            if (!(object3.inPin.getAttachedSink() instanceof IControl) && object3.inPin instanceof ILogicInPin) {
                arrayList = new ArrayList(object2);
                for (IOutPin iOutPin : arrayList) {
                    ControlBridge controlBridge = (ControlBridge)identityHashMap.get(iOutPin);
                    if (controlBridge == null) {
                        controlBridge = this.addBridge((ILogicOutPin)iOutPin, this.d_pinConns.getPinFDSNameMap().get(iOutPin));
                        assert (iOutPin instanceof ILogicOutPin);
                        identityHashMap.put((ILogicOutPin)iOutPin, controlBridge);
                    }
                    object3.inPin.disconnect(iOutPin);
                    object3.inPin.connect(controlBridge.getOutputPins().get(0));
                }
                continue;
            }
            arrayList = object2.iterator();
            while (arrayList.hasNext()) {
                object = arrayList.next();
                if (!(object instanceof ILogicOutPin) || identityHashMap.containsKey(object)) continue;
                identityHashMap.put((ILogicOutPin)object, null);
            }
        }
        for (Map.Entry entry : this.d_pinConns.getPinFDSNameMap().entrySet()) {
            object2 = (IOutPin)entry.getKey();
            arrayList = (String)entry.getValue();
            if (!(object2 instanceof ILogicOutPin) || identityHashMap.containsKey(object2) || object2.getAttachedSource() instanceof IDevice && !(object2.getAttachedSource() instanceof Timer)) continue;
            object = this.addBridge((ILogicOutPin)object2, (String)((Object)arrayList));
            identityHashMap.put((ILogicOutPin)object2, object);
        }
    }

    private ControlBridge addBridge(ILogicOutPin iLogicOutPin, String string) {
        ControlBridge controlBridge = new ControlBridge(this.getBridgeName(iLogicOutPin, string));
        assert (controlBridge.getInputPin().isCompatible(iLogicOutPin));
        controlBridge.getInputPin().connect(iLogicOutPin);
        this.d_pi.getContainer().getControls().add(controlBridge);
        this.d_pi.getParseResult().extractedObjs.add(controlBridge);
        return controlBridge;
    }

    private String getBridgeName(ILogicOutPin iLogicOutPin, String string) {
        int n = 0;
        for (IOutPin iOutPin : iLogicOutPin.getAttachedSource().getOutputPins()) {
            if (!(iOutPin instanceof ILogicOutPin)) continue;
            ++n;
        }
        if (n == 1) {
            return string;
        }
        return string + "->" + iLogicOutPin.getName();
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
    }
}

