/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.DropletColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.common.ParticleQuantityMap;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import thunderheadeng.units.UnitDouble;

public class ParticleParser
extends AFDS6Parser {
    private final PinConnParser d_pinConns;
    private Map<FDSParseRecord, Particle> d_partsWithSurfs = new LinkedHashMap<FDSParseRecord, Particle>();
    private Map<FDSParseRecord, Particle> d_partsWithSpecs = new LinkedHashMap<FDSParseRecord, Particle>();

    public ParticleParser(FDS6ParsingInfo fDS6ParsingInfo, PinConnParser pinConnParser) {
        super(fDS6ParsingInfo);
        this.d_pinConns = pinConnParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("PART");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("BREAKUP", "UNSUPPORTED");
        map.put("BREAKUP_CNF_RAMP_ID", "UNSUPPORTED");
        map.put("BREAKUP_DISTRIBUTION", "UNSUPPORTED");
        map.put("BREAKUP_GAMMA_D", "UNSUPPORTED");
        map.put("BREAKUP_RATIO", "UNSUPPORTED");
        map.put("BREAKUP_SIGMA_D", "UNSUPPORTED");
        map.put("CHECK_DISTRIBUTION", "UNSUPPORTED");
        map.put("CNF_RAMP_ID", "UNSUPPORTED");
        map.put("COMPLEX_REFRACTIVE_INDEX", "UNSUPPORTED");
        map.put("FREE_AREA_FRACTION", "UNSUPPORTED");
        map.put("N_STRATA", "UNSUPPORTED");
        map.put("ORIENTATION", "UNSUPPORTED");
        map.put("PERMEABILITY", "UNSUPPORTED");
        map.put("PROP_ID", "UNSUPPORTED");
        map.put("QUANTITIES_SPEC_ID", "UNSUPPORTED");
        map.put("RADIATIVE_PROPERTY_TABLE", "UNSUPPORTED");
        map.put("REAL_REFRACTIVE_INDEX", "UNSUPPORTED");
        map.put("SURFACE_TENSION", "UNSUPPORTED");
        map.put("HORIZONTAL_VELOCITY", "UNSUPPORTED");
        map.put("VERTICAL_VELOCITY", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Object object;
        Object object2;
        String string = this.parseName(fDSParseRecord, "ID", Particle.class);
        if (!this.checkName(fDSParseRecord, string)) {
            return false;
        }
        Particle.Type type = null;
        if (type == null) {
            if (fDSParseRecord.getBoolean("MASSLESS", true).booleanValue()) {
                type = Particle.Type.TRACER;
            } else {
                object2 = fDSParseRecord.getString("SPEC_ID", true);
                if (object2 != null) {
                    type = Particle.Type.LIQUID;
                } else {
                    object = fDSParseRecord.getString("SURF_ID", true);
                    if (object != null) {
                        type = Particle.Type.SOLID;
                    } else {
                        throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Particle invalid. Must specify SPEC_ID, SURF_ID, or MASSLESS=.TRUE."));
                    }
                }
            }
        }
        object2 = ParticleParser.parseOutput(fDSParseRecord, 10);
        object = ParticleParser.parseColoring(this.getParsingInfo(), fDSParseRecord);
        Particle particle = new Particle(string, type, (Output)object2, (IColoring)object);
        particle.setFYI(fDSParseRecord.getString("FYI", false));
        particle.setStatic(fDSParseRecord.getBoolean("STATIC", true));
        if (particle.getType() == Particle.Type.SOLID) {
            ParticleParser.parseDrag(fDSParseRecord, particle);
            this.d_partsWithSurfs.put(fDSParseRecord, particle);
        }
        if (particle.getType() == Particle.Type.LIQUID) {
            this.d_partsWithSpecs.put(fDSParseRecord, particle);
        }
        ParticleParser.parseSizeDistribution(this.getParsingInfo(), fDSParseRecord, particle);
        this.parseCustomFDSProps(particle, fDSParseRecord);
        int n = this.existsStatus(fDSParseRecord, particle, Particle.class);
        if (n != 0) {
            return this.convertToReturn(n);
        }
        this.getContainer().getPartList().add(particle);
        this.flagObjectAdded(particle);
        ParticleParser.markSingleInputForRetrieval(fDSParseRecord, particle, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    private static IColoring parseColoring(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) {
        if (fDSParseRecord.contains("QUANTITIES")) {
            List list = fDSParseRecord.getList("QUANTITIES", false);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
            for (String string : list) {
                Integer n = ParticleQuantityMap.getPyroVal(string);
                if (n == null) {
                    fDSParsingInfo.addWarning(fDSParseRecord, String.format(Intl.intl("Unknown particle coloring quantity, %s."), string), Intl.intl("Ignoring coloring quantity."));
                    continue;
                }
                arrayList.add(n);
            }
            return new DropletColoring(arrayList);
        }
        Color color = ParticleParser.parseColor(fDSParsingInfo, fDSParseRecord, "RGB", "COLOR", null, false);
        if (color != null) {
            return new ConstColoring(color);
        }
        return null;
    }

    private static void parseSizeDistribution(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, Particle particle) {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DIAMETER", true);
        boolean bl = fDSParseRecord.getBoolean("MONODISPERSE", true);
        if (bl) {
            particle.setConstDistribution(unitDouble);
            return;
        }
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("MINIMUM_DIAMETER", true);
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("MAXIMUM_DIAMETER", true);
        String string = fDSParseRecord.getString("DISTRIBUTION", true);
        if (string.equals("ROSIN-RAMMLER")) {
            double d = fDSParseRecord.getDouble("GAMMA_D", true);
            particle.setRosinRammler(unitDouble, unitDouble2, unitDouble3, d);
        } else if (string.equals("LOGNORMAL")) {
            double d = fDSParseRecord.getDouble("SIGMA_D", false);
            particle.setLognormal(unitDouble, unitDouble2, unitDouble3, d);
        } else if (string.equals("ROSIN-RAMMLER-LOGNORMAL")) {
            double d = fDSParseRecord.getDouble("GAMMA_D", true);
            particle.setRosinRammlerLognormal(unitDouble, unitDouble2, unitDouble3, d);
            if (fDSParseRecord.contains("SIGMA_D")) {
                List<String> list = Arrays.asList(Double.toString(fDSParseRecord.getDouble("SIGMA_D")));
                fDSParseRecord.addUnknownProp("SIGMA_D", list);
            }
        }
    }

    private static void parseDrag(FDSParseRecord fDSParseRecord, Particle particle) {
        if (fDSParseRecord.contains("DRAG_LAW")) {
            String string = fDSParseRecord.getString("DRAG_LAW", true);
            if (string.equals("SPHERE")) {
                particle.setDrag(Particle.Drag.SPHERE);
            } else if (string.equals("CYLINDER")) {
                particle.setDrag(Particle.Drag.CYLINDER);
            } else if (string.equals("SCREEN")) {
                particle.setDrag(Particle.Drag.SCREEN);
            }
        }
        if (fDSParseRecord.contains("DRAG_COEFFICIENT")) {
            particle.setDrag(Particle.Drag.COEF);
            particle.setDragCoef(fDSParseRecord.getDouble("DRAG_COEFFICIENT"));
        }
        if (fDSParseRecord.contains("DENSE_VOLUME_FRACTION")) {
            particle.setDenseVolumeFraction(fDSParseRecord.getDouble("DENSE_VOLUME_FRACTION", true));
        }
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        SurfaceManager surfaceManager = this.getContainer().getSurfaceMgr();
        for (Map.Entry<FDSParseRecord, Particle> entry : this.d_partsWithSurfs.entrySet()) {
            if (!entry.getKey().contains("SURF_ID")) continue;
            ((Particle)entry.getValue()).setSurface((Surface)surfaceManager.get(((FDSParseRecord)entry.getKey()).getString("SURF_ID", true)));
        }
        ExSpecList exSpecList = this.getContainer().getExSpecList();
        for (Map.Entry entry : this.d_partsWithSpecs.entrySet()) {
            if (!((FDSParseRecord)entry.getKey()).contains("SPEC_ID")) continue;
            ExSpec exSpec = exSpecList.get(((FDSParseRecord)entry.getKey()).getString("SPEC_ID", true));
            if (exSpec != null) {
                ((Particle)entry.getValue()).setSpecies(exSpec);
                continue;
            }
            exSpec = ExSpecList.getPredefinedSpecies(((FDSParseRecord)entry.getKey()).getString("SPEC_ID", true));
            if (exSpec != null) {
                ((Particle)entry.getValue()).setSpecies(ExSpecList.getPredefinedSpecies(((FDSParseRecord)entry.getKey()).getString("SPEC_ID", true)));
                continue;
            }
            ((Particle)entry.getValue()).setSpecies(null);
        }
        super.postProcess();
    }

    private static Output parseOutput(FDSParseRecord fDSParseRecord, int n) {
        int n2 = fDSParseRecord.getInteger("SAMPLING_FACTOR", true);
        if (n2 == -1) {
            n2 = n;
        }
        return new Output(fDSParseRecord.getUnitDouble("AGE", true), n2);
    }
}

