/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDSObjParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.SimParamsParser;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class ObstParser
extends AFDSObjParser {
    private final SimParamsParser d_spParser;
    private final PinConnParser d_pinConns;

    public ObstParser(FDS6ParsingInfo fDS6ParsingInfo, PinConnParser pinConnParser, SimParamsParser simParamsParser) {
        super(fDS6ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_spParser = simParamsParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("OBST");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("BNDF_FACE", "UNSUPPORTED");
        map.put("OVERLAY", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = this.generateName(fDSParseRecord, "ID", Intl.intl("Obstruction"));
        AABoxGeom aABoxGeom = ObstParser.parseXBGeom(fDSParseRecord, "OBST", "XB", true);
        Surface[] surfaceArray = this.getSurfs(fDSParseRecord);
        Obstruction obstruction = new Obstruction(string, GeomNodeUtil.newNode(aABoxGeom), surfaceArray);
        Color color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", false);
        if (color == INVISIBLE_COLOR) {
            obstruction.setVisible(false);
            obstruction.setColors(new Color[]{null});
        } else {
            obstruction.setColors(color);
        }
        obstruction.setEvac(this.parseEvac(fDSParseRecord, "EVACUATION", "MESH_ID"));
        this.parseOption(fDSParseRecord, obstruction, 1, "THICKEN");
        this.parseOption(fDSParseRecord, obstruction, 16, "BNDF_OBST");
        obstruction.setOptions(4, fDSParseRecord.getBoolean("PERMIT_HOLE", true));
        obstruction.setOptions(8, fDSParseRecord.getBoolean("ALLOW_VENT", true));
        obstruction.setOptions(32, fDSParseRecord.getBoolean("OUTLINE", true));
        obstruction.setOptions(64, fDSParseRecord.getBoolean("REMOVABLE", true));
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("BULK_DENSITY", true);
        if (unitDouble.getValueNoUnit() > 0.0) {
            obstruction.setBulkDensity(unitDouble);
        }
        TexOrigin texOrigin = ObstParser.parseTexLoc(fDSParseRecord, aABoxGeom.min, "OBST", "TEXTURE_ORIGIN");
        obstruction.setTextureOrigin(texOrigin);
        ObstParser.markSingleInputForRetrieval(fDSParseRecord, obstruction, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        this.parseCustomFDSProps(obstruction, fDSParseRecord);
        Pair<String, List<Obstruction>> pair = this.applyMult(fDSParseRecord, "MULT_ID", obstruction);
        this.addObjects((String)pair.v1, (List)pair.v2);
        return true;
    }

    private void parseOption(FDSParseRecord fDSParseRecord, IObstruction iObstruction, int n, String string) {
        Boolean bl = fDSParseRecord.getBoolean(string, false);
        if (bl == null) {
            boolean bl2 = (this.d_spParser.getObstDefaults() & n) == n;
            iObstruction.setOptions(n, bl2);
        } else {
            iObstruction.setOptions(n, bl);
        }
    }

    private Surface[] getSurfs(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        Predicate<Surface> predicate = Obstruction.getSurfaceFilter();
        Surface[] surfaceArray = null;
        if (fDSParseRecord.contains("SURF_ID")) {
            serializable = this.getSurfaceSafe(fDSParseRecord, fDSParseRecord.getString("SURF_ID", false), predicate);
            surfaceArray = new Surface[]{serializable};
        } else if (fDSParseRecord.contains("SURF_IDS")) {
            serializable = fDSParseRecord.getArray("SURF_IDS", false);
            surfaceArray = new Surface[]{this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(2), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(0), predicate)};
        } else if (fDSParseRecord.contains("SURF_ID6")) {
            serializable = fDSParseRecord.getArray("SURF_ID6", false);
            surfaceArray = new Surface[]{this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(0), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(2), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(3), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(4), predicate), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(5), predicate)};
        } else {
            serializable = this.getDefaultMat();
            surfaceArray = new Surface[]{serializable};
        }
        if (surfaceArray.length > 1 && GeomUtil.isUniform(surfaceArray)) {
            surfaceArray = new Surface[]{surfaceArray[0]};
        }
        if (surfaceArray.length == 1) {
            return surfaceArray;
        }
        serializable = new Surface[]{surfaceArray[0], surfaceArray[1], surfaceArray[2], surfaceArray[3], surfaceArray[4], surfaceArray[5]};
        return serializable;
    }
}

