/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;

public class Multiplier {
    private final String d_id;
    private final UnitPoint3D d_offset;
    private final UnitDouble[] d_sx;
    private final UnitDouble[] d_sy;
    private final UnitDouble[] d_sz;
    private final int[] d_i;
    private final int[] d_j;
    private final int[] d_k;
    private final int[] d_n;

    public Multiplier(String string, UnitPoint3D unitPoint3D, UnitDouble[] unitDoubleArray, UnitDouble[] unitDoubleArray2, UnitDouble[] unitDoubleArray3, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.d_id = string;
        this.d_offset = unitPoint3D;
        this.d_sx = unitDoubleArray;
        this.d_sy = unitDoubleArray2;
        this.d_sz = unitDoubleArray3;
        Multiplier.applySingleScalar(unitDouble, this.d_sx);
        Multiplier.applySingleScalar(unitDouble2, this.d_sy);
        Multiplier.applySingleScalar(unitDouble3, this.d_sz);
        if (nArray4[0] != 0 || nArray4[1] != 0) {
            this.d_n = nArray4;
            this.d_k = null;
            this.d_j = null;
            this.d_i = null;
        } else {
            this.d_i = nArray;
            this.d_j = nArray2;
            this.d_k = nArray3;
            this.d_n = null;
        }
    }

    private static void applySingleScalar(UnitDouble unitDouble, UnitDouble[] unitDoubleArray) {
        if (unitDouble.getValueNoUnit() != 0.0) {
            unitDoubleArray[0] = unitDoubleArray[1] = unitDouble;
        }
    }

    public String getID() {
        return this.d_id;
    }

    public boolean isSequential() {
        return this.d_n != null;
    }

    public int getNumCopies() {
        if (this.isSequential()) {
            return Multiplier.count(this.d_n);
        }
        return Multiplier.count(this.d_i) * Multiplier.count(this.d_j) * Multiplier.count(this.d_k);
    }

    private static int count(int[] nArray) {
        return Math.max(0, nArray[1] - nArray[0] + 1);
    }

    private double[] getScale(UnitDouble[] unitDoubleArray, Unit unit) {
        return new double[]{unitDoubleArray[0].getValue(unit), unitDoubleArray[1].getValue(unit)};
    }

    public <T extends IPyroGeomSrc> Pair<String, List<T>> applyTo(T t) {
        IGeomNode iGeomNode = t.getGeom();
        String string = t instanceof INamed ? ((INamed)((Object)t)).getName() : "";
        int n = this.getNumCopies();
        if (n == 0) {
            return new Pair<String, List<T>>("", Collections.EMPTY_LIST);
        }
        Unit unit = Geometry.LU;
        AABox aABox = iGeomNode.getBoundingBox(new AABox());
        Point3d point3d = this.d_offset.getPoint3dValue(unit);
        double[] dArray = this.getScale(this.d_sx, unit);
        double[] dArray2 = this.getScale(this.d_sy, unit);
        double[] dArray3 = this.getScale(this.d_sz, unit);
        ArrayList arrayList = new ArrayList(n);
        if (this.isSequential()) {
            for (int i = this.d_n[0]; i <= this.d_n[1]; ++i) {
                double d = i;
                ITransform iTransform = Multiplier.createXform(aABox, point3d, dArray, dArray2, dArray3, d, d, d);
                Multiplier.append(arrayList, n, t, iTransform, String.format("[%d]", i));
            }
        } else {
            for (int i = this.d_k[0]; i <= this.d_k[1]; ++i) {
                for (int j = this.d_j[0]; j <= this.d_j[1]; ++j) {
                    for (int k = this.d_i[0]; k <= this.d_i[1]; ++k) {
                        ITransform iTransform = Multiplier.createXform(aABox, point3d, dArray, dArray2, dArray3, k, j, i);
                        Multiplier.append(arrayList, n, t, iTransform, String.format("[%d,%d,%d]", k, j, i));
                    }
                }
            }
        }
        return new Pair<String, List<T>>(string, arrayList);
    }

    private static ITransform createXform(AABox aABox, Point3d point3d, double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double d3) {
        Point3d point3d2 = aABox.getMin();
        ITransform iTransform = TransformUtil.translate(point3d.x + point3d2.x + dArray[0] * d, point3d.y + point3d2.y + dArray2[0] * d2, point3d.z + point3d2.z + dArray3[0] * d3);
        double d4 = aABox.getWidth();
        double d5 = aABox.getDepth();
        double d6 = aABox.getHeight();
        iTransform = iTransform.concatenate(TransformUtil.scale(d4 == 0.0 ? 1.0 : 1.0 + d * (dArray[1] - dArray[0]) / d4, d5 == 0.0 ? 1.0 : 1.0 + d2 * (dArray2[1] - dArray2[0]) / d5, d6 == 0.0 ? 1.0 : 1.0 + d3 * (dArray3[1] - dArray3[0]) / d6));
        iTransform = iTransform.concatenate(TransformUtil.translate(-point3d2.x, -point3d2.y, -point3d2.z));
        return iTransform;
    }

    private static <T extends IPyroGeomSrc> void append(List<T> list, int n, T t, ITransform iTransform, String string) {
        TransformInfo transformInfo = iTransform.getInfo();
        IPyroGeomSrc iPyroGeomSrc = (IPyroGeomSrc)t.clone();
        iPyroGeomSrc.setGeom(iPyroGeomSrc.getGeom().transform(transformInfo));
        if (n > 1 && iPyroGeomSrc instanceof INamed) {
            INamed iNamed = (INamed)((Object)iPyroGeomSrc);
            iNamed.setName(iNamed.getName() + string);
        }
        list.add(iPyroGeomSrc);
    }
}

