/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IHeatBasedValue;
import pyrosim.domain.boundcond.mat.IPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidReaction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class MaterialParser
extends AFDS6Parser {
    private final Map<String, Material> d_matPlaceholderMap;
    private final Map<String, FDSParseRecord> d_placeholderRefMap;
    private final Map<FDSParseRecord, Material> d_parsedMats = new LinkedHashMap<FDSParseRecord, Material>();

    public MaterialParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
        this.d_matPlaceholderMap = new HashMap<String, Material>();
        this.d_placeholderRefMap = new LinkedHashMap<String, FDSParseRecord>();
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("MATL");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("ALLOW_SWELLING", "UNSUPPORTED");
        map.put("ALLOW_SHRINKING", "UNSUPPORTED");
        map.put("GAS_DIFFUSION_DEPTH", "UNSUPPORTED");
        map.put("N_O2", "UNSUPPORTED");
        map.put("PCR", "UNSUPPORTED");
        map.put("REFERENCE_RATE", "UNSUPPORTED");
        map.put("THRESHOLD_SIGN", "UNSUPPORTED");
        map.put("INITIAL_VAPOR_FLUX", "UNSUPPORTED");
    }

    @Override
    public void done() throws FDSRecordFormatException {
        for (Map.Entry<String, FDSParseRecord> entry : this.d_placeholderRefMap.entrySet()) {
            Material material = this.findObject(Material.class, entry.getKey());
            if (material != null) continue;
            throw new FDSRecordFormatException(entry.getValue(), String.format(Intl.intl("Could not find MATL %s."), entry.getKey()));
        }
        for (Map.Entry<Object, Cloneable> entry : this.d_parsedMats.entrySet()) {
            if (((Material)entry.getValue()).hasValidResidues()) continue;
            throw new FDSRecordFormatException((FDSParseRecord)entry.getKey(), Intl.intl("Material contains a residue cycle."));
        }
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string;
        String string2 = this.parseName(fDSParseRecord, "ID", Material.class);
        if (!this.checkName(fDSParseRecord, string2)) {
            return false;
        }
        Material material = this.d_matPlaceholderMap.get(string2);
        if (material == null) {
            material = new Material(string2);
        }
        if ((string = (String)fDSParseRecord.get("FYI")) != null) {
            material.setFYI(string);
        }
        material.setThermalProps(this.getThermalProps(fDSParseRecord));
        this.parseCustomFDSProps(material, fDSParseRecord);
        int n = this.existsStatus(fDSParseRecord, material, Material.class);
        if (n != 0) {
            return this.convertToReturn(n);
        }
        this.getContainer().getMaterialMgr().add(material);
        this.flagObjectAdded(material);
        this.d_parsedMats.put(fDSParseRecord, material);
        return true;
    }

    private ThermalProps getThermalProps(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        IHeatBasedValue iHeatBasedValue = this.getRampableValue(fDSParseRecord, "CONDUCTIVITY", "CONDUCTIVITY_RAMP", RampInputs.HEAT, 19);
        IHeatBasedValue iHeatBasedValue2 = this.getRampableValue(fDSParseRecord, "SPECIFIC_HEAT", "SPECIFIC_HEAT_RAMP", RampInputs.HEAT, 11);
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DENSITY", true);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("ABSORPTION_COEFFICIENT", true);
        double d = fDSParseRecord.getDouble("EMISSIVITY", true);
        return new ThermalProps(iHeatBasedValue, unitDouble, iHeatBasedValue2, d, unitDouble2);
    }

    private IPyrolysis getPyrolysis(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        LiquidPyrolysis liquidPyrolysis = this.getLiquidPyrolysis(fDSParseRecord);
        if (liquidPyrolysis != null) {
            return liquidPyrolysis;
        }
        return this.getSolidPyrolysis(fDSParseRecord);
    }

    private LiquidPyrolysis getLiquidPyrolysis(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        Serializable serializable2;
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("BOILING_TEMPERATURE", false);
        if (unitDouble == null) {
            return null;
        }
        Integer n = fDSParseRecord.getInteger("N_REACTIONS", false);
        if (n != null && n != 1) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Liquid materials must have one reaction."));
        }
        LiquidReaction.Rate rate = new LiquidReaction.Rate(unitDouble);
        List<ReacByproducts> list = this.getReacByproducts(fDSParseRecord, 1);
        if (list.get((int)0).d_heat == null) {
            serializable2 = SIUS.newud(0.0, 46);
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Liquid materials should specify %s."), "HEAT_OF_REACTION"), String.format(Intl.intl("Assuming a %1$s of %2$s."), "HEAT_OF_REACTION", Global.format(serializable2)));
            serializable = list.get(0);
            ReacByproducts reacByproducts = new ReacByproducts((ReacByproducts)serializable);
            list = Arrays.asList(reacByproducts);
        }
        serializable2 = new LiquidReaction(rate, list.get(0));
        serializable = fDSParseRecord.getUnitDouble("HEAT_OF_COMBUSTION", false);
        return new LiquidPyrolysis((UnitDouble)serializable, (LiquidReaction)serializable2);
    }

    private SolidPyrolysis getSolidPyrolysis(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("HEAT_OF_COMBUSTION", true);
        Integer n = fDSParseRecord.getInteger("N_REACTIONS", true);
        List<ReacByproducts> list = this.getReacByproducts(fDSParseRecord, n);
        List<SolidReaction.Rate> list2 = this.getSolidRates(fDSParseRecord, n);
        ArrayList<SolidReaction> arrayList = new ArrayList<SolidReaction>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SolidReaction(list2.get(i), list.get(i)));
        }
        return new SolidPyrolysis(unitDouble, arrayList);
    }

    private List<ReacByproducts> getReacByproducts(FDSParseRecord fDSParseRecord, int n) throws FDSRecordFormatException {
        FDSArray fDSArray = fDSParseRecord.getArray("MATL_ID", false);
        FDSArray fDSArray2 = fDSParseRecord.getArray("SPEC_ID", false);
        ArrayList<ReacByproducts> arrayList = new ArrayList<ReacByproducts>(n);
        List list = fDSParseRecord.getList("HEAT_OF_REACTION", n, true);
        FDSArray fDSArray3 = fDSParseRecord.getArray("NU_MATL", false);
        FDSArray fDSArray4 = fDSParseRecord.getArray("NU_SPEC", false);
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            ArrayList<Material> arrayList2 = new ArrayList<Material>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            for (int j = 0; j < 20; ++j) {
                object2 = (String)fDSArray.get(j, i);
                if (object2 == null) continue;
                Material material = null;
                material = this.getResidueMat(fDSParseRecord, (String)object2);
                object = (Double)fDSArray3.get(j, i);
                if (object == null) {
                    this.addWarning(new FDSParseWarning(fDSParseRecord, String.format(Intl.intl("A material resiude was specified for reaction %d, but no residue fraction was specified."), i), Intl.intl("Skipping byproduct.")));
                    continue;
                }
                arrayList2.add(material);
                arrayList3.add((Double)object);
            }
            ArrayList<ExSpec> arrayList4 = new ArrayList<ExSpec>();
            object2 = new ArrayList();
            for (int j = 0; j < 20; ++j) {
                object = (String)fDSArray2.get(j, i);
                if (object == null) continue;
                ExSpec exSpec = this.getResidueSpec(fDSParseRecord, (String)object);
                if (exSpec == null) {
                    this.addWarning(new FDSParseWarning(fDSParseRecord, String.format(Intl.intl("A reference to the byproduct %s could not be found."), object), Intl.intl("Skipping byproduct.")));
                    continue;
                }
                Double d = (Double)fDSArray4.get(j, i);
                if (d == null) {
                    this.addWarning(new FDSParseWarning(fDSParseRecord, String.format(Intl.intl("A material residue was specified for reaction %d, but no residue fraction was specified."), i), Intl.intl("Skipping byproduct.")));
                    continue;
                }
                arrayList4.add(exSpec);
                object2.add(d);
            }
            arrayList.add(new ReacByproducts(arrayList3, arrayList2, (List<Double>)object2, arrayList4, (UnitDouble)list.get(i)));
        }
        return arrayList;
    }

    private List<SolidReaction.Rate> getSolidRates(FDSParseRecord fDSParseRecord, int n) throws FDSRecordFormatException {
        List list = fDSParseRecord.getList("N_T", n, true);
        List list2 = fDSParseRecord.getList("N_S", n, true);
        List list3 = fDSParseRecord.getList("THRESHOLD_TEMPERATURE", n, true);
        List<SolidReaction.Rate.ISpecification> list4 = this.getSolidRateSpecs(fDSParseRecord, n);
        ArrayList<SolidReaction.Rate> arrayList = new ArrayList<SolidReaction.Rate>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SolidReaction.Rate((Double)list2.get(i), (Double)list.get(i), (UnitDouble)list3.get(i), list4.get(i)));
        }
        return arrayList;
    }

    private List<SolidReaction.Rate.ISpecification> getSolidRateSpecs(FDSParseRecord fDSParseRecord, int n) throws FDSRecordFormatException {
        ArrayList<SolidReaction.Rate.ISpecification> arrayList = new ArrayList<SolidReaction.Rate.ISpecification>(n);
        List list = fDSParseRecord.getList("A", n, true);
        List list2 = fDSParseRecord.getList("E", n, false);
        List list3 = fDSParseRecord.getList("REFERENCE_TEMPERATURE", n, false);
        List list4 = fDSParseRecord.getList("HEATING_RATE", n, true);
        List list5 = fDSParseRecord.getList("PYROLYSIS_RANGE", n, true);
        for (int i = 0; i < n; ++i) {
            UnitDouble unitDouble = (UnitDouble)list2.get(i);
            if (unitDouble != null) {
                arrayList.add(new SolidReaction.Rate.AESpec((UnitDouble)list.get(i), unitDouble));
                continue;
            }
            UnitDouble unitDouble2 = (UnitDouble)list3.get(i);
            if (unitDouble2 != null) {
                arrayList.add(new SolidReaction.Rate.RefSpec(unitDouble2, (UnitDouble)list5.get(i), (UnitDouble)list4.get(i)));
                continue;
            }
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Material is missing A and E parameters for reaction %d."), i + 1));
        }
        return arrayList;
    }

    private Material getResidueMat(FDSParseRecord fDSParseRecord, String string) {
        Material material = this.findObject(Material.class, string);
        if (material == null) {
            material = new Material(string);
            this.d_matPlaceholderMap.put(string, material);
            this.d_placeholderRefMap.put(string, fDSParseRecord);
        }
        return material;
    }

    private ExSpec getResidueSpec(FDSParseRecord fDSParseRecord, String string) {
        ExSpec exSpec = this.getContainer().getExSpecList().get(string);
        return exSpec;
    }

    private IHeatBasedValue getRampableValue(FDSParseRecord fDSParseRecord, String string, String string2, IRampInput iRampInput, int n) throws FDSRecordFormatException {
        IHeatBasedValue iHeatBasedValue;
        String string3 = fDSParseRecord.getString(string2);
        if (string3 != null) {
            Ramp ramp = this.getParsingInfo().getRamp(string3, iRampInput, n, true);
            if (ramp == null) {
                throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Invalid ramp specified."));
            }
            iHeatBasedValue = new IHeatBasedValue.Custom(ramp);
        } else {
            UnitDouble unitDouble = fDSParseRecord.getUnitDouble(string, true);
            iHeatBasedValue = unitDouble != null ? new IHeatBasedValue.Constant(unitDouble) : null;
        }
        return iHeatBasedValue;
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        for (Map.Entry<FDSParseRecord, Material> entry : this.d_parsedMats.entrySet()) {
            entry.getValue().setPyrolysis(this.getPyrolysis(entry.getKey()));
        }
        super.postProcess();
    }
}

