/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class IsofParser
extends AFDS6Parser {
    public IsofParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("ISOF");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("REDUCE_TRIANGLES", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", null, "SPEC_ID", null, null, null, 32, Intl.intl("ISOF ignored"), true, false);
        if (iQuantity == null) {
            return false;
        }
        Unit unit = SIUS.unit(iQuantity.get().unitType);
        List<UnitDouble> list = fDSParseRecord.getUnitDoubleList("VALUE", unit, false);
        if (list == null) {
            this.addWarning(fDSParseRecord, Intl.intl("No values specified for ISOF record."), Intl.intl("ISOF record ignored"));
            return false;
        }
        Isosurface isosurface = this.getContainer().getIsofList().getIso(iQuantity);
        if (isosurface == null) {
            isosurface = new Isosurface(iQuantity, list);
            this.getContainer().getIsofList().add(isosurface);
        } else {
            list.addAll(isosurface.getContours());
            isosurface.setContours(list);
        }
        if (iQuantity.get().equals((Object)Quantity.VELOCITY)) {
            int n = fDSParseRecord.getInteger("VELO_INDEX", true);
            VelocitySign velocitySign = this.parseVelocitySign(fDSParseRecord, n);
            isosurface.setVelocitySign(velocitySign);
        }
        this.flagObjectAdded(isosurface);
        return true;
    }
}

