/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.tasks.FillGridsWithPartsTask;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDSObjParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;

public class InitParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;

    public InitParser(FDS6ParsingInfo fDS6ParsingInfo, PinConnParser pinConnParser) {
        super(fDS6ParsingInfo);
        this.d_pinConns = pinConnParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("INIT");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("DIAMETER", "UNSUPPORTED");
        map.put("HEIGHT", "UNSUPPORTED");
        map.put("HRRPUV", "UNSUPPORTED");
        map.put("PARTICLE_WEIGHT_FACTOR", "UNSUPPORTED");
        map.put("RADIUS", "UNSUPPORTED");
        map.put("SHAPE", "UNSUPPORTED");
        map.put("UVW", "UNSUPPORTED");
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DENSITY");
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("TEMPERATURE");
        boolean bl = fDSParseRecord.contains("MASS_FRACTION") || fDSParseRecord.contains("VOLUME_FRACTION");
        String string = fDSParseRecord.getString("PART_ID");
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        if (unitDouble != null || unitDouble2 != null || bl) {
            arrayList.addAll(this.processAsInitRegion(fDSParseRecord));
        }
        if (string != null) {
            arrayList.addAll(this.processAsPartCloud(fDSParseRecord));
        }
        if (arrayList.isEmpty()) {
            this.addWarning(fDSParseRecord, Intl.intl("Could not extract any data from INIT record."), Intl.intl("Adding INIT record to <b>Additional Records</b>."));
            return false;
        }
        for (PartCloud iCustomFDSPropsContainer : Hierarchy.flatten(arrayList, PartCloud.class)) {
            if (!(iCustomFDSPropsContainer.getInsertion() instanceof PartCloud.InsertPeriodically)) continue;
            InitParser.markSingleInputForRetrieval(fDSParseRecord, iCustomFDSPropsContainer, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        }
        for (ICustomFDSPropsContainer iCustomFDSPropsContainer : Hierarchy.flatten(arrayList, ICustomFDSPropsContainer.class)) {
            this.parseCustomFDSProps(iCustomFDSPropsContainer, fDSParseRecord);
        }
        return true;
    }

    protected Collection<? extends IPyroObject> processAsInitRegion(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        LinkedIdentityHashMap<ExSpec, UnitDouble> linkedIdentityHashMap;
        Object object2;
        Cloneable cloneable;
        AABoxGeom aABoxGeom;
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DENSITY");
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("TEMPERATURE");
        List list = fDSParseRecord.getList("SPEC_ID", false);
        String string = fDSParseRecord.getString("ID");
        if (string == null || string.isEmpty()) {
            string = fDSParseRecord.getComment().trim();
        }
        if (string == null || string.isEmpty()) {
            string = Intl.intl("Init Region");
        }
        if ((aABoxGeom = InitParser.parseXBGeom(fDSParseRecord, "INIT", "XB", false)) == null) {
            cloneable = new AABox();
            for (Object object2 : this.getParsingInfo().getContainer().getGridManager().flatten()) {
                ((AABox)cloneable).add(object2.getBounds());
            }
            aABoxGeom = new AABoxGeom((AABox)cloneable);
        }
        cloneable = new InitRegion(string, aABoxGeom);
        ((InitRegion)cloneable).setDensity(unitDouble);
        ((InitRegion)cloneable).setTemperature(unitDouble2);
        List list2 = null;
        object2 = null;
        if (fDSParseRecord.contains("MASS_FRACTION")) {
            list2 = fDSParseRecord.getList("MASS_FRACTION", false);
            object2 = InitRegion.SpecFractionType.MASS_FRACTION;
        }
        if (fDSParseRecord.contains("VOLUME_FRACTION")) {
            list2 = fDSParseRecord.getList("VOLUME_FRACTION", false);
            object2 = InitRegion.SpecFractionType.VOLUME_FRACTION;
        }
        if (list2 != null) {
            linkedIdentityHashMap = new LinkedIdentityHashMap(list2.size());
            for (int i = 0; i < list2.size(); ++i) {
                UnitDouble unitDouble3 = (UnitDouble)list2.get(i);
                if (unitDouble3 == null || unitDouble3.getValueNoUnit() == 0.0) continue;
                ExSpec exSpec = this.getContainer().getExSpecList().get((String)list.get(i));
                if (exSpec == null) {
                    String string2 = String.format(Intl.intl("Species %d could not be found."), i + 1);
                    String string3 = String.format(Intl.intl("Ignoring species %d."), i + 1);
                    this.addWarning(fDSParseRecord, string2, string3);
                    continue;
                }
                linkedIdentityHashMap.put(exSpec, unitDouble3);
            }
            ((InitRegion)cloneable).setExtraSpecies(linkedIdentityHashMap, (InitRegion.SpecFractionType)((Object)object2));
        }
        linkedIdentityHashMap = this.applyMult(fDSParseRecord, "MULT_ID", cloneable);
        this.addObjects((String)((Pair)((Object)linkedIdentityHashMap)).v1, (List)((Pair)((Object)linkedIdentityHashMap)).v2);
        return (Collection)((Pair)((Object)linkedIdentityHashMap)).v2;
    }

    protected Collection<? extends IPyroObject> processAsPartCloud(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = fDSParseRecord.getString("PART_ID");
        Particle particle = this.findParticle(fDSParseRecord, string);
        if (particle == null) {
            return Collections.EMPTY_LIST;
        }
        PartCloud.IDropletCount iDropletCount = this.parseParticleCount(fDSParseRecord);
        if (iDropletCount == null) {
            String string2 = Intl.intl("No particle count is specified.");
            String string3 = Intl.intl("Ignoring INIT particles.");
            this.addWarning(fDSParseRecord, string2, string3);
            return Collections.EMPTY_LIST;
        }
        String string4 = fDSParseRecord.getString("ID");
        if (string4 == null || string4.isEmpty()) {
            string4 = fDSParseRecord.getComment().trim();
        }
        if (string4 == null || string4.isEmpty()) {
            string4 = string;
        }
        IGeom iGeom = this.parseParticleGeom(fDSParseRecord);
        PartCloud.IInsertion iInsertion = this.parseInsertion(fDSParseRecord, iGeom);
        List<Pair<IGeom, PartCloud.IDropletCount>> list = this.parseParticleTransform(fDSParseRecord, iGeom, iDropletCount);
        if (!list.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            for (Pair<IGeom, PartCloud.IDropletCount> pair : list) {
                PartCloud partCloud = new PartCloud(string4, particle, (IGeom)pair.v1);
                partCloud.setInsertion(iInsertion);
                partCloud.setInitDrops((PartCloud.IDropletCount)pair.v2);
                Pair<String, List<PartCloud>> pair2 = this.applyMult(fDSParseRecord, "MULT_ID", partCloud);
                this.addObjects((String)pair2.v1, (List)pair2.v2);
                arrayList.addAll((Collection)pair2.v2);
            }
            return arrayList;
        }
        FillGridsWithPartsTask fillGridsWithPartsTask = new FillGridsWithPartsTask(this.getContainer(), string4, this.getContainer().getGridManager().flatten(), particle, iDropletCount, iInsertion, false);
        fillGridsWithPartsTask.run();
        this.flagObjectsAdded(fillGridsWithPartsTask.getAddedObjects());
        return fillGridsWithPartsTask.getAddedObjects();
    }

    private PartCloud.IDropletCount parseParticleCount(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (fDSParseRecord.contains("N_PARTICLES") && fDSParseRecord.getInteger("N_PARTICLES", true) != 0 && fDSParseRecord.contains("N_PARTICLES_PER_CELL") && fDSParseRecord.getInteger("N_PARTICLES_PER_CELL", true) != 0) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Only %1$s or %2$s should be specified"), "N_PARTICLES", "N_PARTICLES_PER_CELL"), String.format(Intl.intl("Ignoring %s"), "N_PARTICLES_PER_CELL"));
        }
        if (fDSParseRecord.getInteger("N_PARTICLES", true) != 0) {
            return new PartCloud.ConstDropletCount(fDSParseRecord.getInteger("N_PARTICLES", true));
        }
        if (fDSParseRecord.getInteger("N_PARTICLES_PER_CELL", true) != 0) {
            boolean bl = fDSParseRecord.getBoolean("CELL_CENTERED", true);
            return new PartCloud.PerCellCount(fDSParseRecord.getInteger("N_PARTICLES_PER_CELL", true), bl);
        }
        return null;
    }

    protected Particle findParticle(FDSParseRecord fDSParseRecord, String string) {
        if (string == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Missing PART_ID for INIT particles."), Intl.intl("Ignoring INIT particles."));
            return null;
        }
        Particle particle = this.findObject(Particle.class, string);
        if (particle == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find particle, %s, for INIT particles."), string), Intl.intl("Ignoring INIT particles."));
            return null;
        }
        return particle;
    }

    protected PartCloud.IInsertion parseInsertion(FDSParseRecord fDSParseRecord, IGeom iGeom) {
        boolean bl;
        UnitDouble unitDouble;
        if (fDSParseRecord.contains("MASS_PER_VOLUME") && iGeom instanceof Point) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s cannot be used when there is no volume."), "MASS_PER_VOLUME"), String.format(Intl.intl("Ignoring %s"), "MASS_PER_VOLUME"));
        }
        if ((unitDouble = fDSParseRecord.getUnitDouble("MASS_PER_VOLUME", bl = !fDSParseRecord.contains("DT_INSERT"))) != null) {
            return new PartCloud.InsertOnce(unitDouble);
        }
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("DT_INSERT");
        assert (unitDouble2 != null);
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("MASS_PER_TIME", true);
        return new PartCloud.InsertPeriodically(unitDouble2, unitDouble3);
    }

    protected IGeom parseParticleGeom(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (fDSParseRecord.contains("XB") && fDSParseRecord.contains("XYZ")) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Only %1$s or %2$s should be specified."), "XB", "XYZ"), String.format(Intl.intl("Ignoring %s."), "XB"));
        }
        if (fDSParseRecord.contains("XYZ")) {
            UnitPoint3D unitPoint3D = InitParser.parseLoc(fDSParseRecord, "INIT", "XYZ", true);
            return new Point(unitPoint3D.getPoint3dValue(Geometry.LU));
        }
        if (fDSParseRecord.contains("XB")) {
            return InitParser.parseXBGeom(fDSParseRecord, fDSParseRecord.getType(), "XB", true);
        }
        return null;
    }

    protected List<Pair<IGeom, PartCloud.IDropletCount>> parseParticleTransform(FDSParseRecord fDSParseRecord, IGeom iGeom, PartCloud.IDropletCount iDropletCount) throws FDSRecordFormatException {
        if (iGeom instanceof Point) {
            Point point = (Point)iGeom;
            ArrayList<Pair<IGeom, PartCloud.IDropletCount>> arrayList = new ArrayList<Pair<IGeom, PartCloud.IDropletCount>>();
            int n = iDropletCount.getNumDrops(null);
            double d = fDSParseRecord.getUnitDouble("DX", true).get(Geometry.LU);
            double d2 = fDSParseRecord.getUnitDouble("DY", true).get(Geometry.LU);
            double d3 = fDSParseRecord.getUnitDouble("DZ", true).get(Geometry.LU);
            if (n > 1 && (d != 0.0 || d2 != 0.0 || d3 != 0.0)) {
                for (int i = 0; i < n; ++i) {
                    Point3d point3d = new Point3d(point.loc.x + d * (double)i, point.loc.y + d2 * (double)i, point.loc.z + d3 * (double)i);
                    arrayList.add(new Pair<Point, PartCloud.ConstDropletCount>(new Point(point3d), new PartCloud.ConstDropletCount(1)));
                }
            } else {
                arrayList.add(new Pair<IGeom, PartCloud.IDropletCount>(iGeom, iDropletCount));
            }
            return arrayList;
        }
        if (iGeom != null) {
            if (fDSParseRecord.contains("DX") || fDSParseRecord.contains("DY") || fDSParseRecord.contains("DZ")) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%1$s, %2$s, and %3$s may only be specified with %4$s."), "DX", "DY", "DZ", "XYZ"), Intl.intl("Ignoring offset parameters."));
            }
            return Arrays.asList(new Pair<IGeom, PartCloud.IDropletCount>(iGeom, iDropletCount));
        }
        return Collections.EMPTY_LIST;
    }
}

