/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.AHvacGeomComponent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.VentParser;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.TriConsumer;

public class HvacParser
extends AFDS6Parser {
    private Map<FDSParseRecord, HvacAircoil> d_aircoilMap = new LinkedHashMap<FDSParseRecord, HvacAircoil>();
    private Map<FDSParseRecord, HvacDuct> d_ductMap = new LinkedHashMap<FDSParseRecord, HvacDuct>();
    private Map<FDSParseRecord, HvacFan> d_fanMap = new LinkedHashMap<FDSParseRecord, HvacFan>();
    private Map<FDSParseRecord, HvacFilter> d_filterMap = new LinkedHashMap<FDSParseRecord, HvacFilter>();
    private Map<FDSParseRecord, HvacNode> d_nodeMap = new LinkedHashMap<FDSParseRecord, HvacNode>();
    private Map<FDSParseRecord, HvacNode> d_nodesWithVents = new LinkedHashMap<FDSParseRecord, HvacNode>();
    private Map<FDSParseRecord, HvacLeak> d_leakMap = new LinkedHashMap<FDSParseRecord, HvacLeak>();
    private PinConnParser d_pinConns;
    private VentParser d_ventParser;

    public HvacParser(FDS6ParsingInfo fDS6ParsingInfo, PinConnParser pinConnParser, VentParser ventParser) {
        super(fDS6ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_ventParser = ventParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("HVAC");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("MASS_FLOW", "UNSUPPORTED");
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        HvacComponent hvacComponent;
        Object object;
        if (!fDSParseRecord.contains("TYPE_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Type ID missing"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        String string = fDSParseRecord.getString("TYPE_ID");
        if (string.equals("AIRCOIL")) {
            object = this.parseName(fDSParseRecord, "ID", HvacAircoil.class, 1);
            hvacComponent = new HvacAircoil((String)object);
            this.d_aircoilMap.put(fDSParseRecord, (HvacAircoil)hvacComponent);
            if (!this.parseAircoil(fDSParseRecord, (HvacAircoil)hvacComponent)) {
                return false;
            }
        } else if (string.equals("DUCT")) {
            object = this.parseName(fDSParseRecord, "ID", HvacDuct.class, 0);
            hvacComponent = new HvacDuct((String)object);
            this.d_ductMap.put(fDSParseRecord, (HvacDuct)hvacComponent);
            if (!this.parseDuct(fDSParseRecord, (HvacDuct)hvacComponent)) {
                return false;
            }
        } else if (string.equals("FAN")) {
            object = this.parseName(fDSParseRecord, "ID", HvacFan.class, 1);
            hvacComponent = new HvacFan((String)object);
            this.d_fanMap.put(fDSParseRecord, (HvacFan)hvacComponent);
            if (!this.parseFan(fDSParseRecord, (HvacFan)hvacComponent)) {
                return false;
            }
        } else if (string.equals("FILTER")) {
            object = this.parseName(fDSParseRecord, "ID", HvacFilter.class, 1);
            hvacComponent = new HvacFilter((String)object);
            this.d_filterMap.put(fDSParseRecord, (HvacFilter)hvacComponent);
            if (!this.parseFilter(fDSParseRecord, (HvacFilter)hvacComponent)) {
                return false;
            }
        } else if (string.equals("NODE")) {
            object = this.parseName(fDSParseRecord, "ID", HvacNode.class, 1);
            hvacComponent = new HvacNode((String)object);
            this.d_nodeMap.put(fDSParseRecord, (HvacNode)hvacComponent);
            if (!this.parseNode(fDSParseRecord, (HvacNode)hvacComponent)) {
                return false;
            }
        } else if (string.equals("LEAK")) {
            object = this.parseName(fDSParseRecord, "ID", HvacLeak.class, 1);
            hvacComponent = new HvacLeak((String)object);
            if (!this.parseLeak(fDSParseRecord, (HvacLeak)hvacComponent)) {
                return false;
            }
            this.d_leakMap.put(fDSParseRecord, (HvacLeak)hvacComponent);
        } else {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Invalid type"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (hvacComponent instanceof ICustomFDSPropsContainer) {
            this.parseCustomFDSProps(hvacComponent, fDSParseRecord);
        }
        if (hvacComponent instanceof IModelObj) {
            object = this.getContainer().getObstructions();
            Composite composite = ((Composite)object).find(Intl.intl("HVAC"), Composite.class, false);
            if (composite == null) {
                composite = ((Composite)object).newGroup(Intl.intl("HVAC"));
                ((Composite)object).add(composite);
                this.flagObjectAdded(composite);
            }
            composite.add(hvacComponent);
        } else {
            assert (hvacComponent instanceof IHvacObject);
            this.getContainer().getHvacList().add(hvacComponent);
        }
        this.flagObjectAdded(hvacComponent);
        return true;
    }

    private boolean parseLeak(FDSParseRecord fDSParseRecord, HvacLeak hvacLeak) {
        UnitDouble unitDouble;
        if (fDSParseRecord.contains("AREA")) {
            hvacLeak.setLeakArea(fDSParseRecord.getUnitDouble("AREA"));
        }
        if (fDSParseRecord.contains("LOSS") && (unitDouble = (UnitDouble)((FDSArray)fDSParseRecord.get("LOSS")).get(0, 0)) != null) {
            hvacLeak.setProp("LOSS", Arrays.asList(unitDouble));
        }
        hvacLeak.setEnthalpy(fDSParseRecord.getBoolean("LEAK_ENTHALPY", true));
        return true;
    }

    private boolean parseAircoil(FDSParseRecord fDSParseRecord, HvacAircoil hvacAircoil) {
        Object object;
        int n = 0;
        if (fDSParseRecord.contains("COOLANT_SPECIFIC_HEAT")) {
            hvacAircoil.setProp("COOLANT_SPECIFIC_HEAT", fDSParseRecord.getUnitDouble("COOLANT_SPECIFIC_HEAT"));
            ++n;
        }
        if (fDSParseRecord.contains("COOLANT_MASS_FLOW")) {
            hvacAircoil.setProp("COOLANT_MASS_FLOW", fDSParseRecord.getUnitDouble("COOLANT_MASS_FLOW"));
            ++n;
        }
        if (fDSParseRecord.contains("COOLANT_TEMPERATURE")) {
            hvacAircoil.setProp("COOLANT_TEMPERATURE", fDSParseRecord.getUnitDouble("COOLANT_TEMPERATURE"));
            ++n;
        }
        if (fDSParseRecord.contains("EFFICIENCY") && (object = fDSParseRecord.getList("EFFICIENCY", false)).size() > 0 && object.get(0) != null) {
            hvacAircoil.setProp("EFFICIENCY", object.get(0));
            ++n;
        }
        if (n > 0 && n < 4) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: COOLANT_CP, COOLANT_MDOT, COOLANT_TEMPERATURE, and EFFICIENTY must be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (n > 0 && fDSParseRecord.contains("FIXED_Q")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Only one of FIXED_Q and COOLANT properies may be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (n == 4) {
            hvacAircoil.setProp("opt_aircoil_model", (Object)HvacAircoil.Model.COOLANT);
            return true;
        }
        if (fDSParseRecord.contains("FIXED_Q")) {
            hvacAircoil.setProp("opt_aircoil_model", (Object)HvacAircoil.Model.FIXEDQ);
            object = fDSParseRecord.getUnitDouble("FIXED_Q");
            TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_AC", "RAMP_ID");
            hvacAircoil.setFixedQ(new TimeBasedValue<Object>(object, timeFunction));
        }
        if (fDSParseRecord.contains("CTRL_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("CTRL_ID invalid for HVAC Aircoil components"), String.format(Intl.intl("CTRL_ID dropped from aircoil %s."), hvacAircoil.getName()));
        }
        if (fDSParseRecord.contains("DEVC_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("DEVC_ID invalid for HVAC Aircoil components"), String.format(Intl.intl("DEVC_ID dropped from aircoil %s."), hvacAircoil.getName()));
        }
        return true;
    }

    private boolean parseDuct(FDSParseRecord fDSParseRecord, HvacDuct hvacDuct) {
        Object object;
        HvacDuct hvacDuct2 = hvacDuct;
        if (!this.parseDuctShape(fDSParseRecord, hvacDuct2)) {
            return false;
        }
        if (!this.parseDuctAirflowObj(fDSParseRecord, hvacDuct2)) {
            return false;
        }
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("LENGTH", true);
        hvacDuct.setProp("LENGTH", unitDouble);
        if (fDSParseRecord.contains("LOSS")) {
            object = (FDSArray)fDSParseRecord.get("LOSS");
            UnitDouble unitDouble2 = (UnitDouble)((FDSArray)object).get(0, 0);
            UnitDouble unitDouble3 = (UnitDouble)((FDSArray)object).get(1, 0);
            if (unitDouble2 != null && unitDouble3 != null) {
                hvacDuct.setProp("LOSS", Arrays.asList(unitDouble2, unitDouble3));
            } else if (unitDouble2 != null && unitDouble3 == null) {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: DUCT LOSS is a pair of real numbers."), Intl.intl("Using first entry for both values."));
                hvacDuct.setProp("LOSS", Arrays.asList(unitDouble2, new UnitDouble(unitDouble2.getValueNoUnit(), unitDouble2.getUnit())));
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: DUCT LOSS is a pair of real numbers."), Intl.intl("Using default values."));
            }
        }
        if (fDSParseRecord.contains("NODE_ID")) {
            object = fDSParseRecord.getList("NODE_ID", false);
            hvacDuct.d_n1 = (String)object.get(0);
            hvacDuct.d_n2 = (String)object.get(1);
        }
        if (fDSParseRecord.contains("REVERSE")) {
            hvacDuct.setProp("REVERSE", fDSParseRecord.getBoolean("REVERSE"));
        }
        if ((object = fDSParseRecord.getUnitDouble("ROUGHNESS", false)) == null) {
            hvacDuct.setProp("opt_friction_type", (Object)HvacDuct.FrictionType.NO_FRICTION);
        } else if (((UnitDouble)object).getValueNoUnit() > 0.0) {
            hvacDuct.setProp("opt_friction_type", (Object)HvacDuct.FrictionType.EXPLICIT);
            hvacDuct.setProp("ROUGHNESS", object);
        } else {
            hvacDuct.setProp("opt_friction_type", (Object)HvacDuct.FrictionType.COMPUTED_FRICTION);
        }
        HvacParser.markSingleInputForRetrieval(fDSParseRecord, hvacDuct, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    private boolean parseDuctShape(FDSParseRecord fDSParseRecord, HvacDuct hvacDuct) {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DIAMETER");
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("AREA");
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("PERIMETER");
        if (unitDouble == null && unitDouble2 == null && unitDouble3 == null) {
            String string = String.format(Intl.intl("Unable to process HVAC duct: %1$s or %2$s must be specified, and %3$s can optionally be specified."), "DIAMETER", "AREA", "PERIMETER");
            this.addWarning(fDSParseRecord, string, Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (unitDouble != null) {
            if (unitDouble3 != null) {
                String string = String.format(Intl.intl("Unable to process HVAC duct: %1$s and %2$s cannot both be specified."), "DIAMETER", "PERIMETER");
                this.addWarning(fDSParseRecord, string, Intl.intl("HVAC Record Ignored"));
                return false;
            }
            hvacDuct.setProp("opt_shape", (Object)HvacDuct.Shape.CIRCULAR);
            hvacDuct.setProp("DIAMETER", unitDouble);
            return true;
        }
        if (unitDouble2 != null) {
            if (unitDouble3 != null) {
                hvacDuct.setProp("opt_shape", (Object)HvacDuct.Shape.NON_CIRCULAR);
                hvacDuct.setProp("AREA", unitDouble2);
                hvacDuct.setProp("PERIMETER", unitDouble3);
            } else {
                hvacDuct.setProp("opt_shape", (Object)HvacDuct.Shape.CIRCULAR);
                double d = unitDouble2.getValue(SI.METER.pow(2));
                double d2 = 2.0 * Math.sqrt(d / Math.PI);
                hvacDuct.setProp("DIAMETER", new UnitDouble(d2, SI.METER));
            }
            return true;
        }
        assert (unitDouble3 != null);
        String string = String.format(Intl.intl("Unable to process HVAC duct: Cannot specify %1$s without %2$s."), "PERIMETER", "AREA");
        this.addWarning(fDSParseRecord, string, Intl.intl("HVAC Record Ignored"));
        return false;
    }

    private boolean parseDuctAirflowObj(FDSParseRecord fDSParseRecord, HvacDuct hvacDuct) {
        HvacDuct.AirflowObj airflowObj = HvacDuct.AirflowObj.NONE;
        if (fDSParseRecord.contains("DAMPER") && fDSParseRecord.contains("FAN_ID") && fDSParseRecord.contains("AIRCOIL_ID") && fDSParseRecord.contains("VOLUME_FLOW")) {
            String string = String.format(Intl.intl("Unable to process HVAC record: Only one of %1$s, %2$s, %3$s, or %4$s, may be specified."), "DAMPER", "FAN_ID", "AIRCOIL_ID", "VOLUME_FLOW");
            this.addWarning(fDSParseRecord, string, Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (fDSParseRecord.contains("DAMPER")) {
            airflowObj = HvacDuct.AirflowObj.DAMPER;
        } else if (fDSParseRecord.contains("FAN_ID")) {
            airflowObj = HvacDuct.AirflowObj.FAN;
            hvacDuct.setProp("FAN_ID", fDSParseRecord.getString("FAN_ID"));
        } else if (fDSParseRecord.contains("AIRCOIL_ID")) {
            airflowObj = HvacDuct.AirflowObj.AIRCOIL;
            hvacDuct.setProp("AIRCOIL_ID", fDSParseRecord.getString("AIRCOIL_ID"));
        } else if (fDSParseRecord.contains("VOLUME_FLOW")) {
            airflowObj = HvacDuct.AirflowObj.VOLFLOW;
            UnitDouble unitDouble = fDSParseRecord.getUnitDouble("VOLUME_FLOW");
            TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_VF", "RAMP_ID");
            hvacDuct.setVolflow(new TimeBasedValue<UnitDouble>(unitDouble, timeFunction));
        }
        hvacDuct.setProp("opt_none_damper_fan", (Object)airflowObj);
        return true;
    }

    private boolean parseFan(FDSParseRecord fDSParseRecord, HvacFan hvacFan) {
        Serializable serializable;
        if (fDSParseRecord.contains("TAU_FAN")) {
            hvacFan.setProp("TAU_FAN", fDSParseRecord.getUnitDouble("TAU_FAN"));
            hvacFan.setTauFunc(AFDS6Parser.parseTCurve(fDSParseRecord, "TAU_FAN"));
        }
        if (fDSParseRecord.contains("LOSS")) {
            FDSArray fDSArray = (FDSArray)fDSParseRecord.get("LOSS");
            serializable = (UnitDouble)fDSArray.get(0, 0);
            if (serializable != null) {
                hvacFan.setProp("LOSS", Arrays.asList(serializable));
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: FAN LOSS"), Intl.intl("Using default."));
            }
        }
        int n = 0;
        if (fDSParseRecord.contains("VOLUME_FLOW")) {
            hvacFan.setProp("VOLUME_FLOW", fDSParseRecord.getUnitDouble("VOLUME_FLOW"));
            hvacFan.setProp("opt_fan_model", HvacFan.FAN_MODEL_VOLFLOW);
            ++n;
        }
        if (fDSParseRecord.contains("MAX_FLOW") && fDSParseRecord.contains("MAX_PRESSURE")) {
            hvacFan.setProp("MAX_FLOW", fDSParseRecord.getUnitDouble("MAX_FLOW"));
            hvacFan.setProp("MAX_PRESSURE", fDSParseRecord.getUnitDouble("MAX_PRESSURE"));
            hvacFan.setProp("opt_fan_model", HvacFan.FAN_MODEL_QUADRATIC);
            ++n;
        }
        if (fDSParseRecord.contains("RAMP_ID")) {
            serializable = this.getParsingInfo().getRamp(fDSParseRecord.getString("RAMP_ID"), RampInputs.PRESSURE, 24, true);
            hvacFan.setPressureFlow(Variant.ramp((Ramp)serializable));
            hvacFan.setProp("RAMP_ID", fDSParseRecord.getString("RAMP_ID"));
            hvacFan.setProp("opt_fan_model", HvacFan.FAN_MODEL_PRESDROP);
            ++n;
        }
        if (n > 1) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC FAN record: Only one of VOLUME_FLOW, MAX_FLOW + MAX_PRESSURE, and RAMP_ID can be defined"), Intl.intl("HVAC Record ignored."));
            return false;
        }
        if (fDSParseRecord.contains("CTRL_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("CTRL_ID invalid for HVAC Aircoil components"), String.format(Intl.intl("CTRL_ID dropped from aircoil %s."), hvacFan.getName()));
        }
        if (fDSParseRecord.contains("DEVC_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("DEVC_ID invalid for HVAC Aircoil components"), String.format(Intl.intl("DEVC_ID dropped from aircoil %s."), hvacFan.getName()));
        }
        return true;
    }

    private boolean parseFilter(FDSParseRecord fDSParseRecord, HvacFilter hvacFilter) {
        if (fDSParseRecord.contains("CLEAN_LOSS")) {
            hvacFilter.setProp("CLEAN_LOSS", fDSParseRecord.getUnitDouble("CLEAN_LOSS"));
        }
        if (fDSParseRecord.contains("EFFICIENCY")) {
            hvacFilter.setProp("EFFICIENCY", fDSParseRecord.getList("EFFICIENCY", false));
        }
        if (fDSParseRecord.contains("LOADING")) {
            hvacFilter.setProp("LOADING", fDSParseRecord.getList("LOADING", false));
        }
        if (fDSParseRecord.contains("LOADING_MULTIPLIER")) {
            hvacFilter.setProp("LOADING_MULTIPLIER", fDSParseRecord.getList("LOADING_MULTIPLIER", false));
        }
        if (fDSParseRecord.contains("SPEC_ID")) {
            hvacFilter.setProp("SPEC_ID", fDSParseRecord.getList("SPEC_ID", false));
        }
        if (fDSParseRecord.contains("LOSS") && fDSParseRecord.contains("RAMP_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Only one of LOSS and RAMP_ID may be specified"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (fDSParseRecord.contains("LOSS")) {
            hvacFilter.setProp("opt_loss_ramp", (Object)HvacFilter.LossModel.LINEAR);
            FDSArray fDSArray = (FDSArray)fDSParseRecord.get("LOSS");
            UnitDouble unitDouble = (UnitDouble)fDSArray.get(0, 0);
            if (unitDouble != null) {
                hvacFilter.setProp("LOSS", Arrays.asList(unitDouble));
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: FILTER LOSS"), Intl.intl("Using default."));
            }
        } else if (fDSParseRecord.contains("RAMP_ID")) {
            hvacFilter.setProp("opt_loss_ramp", (Object)HvacFilter.LossModel.CUSTOM);
            Ramp ramp = this.getParsingInfo().getRamp(fDSParseRecord.getString("RAMP_ID"), RampInputs.MASS, 28, true);
            hvacFilter.setCustomLoss(Variant.ramp(ramp));
        }
        return true;
    }

    private boolean parseNode(FDSParseRecord fDSParseRecord, HvacNode hvacNode) throws FDSRecordFormatException {
        HvacNode hvacNode2 = hvacNode;
        boolean bl = fDSParseRecord.getBoolean("AMBIENT", true);
        String string = fDSParseRecord.getString("VENT_ID");
        if (bl && string != null) {
            String string2 = String.format(Intl.intl("Invalid HVAC NODE: Only one of %1$s and %2$s may be specified."), "AMBIENT", "VENT_ID");
            this.addWarning(fDSParseRecord, string2, Intl.intl("HVAC Record Ignored."));
            return false;
        }
        if (bl) {
            hvacNode2.setNodeType(HvacNode.NodeType.AMBIENT);
        } else if (string == null) {
            hvacNode2.setNodeType(HvacNode.NodeType.INTERNAL);
        } else {
            this.d_nodesWithVents.put(fDSParseRecord, hvacNode2);
        }
        UnitPoint3D unitPoint3D = HvacParser.parseLoc(fDSParseRecord, "HVAC", "XYZ", true, string == null);
        if (unitPoint3D != null) {
            hvacNode.setProp("XYZ", unitPoint3D);
        }
        return true;
    }

    private static final <T> T findById(Map<FDSParseRecord, T> map, String string) {
        for (FDSParseRecord fDSParseRecord : map.keySet()) {
            if (!fDSParseRecord.contains("ID") || !fDSParseRecord.getString("ID").equals(string)) continue;
            return map.get(fDSParseRecord);
        }
        return null;
    }

    @Override
    public void done() {
        AHvacGeomComponent aHvacGeomComponent;
        for (FDSParseRecord fDSParseRecord : this.d_ductMap.keySet()) {
            aHvacGeomComponent = this.d_ductMap.get(fDSParseRecord);
            this.finalizeDuct(fDSParseRecord, (HvacDuct)aHvacGeomComponent);
        }
        for (FDSParseRecord fDSParseRecord : this.d_nodeMap.keySet()) {
            aHvacGeomComponent = this.d_nodeMap.get(fDSParseRecord);
            this.finalizeNode(fDSParseRecord, (HvacNode)aHvacGeomComponent);
        }
    }

    private void finalizeDuct(FDSParseRecord fDSParseRecord, HvacDuct hvacDuct) {
        Object object;
        Object object2;
        String[] stringArray = new String[]{hvacDuct.d_n1, hvacDuct.d_n2};
        if (stringArray != null) {
            object2 = HvacParser.findById(this.d_nodeMap, stringArray[0]);
            object = HvacParser.findById(this.d_nodeMap, stringArray[1]);
            if (object2 == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find NODE for DUCT (NODE_ID=%s)."), object2), Intl.intl("Creating invalid HVAC DUCT"));
            }
            if (object == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find NODE for DUCT (NODE_ID=%s)."), object), Intl.intl("Creating invalid HVAC DUCT."));
            }
            hvacDuct.setProp("NODE_ID", Arrays.asList(object2, object));
        }
        if ((object2 = (String)hvacDuct.getProp("FAN_ID")) != null) {
            object = HvacParser.findById(this.d_fanMap, (String)object2);
            if (object == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find FAN for DUCT (FAN_ID=%s)."), object2), Intl.intl("Turned off airflow for duct."));
                hvacDuct.setProp("opt_none_damper_fan", (Object)HvacDuct.AirflowObj.NONE);
            }
            hvacDuct.setProp("FAN_ID", object);
        }
        if ((object = (String)hvacDuct.getProp("AIRCOIL_ID")) != null) {
            HvacAircoil hvacAircoil = HvacParser.findById(this.d_aircoilMap, (String)object);
            if (hvacAircoil == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find AIRCOIL for DUCT (AIRCOIL_ID=%s)."), object), Intl.intl("Turned off airflow for duct."));
                hvacDuct.setProp("opt_none_damper_fan", (Object)HvacDuct.AirflowObj.NONE);
            }
            hvacDuct.setProp("AIRCOIL_ID", hvacAircoil);
        }
    }

    private void finalizeNode(FDSParseRecord fDSParseRecord, HvacNode hvacNode) {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        ArrayList<HvacDuct> arrayList = Collections.EMPTY_LIST;
        if (fDSParseRecord.contains("DUCT_ID")) {
            object3 = (List)fDSParseRecord.get("DUCT_ID");
            if (object3.size() >= 10) {
                this.addWarning(fDSParseRecord, Intl.intl("List exceeds limit: DUCT_ID"), Intl.intl("Ignoring tailing entries"));
                object3 = object3.subList(0, 9);
            }
            arrayList = new ArrayList<HvacDuct>(object3.size());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                serializable = HvacParser.findById(this.d_ductMap, (String)object);
                if (serializable == null) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find DUCT for NODE (DUCT_ID=%s)."), object), Intl.intl("Missing DUCT record will be ignored."));
                } else if (!serializable.getNodes().contains(hvacNode)) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Inconsistent connection: DUCT, \"%1$s,\" does not specify connection to NODE, \"%2$s.\""), object, hvacNode.getName()), Intl.intl("Ignoring connection."));
                    serializable = null;
                }
                arrayList.add((HvacDuct)serializable);
            }
        }
        if (fDSParseRecord.contains("LOSS")) {
            object3 = (FDSArray)fDSParseRecord.get("LOSS");
            if (object3 == null) {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: NODE LOSS"), Intl.intl("Using default."));
            } else {
                Object object4 = object2 = fDSParseRecord.getString("VENT_ID") != null ? HvacNode.NodeType.VENT : hvacNode.getNodeType();
                if (((HvacNode.NodeType)((Object)object2)).terminal) {
                    object = (UnitDouble)((FDSArray)object3).get(0, 0);
                    serializable = (UnitDouble)((FDSArray)object3).get(1, 0);
                    if (object == null) {
                        object = new UnitDouble(0.0, Unit.ONE);
                    }
                    if (serializable == null) {
                        serializable = new UnitDouble(0.0, Unit.ONE);
                    }
                    hvacNode.setTerminalLoss((UnitDouble)object, (UnitDouble)serializable);
                } else {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        serializable = (HvacDuct)arrayList.get(i);
                        if (serializable == null) continue;
                        for (int j = i + 1; j < arrayList.size(); ++j) {
                            HvacDuct hvacDuct = (HvacDuct)arrayList.get(j);
                            if (hvacDuct == null) continue;
                            UnitDouble unitDouble = (UnitDouble)((FDSArray)object3).get(j, i);
                            UnitDouble unitDouble2 = (UnitDouble)((FDSArray)object3).get(i, j);
                            if (!HvacParser.isLoss(unitDouble) && !HvacParser.isLoss(unitDouble2)) continue;
                            HvacDuctLoss hvacDuctLoss = new HvacDuctLoss(hvacNode, hvacDuct, (HvacDuct)serializable, HvacParser.finalizeLoss(unitDouble), HvacParser.finalizeLoss(unitDouble2));
                            this.getContainer().getBridges().add(hvacDuctLoss);
                            this.flagObjectAdded(hvacDuctLoss);
                        }
                    }
                }
            }
        }
        if ((object3 = fDSParseRecord.getString("FILTER_ID", true)) != null) {
            object2 = HvacParser.findById(this.d_filterMap, (String)object3);
            hvacNode.setProp("FILTER_ID", object2);
            if (object2 == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find FILTER for NODE (FILTER_ID=%s)."), object3), Intl.intl("Ignoring filter."));
            } else if (arrayList.size() > 2) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Filtered node connected to %d ducts. Maximum allowed with filters=2."), arrayList.size()), Intl.intl("Node will be invalid until fixed."));
            }
        }
    }

    private static boolean isLoss(UnitDouble unitDouble) {
        return unitDouble != null && unitDouble.getValueNoUnit() != 0.0;
    }

    private static UnitDouble finalizeLoss(UnitDouble unitDouble) {
        return unitDouble == null ? new UnitDouble(0.0, Unit.ONE) : unitDouble;
    }

    @Override
    public void postProcess() {
        HvacParser.postProcessFilters(this.d_filterMap, this.getContainer().getExSpecList());
        Map<FDSParseRecord, Vent> map = this.d_ventParser.getVentMap();
        HvacParser.postProcessLeaks(this.d_leakMap, map);
        HvacParser.postProcessVentNodes(this.d_nodesWithVents, map, (fDSParseRecord, string, string2) -> this.addWarning((FDSParseRecord)fDSParseRecord, (String)string, (String)string2));
    }

    private static void postProcessLeaks(Map<FDSParseRecord, HvacLeak> map, Map<FDSParseRecord, Vent> map2) {
        for (Map.Entry<FDSParseRecord, HvacLeak> entry : map.entrySet()) {
            FDSParseRecord fDSParseRecord = entry.getKey();
            HvacLeak hvacLeak = entry.getValue();
            String string = fDSParseRecord.getString("VENT_ID");
            String string2 = fDSParseRecord.getString("VENT2_ID");
            hvacLeak.setVent1(HvacParser.findById(map2, string));
            hvacLeak.setVent2(HvacParser.findById(map2, string2));
        }
    }

    private static void postProcessFilters(Map<FDSParseRecord, HvacFilter> map, ExSpecList exSpecList) {
        for (Map.Entry<FDSParseRecord, HvacFilter> entry : map.entrySet()) {
            List list;
            if (!entry.getKey().contains("SPEC_ID")) continue;
            List list2 = (List)entry.getValue().getProp("SPEC_ID");
            ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>();
            for (String string : list2) {
                arrayList.add(exSpecList.get(string));
            }
            entry.getValue().setProp("SPEC_ID", arrayList);
            if (!entry.getKey().contains("LOADING")) {
                list = new ArrayList();
                for (int i = 0; i < list2.size(); ++i) {
                    list.add(new UnitDouble(0.0, SI.KILOGRAM));
                }
                entry.getValue().setProp("LOADING", list);
                continue;
            }
            if (entry.getKey().getList("LOADING", false).size() >= list2.size()) continue;
            list = entry.getKey().getList("LOADING", false);
            for (int i = list.size(); i < list2.size(); ++i) {
                list.add(new UnitDouble(0.0, SI.KILOGRAM));
            }
            entry.getValue().setProp("LOADING", list);
        }
    }

    private static void postProcessVentNodes(Map<FDSParseRecord, HvacNode> map, Map<FDSParseRecord, Vent> map2, TriConsumer<FDSParseRecord, String, String> triConsumer) {
        for (Map.Entry<FDSParseRecord, HvacNode> entry : map.entrySet()) {
            String string;
            FDSParseRecord fDSParseRecord = entry.getKey();
            if (!fDSParseRecord.contains("VENT_ID") || (string = fDSParseRecord.getString("VENT_ID")) == null) continue;
            HvacNode hvacNode = entry.getValue();
            Vent vent = HvacParser.findById(map2, string);
            try {
                if (vent == null) {
                    throw new Exception(String.format(Intl.intl("VENT id=%s not found."), string));
                }
                if (!vent.getSurface().isPredefined(PredefSurf.HVAC)) {
                    throw new Exception(String.format(Intl.intl("VENT referenced by HVAC NODE uses SURF, \"%s\", but must use SURF, \"HVAC\", instead."), vent.getSurface().getName()));
                }
                hvacNode.setVent(vent);
            }
            catch (Exception exception) {
                hvacNode.setNodeType(HvacNode.NodeType.AMBIENT);
                triConsumer.accept(fDSParseRecord, exception.getLocalizedMessage(), Intl.intl("Set node type to AMBIENT."));
            }
        }
    }
}

