/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.geom.Hole;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDSObjParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.util.Pair;

public class HoleParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;

    public HoleParser(FDS6ParsingInfo fDS6ParsingInfo, PinConnParser pinConnParser) {
        super(fDS6ParsingInfo);
        this.d_pinConns = pinConnParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("HOLE");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = this.generateName(fDSParseRecord, "ID", Intl.intl("Hole"));
        AABoxGeom aABoxGeom = HoleParser.parseXBGeom(fDSParseRecord, "HOLE", "XB", true);
        Hole hole = new Hole(string, GeomNodeUtil.newNode(aABoxGeom));
        Color color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", false);
        if (color == INVISIBLE_COLOR) {
            hole.setVisible(false);
            hole.setColors(new Color[]{null});
        } else {
            hole.setColors(color);
        }
        hole.setEvac(this.parseEvac(fDSParseRecord, "EVACUATION", "MESH_ID"));
        HoleParser.markSingleInputForRetrieval(fDSParseRecord, hole, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        this.parseCustomFDSProps(hole, fDSParseRecord);
        Pair<String, List<Hole>> pair = this.applyMult(fDSParseRecord, "MULT_ID", hole);
        this.addObjects((String)pair.v1, (List)pair.v2);
        return true;
    }
}

