/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Obstruction;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDSObjParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomParser
extends AFDSObjParser {
    private final Map<String, Pair<IGeomNode, Surface[]>> d_components = new HashMap<String, Pair<IGeomNode, Surface[]>>();

    public GeomParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("GEOM");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Point3d[] point3dArray;
        Serializable serializable;
        ArrayList arrayList;
        List list;
        String string = fDSParseRecord.getString("ID");
        if (string == null) {
            string = "Geom";
        }
        IGeom iGeom = EmptyGeom.INSTANCE;
        Surface[] surfaceArray = new Surface[]{};
        List list2 = fDSParseRecord.getList("FACES", true);
        List list3 = fDSParseRecord.getList("VERTS", true);
        if (!list2.isEmpty() && !list3.isEmpty()) {
            int n;
            list = fDSParseRecord.getList("SURF_ID", true);
            arrayList = Obstruction.getSurfaceFilter();
            serializable = new ArrayList(list.size());
            for (String string2 : list) {
                serializable.add(this.getSurfaceSafe(fDSParseRecord, string2, (Predicate<Surface>)((Object)arrayList)));
            }
            point3dArray = new Point3d[list3.size() / 3];
            int n2 = 0;
            while (n2 < list3.size()) {
                n = n2 / 3;
                point3dArray[n] = new Point3d((Double)list3.get(n2++), (Double)list3.get(n2++), (Double)list3.get(n2++));
            }
            n2 = list2.size() / 4;
            surfaceArray = new Surface[n2];
            n = 0;
            int[] nArray = new int[n2 * 3];
            int n3 = 0;
            int n4 = 0;
            while (n4 < list2.size()) {
                nArray[n3++] = (Integer)list2.get(n4++) - 1;
                nArray[n3++] = (Integer)list2.get(n4++) - 1;
                nArray[n3++] = (Integer)list2.get(n4++) - 1;
                int n5 = (Integer)list2.get(n4++);
                surfaceArray[n++] = n5 == 0 ? this.getDefaultMat() : (Surface)serializable.get(n5 - 1);
            }
            iGeom = new SolidGeom(new Mesh(point3dArray, nArray, 2));
        }
        list = fDSParseRecord.getList("GEOM_IDS", true);
        arrayList = Collections.emptyList();
        if (!list.isEmpty()) {
            arrayList = new ArrayList(list.size());
            serializable = new ArrayList<Surface>(Arrays.asList(surfaceArray));
            for (String string3 : list) {
                Pair<IGeomNode, Surface[]> pair = this.d_components.get(string3);
                if (pair == null) continue;
                serializable.addAll(Arrays.asList((Object[])pair.v2));
                arrayList.add(pair.v1);
            }
            surfaceArray = theUtil.toArray(serializable, Surface.class);
            arrayList.trimToSize();
        }
        serializable = GeomParser.parseTransform(fDSParseRecord);
        point3dArray = GeomNodeUtil.newNode((ITransform)serializable, iGeom, Elements.NONE, arrayList);
        this.d_components.put(string, new Pair(point3dArray, surfaceArray));
        if (fDSParseRecord.getBoolean("COMPONENT_ONLY", true).booleanValue()) {
            return true;
        }
        surfaceArray = GeomUtil.optimize(surfaceArray);
        Obstruction obstruction = new Obstruction(string, (IGeomNode)point3dArray, surfaceArray);
        obstruction.setOptions(128, true);
        this.parseCustomFDSProps(obstruction, fDSParseRecord);
        this.addObject(obstruction);
        return true;
    }

    private static ITransform parseTransform(FDSParseRecord fDSParseRecord) {
        Function<String, Vector3d> function = string -> {
            FDSArray fDSArray = fDSParseRecord.getArray((String)string, true);
            return new Vector3d(((UnitDouble)fDSArray.get(0)).get(Geometry.LU), ((UnitDouble)fDSArray.get(1)).get(Geometry.LU), ((UnitDouble)fDSArray.get(2)).get(Geometry.LU));
        };
        ToDoubleFunction<String> toDoubleFunction = string -> fDSParseRecord.getUnitDouble((String)string, true).get(Geometry.AU);
        FDSArray fDSArray = fDSParseRecord.getArray("SCALE", true);
        FDSArray fDSArray2 = fDSParseRecord.getArray("GAXIS", true);
        Vector3d vector3d = new Vector3d((Double)fDSArray2.get(0), (Double)fDSArray2.get(1), (Double)fDSArray2.get(2));
        if (Util3D.safeNormalize(vector3d, 0.0) == 0.0) {
            // empty if block
        }
        double d = toDoubleFunction.applyAsDouble("GROTATE");
        Vector3d vector3d2 = function.apply("XYZ");
        double d2 = toDoubleFunction.applyAsDouble("AZIM");
        double d3 = toDoubleFunction.applyAsDouble("ELEV");
        Vector3d vector3d3 = function.apply("XYZ0");
        ITransform iTransform = TransformUtil.translate(vector3d2.x, vector3d2.y, vector3d2.z).concatenate(TransformUtil.translate(vector3d3.x, vector3d3.y, vector3d3.z)).concatenate(TransformUtil.rotate(vector3d.x, vector3d.y, vector3d.z, -d)).concatenate(TransformUtil.rotate(Math.cos(d2), Math.sin(d2), 0.0, d3)).concatenate(TransformUtil.rotate(0.0, 0.0, 1.0, d2)).concatenate(TransformUtil.scale((Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2))).concatenate(TransformUtil.translate(-vector3d3.x, -vector3d3.y, -vector3d3.z));
        return iTransform;
    }
}

