/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.parsers.Multiplier;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class FDS6ParsingInfo
extends FDSParsingInfo {
    private final Map<String, RampInfo> d_rampValMap = new HashMap<String, RampInfo>();
    private final Map<String, List<List<Double>>> d_tableValMap = new HashMap<String, List<List<Double>>>();
    private final Map<String, Multiplier> d_multMap = new HashMap<String, Multiplier>();
    private final QuantityMap d_quantityMap = new QuantityMap();
    private final List<Pair<Ramp, RampInfo>> d_rampsToFinish = new ArrayList<Pair<Ramp, RampInfo>>();

    public FDS6ParsingInfo(String string, PyroMod pyroMod, PyroMod pyroMod2) {
        super(string, pyroMod, pyroMod2);
    }

    public QuantityMap getQuantityMap() {
        return this.d_quantityMap;
    }

    public void addMultipler(Multiplier multiplier) {
        this.d_multMap.put(multiplier.getID(), multiplier);
    }

    public Multiplier getMultiplier(String string) {
        return this.d_multMap.get(string);
    }

    public void addRampValue(FDSParseRecord fDSParseRecord, String string, double d, double d2, String string2) {
        RampInfo rampInfo = this.d_rampValMap.get(string);
        if (rampInfo == null) {
            rampInfo = new RampInfo(fDSParseRecord);
            this.d_rampValMap.put(string, rampInfo);
        }
        rampInfo.entries.add(new double[]{d, d2});
        if (string2 != null && rampInfo.devcID == null) {
            rampInfo.rec = fDSParseRecord;
            rampInfo.devcID = string2;
        }
    }

    public RampInfo getRampInfo(String string) {
        return this.d_rampValMap.get(string);
    }

    public Ramp getRamp(String string, IRampInput iRampInput, int n, boolean bl) {
        RampInfo rampInfo = this.getRampInfo(string);
        if (rampInfo == null) {
            return null;
        }
        Unit unit = SIUS.unit(iRampInput.getUnitType());
        Unit unit2 = SIUS.unit(n);
        ArrayList<Ramp.Entry> arrayList = new ArrayList<Ramp.Entry>(rampInfo.entries.size());
        for (double[] dArray : rampInfo.entries) {
            Ramp.Entry entry = new Ramp.Entry(new UnitDouble(dArray[0], unit), new UnitDouble(dArray[1], unit2));
            arrayList.add(entry);
        }
        Ramp ramp = new Ramp(arrayList, iRampInput, n);
        if (bl && rampInfo.devcID != null) {
            this.d_rampsToFinish.add(new Pair<Object, RampInfo>(ramp, rampInfo));
        }
        return ramp;
    }

    public void finishRamps(PinConnParser pinConnParser) throws FDSRecordFormatException {
        for (Pair<Ramp, RampInfo> pair : this.d_rampsToFinish) {
            Ramp ramp = (Ramp)pair.v1;
            RampInfo rampInfo = (RampInfo)pair.v2;
            assert (rampInfo.devcID != null);
            if (!pinConnParser.outputNameExists(rampInfo.devcID)) {
                throw new FDSRecordFormatException(rampInfo.rec, String.format(Intl.intl("Could not find DEVC: %s"), rampInfo.devcID));
            }
            IDoubleOutPin iDoubleOutPin = null;
            for (IOutPin iOutPin : pinConnParser.getPins(rampInfo.devcID)) {
                if (!(iOutPin instanceof IDoubleOutPin)) continue;
                iDoubleOutPin = (IDoubleOutPin)iOutPin;
                break;
            }
            if (iDoubleOutPin == null) {
                throw new FDSRecordFormatException(rampInfo.rec, String.format(Intl.intl("Cannot use DEVC, %s, as an input to a RAMP."), rampInfo.devcID));
            }
            SignalInput signalInput = new SignalInput(iDoubleOutPin);
            ramp.taskSetInput(signalInput).run();
        }
    }

    public void addTableRow(String string, List<Double> list) {
        List<List<Double>> list2 = this.d_tableValMap.get(string);
        if (list2 == null) {
            list2 = new ArrayList<List<Double>>();
            this.d_tableValMap.put(string, list2);
        }
        list2.add(list);
    }

    public List<List<Double>> getTable(String string) {
        return this.d_tableValMap.get(string);
    }

    public static class RampInfo {
        public FDSParseRecord rec;
        public List<double[]> entries;
        public String devcID;

        public RampInfo(FDSParseRecord fDSParseRecord) {
            this.rec = fDSParseRecord;
            this.entries = new ArrayList<double[]>();
            this.devcID = null;
        }
    }
}

