/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.Util;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParser;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.IFDSRecordParser;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.BoundaryParser;
import pyrosim.io.fds.v6.parsers.ControlParser;
import pyrosim.io.fds.v6.parsers.DeviceParser;
import pyrosim.io.fds.v6.parsers.ExSpecParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.GeomParser;
import pyrosim.io.fds.v6.parsers.GridParser;
import pyrosim.io.fds.v6.parsers.HoleParser;
import pyrosim.io.fds.v6.parsers.HvacParser;
import pyrosim.io.fds.v6.parsers.InitParser;
import pyrosim.io.fds.v6.parsers.IsofParser;
import pyrosim.io.fds.v6.parsers.MaterialParser;
import pyrosim.io.fds.v6.parsers.MultParser;
import pyrosim.io.fds.v6.parsers.ObstParser;
import pyrosim.io.fds.v6.parsers.ParticleParser;
import pyrosim.io.fds.v6.parsers.PinConnFinisher;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.Plot3dParser;
import pyrosim.io.fds.v6.parsers.ProfParser;
import pyrosim.io.fds.v6.parsers.PropParser;
import pyrosim.io.fds.v6.parsers.RampFinisher;
import pyrosim.io.fds.v6.parsers.RampParser;
import pyrosim.io.fds.v6.parsers.ReactionParser;
import pyrosim.io.fds.v6.parsers.SimParamsParser;
import pyrosim.io.fds.v6.parsers.SliceParser;
import pyrosim.io.fds.v6.parsers.StatisticsParser;
import pyrosim.io.fds.v6.parsers.SurfaceParser;
import pyrosim.io.fds.v6.parsers.TableParser;
import pyrosim.io.fds.v6.parsers.VentParser;
import pyrosim.io.fds.v6.parsers.ZoneParser;

public class FDS6Parser
extends FDSParser {
    @Override
    protected List<? extends IFDSRecordParser> createParsers(FDSParsingInfo fDSParsingInfo) {
        FDS6ParsingInfo fDS6ParsingInfo = (FDS6ParsingInfo)fDSParsingInfo;
        ExSpecParser exSpecParser = new ExSpecParser(fDS6ParsingInfo);
        PinConnParser pinConnParser = new PinConnParser(fDS6ParsingInfo);
        ControlParser controlParser = new ControlParser(fDS6ParsingInfo, pinConnParser);
        PropParser propParser = new PropParser(fDS6ParsingInfo);
        ZoneParser zoneParser = new ZoneParser(fDS6ParsingInfo);
        SimParamsParser simParamsParser = new SimParamsParser(fDS6ParsingInfo);
        VentParser ventParser = new VentParser(fDS6ParsingInfo, pinConnParser, exSpecParser);
        return Arrays.asList(new MultParser(fDS6ParsingInfo), new GridParser(fDS6ParsingInfo), zoneParser, new RampParser(fDS6ParsingInfo), new TableParser(fDS6ParsingInfo), exSpecParser, new ParticleParser(fDS6ParsingInfo, pinConnParser), new ReactionParser(fDS6ParsingInfo), new InitParser(fDS6ParsingInfo, pinConnParser), new MaterialParser(fDS6ParsingInfo), new SurfaceParser(fDS6ParsingInfo, zoneParser), new HvacParser(fDS6ParsingInfo, pinConnParser, ventParser), controlParser, propParser, new DeviceParser(fDS6ParsingInfo, pinConnParser, propParser), simParamsParser, new ObstParser(fDS6ParsingInfo, pinConnParser, simParamsParser), new GeomParser(fDS6ParsingInfo), new HoleParser(fDS6ParsingInfo, pinConnParser), ventParser, new ProfParser(fDS6ParsingInfo), new IsofParser(fDS6ParsingInfo), new Plot3dParser(fDS6ParsingInfo), new BoundaryParser(fDS6ParsingInfo, propParser), new SliceParser(fDS6ParsingInfo), new StatisticsParser(fDS6ParsingInfo), pinConnParser, new PinConnFinisher(fDS6ParsingInfo, pinConnParser, controlParser), new RampFinisher(fDS6ParsingInfo, pinConnParser), new TailParser());
    }

    @Override
    protected FDSParsingInfo createParsingInfo(String string, PyroMod pyroMod, PyroMod pyroMod2) {
        return new FDS6ParsingInfo(string, pyroMod, pyroMod2);
    }

    @Override
    protected Map<String, FDSRecordSpec> getRecordSpecs() {
        return FDS6Const.getRecordSpecs(false);
    }

    @Override
    protected String getFinishRecType() {
        return "TAIL";
    }

    @Override
    protected void parseRecords(List<FDSParseRecord> list, String string, FDSParsingInfo fDSParsingInfo) throws IOException, FDSParseException {
        super.parseRecords(list, string, fDSParsingInfo);
        for (IPyroObject iPyroObject : fDSParsingInfo.getParseResult().extractedObjs) {
            if (!(iPyroObject instanceof ISignalSink)) continue;
            Util.deleteWires(((ISignalSink)iPyroObject).getInputPin());
        }
    }

    private static class TailParser
    implements IFDSRecordParser {
        private TailParser() {
        }

        @Override
        public void getRecordTypes(Set<String> set) {
            set.add("TAIL");
        }

        @Override
        public void process(Collection<FDSParseRecord> collection, Collection<FDSParseRecord> collection2) throws FDSRecordFormatException {
        }

        @Override
        public void getUnsupportedFields(String string, Map<String, String> map) {
        }

        @Override
        public void postProcess() {
        }
    }
}

