/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.units.UnitDouble;

public class ExSpecParser
extends AFDS6Parser {
    private int d_specIx = 0;
    private boolean d_isReactionDefined = false;
    private final List<ExSpec> d_parsedSpecs = new ArrayList<ExSpec>();
    private final Map<FDSParseRecord, ExSpec> d_lumpedSpecs = new LinkedHashMap<FDSParseRecord, ExSpec>();

    public ExSpecParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("SPEC");
        set.add("REAC");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("ALIAS", "UNSUPPORTED");
        map.put("CONDUCTIVITY", "UNSUPPORTED");
        map.put("FIC_CONCENTRATION", "UNSUPPORTED");
        map.put("FLD_LETHAL_DOSE", "UNSUPPORTED");
        map.put("MASS_EXTINCTION_COEFFICIENT", "UNSUPPORTED");
        map.put("PR_GAS", "UNSUPPORTED");
        map.put("PRIMITIVE", "UNSUPPORTED");
        map.put("RAMP_K", "UNSUPPORTED");
        map.put("THIRD_BODY", "UNSUPPORTED");
    }

    public ExSpec getSpec(int n) {
        if (n >= this.d_parsedSpecs.size()) {
            return null;
        }
        return this.d_parsedSpecs.get(n);
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        boolean bl;
        if (fDSParseRecord.getType().equals("REAC")) {
            this.d_isReactionDefined = true;
            return true;
        }
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process SPEC record: ID missing"), Intl.intl("SPEC Record Ignored"));
            return false;
        }
        ExSpecList exSpecList = this.getContainer().getExSpecList();
        String string = fDSParseRecord.getString("ID");
        boolean bl2 = ExSpecList.isPredefinedSpecies(string);
        if (exSpecList.get(string) != null && this.d_parsedSpecs.contains(exSpecList.get(string))) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process SPEC record: Duplicate ID"), Intl.intl("SPEC Record Ignored"));
            return false;
        }
        ExSpec exSpec = bl2 ? (exSpecList.contains(ExSpecList.getPredefinedSpecies(string)) ? exSpecList.get(string) : new ExSpec(ExSpecList.getPredefinedSpecies(string))) : new ExSpec(string, 1);
        exSpec.setFYI(fDSParseRecord.getString("FYI", false));
        if (fDSParseRecord.contains("MASS_FRACTION_0")) {
            exSpec.setMassFrac0(fDSParseRecord.getDouble("MASS_FRACTION_0"));
        }
        if (fDSParseRecord.contains("LUMPED_COMPONENT_ONLY")) {
            bl = fDSParseRecord.getBoolean("LUMPED_COMPONENT_ONLY");
            if (bl) {
                exSpec.setLumpedComponentOnlyRule(ExSpec.LUMPED_RULE.TRUE);
            } else {
                exSpec.setLumpedComponentOnlyRule(ExSpec.LUMPED_RULE.FALSE);
            }
        } else {
            exSpec.setLumpedComponentOnlyRule(ExSpec.LUMPED_RULE.AUTO);
        }
        exSpec.setIsBackgroundSpec(fDSParseRecord.getBoolean("BACKGROUND", true));
        boolean bl3 = bl = fDSParseRecord.contains("MASS_FRACTION") || fDSParseRecord.contains("VOLUME_FRACTION") || fDSParseRecord.contains("SPEC_ID");
        if (bl || bl2) {
            this.d_lumpedSpecs.put(fDSParseRecord, exSpec);
        } else if (!bl2) {
            Variant variant;
            Variant variant2;
            boolean bl4;
            Variant variant3;
            exSpec.setType(1);
            ExSpec.PrimitiveParams primitiveParams = exSpec.getPrimParams();
            Variant variant4 = this.getRampableValue(fDSParseRecord, "DIFFUSIVITY", "RAMP_D", RampInputs.TIME, 27);
            if (variant4 != null) {
                primitiveParams.setDiffusivity(variant4);
            }
            if ((variant3 = this.getRampableValue(fDSParseRecord, "VISCOSITY", "RAMP_MU", RampInputs.TIME, 41)) != null) {
                primitiveParams.setViscosity(variant3);
            }
            if (fDSParseRecord.contains("SIGMALJ")) {
                primitiveParams.setSigmaLJ(fDSParseRecord.getDouble("SIGMALJ", true), true);
            }
            if (fDSParseRecord.contains("EPSILONKLJ")) {
                primitiveParams.setEpsilonKLJ(fDSParseRecord.getDouble("EPSILONKLJ", true), true);
            }
            if (fDSParseRecord.contains("RADCAL_ID")) {
                primitiveParams.setRadCalSurrogate(fDSParseRecord.getString("RADCAL_ID", true));
            }
            if (bl4 = fDSParseRecord.getBoolean("AEROSOL", true).booleanValue()) {
                primitiveParams.setAerosol(bl4);
                primitiveParams.setDensitySolid(fDSParseRecord.getUnitDouble("DENSITY_SOLID", true));
                primitiveParams.setConductivitySolid(fDSParseRecord.getUnitDouble("CONDUCTIVITY_SOLID", true));
                primitiveParams.setMeanDiameter(fDSParseRecord.getUnitDouble("MEAN_DIAMETER", true));
            }
            if ((variant2 = this.getRampableValue(fDSParseRecord, "SPECIFIC_HEAT", "RAMP_CP", RampInputs.TIME, 11)) != null) {
                primitiveParams.setSpecHeat(variant2);
            }
            if (fDSParseRecord.contains("REFERENCE_TEMPERATURE")) {
                primitiveParams.setRefTemp(fDSParseRecord.getUnitDouble("REFERENCE_TEMPERATURE", true), true);
            }
            if (fDSParseRecord.contains("REFERENCE_ENTHALPY")) {
                primitiveParams.setRefEnthalpy(fDSParseRecord.getUnitDouble("REFERENCE_ENTHALPY", true));
            }
            if (fDSParseRecord.contains("DENSITY_LIQUID")) {
                primitiveParams.setDensityLiquid(fDSParseRecord.getUnitDouble("DENSITY_LIQUID", true));
            }
            if ((variant = this.getRampableValue(fDSParseRecord, "SPECIFIC_HEAT_LIQUID", "RAMP_CP_L", RampInputs.TIME, 11)) != null) {
                primitiveParams.setSpecHeatLiquid(variant);
            }
            if (fDSParseRecord.contains("VAPORIZATION_TEMPERATURE")) {
                primitiveParams.setVapTemp(fDSParseRecord.getUnitDouble("VAPORIZATION_TEMPERATURE", true));
            }
            if (fDSParseRecord.contains("MELTING_TEMPERATURE")) {
                primitiveParams.setMeltingTemp(fDSParseRecord.getUnitDouble("MELTING_TEMPERATURE", true));
            }
            if (fDSParseRecord.contains("HEAT_OF_VAPORIZATION")) {
                primitiveParams.setHoVaporization(fDSParseRecord.getUnitDouble("HEAT_OF_VAPORIZATION", true));
            }
            if (fDSParseRecord.contains("ENTHALPY_OF_FORMATION")) {
                primitiveParams.setEoFormation(fDSParseRecord.getUnitDouble("ENTHALPY_OF_FORMATION", true));
            }
            if (fDSParseRecord.contains("H_V_REFERENCE_TEMPERATURE")) {
                primitiveParams.setHVRefTemp(fDSParseRecord.getUnitDouble("H_V_REFERENCE_TEMPERATURE", true));
            }
            if (fDSParseRecord.contains("MW")) {
                exSpec.setMolecularWeight(fDSParseRecord.getUnitDouble("MW"));
            }
            if (fDSParseRecord.contains("FORMULA")) {
                exSpec.setChemFormula(fDSParseRecord.getString("FORMULA", true));
            }
        }
        this.parseCustomFDSProps(exSpec, fDSParseRecord);
        if (bl || bl2) {
            this.parsePrimforAdvanced(fDSParseRecord, exSpec, bl2);
        }
        this.addSpec(fDSParseRecord, exSpec);
        return true;
    }

    private void addSpec(FDSParseRecord fDSParseRecord, ExSpec exSpec) {
        ExSpecList exSpecList = this.getContainer().getExSpecList();
        exSpecList.add(exSpec);
        this.flagObjectAdded(exSpec);
        this.d_parsedSpecs.add(exSpec);
    }

    private Variant getRampableValue(FDSParseRecord fDSParseRecord, String string, String string2, IRampInput iRampInput, int n) throws FDSRecordFormatException {
        Variant variant;
        String string3 = fDSParseRecord.getString(string2);
        if (string3 != null) {
            Ramp ramp = this.getParsingInfo().getRamp(string3, iRampInput, n, true);
            if (ramp == null) {
                throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Invalid ramp specified."));
            }
            variant = Variant.ramp(ramp);
        } else {
            UnitDouble unitDouble = fDSParseRecord.getUnitDouble(string, true);
            variant = unitDouble != null ? Variant.constant(unitDouble) : null;
        }
        return variant;
    }

    /*
     * WARNING - void declaration
     */
    private void parsePrimforAdvanced(FDSParseRecord fDSParseRecord, ExSpec exSpec, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("MW");
        arrayList.add("FORMULA");
        arrayList.add("DIFFUSIVITY");
        arrayList.add("VISCOSITY");
        arrayList.add("SIGMALJ");
        arrayList.add("EPSILONKLJ");
        arrayList.add("RADCAL_ID");
        arrayList.add("AEROSOL");
        arrayList.add("DENSITY_SOLID");
        arrayList.add("CONDUCTIVITY_SOLID");
        arrayList.add("MEAN_DIAMETER");
        arrayList.add("SPECIFIC_HEAT");
        arrayList.add("REFERENCE_TEMPERATURE");
        arrayList.add("REFERENCE_ENTHALPY");
        arrayList.add("DENSITY_LIQUID");
        arrayList.add("SPECIFIC_HEAT_LIQUID");
        arrayList.add("VAPORIZATION_TEMPERATURE");
        arrayList.add("MELTING_TEMPERATURE");
        arrayList.add("HEAT_OF_VAPORIZATION");
        arrayList.add("ENTHALPY_OF_FORMATION");
        arrayList.add("H_V_REFERENCE_TEMPERATURE");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        FDSRenderProps fDSRenderProps = PyroSim.getApp().getFDSRenderProps();
        for (String object52 : arrayList) {
            object4 = fDSParseRecord.get(object52);
            if (object4 == null || (object3 = fDSParseRecord.getSpec().fields.get(object52)) == null) continue;
            object2 = ((FDSRecordSpec.Field)object3).render(fDSRenderProps, object4);
            this.collectCustomVal(linkedHashMap, (String)object2);
        }
        if (!linkedHashMap.isEmpty()) {
            object = bl ? Intl.intl("PyroSim does not support modifying predefined species.") : Intl.intl("PyroSim does not support changing primitive parameters for lumped species.");
            this.addWarning(fDSParseRecord, (String)object, String.format(Intl.intl("Nonbasic fields used by Species %s moved to Advanced Records."), exSpec.getName()));
        }
        object = new LinkedHashMap();
        if (fDSParseRecord.contains("RAMP_D")) {
            String string = fDSParseRecord.getString("RAMP_D");
            linkedHashMap.put("RAMP_D", '\'' + string + '\'');
            object.put(string, this.getParsingInfo().getRamp(string, RampInputs.TIME, 27, true));
        }
        if (fDSParseRecord.contains("RAMP_MU")) {
            String string = fDSParseRecord.getString("RAMP_MU");
            linkedHashMap.put("RAMP_MU", '\'' + string + '\'');
            object.put(string, this.getParsingInfo().getRamp(string, RampInputs.TIME, 41, true));
        }
        if (fDSParseRecord.contains("RAMP_CP")) {
            String string = fDSParseRecord.getString("RAMP_CP");
            linkedHashMap.put("RAMP_CP", '\'' + string + '\'');
            object.put(string, this.getParsingInfo().getRamp(string, RampInputs.TIME, 11, true));
        }
        if (fDSParseRecord.contains("RAMP_CP_L")) {
            String string = fDSParseRecord.getString("RAMP_CP_L");
            linkedHashMap.put("RAMP_CP_L", '\'' + string + '\'');
            object.put(string, this.getParsingInfo().getRamp(string, RampInputs.TIME, 11, true));
        }
        if (!object.isEmpty()) {
            void var8_19;
            if (bl) {
                String string = Intl.intl("PyroSim does not support modifying predefined species.");
            } else {
                String string = Intl.intl("PyroSim does not support changing primitive parameters for lumped species.");
            }
            this.addWarning(fDSParseRecord, (String)var8_19, String.format(Intl.intl("Ramps used by Species %s moved to Additional Records."), exSpec.getName()));
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            object3 = new FDSNameMap();
            object2 = new PinConnectionRenderer((FDSNameMap)object3);
            FDSStringRenderer fDSStringRenderer = new FDSStringRenderer((FDSRenderProps)object4);
            RampRenderer.render(fDSStringRenderer, (Map<String, Ramp>)object, (PinConnectionRenderer)object2);
            this.getParsingInfo().getContainer().setUnprocessedRecords(this.getParsingInfo().getContainer().getUnprocessedRecords() + fDSStringRenderer.toString());
        }
        CustomFDSProps customFDSProps = CustomFDSProps.get(linkedHashMap);
        exSpec.setCustomFDSProps(CustomFDSProps.union(customFDSProps, exSpec.getCustomFDSProps()));
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        if (this.d_isReactionDefined) {
            this.getContainer().getExSpecList().addImplicitSpecs();
        } else {
            this.getContainer().getExSpecList().addAirSpecs();
        }
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        List list = this.d_parsedSpecs.stream().filter(exSpec -> exSpec.isBackgroundSpec()).collect(Collectors.toList());
        if (list.size() > 1) {
            for (Object object : list) {
                ((ExSpec)object).setIsBackgroundSpec(false);
            }
        }
        ExSpecList exSpecList = this.getContainer().getExSpecList();
        for (Map.Entry entry : this.d_lumpedSpecs.entrySet()) {
            int n;
            if (!((FDSParseRecord)entry.getKey()).contains("SPEC_ID")) continue;
            List<Object> list2 = new ArrayList();
            List<Object> list3 = new ArrayList();
            list3 = ((FDSParseRecord)entry.getKey()).getList("SPEC_ID", false);
            if (((FDSParseRecord)entry.getKey()).contains("SPEC_ID") && !((FDSParseRecord)entry.getKey()).contains("MASS_FRACTION") && !((FDSParseRecord)entry.getKey()).contains("VOLUME_FRACTION")) {
                if (list3.size() > 1) {
                    this.addWarning((FDSParseRecord)entry.getKey(), Intl.intl("Failed to parse lumped species parameters."), Intl.intl(String.format("Species %s imported as a primitive species.", ((ExSpec)entry.getValue()).getName())));
                    continue;
                }
                LinkedHashMap<ExSpec, Double> linkedHashMap = new LinkedHashMap<ExSpec, Double>();
                linkedHashMap.put(exSpecList.get((String)list3.get(0)), 1.0);
                ((ExSpec)entry.getValue()).setComposition(2, linkedHashMap);
                continue;
            }
            if (((FDSParseRecord)entry.getKey()).contains("MASS_FRACTION")) {
                list2 = ((FDSParseRecord)entry.getKey()).getList("MASS_FRACTION", false);
                n = 2;
            } else {
                list2 = ((FDSParseRecord)entry.getKey()).getList("VOLUME_FRACTION", false);
                n = 3;
            }
            if (list2.size() <= 0 || list3.size() != list2.size()) continue;
            LinkedHashMap<ExSpec, Double> linkedHashMap = new LinkedHashMap<ExSpec, Double>();
            for (int i = 0; i < list2.size(); ++i) {
                ExSpec exSpec2 = exSpecList.get((String)list3.get(i));
                if (exSpec2 == null) {
                    if (!ExSpecList.isPredefinedSpecies((String)list3.get(i))) continue;
                    exSpec2 = new ExSpec(ExSpecList.getPredefinedSpecies((String)list3.get(i)));
                    exSpecList.add(exSpec2);
                }
                linkedHashMap.put(exSpec2, (Double)list2.get(i));
            }
            ((ExSpec)entry.getValue()).setComposition(n, linkedHashMap);
        }
        super.postProcess();
    }
}

