/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.NotOp;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.hvac.DuctDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.hvac.NodeDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.sprayers.ASprayer;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.common.GeomUtil;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.PropParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitLineSeg3D;
import thunderheadeng.units.UnitPoint3D;

public class DeviceParser
extends AFDS6Parser {
    private final PinConnParser d_pinConns;
    private final PropParser d_propParser;
    private final List<FDSParseRecord> d_aspSamplerRecs = new ArrayList<FDSParseRecord>();
    private final Map<FDSParseRecord, Set<IDevice>> d_parsedDevices = new LinkedHashMap<FDSParseRecord, Set<IDevice>>();

    public DeviceParser(FDS6ParsingInfo fDS6ParsingInfo, PinConnParser pinConnParser, PropParser propParser) {
        super(fDS6ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        DeviceParser.getUnsupported(string, map);
    }

    public static void getUnsupported(String string, Map<String, String> map) {
        map.put("CONVERSION_FACTOR", "UNSUPPORTED");
        map.put("COORD_FACTOR", "UNSUPPORTED");
        map.put("DRY", "UNSUPPORTED");
        map.put("EVACUATION", "UNSUPPORTED");
        map.put("HIDE_COORDINATES", "UNSUPPORTED");
        map.put("INIT_ID", "UNSUPPORTED");
        map.put("OUTPUT", "UNSUPPORTED");
        map.put("PIPE_INDEX", "UNSUPPORTED");
        map.put("QUANTITY2", "UNSUPPORTED");
        map.put("SMOOTHING_FACTOR", "UNSUPPORTED");
        map.put("STATISTICS_START", "UNSUPPORTED");
        map.put("TIME_AVERAGED", "UNSUPPORTED");
        map.put("UNITS", "UNSUPPORTED");
        map.put("VELO_INDEX", "UNSUPPORTED");
        map.put("X_ID", "UNSUPPORTED");
        map.put("Y_ID", "UNSUPPORTED");
        map.put("Z_ID", "UNSUPPORTED");
        map.put("CABLE_MASS_PER_LENGTH", "UNSUPPORTED");
        map.put("CABLE_DIAMETER", "UNSUPPORTED");
        map.put("CABLE_FAILURE_TEMPERATURE", "UNSUPPORTED");
        map.put("CABLE_JACKET_THICKNESS", "UNSUPPORTED");
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        return this.processDevc(fDSParseRecord);
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        for (FDSParseRecord fDSParseRecord : this.d_aspSamplerRecs) {
            String string = (String)fDSParseRecord.get("DEVC_ID");
            if (string == null) continue;
            String string2 = (String)fDSParseRecord.get("ID");
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("FLOWRATE", true);
            UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("DELAY", true);
            AspiratorSampler aspiratorSampler = (AspiratorSampler)this.getContainer().getDevices().get(string2);
            Aspirator aspirator = (Aspirator)this.getContainer().getDevices().get(string);
            if (aspirator == null) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Could not find aspirator: %s"), string));
            }
            aspirator.setSamplerLine(new Aspirator.SamplerLine(aspiratorSampler, unitDouble, unitDouble2));
        }
    }

    private IQuantity parseQuantity(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, boolean bl, boolean bl2) throws FDSRecordFormatException {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        FDSParseRecord fDSParseRecord3 = fDSParseRecord;
        String string8 = (String)fDSParseRecord.get("QUANTITY", false);
        if (string8 == null) {
            fDSParseRecord3 = fDSParseRecord2;
            string8 = (String)fDSParseRecord2.get("QUANTITY", false);
            if (string8 == null) {
                return null;
            }
        }
        if (fDSParseRecord3.getType().equals("DEVC")) {
            string7 = "QUANTITY";
            string6 = "PART_ID";
            string5 = "SPEC_ID";
            string4 = "MATL_ID";
            string3 = "DUCT_ID";
            string2 = "NODE_ID";
        } else {
            string7 = "QUANTITY";
            string6 = "PART_ID";
            string5 = "SPEC_ID";
            string4 = null;
            string3 = null;
            string2 = null;
        }
        return this.parseQuantity(fDSParseRecord3, string7, string6, string5, string4, string3, string2, 0, string, bl, bl2);
    }

    protected boolean processDevc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        FDSParseRecord fDSParseRecord2;
        String string;
        String string2 = (String)fDSParseRecord.get("STATISTICS", false);
        if (string2 != null) {
            return true;
        }
        Integer n = fDSParseRecord.getInteger("POINTS", false);
        boolean bl = fDSParseRecord.getOptional("TIME_HISTORY").orElse(false);
        if (n != null && !bl) {
            return true;
        }
        boolean bl2 = false;
        String string3 = (String)fDSParseRecord.get("ID");
        if (string3 == null || string3.trim().equals("")) {
            string3 = this.getNames(IDevice.class).generateName();
            bl2 = true;
        }
        if ((string = (String)fDSParseRecord.get("PROP_ID")) == null) {
            fDSParseRecord2 = PropParser.getDefaultProp();
        } else {
            fDSParseRecord2 = this.d_propParser.getProp(string);
            if (fDSParseRecord2 == null) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("PROP record, %s, could not be found."), string));
            }
        }
        String string4 = (String)fDSParseRecord.get("QUANTITY", false);
        if (string4 == null && (string4 = (String)fDSParseRecord2.get("QUANTITY", false)) == null) {
            this.addWarning(fDSParseRecord, Intl.intl("The device type could not be determined from the DEVC or PROP record."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        IDevice iDevice = null;
        if (fDSParseRecord2.contains("PART_ID")) {
            iDevice = this.parseSprayer(fDSParseRecord, fDSParseRecord2, string3, string4);
        } else if (string4.equals("SPRINKLER LINK TEMPERATURE")) {
            iDevice = this.parseSprinklerLink(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.equals("LINK TEMPERATURE")) {
            iDevice = this.parseHeatDetector(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.equals("spot obscuration") || string4.equals("CHAMBER OBSCURATION")) {
            iDevice = this.parseSmokeDetector(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.equalsIgnoreCase("ASPIRATION")) {
            iDevice = this.parseAspirator(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.equals("CABLE TEMPERATURE")) {
            iDevice = null;
        } else if (string4.startsWith("MASS FLOW") || string4.startsWith("HEAT FLOW") || string4.startsWith("VOLUME FLOW")) {
            iDevice = this.parseFlowMeasurer(fDSParseRecord, fDSParseRecord2, string3, string4);
        } else {
            IQuantity iQuantity = this.parseQuantity(fDSParseRecord, fDSParseRecord2, Intl.intl("Adding to additional records section."), true, false);
            if (iQuantity == null) {
                return false;
            }
            Quantity quantity = iQuantity.get();
            if (iQuantity.equals(Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT")))) {
                iDevice = this.parseSootDensityDevice(fDSParseRecord, fDSParseRecord2, string3);
            } else if (quantity.equals((Object)Quantity.PATH_OBSCURATION)) {
                iDevice = this.parsePathObscurationMeasurer(fDSParseRecord, fDSParseRecord2, string3);
            } else if (quantity.equals((Object)Quantity.LAYER_HEIGHT)) {
                iDevice = this.parseLayerInfoMeasurer(fDSParseRecord, fDSParseRecord2, string3, true, false, false);
            } else if (quantity.equals((Object)Quantity.UPPER_TEMPERATURE)) {
                iDevice = this.parseLayerInfoMeasurer(fDSParseRecord, fDSParseRecord2, string3, false, true, false);
            } else if (quantity.equals((Object)Quantity.LOWER_TEMPERATURE)) {
                iDevice = this.parseLayerInfoMeasurer(fDSParseRecord, fDSParseRecord2, string3, false, false, true);
            } else if (quantity.equals((Object)Quantity.TIME)) {
                iDevice = this.parseClock(fDSParseRecord, fDSParseRecord2, string3);
            } else if (GasPointMeasurer.getQuantityFilter().test(iQuantity.get())) {
                iDevice = this.parseGasPointMeasurer(fDSParseRecord, fDSParseRecord2, string3, iQuantity);
            } else if (SolidPointMeasurer.getQuantityFilter().test(iQuantity.get())) {
                iDevice = this.parseSolidPointMeasurer(fDSParseRecord, fDSParseRecord2, string3, iQuantity);
            } else if (AABoxMeasurer.getQuantityFilter().test(iQuantity.get())) {
                iDevice = this.parseAABoxMeasurer(fDSParseRecord, fDSParseRecord2, string3, iQuantity);
            } else if (HvacDevice.isValidQuantity(iQuantity)) {
                iDevice = this.parseHvacDevc(string4, fDSParseRecord, iQuantity, string3);
            }
        }
        if (iDevice == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Unknown device type encountered."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        boolean bl3 = false;
        if (!bl2 && iDevice instanceof ISignalSource) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (iDevice == Clock.INSTANCE) {
            this.d_pinConns.addOutputName(Clock.INSTANCE.getMsrInfo().getPin(), string3);
        } else {
            int n2;
            if (!(iDevice instanceof Timer) && iDevice instanceof ISignalSink) {
                bl4 = true;
            }
            this.parseCustomFDSProps(iDevice, fDSParseRecord);
            if (string != null && !fDSParseRecord2.empty() && this.getResult().unparsedRecords.contains(fDSParseRecord2) && !this.d_propParser.parseCustomFDSProps(iDevice, fDSParseRecord2)) {
                HashMap<String, String> hashMap = new HashMap<String, String>(iDevice.getCustomFDSProps("DEVC").getProps());
                hashMap.put("PROP_ID", "'" + string + "'");
                iDevice.setCustomFDSProps("DEVC", CustomFDSProps.get(hashMap));
            }
            if ((n2 = this.existsStatus(fDSParseRecord, iDevice, IDevice.class)) != 0) {
                return this.convertToReturn(n2);
            }
            ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
            Integer n3 = fDSParseRecord.getInteger("POINTS", false);
            if (n3 != null && n3 > 1 && fDSParseRecord.contains("XB")) {
                UnitLineSeg3D unitLineSeg3D = DeviceParser.parseLineSeg3D(fDSParseRecord, "DEVC", "XB", true);
                List<UnitPoint3D> object = DeviceParser.splitLineSeg(unitLineSeg3D, n3);
                for (int i = 0; i < n3; ++i) {
                    IDevice iDevice2 = (IDevice)iDevice.clone();
                    iDevice2.setGeom(GeomNodeUtil.newNode(new Point(object.get(i).getPoint3dValue(Geometry.LU))));
                    iDevice2.setName(DeviceParser.formatLinearDeviceArrayName(string3, i + 1));
                    if (bl3) {
                        DeviceParser.markSignalSource(iDevice2, this.d_pinConns);
                    }
                    if (bl4) {
                        DeviceParser.markSignalSink(fDSParseRecord, iDevice2, this.d_pinConns);
                    }
                    arrayList.add(iDevice2);
                }
            } else {
                if (bl3) {
                    DeviceParser.markSignalSource(iDevice, this.d_pinConns);
                }
                if (bl4) {
                    DeviceParser.markSignalSink(fDSParseRecord, iDevice, this.d_pinConns);
                }
                arrayList.add(iDevice);
            }
            for (IDevice iDevice3 : arrayList) {
                this.getContainer().getDevices().add(iDevice3);
                this.flagObjectAdded(iDevice3);
                Set set = this.d_parsedDevices.getOrDefault(fDSParseRecord, new HashSet());
                set.add(iDevice3);
                this.d_parsedDevices.put(fDSParseRecord, set);
            }
        }
        return true;
    }

    private static List<UnitPoint3D> splitLineSeg(UnitLineSeg3D unitLineSeg3D, int n) {
        UnitPoint3D unitPoint3D = unitLineSeg3D.getP1().sub(unitLineSeg3D.getP2());
        Point3d point3d = unitPoint3D.getValue(Geometry.LU);
        point3d.scale(1.0 / (double)(n - 1));
        ArrayList<UnitPoint3D> arrayList = new ArrayList<UnitPoint3D>(n);
        arrayList.add(unitLineSeg3D.getP2());
        UnitPoint3D unitPoint3D2 = unitLineSeg3D.getP2();
        for (int i = 1; i < n - 1; ++i) {
            UnitPoint3D unitPoint3D3 = new UnitPoint3D(unitPoint3D2.x() + point3d.x, unitPoint3D2.y() + point3d.y, unitPoint3D2.z() + point3d.z, unitPoint3D2.getUnit());
            arrayList.add(unitPoint3D3);
            unitPoint3D2 = unitPoint3D3;
        }
        arrayList.add(unitLineSeg3D.getP1());
        return arrayList;
    }

    private static String formatLinearDeviceArrayName(String string, int n) {
        String string2 = string + "-";
        if (n <= 9) {
            string2 = string2 + "0";
        }
        string2 = string2 + n;
        return string2;
    }

    private static void markSignalSource(IDevice iDevice, PinConnParser pinConnParser) {
        ISignalSource iSignalSource = (ISignalSource)((Object)iDevice);
        Iterator<? extends IOutPin> iterator = iSignalSource.getOutputPins().iterator();
        while (iterator.hasNext()) {
            IOutPin iOutPin;
            IOutPin iOutPin2 = iOutPin = iterator.next();
            pinConnParser.addOutputName(iOutPin2, iDevice.getName());
        }
        if (iDevice instanceof Timer) {
            pinConnParser.addOutputName(Clock.INSTANCE.getMsrInfo().getPin(), iDevice.getName());
        }
    }

    private static void markSignalSink(FDSParseRecord fDSParseRecord, IDevice iDevice, PinConnParser pinConnParser) {
        String string;
        String string2;
        if (iDevice instanceof IFreezable) {
            string2 = "NO_UPDATE_DEVC_ID";
            string = "NO_UPDATE_CTRL_ID";
        } else {
            string2 = "DEVC_ID";
            string = "CTRL_ID";
        }
        DeviceParser.markSingleInputForRetrieval(fDSParseRecord, (ISignalSink)((Object)iDevice), pinConnParser, string2, string);
    }

    private IOutPin parseLatch(FDSParseRecord fDSParseRecord, IOutPin iOutPin) {
        boolean bl = fDSParseRecord.getBoolean("LATCH", true);
        if (bl) {
            LatchCtrl latchCtrl = new LatchCtrl();
            if (!latchCtrl.getInputPin().canConnect(iOutPin)) {
                return iOutPin;
            }
            latchCtrl.getInputPin().connect(iOutPin);
            return latchCtrl.getOutputPins().get(0);
        }
        return iOutPin;
    }

    private IOutPin parseInvert(FDSParseRecord fDSParseRecord, IOutPin iOutPin) {
        boolean bl = fDSParseRecord.getBoolean("INITIAL_STATE", true);
        if (bl) {
            NotOp notOp = new NotOp();
            if (!notOp.getInputPin().canConnect(iOutPin)) {
                return iOutPin;
            }
            notOp.getInputPin().connect(iOutPin);
            return notOp.getOutputPins().get(0);
        }
        return iOutPin;
    }

    private IDevice parseAABoxMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, IQuantity iQuantity) throws FDSRecordFormatException {
        UnitAABox unitAABox = DeviceParser.parseAABox(fDSParseRecord, "DEVC", "XB", true);
        AABoxMeasurer aABoxMeasurer = new AABoxMeasurer(string, iQuantity, unitAABox);
        aABoxMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, aABoxMeasurer.getQuantity().get()));
        return aABoxMeasurer;
    }

    private FlowMeasurer parseFlowMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, String string2) throws FDSRecordFormatException {
        Serializable serializable;
        String string3;
        int n;
        String string4 = string2.trim();
        char c = string4.charAt(string4.length() - 1);
        switch (c) {
            case '-': {
                n = 1;
                string3 = string4.substring(0, string4.length() - 1).trim();
                break;
            }
            case '+': {
                n = 0;
                string3 = string4.substring(0, string4.length() - 1).trim();
                break;
            }
            default: {
                n = 2;
                string3 = string4;
            }
        }
        Quantity quantity = this.getQuantityMap().getQuantity(string3);
        if (quantity == null || !FlowMeasurer.getQuantityFilter().test(quantity)) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Invalid flow direction specified."));
        }
        if (quantity.quantityType == QuantityType.SOLID && (serializable = (Integer)fDSParseRecord.get("IOR")) != null) {
            switch ((Integer)serializable) {
                case 0: {
                    n = 2;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    n = 1;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n = 0;
                }
            }
        }
        serializable = this.parseAARectangle(fDSParseRecord);
        FlowMeasurer flowMeasurer = new FlowMeasurer(string, quantity.create(), (AARectangle)serializable, n);
        flowMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, flowMeasurer.getQuantity().get()));
        return flowMeasurer;
    }

    private IDevice parseLayerInfoMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, boolean bl, boolean bl2, boolean bl3) throws FDSRecordFormatException {
        UnitLineSeg3D unitLineSeg3D = DeviceParser.parseLineSeg3D(fDSParseRecord, "DEVC", "XB", true);
        LayerMeasurer layerMeasurer = new LayerMeasurer(string, bl, bl2, bl3, unitLineSeg3D);
        if (bl) {
            layerMeasurer.getHeightInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, layerMeasurer.getHeightInfo().getPin()));
        }
        if (bl2) {
            layerMeasurer.getUpperTempInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, layerMeasurer.getUpperTempInfo().getPin()));
        }
        if (bl3) {
            layerMeasurer.getLowerTempInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, layerMeasurer.getLowerTempInfo().getPin()));
        }
        return layerMeasurer;
    }

    private PathObscurationMeasurer parsePathObscurationMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        UnitLineSeg3D unitLineSeg3D = DeviceParser.parseLineSeg3D(fDSParseRecord, "DEVC", "XB", true);
        PathObscurationMeasurer pathObscurationMeasurer = new PathObscurationMeasurer(string, unitLineSeg3D);
        pathObscurationMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, pathObscurationMeasurer.getQuantity().get()));
        return pathObscurationMeasurer;
    }

    private static AlarmInfo parseAlarm(FDSParseRecord fDSParseRecord, IDoubleOutPin iDoubleOutPin) {
        return DeviceParser.parseAlarm(fDSParseRecord, iDoubleOutPin.getUnitType());
    }

    private static AlarmInfo parseAlarm(FDSParseRecord fDSParseRecord, Quantity quantity) {
        return DeviceParser.parseAlarm(fDSParseRecord, quantity.unitType);
    }

    private static AlarmInfo parseAlarm(FDSParseRecord fDSParseRecord, int n) {
        Double d = fDSParseRecord.getDouble("SETPOINT", false);
        if (d == null) {
            return null;
        }
        Unit unit = SIUS.unit(n);
        UnitDouble unitDouble = new UnitDouble(d, unit);
        return new AlarmInfo(unitDouble, DeviceParser.parseTripFlags(fDSParseRecord));
    }

    private static int parseTripFlags(FDSParseRecord fDSParseRecord) {
        int n = 0;
        if (fDSParseRecord.getBoolean("INITIAL_STATE", true).booleanValue()) {
            n |= 2;
        }
        if (fDSParseRecord.getBoolean("LATCH", true).booleanValue()) {
            n |= 1;
        }
        return n;
    }

    private Aspirator parseAspirator(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("BYPASS_FLOWRATE", true);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        Aspirator aspirator = new Aspirator(string, unitDouble, freePointLoc);
        aspirator.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, aspirator.getQuantity().get()));
        return aspirator;
    }

    private AspiratorSampler parseAspiratorSampler(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        AspiratorSampler aspiratorSampler = new AspiratorSampler(string, freePointLoc);
        aspiratorSampler.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, aspiratorSampler.getQuantity().get()));
        this.d_aspSamplerRecs.add(fDSParseRecord);
        return aspiratorSampler;
    }

    private IDevice parseSootDensityDevice(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        if (fDSParseRecord.contains("FLOWRATE") || fDSParseRecord.contains("DELAY") || fDSParseRecord.contains("DEVC_ID")) {
            return this.parseAspiratorSampler(fDSParseRecord, fDSParseRecord2, string);
        }
        return this.parseGasPointMeasurer(fDSParseRecord, fDSParseRecord2, string, Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT")));
    }

    private IDevice parseClock(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        AlarmInfo alarmInfo = DeviceParser.parseAlarm(fDSParseRecord, Quantity.TIME);
        CustomFDSProps customFDSProps = this.getCustomVals(fDSParseRecord);
        if (customFDSProps == CustomFDSProps.EMPTY && PropParser.isDefaultProp(fDSParseRecord2) && fDSParseRecord.getString("NO_UPDATE_CTRL_ID") == null && fDSParseRecord.getString("NO_UPDATE_DEVC_ID") == null) {
            if (alarmInfo == null) {
                return Clock.INSTANCE;
            }
            Timer timer = new Timer(string, alarmInfo.setpoint, TripFlags.initiallyOn(alarmInfo.tripFlags));
            return timer;
        }
        return this.parseGasPointMeasurer(fDSParseRecord, fDSParseRecord2, string, Quantity.TIME.create());
    }

    private void consumeProps(IDevice iDevice, FDSParseRecord fDSParseRecord) {
        if (!PropParser.isDefaultProp(fDSParseRecord)) {
            boolean bl = this.d_propParser.parseCustomFDSProps(iDevice, fDSParseRecord);
            assert (bl);
            this.getResult().unparsedRecords.remove(fDSParseRecord);
        }
    }

    private IDevice parseGasPointMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, IQuantity iQuantity) throws FDSRecordFormatException {
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        if (iQuantity.get().equals((Object)Quantity.THERMOCOUPLE)) {
            Thermocouple thermocouple = new Thermocouple(string, fDSParseRecord2.getUnitDouble("BEAD_DIAMETER", true), fDSParseRecord2.getDouble("BEAD_EMISSIVITY", true), fDSParseRecord2.getUnitDouble("BEAD_DENSITY", true), fDSParseRecord2.getUnitDouble("BEAD_SPECIFIC_HEAT", true), freePointLoc);
            thermocouple.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, thermocouple.getQuantity().get()));
            this.consumeProps(thermocouple, fDSParseRecord2);
            return thermocouple;
        }
        GasPointMeasurer gasPointMeasurer = new GasPointMeasurer(string, iQuantity, freePointLoc);
        gasPointMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, gasPointMeasurer.getQuantity().get()));
        return gasPointMeasurer;
    }

    private IDevice parseSolidPointMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, IQuantity iQuantity) throws FDSRecordFormatException {
        SolidPointMeasurer solidPointMeasurer;
        AttachedPointLoc attachedPointLoc = this.parseAttachedPointLoc(fDSParseRecord);
        if (iQuantity.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE)) {
            solidPointMeasurer = new InnerTempMeasurer(string, fDSParseRecord.getUnitDouble("DEPTH", true), attachedPointLoc);
        } else if (iQuantity.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
            solidPointMeasurer = new PressureCoeffMeasurer(string, fDSParseRecord2.getUnitDouble("CHARACTERISTIC_VELOCITY", true), attachedPointLoc);
            this.consumeProps(solidPointMeasurer, fDSParseRecord2);
        } else if (iQuantity.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
            solidPointMeasurer = new GaugeHeatFluxMeasurer(string, fDSParseRecord2.getUnitDouble("GAUGE_TEMPERATURE", true), fDSParseRecord2.getDouble("GAUGE_EMISSIVITY", true), attachedPointLoc);
            this.consumeProps(solidPointMeasurer, fDSParseRecord2);
        } else {
            solidPointMeasurer = SolidDensityMeasurer.getQuantityFilter().test(iQuantity.get()) ? new SolidDensityMeasurer(string, (ObjectQuantity)iQuantity, fDSParseRecord.getUnitDouble("DEPTH", true), attachedPointLoc) : new SolidPointMeasurer(string, iQuantity, attachedPointLoc);
        }
        solidPointMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, solidPointMeasurer.getQuantity().get()));
        return solidPointMeasurer;
    }

    private ASprayer parseSprayer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, String string2) throws FDSRecordFormatException {
        if (string2.equals("SPRINKLER LINK TEMPERATURE")) {
            return this.parseSprinkler(fDSParseRecord, fDSParseRecord2, string);
        }
        if (string2.equals("CONTROL")) {
            return this.parseGenericNozzle(fDSParseRecord, fDSParseRecord2, string);
        }
        return this.parseMeasuringNozzle(fDSParseRecord, fDSParseRecord2, string);
    }

    private Sprinkler parseSprinkler(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SprinklerLinkModel sprinklerLinkModel = this.d_propParser.parseSprinklerLinkModel(fDSParseRecord2);
        SprayModel sprayModel = this.d_propParser.parseSprayModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        Sprinkler.TraditionalModel traditionalModel = new Sprinkler.TraditionalModel(sprinklerLinkModel, fDSParseRecord.getBoolean("INITIAL_STATE", true), fDSParseRecord.getBoolean("LATCH", true));
        Sprinkler sprinkler = new Sprinkler(string, sprayModel, traditionalModel, freePointLoc);
        return sprinkler;
    }

    private Nozzle parseGenericNozzle(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        return new Nozzle(string, sprayModel, freePointLoc);
    }

    private ASprayer parseMeasuringNozzle(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(fDSParseRecord2);
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, fDSParseRecord2, "", false, false);
        if (iQuantity == null || !Sprinkler.QuantityModel.getQuantityFilter().test(iQuantity.get())) {
            return null;
        }
        Double d = (Double)fDSParseRecord.get("SETPOINT", true);
        if (d == null) {
            return null;
        }
        UnitDouble unitDouble = new UnitDouble(d, SIUS.unit(iQuantity.get().unitType));
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        Sprinkler.QuantityModel quantityModel = new Sprinkler.QuantityModel(iQuantity, unitDouble, fDSParseRecord.getBoolean("INITIAL_STATE", true), fDSParseRecord.getBoolean("LATCH", true));
        Sprinkler sprinkler = new Sprinkler(string, sprayModel, quantityModel, freePointLoc);
        return sprinkler;
    }

    private SprinklerLink parseSprinklerLink(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SprinklerLinkModel sprinklerLinkModel = this.d_propParser.parseSprinklerLinkModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        SprinklerLink sprinklerLink = new SprinklerLink(string, sprinklerLinkModel, freePointLoc);
        sprinklerLink.setTripFlags(DeviceParser.parseTripFlags(fDSParseRecord));
        return sprinklerLink;
    }

    private IDetector parseSmokeDetector(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SmokeLinkModel smokeLinkModel = this.d_propParser.parseSmokeLinkModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        SmokeDetector smokeDetector = new SmokeDetector(string, smokeLinkModel, freePointLoc);
        smokeDetector.setTripFlags(DeviceParser.parseTripFlags(fDSParseRecord));
        return smokeDetector;
    }

    private IDetector parseHeatDetector(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        HeatLinkModel heatLinkModel = this.d_propParser.parseHeatLinkModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        HeatDetector heatDetector = new HeatDetector(string, heatLinkModel, freePointLoc);
        heatDetector.setTripFlags(DeviceParser.parseTripFlags(fDSParseRecord));
        return heatDetector;
    }

    private IDevice parseHvacDevc(String string, FDSParseRecord fDSParseRecord, IQuantity iQuantity, String string2) throws FDSRecordFormatException {
        boolean bl = false;
        boolean bl2 = false;
        for (Class<? extends IPyroObject> clazz : iQuantity.get().requiredTypes) {
            if (HvacDuct.class.isAssignableFrom(clazz)) {
                bl = true;
            }
            if (!HvacNode.class.isAssignableFrom(clazz)) continue;
            bl2 = true;
        }
        if (bl) {
            return new DuctDevice(string2, iQuantity);
        }
        if (bl2) {
            return new NodeDevice(string2, iQuantity);
        }
        return null;
    }

    private AARectangle parseAARectangle(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitPoint3D[] unitPoint3DArray = DeviceParser.parseXB(fDSParseRecord, "DEVC", "XB", true);
        if (unitPoint3DArray[0].x() == unitPoint3DArray[1].x()) {
            return new AARectangle(0, unitPoint3DArray[0].x(), unitPoint3DArray[0].y(), unitPoint3DArray[0].z(), unitPoint3DArray[1].y(), unitPoint3DArray[1].z(), false);
        }
        if (unitPoint3DArray[0].y() == unitPoint3DArray[1].y()) {
            return new AARectangle(1, unitPoint3DArray[0].y(), unitPoint3DArray[0].x(), unitPoint3DArray[0].z(), unitPoint3DArray[1].x(), unitPoint3DArray[1].z(), false);
        }
        if (unitPoint3DArray[0].z() == unitPoint3DArray[1].z()) {
            return new AARectangle(2, unitPoint3DArray[0].z(), unitPoint3DArray[0].x(), unitPoint3DArray[0].y(), unitPoint3DArray[1].x(), unitPoint3DArray[1].y(), false);
        }
        throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("XB must specify a plane."));
    }

    private FreePointLoc parseFreePointLoc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitPoint3D unitPoint3D = DeviceParser.parseLoc(fDSParseRecord, "DEVC", "XYZ", false, false);
        if (unitPoint3D == null) {
            unitPoint3D = DeviceParser.parseLineSeg3D(fDSParseRecord, "DEVC", "XB", true).getP1();
        }
        Point point = new Point(unitPoint3D.getPoint3dValue(Geometry.LU));
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("ROTATION", true);
        FDSArray fDSArray = fDSParseRecord.getArray("ORIENTATION", true);
        Vector3d vector3d = new Vector3d((Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2));
        return new FreePointLoc(point, vector3d, unitDouble);
    }

    private AttachedPointLoc parseAttachedPointLoc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitPoint3D unitPoint3D = DeviceParser.parseLoc(fDSParseRecord, "DEVC", "XYZ", true);
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("ROTATION", true);
        Integer n = (Integer)fDSParseRecord.get("IOR");
        Vector3d vector3d = null;
        if (n == null) {
            FDSArray fDSArray = fDSParseRecord.getArray("ORIENTATION", true);
            vector3d = new Vector3d((Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2));
        } else {
            vector3d = GeomUtil.toWorldVec(n);
        }
        return new AttachedPointLoc(unitPoint3D, vector3d, unitDouble);
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        for (Map.Entry<FDSParseRecord, Set<IDevice>> entry : this.d_parsedDevices.entrySet()) {
            FDSParseRecord fDSParseRecord = entry.getKey();
            for (IDevice iDevice : entry.getValue()) {
                if (!(iDevice instanceof ISignalSink) || !Util.isCycle((ISignalSink)((Object)iDevice))) continue;
                this.addWarning(new FDSParseWarning(fDSParseRecord, Intl.intl("Device activation includes a cyclic definition."), String.format(Intl.intl("Activation inputs removed from device %s."), iDevice.getName())));
                ((ISignalSink)((Object)iDevice)).getInputPin().disconnectAll();
            }
        }
    }
}

