/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.AIntCompareOp;
import pyrosim.domain.controls.AndOp;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DblGreaterThanOp;
import pyrosim.domain.controls.DblLessThanOp;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.IntEqualOp;
import pyrosim.domain.controls.IntGreaterThanOp;
import pyrosim.domain.controls.IntLessThanOp;
import pyrosim.domain.controls.IntNotEqualOp;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.NotOp;
import pyrosim.domain.controls.OrOp;
import pyrosim.domain.controls.SumOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.simctrl.ASimCtrlDevice;
import pyrosim.domain.devices.simctrl.KillDevice;
import pyrosim.domain.devices.simctrl.RestartFileDevc;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class ControlParser
extends AFDS6Parser {
    private final PinConnParser d_pinConns;
    private final List<IControl> d_doubleInCtrls;

    public ControlParser(FDS6ParsingInfo fDS6ParsingInfo, PinConnParser pinConnParser) {
        super(fDS6ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_doubleInCtrls = new ArrayList<IControl>();
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("CTRL");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("CONSTANT", "UNSUPPORTED");
        map.put("DIFFERENTIAL_GAIN", "UNSUPPORTED");
        map.put("EVACUATION", "UNSUPPORTED");
        map.put("INTEGRAL_GAIN", "UNSUPPORTED");
        map.put("PROPORTIONAL_GAIN", "UNSUPPORTED");
        map.put("TARGET_VALUE", "UNSUPPORTED");
        map.put("TRIP_DIRECTION", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        IControl iControl;
        String string = (String)fDSParseRecord.get("ID");
        if (string == null || string.trim().equals("")) {
            this.addWarning(fDSParseRecord, Intl.intl("Control has no ID."), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (this.d_pinConns.outputNameExists(string)) {
            this.addWarning(fDSParseRecord, Intl.intl("CTRL ID is not unique across all controls and devices."), Intl.intl("Ignoring control."));
            return true;
        }
        String string2 = (String)fDSParseRecord.get("FUNCTION_TYPE");
        if (string2 == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Control has no function type specified."), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (string2.equals("KILL") || string2.equals("RESTART")) {
            ASimCtrlDevice aSimCtrlDevice = string2.equals("KILL") ? this.parseKill(fDSParseRecord, string) : this.parseRestart(fDSParseRecord, string);
            this.markInputRetrieval(fDSParseRecord, aSimCtrlDevice);
            this.getContainer().getDevices().add(aSimCtrlDevice);
            this.flagObjectAdded(aSimCtrlDevice);
            int n = this.existsStatus(fDSParseRecord, aSimCtrlDevice, IDevice.class);
            if (n != 0) {
                return this.convertToReturn(n);
            }
            this.getContainer().getDevices().add(aSimCtrlDevice);
            this.flagObjectAdded(aSimCtrlDevice);
            return true;
        }
        if (string2.equals("ANY")) {
            iControl = this.parseAny(fDSParseRecord);
        } else if (string2.equals("ALL")) {
            iControl = this.parseAll(fDSParseRecord);
        } else if (string2.equals("ONLY")) {
            iControl = this.parseOnly(fDSParseRecord);
        } else if (string2.equals("AT_LEAST")) {
            iControl = this.parseAtLeast(fDSParseRecord);
        } else if (string2.equals("TIME_DELAY")) {
            iControl = this.parseTimeDelay(fDSParseRecord);
        } else if (string2.equals("CUSTOM")) {
            iControl = this.parseCustom(fDSParseRecord);
        } else if (string2.equals("DEADBAND")) {
            iControl = this.parseDeadBand(fDSParseRecord);
        } else {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Unknown control function type, %s."), string2), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (iControl != null) {
            iControl.setName(string);
            this.d_pinConns.addOutputName(iControl.getOutputPins().get(0), string);
        }
        return true;
    }

    public void finish() throws FDSRecordFormatException {
        for (IControl iControl : this.d_doubleInCtrls) {
            IDoubleInPin iDoubleInPin = (IDoubleInPin)iControl.getInputPin();
            iDoubleInPin.changeInputUnits(SIUS.getInstance());
        }
    }

    private RestartFileDevc parseRestart(FDSParseRecord fDSParseRecord, String string) {
        return new RestartFileDevc(string);
    }

    private KillDevice parseKill(FDSParseRecord fDSParseRecord, String string) {
        return new KillDevice(string);
    }

    private IControl parseDeadBand(FDSParseRecord fDSParseRecord) {
        int n;
        String string = (String)fDSParseRecord.get("ON_BOUND", true);
        if (string.equals("LOWER")) {
            n = 0;
        } else if (string.equals("UPPER")) {
            n = 1;
        } else {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Unknown on-bound, %s."), string), Intl.intl("Adding control to additional records."));
            return null;
        }
        if (!fDSParseRecord.contains("SETPOINT")) {
            this.addWarning(fDSParseRecord, Intl.intl("Deadband control has no setpoint."), Intl.intl("Adding control to additional records."));
            return null;
        }
        FDSArray fDSArray = fDSParseRecord.getArray("SETPOINT", true);
        DeadbandCtrl deadbandCtrl = new DeadbandCtrl(n, new UnitDouble((Double)fDSArray.get(0), Unit.ONE), new UnitDouble((Double)fDSArray.get(1), Unit.ONE));
        this.markInputRetrieval(fDSParseRecord, deadbandCtrl);
        this.d_doubleInCtrls.add(deadbandCtrl);
        return this.parseInvertAndLatch(fDSParseRecord, deadbandCtrl);
    }

    private IControl parseCustom(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        AControl aControl;
        String string = (String)fDSParseRecord.get("RAMP_ID");
        if (string == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Custom control has no ramp function."));
        }
        IRampInput iRampInput = new IRampInput(){
            private static final long serialVersionUID = -9176306205357962471L;

            @Override
            public String getName() {
                return "";
            }

            @Override
            public int getUnitType() {
                return 28;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        };
        Ramp ramp = this.getParsingInfo().getRamp(string, iRampInput, 28, false);
        if (ramp == null) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Could not find ramp with id, %s."), string));
        }
        Pair<List<UnitDouble>, Boolean> pair = this.parseCustomRamp(ramp);
        if (((List)pair.v1).isEmpty()) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Custom ramp %s for control contains no zero-crossings."), string), Intl.intl("Unused time entries from ramp dropped."));
        }
        if (((List)pair.v1).size() == 1) {
            UnitDouble unitDouble = (UnitDouble)((List)pair.v1).iterator().next();
            aControl = (Boolean)pair.v2 != false ? new DblLessThanOp(unitDouble) : new DblGreaterThanOp(unitDouble);
        } else {
            aControl = new CustomCtrl((boolean)((Boolean)pair.v2), (Collection)pair.v1);
        }
        this.markInputRetrieval(fDSParseRecord, aControl);
        this.d_doubleInCtrls.add(aControl);
        return aControl;
    }

    private Pair<List<UnitDouble>, Boolean> parseCustomRamp(Ramp ramp) {
        Object object;
        List<Ramp.Entry> list = ramp.getRecords();
        if (list.isEmpty()) {
            return new Pair<List<UnitDouble>, Boolean>(new ArrayList(), false);
        }
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
        for (Ramp.Entry entry : list) {
            object = entry.t;
            treeMap.put(((UnitDouble)object).getValueNoUnit(), entry.f.getValueNoUnit());
        }
        ArrayList arrayList = new ArrayList();
        boolean bl = (Double)treeMap.values().iterator().next() >= 0.0;
        object = treeMap.entrySet().iterator();
        Map.Entry entry = (Map.Entry)object.next();
        while (object.hasNext()) {
            Map.Entry entry2 = (Map.Entry)object.next();
            if ((Double)entry2.getValue() < 0.0 && (Double)entry.getValue() >= 0.0 || (Double)entry2.getValue() >= 0.0 && (Double)entry.getValue() < 0.0) {
                double d = ((Double)entry2.getValue() - (Double)entry.getValue()) / ((Double)entry2.getKey() - (Double)entry.getKey());
                double d2 = (Double)entry2.getValue() - d * (Double)entry2.getKey();
                double d3 = -d2 / d;
                arrayList.add(new UnitDouble(d3, Unit.ONE));
            }
            entry = entry2;
        }
        return new Pair<Object, Boolean>(arrayList, bl);
    }

    private IControl parseTimeDelay(FDSParseRecord fDSParseRecord) {
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("DELAY", true);
        TimeDelayCtrl timeDelayCtrl = new TimeDelayCtrl(unitDouble);
        this.markInputRetrieval(fDSParseRecord, timeDelayCtrl);
        return this.parseInvertAndLatch(fDSParseRecord, timeDelayCtrl);
    }

    private IControl parseAll(FDSParseRecord fDSParseRecord) {
        AndOp andOp = new AndOp();
        this.markInputRetrieval(fDSParseRecord, andOp);
        return this.parseInvertAndLatch(fDSParseRecord, andOp);
    }

    private IControl parseAny(FDSParseRecord fDSParseRecord) {
        OrOp orOp = new OrOp();
        this.markInputRetrieval(fDSParseRecord, orOp);
        return this.parseInvertAndLatch(fDSParseRecord, orOp);
    }

    private IControl parseAtLeast(FDSParseRecord fDSParseRecord) {
        SumOp sumOp = new SumOp();
        this.markInputRetrieval(fDSParseRecord, sumOp);
        boolean bl = (Boolean)fDSParseRecord.get("INITIAL_STATE", true);
        int n = fDSParseRecord.getInteger("N", true);
        AIntCompareOp aIntCompareOp = bl ? new IntLessThanOp(n) : new IntGreaterThanOp(n - 1);
        aIntCompareOp.getInputPin().connect(sumOp.getOutputPins().get(0));
        return this.parseLatch(fDSParseRecord, aIntCompareOp);
    }

    private IControl parseOnly(FDSParseRecord fDSParseRecord) {
        SumOp sumOp = new SumOp();
        this.markInputRetrieval(fDSParseRecord, sumOp);
        boolean bl = (Boolean)fDSParseRecord.get("INITIAL_STATE", true);
        int n = (Integer)fDSParseRecord.get("N", true);
        AIntCompareOp aIntCompareOp = bl ? new IntNotEqualOp(n) : new IntEqualOp(n);
        aIntCompareOp.getInputPin().connect(sumOp.getOutputPins().get(0));
        return this.parseLatch(fDSParseRecord, aIntCompareOp);
    }

    private IControl parseInvertAndLatch(FDSParseRecord fDSParseRecord, IControl iControl) {
        return this.parseInvert(fDSParseRecord, this.parseLatch(fDSParseRecord, iControl));
    }

    private IControl parseLatch(FDSParseRecord fDSParseRecord, IControl iControl) {
        boolean bl = fDSParseRecord.getBoolean("LATCH", true);
        if (bl) {
            LatchCtrl latchCtrl = new LatchCtrl();
            latchCtrl.getInputPin().connect(iControl.getOutputPins().get(0));
            return latchCtrl;
        }
        return iControl;
    }

    private IControl parseInvert(FDSParseRecord fDSParseRecord, IControl iControl) {
        boolean bl = fDSParseRecord.getBoolean("INITIAL_STATE", true);
        if (bl) {
            NotOp notOp = new NotOp();
            notOp.getInputPin().connect(iControl.getOutputPins().get(0));
            return notOp;
        }
        return iControl;
    }

    private void markInputRetrieval(FDSParseRecord fDSParseRecord, ISignalSink iSignalSink) {
        List<String> list = fDSParseRecord.getList("INPUT_ID", false);
        this.d_pinConns.markInputForRetrieval(fDSParseRecord, iSignalSink.getInputPin(), list);
    }
}

