/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PropParser;
import thunderheadeng.units.UnitDouble;

public class BoundaryParser
extends AFDS6Parser {
    private final Set<IQuantity> d_measurements = new LinkedHashSet<IQuantity>();
    private final PropParser d_propParser;

    public BoundaryParser(FDS6ParsingInfo fDS6ParsingInfo, PropParser propParser) {
        super(fDS6ParsingInfo);
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("BNDF");
    }

    @Override
    public void getUnsupportedFields(String string, Map<String, String> map) {
        map.put("CELL_CENTERED", "UNSUPPORTED");
        map.put("STATISTICS", "UNSUPPORTED");
    }

    @Override
    public void done() throws FDSRecordFormatException {
        if (this.d_measurements.isEmpty()) {
            return;
        }
        Boundaries boundaries = this.getContainer().getBoundaryOutput();
        this.d_measurements.addAll(boundaries.getQuantities());
        boundaries.setQuantities(this.d_measurements);
        this.flagObjectAdded(boundaries);
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, 16, Intl.intl("BNDF record ignored"), true, false);
        if (iQuantity == null) {
            return false;
        }
        this.d_measurements.add(iQuantity);
        FDSParseRecord fDSParseRecord2 = null;
        String string = (String)fDSParseRecord.get("PROP_ID");
        if (string != null && (fDSParseRecord2 = this.d_propParser.getProp(string)) == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find PROP record: %s"), string), Intl.intl("Ignoring properties."));
        }
        if (fDSParseRecord2 == null) {
            fDSParseRecord2 = PropParser.getDefaultProp();
        }
        if (iQuantity.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord2.get("CHARACTERISTIC_VELOCITY", true);
            this.getContainer().getBoundaryOutput().setPressCoeffCharVel(unitDouble);
            this.getResult().unparsedRecords.remove(fDSParseRecord2);
        } else if (iQuantity.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord2.get("GAUGE_TEMPERATURE", true);
            this.getContainer().getBoundaryOutput().setGaugeTemperature(unitDouble);
            double d = fDSParseRecord2.getDouble("GAUGE_EMISSIVITY", true);
            this.getContainer().getBoundaryOutput().setGaugeEmissivty(d);
            this.getResult().unparsedRecords.remove(fDSParseRecord2);
        }
        return true;
    }
}

