/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.util.Util;

public abstract class AFDSObjParser
extends AFDS6Parser {
    private int d_nextObjNum = 1;
    private Map<String, Object> d_compositesMap = new LinkedHashMap<String, Object>();

    public AFDSObjParser(FDS6ParsingInfo fDS6ParsingInfo) {
        super(fDS6ParsingInfo);
    }

    protected String generateName(FDSParseRecord fDSParseRecord, String string, String string2) {
        String string3;
        if (string != null && (string3 = fDSParseRecord.getString(string)) != null && !string3.isEmpty()) {
            return string3;
        }
        string3 = fDSParseRecord.getComment();
        if (string3 == null || string3.equals("")) {
            string3 = String.format(Intl.intl("%1$s #%2$d"), string2, this.d_nextObjNum++);
        }
        return string3;
    }

    protected void addObjects(String string, List<? extends IPyroObject> list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.size() == 1) {
            this.addObject(list.get(0));
        } else {
            ModelComposite modelComposite = new ModelComposite(string);
            modelComposite.addAll(list);
            this.addObject(modelComposite);
        }
    }

    protected void addObject(IPyroObject iPyroObject) {
        String string = Util.getName(iPyroObject);
        Object object = this.d_compositesMap.get(string);
        if (object != null) {
            if (object instanceof List) {
                ((List)object).add(iPyroObject);
            } else {
                ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
                arrayList.add((IPyroObject)object);
                arrayList.add(iPyroObject);
                this.d_compositesMap.put(string, arrayList);
            }
        } else {
            this.d_compositesMap.put(string, iPyroObject);
        }
    }

    @Override
    public void done() throws FDSRecordFormatException {
        ModelComposite modelComposite = this.getContainer().getObstructions();
        for (Map.Entry<String, Object> entry : this.d_compositesMap.entrySet()) {
            Object object;
            Object object2 = entry.getValue();
            if (object2 instanceof IPyroObject) {
                object = (IPyroObject)object2;
                modelComposite.add((IPyroObject)object);
                this.flagObjectAdded((IPyroObject)object);
                continue;
            }
            assert (object2 instanceof List);
            object = (List)object2;
            ModelComposite modelComposite2 = new ModelComposite(entry.getKey());
            modelComposite2.addAll((Collection<IPyroObject>)object);
            modelComposite.add(modelComposite2);
            this.flagObjectAdded(modelComposite2);
        }
    }

    protected Surface getDefaultMat() {
        return this.getContainer().getSimParams().getMisc().getSurfDefault();
    }

    protected Surface getSurfaceSafe(FDSParseRecord fDSParseRecord, String string, Predicate<Surface> predicate) throws FDSRecordFormatException {
        if (string == null) {
            return this.getDefaultMat();
        }
        Surface surface = this.findObject(Surface.class, string);
        if (surface == null) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("The SURF, %s, does not exist in the model."), string));
        }
        if (!predicate.test(surface)) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("The SURF, %1$s, cannot be applied to the %2$s."), string, fDSParseRecord.getType()));
        }
        return surface;
    }

    protected EvacProps parseEvac(FDSParseRecord fDSParseRecord, String string, String string2) throws FDSRecordFormatException {
        int n = 0;
        Boolean bl = fDSParseRecord.getBoolean("EVACUATION");
        if (bl == null) {
            n = 0;
        } else if (bl.booleanValue()) {
            n = 2;
        } else if (!bl.booleanValue()) {
            n = 1;
        }
        Grid grid = null;
        if (fDSParseRecord.contains("MESH_ID")) {
            grid = this.findObject(fDSParseRecord, Grid.class, fDSParseRecord.getString("MESH_ID"), true);
        }
        return grid == null && n == 0 ? EvacProps.DEFAULT : EvacProps.get(n, grid);
    }
}

