/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.IFDSRecordParser;
import pyrosim.io.fds.v6.FDS6Colors;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.Multiplier;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitLineSeg3D;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;

public abstract class AFDS6Parser
implements IFDSRecordParser {
    protected static final int VALID = 0;
    protected static final int IGNORE = 1;
    protected static final int ADDITIONAL_RECORD = 2;
    protected static final Color INVISIBLE_COLOR = new InvsColor();
    private FDS6ParsingInfo d_parsingInfo;
    protected static final int NAMEOPT_WARN_EMPTY = 1;

    public AFDS6Parser(FDS6ParsingInfo fDS6ParsingInfo) {
        this.d_parsingInfo = fDS6ParsingInfo;
    }

    @Override
    public void process(Collection<FDSParseRecord> collection, Collection<FDSParseRecord> collection2) throws FDSRecordFormatException {
        for (FDSParseRecord fDSParseRecord : collection) {
            boolean bl = false;
            try {
                bl = this.process(fDSParseRecord);
            }
            catch (FDSRecordFormatException fDSRecordFormatException) {
                throw fDSRecordFormatException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new FDSRecordFormatException(fDSParseRecord);
            }
            if (bl) continue;
            collection2.add(fDSParseRecord);
        }
        this.done();
    }

    protected abstract boolean process(FDSParseRecord var1) throws FDSRecordFormatException;

    protected void done() throws FDSRecordFormatException {
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
    }

    public PyroMod getContainer() {
        return this.d_parsingInfo.getContainer();
    }

    public FDS6ParsingInfo getParsingInfo() {
        return this.d_parsingInfo;
    }

    protected FDSParseResult getResult() {
        return this.d_parsingInfo.getParseResult();
    }

    public boolean isNameUsed(Class<?> clazz, String string) {
        return this.getNames(clazz).isRegistered(string);
    }

    public NameGenerator getNames(Class<?> clazz) {
        return this.d_parsingInfo.getNames(clazz);
    }

    public String getValidName(FDSParseRecord fDSParseRecord, String string, Class<?> clazz) {
        String string2 = fDSParseRecord.getString(string);
        if (string2 == null || string2.trim().isEmpty()) {
            string2 = this.getNames(clazz).generateName();
        }
        return string2;
    }

    private static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    protected String parseName(FDSParseRecord fDSParseRecord, String string, Class<?> clazz) {
        return this.parseName(fDSParseRecord, string, clazz, 0);
    }

    protected String parseName(FDSParseRecord fDSParseRecord, String string, Class<?> clazz, int n) {
        String string2 = fDSParseRecord.getString(string);
        if (string2 == null || string2.isEmpty()) {
            string2 = this.getNames(clazz).generateName();
            if (AFDS6Parser.test(n, 1)) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s missing ID."), fDSParseRecord.getType()), String.format(Intl.intl("Setting ID to %s."), string2));
            }
            return string2;
        }
        NameGenerator nameGenerator = this.getNames(clazz);
        String string3 = nameGenerator.generateValidName(string2);
        if (!string3.equals(string2)) {
            this.getParsingInfo().addAlias(clazz, string2, string3);
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), fDSParseRecord.getType(), string2), String.format(Intl.intl("Renaming to \"%s\". Conflicting references now point to \"%s\"."), string3, string3));
        }
        return string3;
    }

    public void autoRename(INamed iNamed) {
        String string = this.getNames(iNamed.getClass()).generateValidName(iNamed.getName());
        iNamed.setName(string);
    }

    public void flagObjectAdded(IPyroObject iPyroObject) {
        this.d_parsingInfo.getParseResult().extractedObjs.add(iPyroObject);
        if (iPyroObject instanceof INamed) {
            this.d_parsingInfo.getNames(iPyroObject.getClass()).registerName(((INamed)iPyroObject).getName());
        }
    }

    public void flagObjectsAdded(Collection<? extends IPyroObject> collection) {
        for (IPyroObject iPyroObject : collection) {
            this.flagObjectAdded(iPyroObject);
        }
    }

    public void flagEvac() {
        this.getContainer().setEvacEnabled(true);
    }

    public void addWarning(FDSParseWarning fDSParseWarning) {
        this.d_parsingInfo.addWarning(fDSParseWarning);
    }

    public void addWarning(FDSParseRecord fDSParseRecord, String string, String string2) {
        this.d_parsingInfo.addWarning(new FDSParseWarning(fDSParseRecord, string, string2));
    }

    public QuantityMap getQuantityMap() {
        return this.d_parsingInfo.getQuantityMap();
    }

    public IQuantity parseQuantity(FDSParseRecord fDSParseRecord, String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, boolean bl, boolean bl2) throws FDSRecordFormatException {
        try {
            IQuantity iQuantity = this.getQuantityMap().parseQuantity(this.getParsingInfo(), fDSParseRecord, string, string2, string3, string4, string5, string6, bl);
            if (iQuantity != null && !QuantityUtil.canOutputAll(iQuantity.get(), n)) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Quantity %s is invalid for output."), fDSParseRecord.getString(string)), string7);
                return null;
            }
            return iQuantity;
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            if (bl2) {
                throw fDSRecordFormatException;
            }
            this.addWarning(fDSParseRecord, fDSRecordFormatException.getError(), string7);
            return null;
        }
    }

    protected Color parseColor(FDSParseRecord fDSParseRecord, String string, String string2, String string3, boolean bl) {
        return AFDS6Parser.parseColor(this.getParsingInfo(), fDSParseRecord, string, string2, string3, bl);
    }

    protected static Color parseColor(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, String string, String string2, String string3, boolean bl) {
        FDSArray fDSArray;
        Color color = null;
        if (string != null && fDSParseRecord.contains(string)) {
            fDSArray = fDSParseRecord.getArray(string, false);
            color = AFDS6Parser.interpColor(fDSParsingInfo, fDSParseRecord, (Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2));
        } else if (string2 != null && fDSParseRecord.contains(string2)) {
            fDSArray = (String)fDSParseRecord.get(string2);
            if (((String)((Object)fDSArray)).equals("INVISIBLE")) {
                return INVISIBLE_COLOR;
            }
            color = FDS6Colors.getColor(fDSArray);
            if (color == null) {
                fDSParsingInfo.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a valid FDS color name."), fDSArray), String.format(Intl.intl("Using default color."), new Object[0]));
            }
        }
        if (color == null) {
            if (!bl) {
                return null;
            }
            fDSArray = fDSParseRecord.getArray(string, true);
            if (fDSArray != null) {
                color = AFDS6Parser.interpColor(fDSParsingInfo, fDSParseRecord, (Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2));
            } else {
                String string4 = (String)fDSParseRecord.get(string2, true);
                if (string4 != null) {
                    color = FDS6Colors.getColor(string4);
                }
            }
        }
        int n = 255;
        if (string3 != null && fDSParseRecord.contains(string3)) {
            n = (int)((Double)fDSParseRecord.get(string3) * 255.0);
        }
        if (color == null) {
            return new Color(128, 128, 128, n);
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    private static Color interpColor(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, double d, double d2, double d3) {
        if (0.0 < d && d < 1.0 || 0.0 < d2 && d2 < 1.0 || 0.0 < d3 && d3 < 1.0) {
            fDSParsingInfo.addWarning(fDSParseRecord, Intl.intl("Old-style RGB value detected."), Intl.intl("Converted to new range [0...255]."));
            return new Color((float)d, (float)d2, (float)d3);
        }
        return new Color((int)d, (int)d2, (int)d3);
    }

    protected <T extends IPyroGeomSrc> Pair<String, List<T>> applyMult(FDSParseRecord fDSParseRecord, String string, T t) {
        Object object;
        String string2 = fDSParseRecord.getString(string, false);
        if (string2 != null) {
            object = this.getParsingInfo().getMultiplier(string2);
            if (object == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find MULT record, \"%s\""), string2), String.format(Intl.intl("Ignoring MULT and adding %s as defined."), fDSParseRecord.getType()));
            } else {
                return ((Multiplier)object).applyTo(t);
            }
        }
        object = t instanceof INamed ? ((INamed)((Object)t)).getName() : "";
        return new Pair<Object, List<IPyroGeomSrc>>(object, Arrays.asList(t));
    }

    protected static AABoxGeom parseXBGeom(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        UnitPoint3D[] unitPoint3DArray = AFDS6Parser.parseXB(fDSParseRecord, string, string2, bl);
        if (unitPoint3DArray == null) {
            return null;
        }
        return new AABoxGeom(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU), 0);
    }

    protected static UnitPoint3D[] parseXB(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        FDSArray fDSArray = null;
        if (fDSParseRecord.contains(string2)) {
            fDSArray = fDSParseRecord.getArray(string2, true);
        }
        if (fDSArray == null) {
            if (bl) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("%s must specify geometry."), string));
            }
            return null;
        }
        UnitPoint3D unitPoint3D = new UnitPoint3D((UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(2), (UnitDouble)fDSArray.get(4));
        UnitPoint3D unitPoint3D2 = new UnitPoint3D((UnitDouble)fDSArray.get(1), (UnitDouble)fDSArray.get(3), (UnitDouble)fDSArray.get(5));
        return new UnitPoint3D[]{unitPoint3D, unitPoint3D2};
    }

    protected static UnitAABox parseAABox(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        UnitPoint3D[] unitPoint3DArray = AFDS6Parser.parseXB(fDSParseRecord, string, string2, bl);
        if (unitPoint3DArray == null) {
            return null;
        }
        return new UnitAABox(unitPoint3DArray[0], unitPoint3DArray[1]);
    }

    protected static UnitLineSeg3D parseLineSeg3D(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        UnitPoint3D[] unitPoint3DArray = AFDS6Parser.parseXB(fDSParseRecord, string, string2, bl);
        if (unitPoint3DArray == null) {
            return null;
        }
        return new UnitLineSeg3D(unitPoint3DArray[0], unitPoint3DArray[1]);
    }

    protected static UnitPoint3D parseLoc(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        return AFDS6Parser.parseLoc(fDSParseRecord, string, string2, true, bl);
    }

    protected static UnitPoint3D parseLoc(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl, boolean bl2) throws FDSRecordFormatException {
        FDSArray fDSArray = fDSParseRecord.getArray(string2, bl);
        if (fDSArray == null || fDSArray.get(0) == null || fDSArray.get(1) == null || fDSArray.get(2) == null) {
            if (bl2) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("%s is missing a location."), string));
            }
            return null;
        }
        return new UnitPoint3D((UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), (UnitDouble)fDSArray.get(2));
    }

    protected static TexOrigin parseTexLoc(FDSParseRecord fDSParseRecord, Point3d point3d, String string, String string2) throws FDSRecordFormatException {
        UnitPoint3D unitPoint3D = AFDS6Parser.parseLoc(fDSParseRecord, string, string2, false);
        if (unitPoint3D != null && !unitPoint3D.equals(TexOrigin.DEF_LOC)) {
            if (unitPoint3D.getPoint3dValue(Geometry.LU).equals(point3d)) {
                return TexOrigin.defaultLocal();
            }
            return new TexOrigin(unitPoint3D, false);
        }
        return TexOrigin.defaultWorld();
    }

    protected static int countDimensions(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        int n = 0;
        if (unitPoint3D.xu().equals(unitPoint3D2.xu())) {
            ++n;
        }
        if (unitPoint3D.yu().equals(unitPoint3D2.yu())) {
            ++n;
        }
        if (unitPoint3D.zu().equals(unitPoint3D2.zu())) {
            ++n;
        }
        return n;
    }

    protected <T extends IPyroObject> T findObject(Class<T> clazz, String string) {
        try {
            return this.findObject(null, clazz, string, false);
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            assert (false);
            return null;
        }
    }

    protected <T extends IPyroObject> T findObject(FDSParseRecord fDSParseRecord, Class<T> clazz, String string, boolean bl) throws FDSRecordFormatException {
        T t = this.getParsingInfo().findObject(clazz, string);
        if (t == null && bl) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Could not find %s."), string));
        }
        return t;
    }

    protected <T extends IPyroObject> T findReplacementObject(Class<T> clazz, String string) {
        return this.getParsingInfo().findReplacementObject(clazz, string);
    }

    protected boolean checkName(FDSParseRecord fDSParseRecord, String string) {
        if (string == null || string.trim().equals("")) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s has no ID."), fDSParseRecord.getType()), String.format(Intl.intl("Adding %s to additional records section."), fDSParseRecord.getType()));
            return false;
        }
        return true;
    }

    protected <T extends INamed> int existsStatus(FDSParseRecord fDSParseRecord, T t, Class<T> clazz) {
        if (!this.getNames(clazz).isRegistered(t.getName())) {
            return 0;
        }
        T t2 = this.findReplacementObject(clazz, t.getName());
        if (t2 == null) {
            return 0;
        }
        T t3 = this.findObject(clazz, t.getName());
        if (t3 != null && t3.equals(t)) {
            return 1;
        }
        this.addWarning(fDSParseRecord, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), fDSParseRecord.getType(), t.getName()), String.format(Intl.intl("Adding to additional records section."), fDSParseRecord.getType()));
        return 2;
    }

    protected boolean convertToReturn(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    protected TimeFunction parseTimeFunction(FDSParseRecord fDSParseRecord, String string, String string2) {
        UnitDouble unitDouble = string != null ? fDSParseRecord.getUnitDouble(string, true) : null;
        String string3 = string2 != null ? fDSParseRecord.getString(string2, false) : null;
        return this.parseTimeFunction(fDSParseRecord, unitDouble, string3);
    }

    protected TimeFunction parseTimeFunction(FDSParseRecord fDSParseRecord, UnitDouble unitDouble, String string) {
        TimeFunction timeFunction = null;
        if (string != null) {
            Ramp ramp = this.getParsingInfo().getRamp(string, RampInputs.TIME, 28, true);
            if (ramp == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Ramp %s could not be found."), string), Intl.intl("Using the default ramp function."));
            } else {
                timeFunction = new TimeFunction.Custom(ramp);
            }
        }
        if (timeFunction == null) {
            timeFunction = AFDS6Parser.parseTCurve(fDSParseRecord, unitDouble);
        }
        assert (timeFunction != null);
        return timeFunction;
    }

    protected static TimeFunction parseTCurve(FDSParseRecord fDSParseRecord, String string) {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble(string);
        return AFDS6Parser.parseTCurve(fDSParseRecord, unitDouble);
    }

    protected static TimeFunction parseTCurve(FDSParseRecord fDSParseRecord, UnitDouble unitDouble) {
        if (unitDouble != null) {
            double d = unitDouble.getValueNoUnit();
            if (d < 0.0) {
                return new TimeFunction.TSquared(unitDouble.negate());
            }
            return new TimeFunction.TanH(unitDouble);
        }
        return TimeFunction.newDefault();
    }

    protected static String getInputID(FDSParseRecord fDSParseRecord, String string, String string2) {
        String string3 = fDSParseRecord.getString(string);
        if (string3 != null) {
            return string3;
        }
        return fDSParseRecord.getString(string2);
    }

    protected static void markSingleInputForRetrieval(FDSParseRecord fDSParseRecord, ISignalSink iSignalSink, PinConnParser pinConnParser, String string, String string2) {
        String string3 = AFDS6Parser.getInputID(fDSParseRecord, string, string2);
        if (string3 != null) {
            pinConnParser.markInputForRetrieval(fDSParseRecord, iSignalSink.getInputPin(), Arrays.asList(string3));
        }
    }

    protected VelocitySign parseVelocitySign(FDSParseRecord fDSParseRecord, Integer n) {
        if (n == null) {
            return VelocitySign.ALWAYS_POSITIVE;
        }
        switch (n) {
            case 1: {
                return VelocitySign.MATCH_U;
            }
            case 2: {
                return VelocitySign.MATCH_V;
            }
            case 3: {
                return VelocitySign.MATCH_W;
            }
            case 0: {
                return VelocitySign.ALWAYS_POSITIVE;
            }
        }
        this.addWarning(new FDSParseWarning(fDSParseRecord, String.format(Intl.intl("Unknown Velocity Index: %d"), n), Intl.intl("Ignoring Velocity Index")));
        return VelocitySign.ALWAYS_POSITIVE;
    }

    protected boolean parseCustomFDSProps(ICustomFDSPropsContainer iCustomFDSPropsContainer, FDSParseRecord fDSParseRecord) {
        if (iCustomFDSPropsContainer.getCustomFDSTypes().contains(fDSParseRecord.getType())) {
            iCustomFDSPropsContainer.setCustomFDSProps(fDSParseRecord.getType(), CustomFDSProps.union(iCustomFDSPropsContainer.getCustomFDSProps(fDSParseRecord.getType()), this.getCustomVals(fDSParseRecord)));
            this.getParsingInfo().getParseResult().extractedUnsupportedRecs.add(fDSParseRecord);
            return true;
        }
        return false;
    }

    protected CustomFDSProps getCustomVals(FDSParseRecord fDSParseRecord) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        FDSRenderProps fDSRenderProps = PyroSim.getApp().getFDSRenderProps();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.getUnsupportedFields(fDSParseRecord.getType(), hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            FDSRecordSpec.Field field;
            Object t;
            if (!((String)entry.getValue()).equals("UNSUPPORTED") || (t = fDSParseRecord.get((String)entry.getKey())) == null || (field = fDSParseRecord.getSpec().fields.get(entry.getKey())) == null) continue;
            String string = field.render(fDSRenderProps, t);
            this.collectCustomVal(linkedHashMap, string);
        }
        for (FDSRecord.UnknownProp unknownProp : fDSParseRecord.getUnknownProps()) {
            linkedHashMap.put(unknownProp.key, unknownProp.renderVal());
        }
        return CustomFDSProps.get(linkedHashMap);
    }

    protected void collectCustomVal(Map<String, String> map, String string) {
        int n = string.indexOf(61);
        if (n == -1 || n == 0 || n == string.length() - 1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        assert (!string2.isEmpty() && !string3.isEmpty());
        map.put(string2, string3);
    }

    private static class InvsColor
    extends Color {
        private static final long serialVersionUID = -762022996250689188L;

        public InvsColor() {
            super(0, 0, 0, 0);
        }
    }
}

