/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import junit.framework.TestCase;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AddTask;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParser;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitLineSeg3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.theUtil;

public class QuantityTest
extends TestCase {
    private PyroSim d_app;

    protected void setUp() throws Exception {
        this.d_app = new PyroSim();
        QuantityTest.generateAllQuantities(this.d_app.getMediator());
    }

    public static void generateAllQuantities(PyroMod pyroMod) {
        Serializable serializable;
        Object object;
        if (pyroMod.getMaterialMgr().flatten().isEmpty()) {
            pyroMod.getTaskManager().exec(new AddTask((IPyroObject)pyroMod.getMaterialMgr(), new IPyroObject[]{new Material("material")}), "Add Test Material");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<IQuantity> list = QuantityUtil.generateAllQuantities(pyroMod, Filters.acceptAll(Quantity.class), true);
        int n = 1;
        AspiratorSampler aspiratorSampler = new AspiratorSampler("MISC_DEVC" + n++, new FreePointLoc());
        Aspirator aspirator = new Aspirator("MISC_DEVC" + n++, new FreePointLoc());
        aspirator.setSamplerLine(new Aspirator.SamplerLine(aspiratorSampler));
        arrayList.add(aspiratorSampler);
        arrayList.add(aspirator);
        arrayList.add(new PathObscurationMeasurer("MISC_DEVC" + n++, new UnitLineSeg3D(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), SI.METER)));
        arrayList.add(new HeatDetector("MISC_DEVC" + n++, (HeatLinkModel)pyroMod.getHeatLinkModels().flatten().iterator().next(), new FreePointLoc()));
        arrayList.add(new SmokeDetector("MISC_DEVC" + n++, (SmokeLinkModel)pyroMod.getSmokeLinkModels().flatten().iterator().next(), new FreePointLoc()));
        arrayList.add(new SprinklerLink("MISC_DEVC" + n++, (SprinklerLinkModel)pyroMod.getSprinklerLinkModels().flatten().iterator().next(), new FreePointLoc()));
        arrayList.add(new LayerMeasurer("MISC_DEVC" + n++, true, true, true, new UnitLineSeg3D(new Point3d(), new Point3d(), SI.METER)));
        n = 1;
        for (IQuantity iQuantity : QuantityTest.filter(list, GasPointMeasurer.getQuantityFilter())) {
            if (iQuantity.get() == Quantity.TIME) continue;
            object = "GAS" + n++;
            serializable = iQuantity.get() == Quantity.THERMOCOUPLE ? new Thermocouple((String)object, new FreePointLoc()) : new GasPointMeasurer((String)object, iQuantity, new FreePointLoc());
            arrayList.add(serializable);
        }
        n = 1;
        for (IQuantity iQuantity : QuantityTest.filter(list, SolidPointMeasurer.getQuantityFilter())) {
            serializable = new AttachedPointLoc();
            String string = "SOLID" + n++;
            switch (iQuantity.get()) {
                case GAUGE_HEAT_FLUX: {
                    object = new GaugeHeatFluxMeasurer(string, SIUS.newud(0.0, 1), (AttachedPointLoc)serializable);
                    break;
                }
                case INSIDE_WALL_TEMPERATURE: {
                    object = new InnerTempMeasurer(string, (AttachedPointLoc)serializable);
                    break;
                }
                case PRESSURE_COEFFICIENT: {
                    object = new PressureCoeffMeasurer(string, (AttachedPointLoc)serializable);
                    break;
                }
                case MATL_SOLID_DENSITY: {
                    object = new SolidDensityMeasurer(string, (ObjectQuantity)iQuantity, (AttachedPointLoc)serializable);
                    break;
                }
                default: {
                    object = new SolidPointMeasurer(string, iQuantity, (AttachedPointLoc)serializable);
                }
            }
            arrayList.add(object);
        }
        n = 1;
        for (IQuantity iQuantity : QuantityTest.filter(list, FlowMeasurer.getQuantityFilter())) {
            arrayList.add(new FlowMeasurer("FLOW" + n++, iQuantity, new AARectangle(), 2));
            arrayList.add(new FlowMeasurer("FLOW" + n++, iQuantity, new AARectangle(), 0));
            arrayList.add(new FlowMeasurer("FLOW" + n++, iQuantity, new AARectangle(), 1));
        }
        n = 1;
        for (IQuantity iQuantity : QuantityTest.filter(list, AABoxMeasurer.getQuantityFilter())) {
            arrayList.add(new AABoxMeasurer("AABOX" + n++, iQuantity, new UnitAABox(new AABox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), SI.METER)));
        }
        n = 1;
        for (IQuantity iQuantity : QuantityTest.filter(list, Sprinkler.QuantityModel.getQuantityFilter())) {
            arrayList.add(new Sprinkler("SPRK" + n++, (SprayModel)pyroMod.getSprayModels().flatten().iterator().next(), new Sprinkler.QuantityModel(iQuantity, SIUS.newud(0.0, iQuantity.get().unitType)), new FreePointLoc()));
        }
        pyroMod.getTaskManager().exec(new AddTask((IPyroObject)pyroMod.getDevices(), arrayList), "Add Test Devices");
    }

    private static Collection<? extends IQuantity> filter(List<IQuantity> list, final Predicate<Quantity> predicate) {
        return theUtil.filter(list, new Predicate<IQuantity>(){

            @Override
            public boolean test(IQuantity iQuantity) {
                return predicate.test(iQuantity.get());
            }
        });
    }

    public void testRoundtrip() {
        PyroMod pyroMod;
        block3: {
            FDSRenderer fDSRenderer = FDS.newRenderer(this.d_app.getMediator(), this.d_app.getFDSRenderProps());
            FDSStringRenderer fDSStringRenderer = new FDSStringRenderer(this.d_app.getFDSRenderProps());
            fDSRenderer.renderAllObjects(fDSStringRenderer, Collections.EMPTY_MAP);
            String string = fDSStringRenderer.toString();
            FDSParser fDSParser = FDS.newParser(6);
            pyroMod = new PyroMod(false);
            pyroMod.setAutoProxUpdate(false);
            try {
                fDSParser.parseBuffer(string, pyroMod);
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        PyroMod pyroMod2 = this.d_app.getMediator();
        PyroMod pyroMod3 = pyroMod;
        int n = 0;
        for (IDevice iDevice : pyroMod2.getDevices().flatten()) {
            if (iDevice instanceof Sprinkler || iDevice instanceof SprinklerLink || iDevice instanceof LayerMeasurer) continue;
            IDevice iDevice2 = (IDevice)pyroMod3.getDevices().get(iDevice.getName());
            QuantityTest.assertNotNull((Object)iDevice2);
            QuantityTest.assertEquals((Object)iDevice, (Object)iDevice2);
            ++n;
        }
        System.out.printf("%d/%d devices tested for equality.%n", n, pyroMod2.getDevices().flatten().size());
    }
}

