/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6;

import java.util.Arrays;
import java.util.Collections;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.IBeamDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.ParseTest;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.FDS6Parser;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitLineSeg3D;

public class DeviceTest
extends ParseTest {
    private PyroMod d_parseMod;
    private FDS6Parser d_parser;
    private DeviceManager d_parseMgr;
    private PyroMod d_rendMod;
    private FDSStringRenderer d_renderProps;
    private FDS6Renderer d_renderer;
    private DeviceManager d_rendMgr;

    public DeviceTest() {
        super("Device Rendering and Parsing", FDS6Const.getRecordSpecs());
    }

    protected void setUp() throws Exception {
        this.d_parseMod = new PyroMod();
        this.d_parser = new FDS6Parser();
        this.d_parseMgr = this.d_parseMod.getDevices();
        this.d_rendMod = new PyroMod();
        this.d_renderProps = new FDSStringRenderer(new FDSRenderProps());
        this.d_renderer = new FDS6Renderer(this.d_rendMod, this.d_renderProps.props());
        this.d_rendMgr = this.d_rendMod.getDevices();
    }

    public void testSprinkler() {
        ExSpec exSpec = new ExSpec("sp1", 1);
        Particle particle = new Particle("p1", Particle.Type.LIQUID, new Output(10), null);
        particle.setSpecies(exSpec);
        SprayModel sprayModel = new SprayModel("sm1", particle);
        SprinklerLinkModel sprinklerLinkModel = new SprinklerLinkModel("slm1");
        Sprinkler sprinkler = new Sprinkler("s1", sprayModel, new Sprinkler.TraditionalModel(sprinklerLinkModel, true, true), new FreePointLoc());
        Sprinkler sprinkler2 = new Sprinkler("s2", sprayModel, new Sprinkler.QuantityModel(Quantity.DENSITY.create(), SIUS.newud(40.0, 4), true, true), new FreePointLoc(new Point(new Point3d(1.0, 1.0, 1.0))));
        DryPipe dryPipe = new DryPipe("dp1", new UnitDouble(10.0, SI.SECOND));
        sprinkler.setDryPipe(dryPipe);
        sprinkler2.setDryPipe(dryPipe);
        this.d_rendMod.getExSpecList().add(exSpec);
        this.d_rendMod.getPartList().add(particle);
        this.d_rendMod.getSprayModels().add(sprayModel);
        this.d_rendMod.getSprinklerLinkModels().add(sprinklerLinkModel);
        this.d_rendMod.getDevices().addAll(Arrays.asList(sprinkler, sprinkler2, dryPipe));
        this.renderAndParse();
    }

    public void testAspiratorSystem() {
        Aspirator aspirator = new Aspirator("a1", SIUS.newud(10.0, 38), new FreePointLoc(new Point(new Point3d(1.0, 2.0, 3.0)), new Vector3d(4.0, 5.0, 6.0), new UnitDouble(7.0, NonSI.DEGREE_ANGLE)));
        Aspirator aspirator2 = new Aspirator("a2", SIUS.newud(10.0, 38), new FreePointLoc(new Point(new Point3d(4.0, 5.0, 6.0))));
        AspiratorSampler aspiratorSampler = new AspiratorSampler("s1", new FreePointLoc(new Point(new Point3d(-1.0, 2.0, 0.0))));
        AspiratorSampler aspiratorSampler2 = new AspiratorSampler("s2", new FreePointLoc(new Point(new Point3d(0.0, 2.0, 0.0))));
        AspiratorSampler aspiratorSampler3 = new AspiratorSampler("s3", new FreePointLoc(new Point(new Point3d(1.0, 2.0, 0.0))));
        aspirator.setSamplerLine(new Aspirator.SamplerLine(aspiratorSampler, SIUS.newud(1.0, 38), new UnitDouble(2.0, SI.SECOND)));
        aspirator.setSamplerLine(new Aspirator.SamplerLine(aspiratorSampler2, SIUS.newud(3.0, 38), new UnitDouble(4.0, SI.SECOND)));
        aspirator2.setSamplerLine(new Aspirator.SamplerLine(aspiratorSampler2, SIUS.newud(5.0, 38), new UnitDouble(6.0, SI.SECOND)));
        aspirator2.setSamplerLine(new Aspirator.SamplerLine(aspiratorSampler3, SIUS.newud(7.0, 38), new UnitDouble(8.0, SI.SECOND)));
        this.d_rendMod.getDevices().add(aspirator);
        this.d_rendMod.getDevices().add(aspirator2);
        this.d_rendMod.getDevices().add(aspiratorSampler);
        this.d_rendMod.getDevices().add(aspiratorSampler2);
        this.d_rendMod.getDevices().add(aspiratorSampler3);
        ExSpec exSpec = new ExSpec(ExSpecList.getPredefinedSpecies("SOOT"));
        exSpec.setForceWrite(true);
        this.d_rendMod.getExSpecList().add(exSpec);
        this.renderAndParse();
        DeviceManager deviceManager = this.d_parseMod.getDevices();
        Aspirator aspirator3 = (Aspirator)this.get(deviceManager, "a1");
        Aspirator aspirator4 = (Aspirator)this.get(deviceManager, "a2");
        AspiratorSampler aspiratorSampler4 = (AspiratorSampler)this.get(deviceManager, "s1");
        AspiratorSampler aspiratorSampler5 = (AspiratorSampler)this.get(deviceManager, "s2");
        AspiratorSampler aspiratorSampler6 = (AspiratorSampler)this.get(deviceManager, "s22");
        AspiratorSampler aspiratorSampler7 = (AspiratorSampler)this.get(deviceManager, "s3");
        DeviceTest.assertEquals((Object)aspirator, (Object)aspirator3);
        this.assertUnequal(aspirator2, aspirator4);
        DeviceTest.assertEquals((Object)aspiratorSampler, (Object)aspiratorSampler4);
        DeviceTest.assertEquals((Object)aspiratorSampler2, (Object)aspiratorSampler5);
        DeviceTest.assertEquals((Object)aspiratorSampler3, (Object)aspiratorSampler7);
        DeviceTest.assertTrue((boolean)aspirator3.isConnectedTo(aspiratorSampler4));
        DeviceTest.assertTrue((boolean)aspirator3.isConnectedTo(aspiratorSampler5));
        DeviceTest.assertFalse((boolean)aspirator3.isConnectedTo(aspiratorSampler6));
        DeviceTest.assertFalse((boolean)aspirator4.isConnectedTo(aspiratorSampler5));
        DeviceTest.assertTrue((boolean)aspirator4.isConnectedTo(aspiratorSampler6));
        DeviceTest.assertTrue((boolean)aspirator4.isConnectedTo(aspiratorSampler7));
    }

    public void testSprayers() {
        ExSpec exSpec = new ExSpec("sp1", 1);
        Particle particle = new Particle("p1", Particle.Type.LIQUID, new Output(10), null);
        Particle particle2 = new Particle("p2", Particle.Type.LIQUID, new Output(10), null);
        particle.setSpecies(exSpec);
        particle2.setSpecies(exSpec);
        SprayModel sprayModel = new SprayModel("sm1", particle);
        SprayModel sprayModel2 = new SprayModel("sm2", particle2);
        SprinklerLinkModel sprinklerLinkModel = new SprinklerLinkModel("slm1", SIUS.newud(0.0, 3), SIUS.newud(1.0, 1), SIUS.newud(2.0, 1), SIUS.newud(3.0, 60));
        SprinklerLinkModel sprinklerLinkModel2 = new SprinklerLinkModel("slm2", SIUS.newud(4.0, 3), SIUS.newud(5.0, 1), SIUS.newud(6.0, 1), SIUS.newud(7.0, 60));
        Nozzle nozzle = new Nozzle("n1", sprayModel, new FreePointLoc());
        Nozzle nozzle2 = new Nozzle("n2", sprayModel2, new FreePointLoc());
        this.d_rendMgr.addAll(Arrays.asList(nozzle, nozzle2));
        this.d_rendMod.getExSpecList().add(exSpec);
        this.d_rendMod.getSprayModels().addAll(Arrays.asList(sprayModel, sprayModel2));
        this.d_rendMod.getPartList().addAll(Arrays.asList(particle, particle2));
        this.d_rendMod.getSprinklerLinkModels().addAll(Arrays.asList(sprinklerLinkModel, sprinklerLinkModel2));
        this.renderAndParse();
        Particle particle3 = (Particle)this.d_parseMod.getPartList().get("p1");
        Particle particle4 = (Particle)this.d_parseMod.getPartList().get("p2");
        SprayModel sprayModel3 = (SprayModel)this.d_parseMod.getSprayModels().get("sm1");
        SprayModel sprayModel4 = (SprayModel)this.d_parseMod.getSprayModels().get("sm2");
        DeviceTest.assertNull(this.d_parseMod.getSprinklerLinkModels().get("slm1"));
        DeviceTest.assertNull(this.d_parseMod.getSprinklerLinkModels().get("slm2"));
        DeviceTest.assertTrue((boolean)(this.get(this.d_parseMgr, "n1") instanceof Sprinkler));
        DeviceTest.assertTrue((boolean)(this.get(this.d_parseMgr, "n2") instanceof Sprinkler));
        Sprinkler sprinkler = (Sprinkler)this.get(this.d_parseMgr, "n1");
        Sprinkler sprinkler2 = (Sprinkler)this.get(this.d_parseMgr, "n2");
        DeviceTest.assertEquals((Object)particle, (Object)particle3);
        DeviceTest.assertEquals((Object)particle2, (Object)particle4);
        DeviceTest.assertEquals((Object)sprayModel, (Object)sprayModel3);
        DeviceTest.assertEquals((Object)sprayModel2, (Object)sprayModel4);
        DeviceTest.assertSame((Object)particle3, (Object)sprayModel3.getParticle());
        DeviceTest.assertSame((Object)particle4, (Object)sprayModel4.getParticle());
        DeviceTest.assertSame((Object)sprayModel3, (Object)sprinkler.getSprayModel());
        DeviceTest.assertSame((Object)sprayModel4, (Object)sprinkler2.getSprayModel());
    }

    public void testAspirators() {
        Aspirator aspirator = new Aspirator("a1", SIUS.newud(10.0, 38), new FreePointLoc(new Point(new Point3d(1.0, 2.0, 3.0)), new Vector3d(4.0, 5.0, 6.0), new UnitDouble(7.0, NonSI.DEGREE_ANGLE)));
        Aspirator aspirator2 = new Aspirator("a2", SIUS.newud(11.0, 38), new FreePointLoc(new Point(new Point3d(4.0, 5.0, 6.0))));
        this.testRetrieval(new Aspirator[]{aspirator, aspirator2});
    }

    public void testAspiratorSamplers() {
        AspiratorSampler aspiratorSampler = new AspiratorSampler("s1", new FreePointLoc(new Point(new Point3d(-1.0, 2.0, 0.0))));
        AspiratorSampler aspiratorSampler2 = new AspiratorSampler("s2", new FreePointLoc(new Point(new Point3d(0.0, 2.0, 0.0))));
        this.d_rendMgr.add(aspiratorSampler);
        this.d_rendMgr.add(aspiratorSampler2);
        ExSpec exSpec = new ExSpec(ExSpecList.getPredefinedSpecies("SOOT"));
        exSpec.setForceWrite(true);
        this.d_rendMod.getExSpecList().add(exSpec);
        this.renderAndParse();
        IDevice iDevice = (IDevice)this.d_parseMgr.get(aspiratorSampler.getName());
        IDevice iDevice2 = (IDevice)this.d_parseMgr.get(aspiratorSampler2.getName());
        DeviceTest.assertNotNull((Object)iDevice);
        DeviceTest.assertNotNull((Object)iDevice2);
        DeviceTest.assertTrue((boolean)(iDevice instanceof GasPointMeasurer));
        DeviceTest.assertTrue((boolean)(iDevice2 instanceof GasPointMeasurer));
        DeviceTest.assertEquals((Object)Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT")), (Object)((GasPointMeasurer)iDevice).getQuantity());
        DeviceTest.assertEquals((Object)Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT")), (Object)((GasPointMeasurer)iDevice2).getQuantity());
        DeviceTest.assertEquals((Object)aspiratorSampler.getLocation(), (Object)((GasPointMeasurer)iDevice).getLocation());
        DeviceTest.assertEquals((Object)aspiratorSampler2.getLocation(), (Object)((GasPointMeasurer)iDevice2).getLocation());
    }

    public void testHeatDetectors() {
        HeatLinkModel heatLinkModel = new HeatLinkModel("hlm1", SIUS.newud(0.0, 3), SIUS.newud(1.0, 1), SIUS.newud(2.0, 1));
        HeatLinkModel heatLinkModel2 = new HeatLinkModel("hlm2", SIUS.newud(3.0, 3), SIUS.newud(4.0, 1), SIUS.newud(5.0, 1));
        HeatDetector heatDetector = new HeatDetector("hd1", heatLinkModel, new FreePointLoc());
        HeatDetector heatDetector2 = new HeatDetector("hd2", heatLinkModel, new FreePointLoc());
        HeatDetector heatDetector3 = new HeatDetector("hd3", heatLinkModel2, new FreePointLoc());
        this.d_rendMgr.add(heatDetector);
        this.d_rendMgr.add(heatDetector2);
        this.d_rendMgr.add(heatDetector3);
        this.d_rendMod.getHeatLinkModels().add(heatLinkModel);
        this.d_rendMod.getHeatLinkModels().add(heatLinkModel2);
        this.renderAndParse();
        DeviceTest.assertSame((Object)3, (Object)this.d_parseMgr.flatten().size());
        DeviceTest.assertSame((Object)2, (Object)this.d_parseMod.getHeatLinkModels().flatten().size());
        HeatLinkModel heatLinkModel3 = (HeatLinkModel)this.d_parseMod.getHeatLinkModels().get("hlm1");
        HeatLinkModel heatLinkModel4 = (HeatLinkModel)this.d_parseMod.getHeatLinkModels().get("hlm2");
        HeatDetector heatDetector4 = (HeatDetector)this.get(this.d_parseMgr, "hd1");
        HeatDetector heatDetector5 = (HeatDetector)this.get(this.d_parseMgr, "hd2");
        HeatDetector heatDetector6 = (HeatDetector)this.get(this.d_parseMgr, "hd3");
        DeviceTest.assertEquals((Object)heatLinkModel, (Object)heatLinkModel3);
        DeviceTest.assertEquals((Object)heatLinkModel2, (Object)heatLinkModel4);
        DeviceTest.assertEquals((Object)heatDetector, (Object)heatDetector4);
        DeviceTest.assertEquals((Object)heatDetector2, (Object)heatDetector5);
        DeviceTest.assertEquals((Object)heatDetector3, (Object)heatDetector6);
        DeviceTest.assertSame((Object)heatLinkModel3, (Object)heatDetector4.getModel());
        DeviceTest.assertSame((Object)heatLinkModel3, (Object)heatDetector5.getModel());
        DeviceTest.assertSame((Object)heatLinkModel4, (Object)heatDetector6.getModel());
    }

    public void testSmokeDetectors() {
        SmokeLinkModel smokeLinkModel = new SmokeLinkModel("slm1", SIUS.newud(1.0, 31), null, new SmokeLinkModel.Cleary());
        SmokeLinkModel smokeLinkModel2 = new SmokeLinkModel("slm2", SIUS.newud(2.0, 31), null, new SmokeLinkModel.Heskestad());
        SmokeDetector smokeDetector = new SmokeDetector("sd1", smokeLinkModel, new FreePointLoc());
        SmokeDetector smokeDetector2 = new SmokeDetector("sd2", smokeLinkModel, new FreePointLoc());
        SmokeDetector smokeDetector3 = new SmokeDetector("sd3", smokeLinkModel2, new FreePointLoc());
        this.d_rendMgr.add(smokeDetector);
        this.d_rendMgr.add(smokeDetector2);
        this.d_rendMgr.add(smokeDetector3);
        this.d_rendMod.getSmokeLinkModels().add(smokeLinkModel);
        this.d_rendMod.getSmokeLinkModels().add(smokeLinkModel2);
        this.renderAndParse();
        DeviceTest.assertSame((Object)3, (Object)this.d_parseMgr.flatten().size());
        DeviceTest.assertSame((Object)2, (Object)this.d_parseMod.getSmokeLinkModels().flatten().size());
        SmokeLinkModel smokeLinkModel3 = (SmokeLinkModel)this.d_parseMod.getSmokeLinkModels().get("slm1");
        SmokeLinkModel smokeLinkModel4 = (SmokeLinkModel)this.d_parseMod.getSmokeLinkModels().get("slm2");
        SmokeDetector smokeDetector4 = (SmokeDetector)this.get(this.d_parseMgr, "sd1");
        SmokeDetector smokeDetector5 = (SmokeDetector)this.get(this.d_parseMgr, "sd2");
        SmokeDetector smokeDetector6 = (SmokeDetector)this.get(this.d_parseMgr, "sd3");
        DeviceTest.assertEquals((Object)smokeLinkModel, (Object)smokeLinkModel3);
        DeviceTest.assertEquals((Object)smokeLinkModel2, (Object)smokeLinkModel4);
        DeviceTest.assertEquals((Object)smokeDetector, (Object)smokeDetector4);
        DeviceTest.assertEquals((Object)smokeDetector2, (Object)smokeDetector5);
        DeviceTest.assertEquals((Object)smokeDetector3, (Object)smokeDetector6);
        DeviceTest.assertSame((Object)smokeLinkModel3, (Object)smokeDetector4.getModel());
        DeviceTest.assertSame((Object)smokeLinkModel3, (Object)smokeDetector5.getModel());
        DeviceTest.assertSame((Object)smokeLinkModel4, (Object)smokeDetector6.getModel());
    }

    public void testSprinklerLinks() {
        SprinklerLinkModel sprinklerLinkModel = new SprinklerLinkModel("slm1", SIUS.newud(0.0, 3), SIUS.newud(1.0, 1), SIUS.newud(2.0, 1), SIUS.newud(3.0, 60));
        SprinklerLinkModel sprinklerLinkModel2 = new SprinklerLinkModel("slm2", SIUS.newud(4.0, 3), SIUS.newud(5.0, 1), SIUS.newud(6.0, 1), SIUS.newud(7.0, 60));
        SprinklerLink sprinklerLink = new SprinklerLink("sd1", sprinklerLinkModel, new FreePointLoc());
        SprinklerLink sprinklerLink2 = new SprinklerLink("sd2", sprinklerLinkModel, new FreePointLoc());
        SprinklerLink sprinklerLink3 = new SprinklerLink("sd3", sprinklerLinkModel2, new FreePointLoc());
        this.d_rendMgr.add(sprinklerLink);
        this.d_rendMgr.add(sprinklerLink2);
        this.d_rendMgr.add(sprinklerLink3);
        this.d_rendMod.getSprinklerLinkModels().add(sprinklerLinkModel);
        this.d_rendMod.getSprinklerLinkModels().add(sprinklerLinkModel2);
        this.renderAndParse();
        DeviceTest.assertSame((Object)3, (Object)this.d_parseMgr.flatten().size());
        DeviceTest.assertSame((Object)2, (Object)this.d_parseMod.getSprinklerLinkModels().flatten().size());
        SprinklerLinkModel sprinklerLinkModel3 = (SprinklerLinkModel)this.d_parseMod.getSprinklerLinkModels().get("slm1");
        SprinklerLinkModel sprinklerLinkModel4 = (SprinklerLinkModel)this.d_parseMod.getSprinklerLinkModels().get("slm2");
        SprinklerLink sprinklerLink4 = (SprinklerLink)this.get(this.d_parseMgr, "sd1");
        SprinklerLink sprinklerLink5 = (SprinklerLink)this.get(this.d_parseMgr, "sd2");
        SprinklerLink sprinklerLink6 = (SprinklerLink)this.get(this.d_parseMgr, "sd3");
        DeviceTest.assertEquals((Object)sprinklerLinkModel, (Object)sprinklerLinkModel3);
        DeviceTest.assertEquals((Object)sprinklerLinkModel2, (Object)sprinklerLinkModel4);
        DeviceTest.assertEquals((Object)sprinklerLink, (Object)sprinklerLink4);
        DeviceTest.assertEquals((Object)sprinklerLink2, (Object)sprinklerLink5);
        DeviceTest.assertEquals((Object)sprinklerLink3, (Object)sprinklerLink6);
        DeviceTest.assertSame((Object)sprinklerLinkModel3, (Object)sprinklerLink4.getModel());
        DeviceTest.assertSame((Object)sprinklerLinkModel3, (Object)sprinklerLink5.getModel());
        DeviceTest.assertSame((Object)sprinklerLinkModel4, (Object)sprinklerLink6.getModel());
    }

    public void testThermocouples() {
        Thermocouple thermocouple = new Thermocouple("thcp1", SIUS.newud(1.0, 0), 2.0, SIUS.newud(8000.0, 4), SIUS.newud(0.5, 11), new FreePointLoc());
        Thermocouple thermocouple2 = new Thermocouple("thcp2", SIUS.newud(3.0, 0), 4.0, SIUS.newud(9000.0, 4), SIUS.newud(0.6, 11), new FreePointLoc());
        this.testRetrieval(new Thermocouple[]{thermocouple, thermocouple2});
    }

    public void testPressureCoeffMeasurer() {
        PressureCoeffMeasurer pressureCoeffMeasurer = new PressureCoeffMeasurer("d1", SIUS.newud(1.0, 8), new AttachedPointLoc());
        PressureCoeffMeasurer pressureCoeffMeasurer2 = new PressureCoeffMeasurer("d2", SIUS.newud(2.0, 8), new AttachedPointLoc());
        this.testRetrieval(new PressureCoeffMeasurer[]{pressureCoeffMeasurer, pressureCoeffMeasurer2});
    }

    public void testGaugeHeatFluxMeasurer() {
        GaugeHeatFluxMeasurer gaugeHeatFluxMeasurer = new GaugeHeatFluxMeasurer("d1", SIUS.newud(1.0, 1), 0.9, new AttachedPointLoc());
        GaugeHeatFluxMeasurer gaugeHeatFluxMeasurer2 = new GaugeHeatFluxMeasurer("d2", SIUS.newud(2.0, 1), 0.9, new AttachedPointLoc());
        this.testRetrieval(new GaugeHeatFluxMeasurer[]{gaugeHeatFluxMeasurer, gaugeHeatFluxMeasurer2});
    }

    public void testInnerTempMeasurer() {
        InnerTempMeasurer innerTempMeasurer = new InnerTempMeasurer("d1", SIUS.newud(1.0, 0), new AttachedPointLoc());
        InnerTempMeasurer innerTempMeasurer2 = new InnerTempMeasurer("d2", SIUS.newud(2.0, 0), new AttachedPointLoc());
        this.testRetrieval(new InnerTempMeasurer[]{innerTempMeasurer, innerTempMeasurer2});
    }

    public void testGasPointMeasurer() {
        GasPointMeasurer gasPointMeasurer = new GasPointMeasurer("d1", Quantity.ABSORPTION_COEFFICIENT.create(), new FreePointLoc());
        GasPointMeasurer gasPointMeasurer2 = new GasPointMeasurer("d2", Quantity.DIVERGENCE.create(), new FreePointLoc());
        this.testRetrieval(new GasPointMeasurer[]{gasPointMeasurer, gasPointMeasurer2});
    }

    public void testSolidPointMeasurer() {
        SolidPointMeasurer solidPointMeasurer = new SolidPointMeasurer("d1", Quantity.ADIABATIC_SURFACE_TEMPERATURE.create(), new AttachedPointLoc());
        SolidPointMeasurer solidPointMeasurer2 = new SolidPointMeasurer("d2", Quantity.INCIDENT_HEAT_FLUX.create(), new AttachedPointLoc());
        this.testRetrieval(new SolidPointMeasurer[]{solidPointMeasurer, solidPointMeasurer2});
    }

    public void testLayerMeasurer() {
        LayerMeasurer layerMeasurer = new LayerMeasurer("d1", true, false, false, new UnitLineSeg3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, SI.METER));
        LayerMeasurer layerMeasurer2 = new LayerMeasurer("d2", false, true, false, new UnitLineSeg3D(1.0, 0.0, 0.0, 1.0, 0.0, 1.0, SI.METER));
        LayerMeasurer layerMeasurer3 = new LayerMeasurer("d3", false, false, true, new UnitLineSeg3D(0.0, 1.0, 0.0, 0.0, 1.0, 1.0, SI.METER));
        LayerMeasurer layerMeasurer4 = new LayerMeasurer("d4", true, true, true, new UnitLineSeg3D(3.0, 0.0, 0.0, 3.0, 0.0, 1.0, SI.METER));
        this.d_rendMgr.addAll(Arrays.asList(layerMeasurer, layerMeasurer2, layerMeasurer3, layerMeasurer4));
        this.renderAndParse();
        DeviceTest.assertSame((Object)6, (Object)this.d_parseMgr.flatten().size());
        IBeamDevice iBeamDevice = (IBeamDevice)this.get(this.d_parseMgr, "d1");
        IBeamDevice iBeamDevice2 = (IBeamDevice)this.get(this.d_parseMgr, "d2");
        IBeamDevice iBeamDevice3 = (IBeamDevice)this.get(this.d_parseMgr, "d3");
        DeviceTest.assertEquals((Object)layerMeasurer, (Object)iBeamDevice);
        DeviceTest.assertEquals((Object)layerMeasurer2, (Object)iBeamDevice2);
        DeviceTest.assertEquals((Object)layerMeasurer3, (Object)iBeamDevice3);
        DeviceTest.assertNull(this.d_parseMgr.get("d4"));
        IBeamDevice iBeamDevice4 = (IBeamDevice)this.get(this.d_parseMgr, "d4->" + layerMeasurer4.getHeightInfo().getPin().getName());
        IBeamDevice iBeamDevice5 = (IBeamDevice)this.get(this.d_parseMgr, "d4->" + layerMeasurer4.getUpperTempInfo().getPin().getName());
        IBeamDevice iBeamDevice6 = (IBeamDevice)this.get(this.d_parseMgr, "d4->" + layerMeasurer4.getLowerTempInfo().getPin().getName());
        DeviceTest.assertNotNull((Object)iBeamDevice4);
        DeviceTest.assertNotNull((Object)iBeamDevice5);
        DeviceTest.assertNotNull((Object)iBeamDevice6);
        DeviceTest.assertEquals((Object)layerMeasurer4.getBeam(), (Object)iBeamDevice4.getBeam());
        DeviceTest.assertEquals((Object)layerMeasurer4.getBeam(), (Object)iBeamDevice5.getBeam());
        DeviceTest.assertEquals((Object)layerMeasurer4.getBeam(), (Object)iBeamDevice6.getBeam());
    }

    public void testPathObsMsr() {
        PathObscurationMeasurer pathObscurationMeasurer = new PathObscurationMeasurer("d1", new UnitLineSeg3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, SI.METER));
        PathObscurationMeasurer pathObscurationMeasurer2 = new PathObscurationMeasurer("d2", new UnitLineSeg3D(1.0, 0.0, 0.0, 1.0, 0.0, 1.0, SI.METER));
        this.testRetrieval(new PathObscurationMeasurer[]{pathObscurationMeasurer, pathObscurationMeasurer2});
    }

    public void testFlowMsr() {
        FlowMeasurer flowMeasurer = new FlowMeasurer("f1a", Quantity.HEAT_FLOW.create(), new AARectangle(), 2);
        FlowMeasurer flowMeasurer2 = new FlowMeasurer("f1b", Quantity.HEAT_FLOW.create(), new AARectangle(), 0);
        FlowMeasurer flowMeasurer3 = new FlowMeasurer("f1c", Quantity.HEAT_FLOW.create(), new AARectangle(), 1);
        FlowMeasurer flowMeasurer4 = new FlowMeasurer("f2a", Quantity.HEAT_FLOW.create(), new AARectangle(), 2);
        FlowMeasurer flowMeasurer5 = new FlowMeasurer("f2b", Quantity.HEAT_FLOW.create(), new AARectangle(), 0);
        FlowMeasurer flowMeasurer6 = new FlowMeasurer("f2c", Quantity.HEAT_FLOW.create(), new AARectangle(), 1);
        FlowMeasurer flowMeasurer7 = new FlowMeasurer("f3a", Quantity.VOLUME_FLOW.create(), new AARectangle(), 2);
        FlowMeasurer flowMeasurer8 = new FlowMeasurer("f3b", Quantity.VOLUME_FLOW.create(), new AARectangle(), 0);
        FlowMeasurer flowMeasurer9 = new FlowMeasurer("f3c", Quantity.VOLUME_FLOW.create(), new AARectangle(), 1);
        this.testRetrieval(new FlowMeasurer[]{flowMeasurer, flowMeasurer2, flowMeasurer3, flowMeasurer4, flowMeasurer5, flowMeasurer6, flowMeasurer7, flowMeasurer8, flowMeasurer9});
    }

    public void testAABoxMsr() {
        AABoxMeasurer aABoxMeasurer = new AABoxMeasurer("d1", Quantity.HRR.create(), new UnitAABox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, SI.METER));
        AABoxMeasurer aABoxMeasurer2 = new AABoxMeasurer("d2", Quantity.HRR.create(), new UnitAABox(0.0, 0.0, 0.0, 2.0, 2.0, 2.0, SI.METER));
        this.testRetrieval(new AABoxMeasurer[]{aABoxMeasurer, aABoxMeasurer2});
    }

    private <T extends IDevice> void testRetrieval(T ... TArray) {
        this.d_rendMod.getDevices().addAll(Arrays.asList(TArray));
        this.renderAndParse();
        DeviceTest.assertSame((Object)TArray.length, (Object)this.d_parseMod.getDevices().flatten().size());
        Object var2_2 = null;
        for (T t : TArray) {
            T t2 = this.get(this.d_parseMgr, t.getName());
            DeviceTest.assertEquals(t, t2);
            if (var2_2 != null) {
                this.assertUnequal(var2_2, t2);
            }
            var2_2 = t2;
        }
    }

    private void renderAndParse() {
        this.d_renderer.renderAllObjects(this.d_renderProps, Collections.EMPTY_MAP);
        try {
            this.d_parser.parseBuffer((CharSequence)this.d_renderProps.toString(), this.d_parseMod, this.d_parseMod);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DeviceTest.fail();
        }
    }

    private <T extends IDevice> T get(DeviceManager deviceManager, String string) {
        return (T)((IDevice)deviceManager.get(string));
    }

    private void assertUnequal(Object object, Object object2) {
        DeviceTest.assertFalse((boolean)object.equals(object2));
    }

    static {
        new PyroSim();
    }
}

