/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.LinkedHashMap;
import java.util.Map;

public class SyntaxMap {
    public static final String SYMBOL_KEYWORD = "SYMBOL_KEYWORD";
    public static final String SYMBOL_SPECIAL = "SYMBOL_SPECIAL";
    public static final String SYMBOL_REFERENCE = "SYMBOL_REFERENCE";
    public static final String SYMBOL_VALUE = "SYMBOL_VALUE";
    public static final String SYMBOL_COMMENT = "SYMBOL_COMMENT";
    public static final String SYMBOL_EMPTY = "SYMBOL_EMPTY";
    private Map<Integer, String> d_map = new LinkedHashMap<Integer, String>();
    private int d_currIx = 0;

    public void put(int n, String string) {
        this.d_map.put(n, string);
        this.d_currIx = n == 0 ? n : n + 1;
    }

    public void putSmart(int n, String string) {
        this.d_currIx += n;
        this.d_map.put(this.d_currIx, string);
    }

    public int getCurrIx() {
        return this.d_currIx;
    }

    public Map<Integer, String> getMap() {
        return new LinkedHashMap<Integer, String>(this.d_map);
    }

    public void mergeSyntaxToRoot(SyntaxMap syntaxMap) {
        Map<Integer, String> map = syntaxMap.getMap();
        int n = Integer.MAX_VALUE;
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            n = entry.getKey() + this.d_currIx;
            this.d_map.put(n, entry.getValue());
        }
        if (n != Integer.MAX_VALUE) {
            this.d_currIx = n;
        }
    }

    public void clearSyntax() {
        this.d_map.clear();
        this.d_currIx = 0;
    }
}

