/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AdjacencyMerger;
import thunderheadeng.util.FileWarning;
import thunderheadeng.util.FileWarningReport;
import thunderheadeng.util.MergedCell;

public class SPKReader {
    private static final String MANUFACTURER = "MANUFACTURER";
    private static final String MODEL = "MODEL";
    private static final String RTI = "RTI";
    private static final String C_FACTOR = "C-FACTOR";
    private static final String K_FACTOR = "K-FACTOR";
    private static final String ACTIVATION_TEMPERATURE = "ACTIVATION_TEMPERATURE";
    private static final String OPERATING_PRESSURE = "OPERATING_PRESSURE";
    private static final String OFFSET_DISTANCE = "OFFSET_DISTANCE";
    private static final String VELOCITY = "VELOCITY";
    private static final String FLUX = "FLUX";
    private static final String SIZE_DISTRIBUTION = "SIZE_DISTRIBUTION";
    private SPKResult d_result;

    public SPKResult parse(String string, double d) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        return this.parse(new File(string).getName(), bufferedReader, d);
    }

    public SPKResult parse(String string, BufferedReader bufferedReader, double d) throws Exception {
        Object object;
        Serializable serializable;
        String string2;
        this.d_result = new SPKResult();
        String string3 = string;
        UnitDouble unitDouble = SIUS.newud(165.0, 3);
        UnitDouble unitDouble2 = SIUS.newud(0.0, 60);
        UnitDouble unitDouble3 = SIUS.newud(74.0, 1);
        UnitDouble unitDouble4 = SIUS.newud(0.05, 0);
        UnitDouble unitDouble5 = null;
        UnitDouble unitDouble6 = SIUS.newud(166.0, 58);
        ISampleResult iSampleResult = null;
        ISampleResult iSampleResult2 = null;
        CustomFDSProps customFDSProps = null;
        while (bufferedReader.ready()) {
            string2 = this.readString(bufferedReader);
            if (!bufferedReader.ready()) break;
            if (string2.equals(MANUFACTURER)) {
                this.readString(bufferedReader);
                continue;
            }
            if (string2.equals(MODEL)) {
                string3 = this.readString(bufferedReader);
                continue;
            }
            if (string2.equals(RTI)) {
                unitDouble = this.readUnitDouble(bufferedReader, 3);
                continue;
            }
            if (string2.equals(C_FACTOR)) {
                unitDouble2 = this.readUnitDouble(bufferedReader, 60);
                continue;
            }
            if (string2.equals(K_FACTOR)) {
                unitDouble6 = this.readUnitDouble(bufferedReader, 58);
                continue;
            }
            if (string2.equals(ACTIVATION_TEMPERATURE)) {
                unitDouble3 = this.readUnitDouble(bufferedReader, 1);
                continue;
            }
            if (string2.equals(OPERATING_PRESSURE)) {
                unitDouble5 = this.readUnitDouble(bufferedReader, 12);
                continue;
            }
            if (string2.equals(OFFSET_DISTANCE)) {
                unitDouble4 = this.readUnitDouble(bufferedReader, 0);
                continue;
            }
            if (string2.equals(VELOCITY)) {
                iSampleResult = this.readSampleResult(bufferedReader, VELOCITY);
                continue;
            }
            if (string2.equals(FLUX)) {
                iSampleResult2 = this.readSampleResult(bufferedReader, FLUX);
                continue;
            }
            if (!string2.equals(SIZE_DISTRIBUTION)) continue;
            customFDSProps = this.readSizeDist(bufferedReader);
        }
        if (iSampleResult == null) {
            throw this.newException(Intl.intl("No VELOCITY was specified."));
        }
        string2 = string3;
        String string4 = string3;
        String string5 = String.format(Intl.intl("%s_PARTICLE"), string3);
        this.d_result.d_linkModel = new SprinklerLinkModel(string4, unitDouble, null, unitDouble3, unitDouble2);
        Output output = new Output(new UnitDouble(60.0, SI.SECOND), 10);
        Particle particle = new Particle(string5, Particle.Type.LIQUID, output, null);
        particle.setSpecies(ExSpecList.Predefined.WATER_VAPOR.spec);
        if (customFDSProps != null) {
            serializable = particle.getCustomFDSProps(null);
            object = CustomFDSProps.union(serializable, customFDSProps);
            particle.setCustomFDSProps(null, (CustomFDSProps)object);
        }
        serializable = unitDouble5 != null ? new SprayModel.PressurizedFlowRate(unitDouble5, unitDouble6, new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND))) : new SprayModel.ExplicitFlowRate();
        object = this.toJetList(iSampleResult, iSampleResult2, d);
        this.d_result.d_sprayModel = new SprayModel(string2, particle, unitDouble4, (SprayModel.FlowRate)serializable, 5000, (List<SprayModel.Jet>)object);
        return this.d_result;
    }

    private static double average(double[][] dArray, int n, int n2, int n3, int n4) {
        return SPKReader.sum(dArray, n, n2, n3, n4) / (double)((n4 - n3 + 1) * (n2 - n + 1));
    }

    private static double sum(double[][] dArray, int n, int n2, int n3, int n4) {
        double d = 0.0;
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                d += dArray[i][j];
            }
        }
        return d;
    }

    private List<SprayModel.Jet> toJetList(ISampleResult iSampleResult, ISampleResult iSampleResult2, final double d) throws Exception {
        double d2;
        if (iSampleResult instanceof SimpleSampleResult) {
            SimpleSampleResult simpleSampleResult = (SimpleSampleResult)iSampleResult;
            SprayModel.Jet jet = new SprayModel.Jet(SIUS.newud(simpleSampleResult.d_val, 8), null, 1.0, simpleSampleResult.d_angle1, simpleSampleResult.d_angle2);
            return Arrays.asList(jet);
        }
        if (!(iSampleResult2 instanceof TableSampleResult)) {
            throw this.newException(Intl.intl("FLUX must also be specified as a table."));
        }
        TableSampleResult tableSampleResult = (TableSampleResult)iSampleResult;
        TableSampleResult tableSampleResult2 = (TableSampleResult)iSampleResult2;
        int n = Math.max(tableSampleResult.d_vals.length, tableSampleResult2.d_vals.length);
        int n2 = Math.max(tableSampleResult.d_vals[0].length, tableSampleResult2.d_vals[0].length);
        double d3 = n == 1 ? 0.0 : 1.0 / (double)n;
        double d4 = n2 == 1 ? 0.0 : 1.0 / (double)n2;
        final double[][] dArray = new double[n][n2];
        final double[][] dArray2 = new double[n][n2];
        ArrIndex[][] arrIndexArray = new ArrIndex[n][n2];
        for (int i = 0; i < n; ++i) {
            double d5 = (double)i * d3;
            for (int j = 0; j < n2; ++j) {
                double d6 = (double)j * d4;
                dArray[i][j] = SPKReader.sampleTable(tableSampleResult.d_vals, d5, d6);
                dArray2[i][j] = SPKReader.sampleTable(tableSampleResult2.d_vals, d5, d6);
                arrIndexArray[i][j] = new ArrIndex(i, j);
            }
        }
        Collection<MergedCell<ArrIndex>> collection = AdjacencyMerger.mergeCells(arrIndexArray, new AdjacencyMerger.IMergeQuery<ArrIndex>(){

            @Override
            public ArrIndex merge(ArrIndex arrIndex, ArrIndex arrIndex2, AdjacencyMerger.Dir dir) {
                if (Math.abs(dArray[arrIndex2.row][arrIndex2.col] - dArray[arrIndex.row][arrIndex.col]) <= d && Math.abs(dArray2[arrIndex2.row][arrIndex2.col] - dArray2[arrIndex.row][arrIndex.col]) <= d) {
                    return arrIndex;
                }
                return null;
            }
        });
        TreeSet<MergedCell<ArrIndex>> treeSet = new TreeSet<MergedCell<ArrIndex>>(new Comparator<MergedCell<ArrIndex>>(){

            @Override
            public int compare(MergedCell<ArrIndex> mergedCell, MergedCell<ArrIndex> mergedCell2) {
                if (((ArrIndex)mergedCell.val).row == ((ArrIndex)mergedCell2.val).row) {
                    return ((ArrIndex)mergedCell.val).col - ((ArrIndex)mergedCell2.val).col;
                }
                return ((ArrIndex)mergedCell.val).row - ((ArrIndex)mergedCell2.val).row;
            }
        });
        treeSet.addAll(collection);
        collection = treeSet;
        ArrayList<SprayModel.Jet> arrayList = new ArrayList<SprayModel.Jet>();
        double d7 = 0.0;
        for (MergedCell<ArrIndex> mergedCell : collection) {
            d2 = SPKReader.average(dArray, mergedCell.x1, mergedCell.x2, mergedCell.y1, mergedCell.y2);
            double d8 = SPKReader.sum(dArray2, mergedCell.x1, mergedCell.x2, mergedCell.y1, mergedCell.y2);
            dArray[((ArrIndex)mergedCell.val).row][((ArrIndex)mergedCell.val).col] = d2;
            dArray2[((ArrIndex)mergedCell.val).row][((ArrIndex)mergedCell.val).col] = d8;
            d7 += d8;
        }
        double d9 = d3 * 180.0;
        d2 = d4 * 360.0;
        for (MergedCell<ArrIndex> mergedCell : collection) {
            double d10;
            double d11 = dArray2[((ArrIndex)mergedCell.val).row][((ArrIndex)mergedCell.val).col];
            double d12 = d11 / d7;
            if (Math.abs(d12) < 1.0E-16 || Math.abs(d10 = dArray[((ArrIndex)mergedCell.val).row][((ArrIndex)mergedCell.val).col]) < 1.0E-16) continue;
            double d13 = (double)mergedCell.y1 * d9;
            double d14 = (double)mergedCell.y2 * d9 + d9;
            double d15 = (double)mergedCell.x1 * d2;
            double d16 = (double)mergedCell.x2 * d2 + d2;
            arrayList.add(new SprayModel.Jet(SIUS.newud(d10, 8), null, d12, new UnitDouble(d15, NonSI.DEGREE_ANGLE), new UnitDouble(d16, NonSI.DEGREE_ANGLE), new UnitDouble(d13, NonSI.DEGREE_ANGLE), new UnitDouble(d14, NonSI.DEGREE_ANGLE)));
        }
        return arrayList;
    }

    private static double sampleTable(double[][] dArray, double d, double d2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d3 = (double)n * d;
        int n3 = (int)Math.floor(d3);
        int n4 = (n3 + 1) % n;
        double d4 = d3 - (double)n3;
        double d5 = (double)n2 * d2;
        int n5 = (int)Math.floor(d5);
        int n6 = (n5 + 1) % n2;
        double d6 = d5 - (double)n5;
        double d7 = dArray[n3][n5];
        double d8 = dArray[n3][n6];
        double d9 = dArray[n4][n5];
        double d10 = dArray[n4][n6];
        double d11 = SPKReader.lerp(d7, d8, d6);
        double d12 = SPKReader.lerp(d9, d10, d6);
        double d13 = SPKReader.lerp(d11, d12, d4);
        return d13;
    }

    private static double lerp(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    private CustomFDSProps readSizeDist(BufferedReader bufferedReader) throws Exception {
        int n = this.readInt(bufferedReader);
        if (n == 1) {
            String[] stringArray = this.readVals(bufferedReader, 2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = Double.toString(this.getDouble(stringArray, 0));
            hashMap.put("DIAMETER", string);
            String string2 = Double.toString(this.getDouble(stringArray, 1));
            hashMap.put("GAMMA_D", string2);
            return CustomFDSProps.get(hashMap);
        }
        if (n == 2) {
            this.d_result.addWarning(Intl.intl("The median particle diameter can no longer be a function of position."), Intl.intl("Using default size distribution."));
            return null;
        }
        throw this.newException(String.format(Intl.intl("Unrecognized size distribution type: %d"), n));
    }

    private ISampleResult readSampleResult(BufferedReader bufferedReader, String string) throws Exception {
        int n = this.readInt(bufferedReader);
        if (n == 1) {
            String[] stringArray = this.readVals(bufferedReader, 3);
            return new SimpleSampleResult(this.getDouble(stringArray, 0), this.getUnitDouble(stringArray, 1, NonSI.DEGREE_ANGLE), this.getUnitDouble(stringArray, 2, NonSI.DEGREE_ANGLE));
        }
        if (n == 2) {
            String[] stringArray = this.readVals(bufferedReader, 2);
            int n2 = this.getInt(stringArray, 0);
            int n3 = this.getInt(stringArray, 1);
            if (n2 <= 0 || n3 <= 0) {
                throw this.newException(Intl.intl("na and nl must be greater than 0."));
            }
            double[][] dArray = new double[n2][n3];
            for (int i = 0; i < n2; ++i) {
                String[] stringArray2 = this.readVals(bufferedReader, n3);
                for (int j = 0; j < n3; ++j) {
                    dArray[i][j] = this.getDouble(stringArray2, j);
                }
            }
            return new TableSampleResult(dArray);
        }
        throw this.newException(String.format(Intl.intl("Unknown %1$s type: %2$d"), string, n));
    }

    private String readLine(BufferedReader bufferedReader) throws Exception {
        if (!bufferedReader.ready()) {
            throw this.newException(Intl.intl("Unexpected end of file."));
        }
        String string = bufferedReader.readLine();
        ++this.d_result.d_lineNumber;
        return string;
    }

    private String readString(BufferedReader bufferedReader) throws Exception {
        return this.readLine(bufferedReader);
    }

    private UnitDouble readUnitDouble(BufferedReader bufferedReader, int n) throws Exception {
        Unit unit = SIUS.getInstance().getUnit(n);
        String string = this.readLine(bufferedReader);
        try {
            Double d = new Double(string);
            return new UnitDouble(d, unit);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException(String.format(Intl.intl("Could not read number: %s"), string), numberFormatException.getCause());
        }
    }

    private int readInt(BufferedReader bufferedReader) throws Exception {
        String string = this.readLine(bufferedReader);
        try {
            Integer n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException(String.format(Intl.intl("Could not read integer: %s"), string), numberFormatException.getCause());
        }
    }

    private String[] readVals(BufferedReader bufferedReader, int n) throws Exception {
        String string = this.readLine(bufferedReader);
        String[] stringArray = string.split("[ ,]+");
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray.length < n) {
            throw this.newException(String.format(Intl.intl("Expected %d values in list."), n));
        }
        return stringArray;
    }

    private int getInt(String[] stringArray, int n) throws Exception {
        try {
            return new Integer(stringArray[n]);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException(String.format(Intl.intl("Could not read integer: %s"), stringArray[n]), numberFormatException.getCause());
        }
    }

    private UnitDouble getUnitDouble(String[] stringArray, int n, Unit unit) throws Exception {
        try {
            return new UnitDouble(new Double(stringArray[n]), unit);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException(String.format(Intl.intl("Could not read number: %s"), stringArray[n]), numberFormatException.getCause());
        }
    }

    private double getDouble(String[] stringArray, int n) throws Exception {
        try {
            return new Double(stringArray[n]);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException(String.format(Intl.intl("Could not read number: %s"), stringArray[n]), numberFormatException.getCause());
        }
    }

    private Exception newException(String string) {
        return this.newException(string, null);
    }

    private Exception newException(String string, Throwable throwable) {
        return new Exception(string + "  \n" + String.format(Intl.intl("Line Number: %d"), this.d_result.d_lineNumber), throwable);
    }

    private static class TableSampleResult
    implements ISampleResult {
        public final double[][] d_vals;

        public TableSampleResult(double[][] dArray) {
            this.d_vals = dArray;
        }
    }

    private static class SimpleSampleResult
    implements ISampleResult {
        public final double d_val;
        public final UnitDouble d_angle1;
        public final UnitDouble d_angle2;

        public SimpleSampleResult(double d, UnitDouble unitDouble, UnitDouble unitDouble2) {
            this.d_val = d;
            this.d_angle1 = unitDouble;
            this.d_angle2 = unitDouble2;
        }
    }

    private static interface ISampleResult {
    }

    private static final class ArrIndex {
        public final int row;
        public final int col;

        public ArrIndex(int n, int n2) {
            this.row = n;
            this.col = n2;
        }
    }

    public static class SPKResult {
        public final FileWarningReport d_warnings = new FileWarningReport();
        public int d_lineNumber = 0;
        public SprayModel d_sprayModel;
        public SprinklerLinkModel d_linkModel;

        public void addWarning(String string, String string2) {
            this.d_warnings.addWarning(new FileWarning(this.d_lineNumber, string, string2));
        }
    }
}

