/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import pyrosim.io.fds.LineScanner;
import thunderheadeng.geometry.AABox;

public class SMVReader {
    public SMVInfo read(InputStream inputStream) throws IOException {
        LineScanner lineScanner = new LineScanner(inputStream);
        try {
            ArrayList<MeshInfo> arrayList = new ArrayList<MeshInfo>();
            int n = Integer.MAX_VALUE;
            MeshInfo meshInfo = new MeshInfo();
            Runnable runnable = () -> {
                if (meshInfo.isComplete()) {
                    if (meshInfo.isValid()) {
                        arrayList.add(meshInfo.clone());
                    }
                    meshInfo.reset();
                }
            };
            Type type = Type.UNKNOWN;
            while (arrayList.size() < n) {
                String string;
                try {
                    string = lineScanner.next();
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                try {
                    type = Type.valueOf(string.trim().toUpperCase());
                }
                catch (Throwable throwable) {
                    type = Type.UNKNOWN;
                }
                switch (type) {
                    case NMESHES: {
                        lineScanner.nextLine();
                        n = this.readNMeshes(lineScanner);
                        break;
                    }
                    case GRID: {
                        meshInfo.name = lineScanner.nextLine().trim();
                        this.readGrid(lineScanner);
                        runnable.run();
                        break;
                    }
                    case PDIM: {
                        meshInfo.bounds = this.readPDIM(lineScanner);
                        runnable.run();
                    }
                }
            }
            return new SMVInfo(arrayList);
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    private int readNMeshes(LineScanner lineScanner) {
        int n = lineScanner.nextInt();
        lineScanner.nextLine();
        return n;
    }

    private void readGrid(LineScanner lineScanner) {
        lineScanner.nextLine();
    }

    private AABox readPDIM(LineScanner lineScanner) {
        double[] dArray = lineScanner.nextDoubles(6);
        return new AABox(dArray[0], dArray[2], dArray[4], dArray[1], dArray[3], dArray[5]);
    }

    public static class SMVInfo {
        public final List<MeshInfo> meshes;

        public SMVInfo(List<MeshInfo> list) {
            this.meshes = list;
        }
    }

    public static class MeshInfo
    implements Cloneable {
        public String name;
        public AABox bounds;

        protected MeshInfo clone() {
            try {
                return (MeshInfo)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean isComplete() {
            return this.name != null && this.bounds != null;
        }

        public boolean isValid() {
            return this.isComplete() && this.bounds.isValid();
        }

        public void reset() {
            this.name = null;
            this.bounds = null;
        }
    }

    private static enum Type {
        UNKNOWN,
        NMESHES,
        GRID,
        PDIM;

    }
}

