/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import pyrosim.io.fds.FDSGrammar;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSWarningReport;

public class ParseTest
extends TestCase {
    private final Map<String, FDSRecordSpec> d_recordSpecs;

    public ParseTest(Map<String, FDSRecordSpec> map) {
        this.d_recordSpecs = map;
    }

    public ParseTest(String string, Map<String, FDSRecordSpec> map) {
        super(string);
        this.d_recordSpecs = map;
    }

    public FDSParseRecord parseRecord(String string) {
        return this.parseRecord(string, true);
    }

    public FDSParseRecord parseRecord(String string, boolean bl) {
        FDSParseRecord fDSParseRecord = null;
        try {
            List<FDSParseRecord> list = FDSGrammar.parse(string, null, new FDSWarningReport(), this.d_recordSpecs, null);
            if (list != null && list.size() == 1) {
                fDSParseRecord = list.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            ParseTest.assertNotNull(fDSParseRecord);
        } else {
            ParseTest.assertNull(fDSParseRecord);
        }
        return fDSParseRecord;
    }
}

