/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import thunderheadeng.util.FileWarning;

class LineScanner
implements AutoCloseable {
    public int line;
    private final Scanner d_scanner;

    public LineScanner(InputStream inputStream) throws IOException {
        this.d_scanner = new Scanner(inputStream);
        this.d_scanner.useLocale(Locale.US);
        this.d_scanner.useDelimiter("[, \\n\\r\\t]+");
        this.line = 1;
    }

    public String nextLine() throws NoSuchElementException {
        String string = this.d_scanner.nextLine();
        ++this.line;
        return string;
    }

    public FileWarning newWarning(String string, String string2) {
        return new FileWarning(this.line, string, string2);
    }

    public String next() {
        return this.d_scanner.next();
    }

    public int nextInt() {
        return this.d_scanner.nextInt();
    }

    public double nextDouble() {
        if (!this.d_scanner.hasNextDouble()) {
            if (this.d_scanner.hasNextInt()) {
                return this.d_scanner.nextInt();
            }
            if (this.d_scanner.hasNextShort()) {
                return this.d_scanner.nextShort();
            }
            if (this.d_scanner.hasNextLong()) {
                return this.d_scanner.nextLong();
            }
        }
        return this.d_scanner.nextDouble();
    }

    public boolean hasMore() {
        return this.d_scanner.hasNext();
    }

    public double[] nextDoubles(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.nextDouble();
        }
        return dArray;
    }

    public int[] nextInts(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.nextInt();
        }
        return nArray;
    }

    @Override
    public void close() {
        if (this.d_scanner != null) {
            this.d_scanner.close();
        }
    }
}

