/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.unitsystem.EnglishUS;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.units.UnitDouble;

public class INIWriter {
    public static final UnitDouble FOV = new UnitDouble(65.0, NonSI.DEGREE_ANGLE);
    private final AABox d_meshBounds;
    public static final int TEMPUNIT_CELCIUS = 0;
    public static final int TEMPUNIT_FARENHEIT = 1;
    public static final int TEMP_KELVIN = 2;
    public static final int VELOUNIT_METER_SECOND = 0;
    public static final int VELOUNIT_MPH = 1;
    public static final int VELOUNIT_FOOT_SECOND = 2;
    public static final int DISTUNIT_METER = 0;
    public static final int DISTUNIT_FOOT = 1;
    public static final int VOLFLOWUNIT_METER3_SECOND = 0;
    public static final int VOLFLOWUNIT_CFM = 1;
    public static final int MASSFRACUNIT_KG_KG = 0;
    public static final int MASSFRACUNIT_G_KG = 1;
    public static final int CONCUNIT_MOL_MOL = 0;
    public static final int CONCUNIT_PPM = 1;

    public INIWriter(AABox aABox) {
        this.d_meshBounds = aABox;
    }

    public void write(OutputStream outputStream, boolean bl, boolean bl2, boolean bl3, Collection<? extends IPyroObject> collection) throws IOException {
        IniWriter iniWriter = new IniWriter(outputStream);
        if (bl) {
            if (bl2) {
                iniWriter.write("BLOCKLOCATION", 7);
            } else {
                iniWriter.write("BLOCKLOCATION", 5);
            }
        }
        iniWriter.write("SHOWNORMALWHENSMOOTH", 1);
        iniWriter.write("SHOWALLTEXTURES", 1);
        iniWriter.write("APERTURE", 1);
        iniWriter.write("ZOOM", -1, INIWriter.aperatureToZoom(FOV));
        iniWriter.write("LIGHT1", 0);
        iniWriter.write("LIGHTPOS0", 0, 0, 0, 1);
        iniWriter.write("LIGHTMODELLOCALVIEWER", 1);
        iniWriter.write("LIGHTMODELSEPARATESPECULARCOLOR", 1);
        iniWriter.write("ENABLETEXTURELIGHTING", 1);
        iniWriter.write("AMBIENTLIGHT", 0.2, 0.2, 0.2, 1);
        iniWriter.write("DIFFUSELIGHT", 1, 1, 1, 1);
        iniWriter.write("BLOCKSPECULAR", 0, 0, 0);
        iniWriter.write("BLOCKSHININESS", 0);
        this.writeUnitPrefs(iniWriter);
        if (bl3) {
            this.writeViewpoints(iniWriter, collection);
        }
        iniWriter.flush();
    }

    private static double aperatureToZoom(UnitDouble unitDouble) {
        return INIWriter.aperatureToZoom(unitDouble.get(SI.RADIAN));
    }

    private static double aperatureToZoom(double d) {
        return Math.tan(Math.toRadians(45.0) / 2.0) / Math.tan(d / 2.0);
    }

    public void writeViewpoints(IniWriter iniWriter, Collection<? extends IPyroObject> collection) throws IOException {
        PrintWriter printWriter = iniWriter.iniWriter;
        ArrayList<View> arrayList = new ArrayList<View>(Hierarchy.flatten(collection, View.class, view -> view.get(View.PROP_CAMERA) != null && ((CameraRecord)view.get(View.PROP_CAMERA).get()).frustum instanceof PerspectiveCamera.FrustumRecord));
        double d = DoubleStream.of(this.d_meshBounds.getWidth(), this.d_meshBounds.getHeight(), this.d_meshBounds.getDepth()).max().getAsDouble();
        double d2 = 1.0 / d;
        UnaryOperator unaryOperator = point3d -> new Point3d((point3d.x - this.d_meshBounds.getMinX()) * d2, (point3d.y - this.d_meshBounds.getMinY()) * d2, (point3d.z - this.d_meshBounds.getMinZ()) * d2);
        BiConsumer<CameraRecord, Integer> biConsumer = (cameraRecord, n) -> {
            boolean bl = cameraRecord.frustum instanceof PerspectiveCamera.FrustumRecord;
            double d = bl ? INIWriter.aperatureToZoom(FOV) : 1.0;
            d *= cameraRecord.zoom;
            boolean bl2 = n == 0;
            double[] dArray = INIWriter.getAxes(cameraRecord, Order.XYZ, bl2);
            double d2 = dArray[2] + 1.5707963267948966;
            if (d2 > Math.PI) {
                d2 -= Math.PI * 2;
            }
            double d3 = Math.toDegrees(d2);
            double d4 = dArray[1];
            double d5 = Math.toDegrees(d4);
            Point3d point3d = (Point3d)unaryOperator.apply(cameraRecord.loc);
            Point3d point3d2 = (Point3d)unaryOperator.apply(cameraRecord.ref);
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            switch (n) {
                case 0: {
                    d5 = -d5;
                    Matrix4d matrix4d = INIWriter.getSMVXform(point3d2, Math.toRadians(d3), Math.toRadians(d5));
                    matrix4d.transform(point3d);
                    matrix4d.transform(point3d2);
                    d8 = d3;
                    d9 = d5;
                    break;
                }
                case 1: {
                    if (d5 < -89.999) {
                        d5 = -89.999;
                    } else if (d5 > 89.999) {
                        d5 = 89.999;
                    }
                    d6 = d3;
                    d7 = d5;
                }
            }
            printWriter.printf("%f %f %f %f -1%n", point3d.x, point3d.y, point3d.z, d);
            printWriter.printf("0.0 %f %f %d%n", d6, d7, bl ? 0 : 1);
            printWriter.printf("%f %f %f%n", point3d2.x, point3d2.y, point3d2.z);
            printWriter.printf("%f %f%n", d8, d9);
            printWriter.printf("1.0 0.0 0.0 0.0%n", new Object[0]);
            printWriter.printf("0.0 1.0 0.0 0.0%n", new Object[0]);
            printWriter.printf("0.0 0.0 1.0 0.0%n", new Object[0]);
            printWriter.printf("0.0 0.0 0.0 1.0%n", new Object[0]);
        };
        Function<SectionBox, AABoxGeom> function = sectionBox -> {
            if (sectionBox == null) {
                return null;
            }
            IGeom iGeom = (IGeom)sectionBox.get();
            if (iGeom instanceof AABoxGeom) {
                return (AABoxGeom)iGeom;
            }
            if (iGeom.getNumPrims(1) != 6) {
                return null;
            }
            int n = 0;
            for (IPlanarFace iPlanarFace : GeomUtil.explode(Arrays.asList(iGeom), IPlanarFace.class)) {
                Vector3d vector3d = iPlanarFace.getPlane(true).getNormal();
                if (vector3d.epsilonEquals(GeomConstants.VEC3D_XNEG, 1.0E-6)) {
                    n |= 1;
                    continue;
                }
                if (vector3d.epsilonEquals(GeomConstants.VEC3D_XPOS, 1.0E-6)) {
                    n |= 2;
                    continue;
                }
                if (vector3d.epsilonEquals(GeomConstants.VEC3D_YNEG, 1.0E-6)) {
                    n |= 4;
                    continue;
                }
                if (vector3d.epsilonEquals(GeomConstants.VEC3D_YPOS, 1.0E-6)) {
                    n |= 8;
                    continue;
                }
                if (vector3d.epsilonEquals(GeomConstants.VEC3D_ZNEG, 1.0E-6)) {
                    n |= 0x10;
                    continue;
                }
                if (!vector3d.epsilonEquals(GeomConstants.VEC3D_ZPOS, 1.0E-6)) continue;
                n |= 0x20;
            }
            if (n == 63) {
                return new AABoxGeom(iGeom.getBoundingBox(new AABox()));
            }
            return null;
        };
        Consumer<SectionBox> consumer = sectionBox -> {
            AABoxGeom aABoxGeom = (AABoxGeom)function.apply((SectionBox)sectionBox);
            if (aABoxGeom == null) {
                printWriter.printf("0 0 0 0 0 0 0%n", new Object[0]);
                printWriter.printf("0 0 0 0 0 0%n", new Object[0]);
            } else {
                printWriter.printf("1 1 1 1 1 1 1%n", new Object[0]);
                printWriter.printf("%f %f %f %f %f %f%n", aABoxGeom.min.x, aABoxGeom.min.y, aABoxGeom.min.z, aABoxGeom.max.x, aABoxGeom.max.y, aABoxGeom.max.z);
            }
        };
        int n2 = 2;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            View view2 = arrayList.get(i);
            CameraState cameraState = view2.get(View.PROP_CAMERA);
            int n3 = 0;
            switch (view2.get(View.PROP_NAV_TOOL)) {
                case ROAM: {
                    n3 = 1;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            int n4 = 4;
            printWriter.println("VIEWPOINT5");
            printWriter.printf("%d %d %d%n", n3, n4, n2 + i);
            CameraRecord cameraRecord2 = (CameraRecord)cameraState.get();
            biConsumer.accept(cameraRecord2, n3);
            consumer.accept(view2.get(View.PROP_SECTION_BOX));
            String string = view2.getName();
            printWriter.println(string);
        }
    }

    private void writeUnitPrefs(IniWriter iniWriter) {
        if (PyroSim.getApp().getUnitSystem() instanceof EnglishUS) {
            iniWriter.write("UNITCLASSES", Units.values().length);
            PrintWriter printWriter = iniWriter.iniWriter;
            for (Units units : Units.values()) {
                printWriter.println(units.engUnit);
            }
        }
    }

    private static void writeTours(IniWriter iniWriter, Collection<? extends IPyroObject> collection) throws IOException {
    }

    private static Matrix4d getSMVXform(Point3d point3d, double d, double d2) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.mul(Util.translateMat(point3d.x, point3d.y, point3d.z));
        matrix4d.mul(Util.rotMat(1.0, 0.0, 0.0, d2));
        matrix4d.mul(Util.rotMat(0.0, 0.0, 1.0, d));
        matrix4d.mul(Util.translateMat(-point3d.x, -point3d.y, -point3d.z));
        return matrix4d;
    }

    private static double[] getAxes(CameraRecord cameraRecord, Order order, boolean bl) {
        Vector3d vector3d = Util3D.vectorN(cameraRecord.loc, cameraRecord.ref);
        Vector3d vector3d2 = cameraRecord.up;
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        Matrix3d matrix3d = new Matrix3d(vector3d.x, vector3d.y, vector3d.z, -vector3d3.x, -vector3d3.y, -vector3d3.z, vector3d2.x, vector3d2.y, vector3d2.z);
        return INIWriter.tr2rpy(matrix3d, order, 1.0E-9, bl);
    }

    private static double[] tr2rpy(Matrix3d matrix3d, Order order, double d, boolean bl) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        if (order == Order.XYZ) {
            if (bl || Math.abs(matrix3d.m22) < d && Math.abs(matrix3d.m12) < d) {
                dArray[0] = 0.0;
                dArray[1] = Math.atan2(matrix3d.m02, matrix3d.m22);
                dArray[2] = Math.atan2(matrix3d.m10, matrix3d.m11);
            } else {
                dArray[0] = Math.atan2(-matrix3d.m12, matrix3d.m22);
                double d2 = Math.sin(dArray[0]);
                double d3 = Math.cos(dArray[0]);
                dArray[1] = Math.atan2(matrix3d.m02, d3 * matrix3d.m22 - d2 * matrix3d.m12);
                dArray[2] = Math.atan2(-matrix3d.m01, matrix3d.m00);
            }
        } else if (bl || Math.abs(matrix3d.m00) < d && Math.abs(matrix3d.m10) < d) {
            dArray[0] = 0.0;
            dArray[1] = Math.atan2(-matrix3d.m20, matrix3d.m00);
            dArray[2] = Math.atan2(-matrix3d.m12, matrix3d.m11);
        } else {
            dArray[0] = Math.atan2(matrix3d.m10, matrix3d.m00);
            double d4 = Math.sin(dArray[0]);
            double d5 = Math.cos(dArray[0]);
            dArray[1] = Math.atan2(-matrix3d.m20, d5 * matrix3d.m00 + d4 * matrix3d.m10);
            dArray[2] = Math.atan2(d4 * matrix3d.m02 - d5 * matrix3d.m12, d5 * matrix3d.m11 - d4 * matrix3d.m01);
        }
        return dArray;
    }

    public static enum Units {
        TEMPERATURE(0, 1),
        VELOCITY(0, 2),
        DISTANCE(0, 1),
        VOLUME_FLOW(0, 1),
        MASS_FRACTION(0, 0),
        CONCENTRATION(0, 0);

        public final int siUnit;
        public final int engUnit;

        private Units(int n2, int n3) {
            this.siUnit = n2;
            this.engUnit = n3;
        }
    }

    private static class IniWriter {
        final PrintWriter iniWriter;

        public IniWriter(OutputStream outputStream) throws IOException {
            this.iniWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        }

        public void write(String string, Object ... objectArray) {
            this.iniWriter.println(string);
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    this.iniWriter.print(' ');
                }
                this.iniWriter.print(objectArray[i].toString());
            }
            this.iniWriter.println();
        }

        public void flush() {
            this.iniWriter.flush();
        }
    }

    private static enum Order {
        XYZ,
        ZYX;

    }
}

