/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.io.fds.LineScanner;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.util.FileWarningReport;

public class INIReader {
    private final FileWarningReport d_warnings = new FileWarningReport();
    private final AABox d_modelBounds;
    private final AABox d_gridBounds;
    private static final int ROTATION_3AXIS = 3;
    private static final int ROTATION_EYECENTERED = 1;
    private static final int ROTATION_2AXIS = 0;

    public INIReader(AABox aABox, AABox aABox2) {
        this.d_modelBounds = aABox;
        this.d_gridBounds = aABox2;
    }

    public FileWarningReport getWarnings() {
        return this.d_warnings;
    }

    public Collection<IPyroObject> read(InputStream inputStream) throws IOException, ParseException {
        Object object;
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        Type type = Type.UNKNOWN;
        LineScanner lineScanner = new LineScanner(inputStream);
        try {
            while (true) {
                try {
                    object = lineScanner.nextLine();
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                if (object == null) break;
                try {
                    type = Type.valueOf(((String)object).trim().toUpperCase());
                }
                catch (Throwable throwable) {
                    type = Type.UNKNOWN;
                }
                switch (type) {
                    case VIEWPOINT5: {
                        this.readViewpoint5(lineScanner, arrayList);
                        break;
                    }
                    case VIEWPOINT6: {
                        this.readViewpoint6(lineScanner, arrayList);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new ParseException(throwable.getLocalizedMessage(), lineScanner.line);
        }
        object = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            object.add(arrayList.get(i));
        }
        return object;
    }

    private void readViewpoint5(LineScanner lineScanner2, Collection<IPyroObject> collection) throws Throwable {
        this.readViewpoint(lineScanner2, collection, lineScanner -> {
            lineScanner.nextDoubles(4);
            lineScanner.nextLine();
            lineScanner.nextDoubles(4);
            lineScanner.nextLine();
            lineScanner.nextDoubles(4);
            lineScanner.nextLine();
            lineScanner.nextDoubles(4);
            lineScanner.nextLine();
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            return matrix4d;
        });
    }

    private void readViewpoint6(LineScanner lineScanner2, Collection<IPyroObject> collection) throws Throwable {
        this.readViewpoint(lineScanner2, collection, lineScanner -> {
            double[] dArray = lineScanner.nextDoubles(4);
            lineScanner.nextLine();
            Quat4d quat4d = new Quat4d(dArray);
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.set(quat4d);
            return matrix4d;
        });
    }

    private void readViewpoint(LineScanner lineScanner, Collection<IPyroObject> collection, CheckedFunction<LineScanner, Matrix4d, Throwable> checkedFunction) throws Throwable {
        View.NavTool navTool;
        double[] dArray;
        double d;
        boolean bl = false;
        int n = lineScanner.nextInt();
        lineScanner.nextInt();
        lineScanner.nextInt();
        lineScanner.nextLine();
        double[] dArray3 = lineScanner.nextDoubles(3);
        double d2 = lineScanner.nextDouble();
        d2 = 1.0;
        lineScanner.nextInt();
        lineScanner.nextLine();
        double d3 = lineScanner.nextDouble();
        double d4 = lineScanner.nextDouble();
        double d5 = lineScanner.nextDouble();
        int n2 = lineScanner.nextInt();
        if (n2 != 0) {
            this.d_warnings.addWarning(lineScanner.newWarning(Intl.intl("Orthographic projections are not supported."), Intl.intl("Skipped viewpoint.")));
            bl = true;
        }
        lineScanner.nextLine();
        double[] dArray4 = lineScanner.nextDoubles(3);
        lineScanner.nextLine();
        double[] dArray5 = lineScanner.nextDoubles(2);
        lineScanner.nextLine();
        Matrix4d matrix4d = checkedFunction.apply(lineScanner);
        int n3 = lineScanner.nextInt();
        int[] nArray = lineScanner.nextInts(6);
        lineScanner.nextLine();
        double[] dArray6 = lineScanner.nextDoubles(6);
        lineScanner.nextLine();
        String string = lineScanner.nextLine();
        if (bl) {
            return;
        }
        View view = new View(string);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setIdentity();
        double d6 = d = !this.d_gridBounds.isValid() ? 1.0 : DoubleStream.of(this.d_gridBounds.getWidth(), this.d_gridBounds.getHeight(), this.d_gridBounds.getDepth()).max().getAsDouble();
        if (!this.d_gridBounds.isValid()) {
            double[] dArray7 = new double[3];
            dArray7[0] = 0.0;
            dArray7[1] = 0.0;
            dArray = dArray7;
            dArray7[2] = 0.0;
        } else {
            double[] dArray8 = new double[3];
            dArray8[0] = this.d_gridBounds.getMinX();
            dArray8[1] = this.d_gridBounds.getMinY();
            dArray = dArray8;
            dArray8[2] = this.d_gridBounds.getMinZ();
        }
        double[] dArray9 = dArray;
        UnaryOperator unaryOperator = dArray2 -> {
            double[] dArray3 = Arrays.copyOf(dArray2, ((double[])dArray2).length);
            for (int i = 0; i < ((double[])dArray2).length; ++i) {
                dArray3[i] = dArray2[i] * d + dArray9[i];
            }
            return dArray3;
        };
        double d7 = 0.0;
        double d8 = Math.PI / 180;
        double[] dArray10 = dArray5;
        double d9 = d4;
        double d10 = d5;
        double[] dArray11 = (double[])unaryOperator.apply(dArray4);
        double[] dArray12 = new double[]{0.0, 0.0, 1.0};
        double[] dArray13 = (double[])unaryOperator.apply(dArray3);
        double[] dArray14 = new double[]{0.0, 90.0, 0.0};
        double d11 = dArray14[0];
        double d12 = dArray14[1];
        Vector3d vector3d = new Vector3d(Math.cos(d8 * d11) * Math.cos(d8 * d12), Math.sin(d8 * d11) * Math.cos(d8 * d12), Math.sin(d8 * d12));
        double[] dArray15 = dArray13;
        double d13 = Math.sin(d8 * d3);
        double d14 = Math.cos(d8 * d3);
        double d15 = Math.sin(d8 * d9);
        double d16 = Math.cos(d8 * d9);
        double d17 = dArray11[0];
        double d18 = dArray11[1];
        double d19 = dArray11[2];
        double d20 = Math.cos(d8 * d10);
        double d21 = Math.sin(d8 * d10);
        double d22 = d15 * d14 + d16 * d13;
        double d23 = d16 * d14 - d15 * d13;
        double d24 = dArray15[0] + d7 * d23;
        double d25 = dArray15[1] - d7 * d22;
        double d26 = dArray15[2];
        double d27 = d24 + d22 * d20;
        double d28 = d25 + d23 * d20;
        double d29 = d26 + d21;
        double d30 = dArray10[1];
        double d31 = dArray10[0];
        double[] dArray16 = dArray12;
        matrix4d2.mul(INIReader.gluLookAt(d24, d25, d26, d27, d28, d29, dArray16[0], dArray16[1], dArray16[2]));
        matrix4d2.mul(Util.translateMat(d17, d18, d19));
        Tuple3d tuple3d = new Vector3d(0.0, 0.0, 1.0);
        Tuple3d tuple3d2 = new Vector3d();
        double d32 = INIReader.rotateu2v(vector3d, tuple3d, tuple3d2);
        matrix4d2.mul(Util.rotMat(tuple3d2.x, tuple3d2.y, tuple3d2.z, d32));
        matrix4d2.mul(Util.rotMat(tuple3d.x, tuple3d.y, tuple3d.z, d8 * dArray14[2]));
        if (n == 3) {
            matrix4d2.mul(matrix4d);
        } else {
            if (n == 0) {
                matrix4d2.mul(Util.rotMat(1.0, 0.0, 0.0, d8 * d30));
            }
            matrix4d2.mul(Util.rotMat(0.0, 0.0, 1.0, d8 * d31));
        }
        matrix4d2.mul(Util.translateMat(-d17, -d18, -d19));
        try {
            matrix4d2.invert();
        }
        catch (Throwable throwable) {
            this.d_warnings.addWarning(lineScanner.newWarning(String.format(Intl.intl("Cannot reconstruct view angle from viewpoint, \"%s\"."), string), Intl.intl("Skipped viewpoint.")));
            return;
        }
        tuple3d = new Point3d(0.0, 0.0, 0.0);
        tuple3d2 = new Point3d(0.0, 0.0, -1.0);
        Vector3d vector3d2 = new Vector3d(0.0, 1.0, 0.0);
        matrix4d2.transform((Point3d)tuple3d);
        matrix4d2.transform((Point3d)tuple3d2);
        matrix4d2.transform(vector3d2);
        double d33 = new Point3d(dArray13).distance(new Point3d(dArray11));
        Vector3d vector3d3 = Util3D.vectorN((Point3d)tuple3d, (Point3d)tuple3d2);
        vector3d3.scale(d33);
        tuple3d2 = Util3D.add((Point3d)tuple3d, (Tuple3d)vector3d3);
        CameraRecord cameraRecord = new CameraRecord((Point3d)tuple3d, (Point3d)tuple3d2, vector3d2, d2, new Point2d(0.0, 0.0), 0.1, 10000.0, new PerspectiveCamera.FrustumRecord(0.7853981633974483));
        switch (n) {
            case 1: {
                navTool = View.NavTool.ROAM;
                break;
            }
            default: {
                navTool = View.NavTool.ORBIT;
            }
        }
        view.set(View.PROP_CAMERA, new CameraState(cameraRecord));
        view.set(View.PROP_NAV_TOOL, navTool);
        if (n3 != 0) {
            AABox aABox = this.d_modelBounds.scale(1.1);
            double[] dArray17 = new double[]{aABox.getMinX(), aABox.getMinY(), aABox.getMinZ(), aABox.getMaxX(), aABox.getMaxY(), aABox.getMaxZ()};
            for (int i = 0; i < 6; ++i) {
                if (nArray[i] == 0) continue;
                dArray17[i] = dArray6[i];
            }
            aABox = new AABox(dArray17[0], dArray17[1], dArray17[2], dArray17[3], dArray17[4], dArray17[5]);
            SectionBox sectionBox = new SectionBox(new AABoxGeom(aABox));
            view.set(View.PROP_SECTION_BOX, sectionBox);
        }
        collection.add(view);
    }

    private static double rotateu2v(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        vector3d3.cross(vector3d, vector3d2);
        double d = Util3D.safeNormalize(vector3d3, 0.0);
        double d2 = Util3D.safeNormalize(vector3d, 0.0);
        double d3 = Util3D.safeNormalize(vector3d2, 0.0);
        if (d > 0.0 && d2 > 0.0 && d3 > 0.0) {
            vector3d3.x /= d;
            vector3d3.y /= d;
            vector3d3.z /= d;
            double d4 = Util.clampT(vector3d.dot(vector3d2) / (d2 * d3), -1.0, 1.0);
            return Math.acos(d4);
        }
        vector3d3.x = 0.0;
        vector3d3.y = 0.0;
        vector3d3.z = 1.0;
        return 0.0;
    }

    private static Matrix4d gluLookAt(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        Vector3d vector3d = Util3D.vectorN(new Point3d(d, d2, d3), new Point3d(d4, d5, d6));
        Vector3d vector3d2 = new Vector3d(d7, d8, d9);
        vector3d2.normalize();
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        vector3d2 = Util3D.cross(vector3d3, vector3d);
        Matrix4d matrix4d = new Matrix4d(vector3d3.x, vector3d3.y, vector3d3.z, 0.0, vector3d2.x, vector3d2.y, vector3d2.z, 0.0, -vector3d.x, -vector3d.y, -vector3d.z, 0.0, 0.0, 0.0, 0.0, 1.0);
        matrix4d.mul(Util.translateMat(-d, -d2, -d3));
        return matrix4d;
    }

    private static List<String> getTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private static interface CheckedFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    private static enum Type {
        UNKNOWN,
        VIEWPOINT5,
        VIEWPOINT6;

    }
}

