/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.APyroObject;
import pyrosim.domain.AWriteablePyroObject;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ALogicOp;
import pyrosim.domain.controls.AndOp;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.NotOp;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.view.ViewList;
import pyrosim.gui.actions.ExportPyroFloorsAction;
import pyrosim.gui.actions.ExportPyroViewsAction;
import pyrosim.io.GE1File;
import pyrosim.io.PyroGeomFile;
import pyrosim.io.fds.FDSEnabledFilter;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.INIWriter;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.RTree;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public abstract class FDSRenderer {
    private final PyroMod d_model;
    private final FDSRenderProps d_props;

    public Collection<IPyroObject> collectPyroObjects() {
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        linkedIdentityHashSet.add(this.d_model.getSimParams());
        linkedIdentityHashSet.addAll(this.d_model.getObstructions().flatten());
        linkedIdentityHashSet.addAll(this.d_model.getGridManager().flatten());
        linkedIdentityHashSet.addAll(this.d_model.getBridges().flatten());
        linkedIdentityHashSet.addAll(Util.sort(this.d_model.getZoneMgr()));
        linkedIdentityHashSet.addAll(Util.sort(this.d_model.getExSpecList().getInitialFractions()));
        if (this.d_model.getExSpecList().getBackgroundSpecies() != null) {
            linkedIdentityHashSet.add(this.d_model.getExSpecList().getBackgroundSpecies());
        }
        linkedIdentityHashSet.addAll(this.d_model.getReactions().getActiveReactions());
        linkedIdentityHashSet.addAll(((APyroObject)this.d_model.getHvacList()).flatten(HvacLeak.class));
        linkedIdentityHashSet.addAll(this.d_model.getDevices().flatten());
        linkedIdentityHashSet.add(this.d_model.getBoundaryOutput());
        linkedIdentityHashSet.add(this.d_model.getPlot3d());
        linkedIdentityHashSet.addAll(this.d_model.getIsofList().flatten());
        linkedIdentityHashSet.addAll(this.d_model.getProfList().flatten());
        linkedIdentityHashSet.addAll(this.d_model.getSlcfList().flatten());
        linkedIdentityHashSet.addAll(this.d_model.getSlcf3dList().flatten());
        linkedIdentityHashSet.addAll(this.d_model.getMsrStatMgr().flatten());
        linkedIdentityHashSet.addAll(this.d_model.getViews().flatten());
        if (this.d_model.getFdsEvacEnabled()) {
            linkedIdentityHashSet.addAll(this.d_model.getPersList().flatten());
            linkedIdentityHashSet.addAll(this.d_model.getExitList().flatten());
            linkedIdentityHashSet.addAll(this.d_model.getEvacList().flatten());
            linkedIdentityHashSet.addAll(this.d_model.getEntrList().flatten());
            linkedIdentityHashSet.addAll(this.d_model.getEvhoList().flatten());
            linkedIdentityHashSet.addAll(this.d_model.getDoorList().flatten());
            linkedIdentityHashSet.addAll(this.d_model.getCorrList().flatten());
            linkedIdentityHashSet.addAll(this.d_model.getEvssList().flatten());
        }
        linkedIdentityHashSet.addAll(this.collectForceToWriteObjs());
        assert (!linkedIdentityHashSet.contains(null));
        return theUtil.filter(linkedIdentityHashSet, new FDSEnabledFilter());
    }

    private Collection<IPyroObject> collectForceToWriteObjs() {
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        Predicate<IPyroObject> predicate = iPyroObject -> iPyroObject instanceof AWriteablePyroObject && ((AWriteablePyroObject)iPyroObject).isForceWrite();
        arrayList.addAll(this.d_model.getExSpecList().flatten(predicate));
        arrayList.addAll(this.d_model.getReactions().flatten(predicate));
        arrayList.addAll(this.d_model.getSurfaceMgr().flatten(predicate));
        arrayList.addAll(this.d_model.getMaterialMgr().flatten(predicate));
        arrayList.addAll(this.d_model.getPartList().flatten(predicate));
        arrayList.addAll(this.d_model.getHeatLinkModels().flatten(predicate));
        arrayList.addAll(this.d_model.getSmokeLinkModels().flatten(predicate));
        arrayList.addAll(this.d_model.getSprinklerLinkModels().flatten(predicate));
        arrayList.addAll(this.d_model.getSprayModels().flatten(predicate));
        arrayList.addAll(this.d_model.getHvacList().flatten(predicate));
        return arrayList;
    }

    public abstract void renderObjects(IFDSRecordRenderer var1, Collection<? extends IPyroObject> var2, DepSnapshot var3, Map<IImage, String> var4);

    protected abstract void renderFileForVersion(File var1, Collection<? extends IPyroObject> var2, DepSnapshot var3) throws IOException;

    protected FDSRenderer(PyroMod pyroMod, FDSRenderProps fDSRenderProps) {
        this.d_model = pyroMod;
        this.d_props = fDSRenderProps.clone();
    }

    public FDSRenderProps getProps() {
        return this.d_props;
    }

    protected PyroMod getModel() {
        return this.d_model;
    }

    public void renderFile(File file) throws IOException {
        this.renderFile(file, this.collectPyroObjects());
    }

    public void renderFile(File file, Collection<? extends IPyroObject> collection) throws IOException {
        Prep prep = this.prepareObjs(collection, PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM), this.d_model.getUnprocessedRecords());
        this.renderFileForVersion(file, prep.objs, prep.deps);
    }

    public void renderAllObjects(IFDSRecordRenderer iFDSRecordRenderer, Map<IImage, String> map) {
        Collection<IPyroObject> collection = this.collectPyroObjects();
        this.renderObjects(iFDSRecordRenderer, collection, map);
    }

    public void renderObjects(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection, Map<IImage, String> map) {
        Prep prep = this.prepareObjs(collection, false, "");
        this.renderObjects(iFDSRecordRenderer, prep.objs, prep.deps, map);
    }

    private static boolean getAdditionalRecordsHasGeom(String string) {
        if (string.isEmpty()) {
            return false;
        }
        try {
            HashSet<String> hashSet = Sets.fromArrayHS("OBST", "HOLE", "VENT");
            Pattern pattern = Pattern.compile("&\\s*([a-zA-Z0-9]+)[^/&]*/");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(1);
                if (!hashSet.contains(string2.toUpperCase())) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            assert (false);
            throwable.printStackTrace();
        }
        return false;
    }

    public Prep prepareObjs(Collection<? extends IPyroObject> collection, boolean bl, String string) {
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(collection);
        if (bl || this.d_model.getRastOptions().immersedBoundary) {
            this.d_props.setLinkPyroGeom(!FDSRenderer.getAdditionalRecordsHasGeom(string));
            FDSRenderer.splitObstructions(this.d_props, this.d_model.getRastOptions(), arrayList);
        }
        DepSnapshot depSnapshot = new DepSnapshot();
        for (IPyroObject iPyroObject : arrayList) {
            depSnapshot.takeSnapshot(iPyroObject);
        }
        return new Prep(arrayList, depSnapshot);
    }

    protected static boolean writeGE1(File file, String string, PyroMod pyroMod, Map<IImage, String> map) throws IOException {
        return GE1File.writeFile(new File(file, string).getAbsolutePath(), pyroMod, map);
    }

    private static Predicate<IHole> getPrecutHoleFilter(RasterizationOptions rasterizationOptions, boolean bl) {
        boolean bl2 = rasterizationOptions.immersedBoundary;
        if (bl2) {
            return Filters.alwaysTrue();
        }
        if (!bl) {
            return Filters.alwaysFalse();
        }
        return iHole -> !iHole.getInputPin().getConnections().isEmpty();
    }

    protected static boolean writeGeom(File file, String string, PyroMod pyroMod, Collection<? extends IPyroObject> collection, boolean bl, Map<IObstruction, List<Integer>> map, Map<Vent, Integer> map2, boolean bl2) throws IOException {
        Predicate<IHole> predicate = FDSRenderer.getPrecutHoleFilter(pyroMod.getRastOptions(), bl).negate();
        return PyroGeomFile.write(file, string, pyroMod, collection, bl, map, map2, bl2, predicate);
    }

    private static void splitObstructions(FDSRenderProps fDSRenderProps, RasterizationOptions rasterizationOptions, List<IPyroObject> list) {
        IFilteredCollection<IHole> iFilteredCollection = theUtil.filter(list, IHole.class, FDSRenderer.getPrecutHoleFilter(rasterizationOptions, fDSRenderProps.getLinkPyroGeom()));
        if (iFilteredCollection.isEmpty()) {
            return;
        }
        RTree<IHole> rTree = new RTree<IHole>();
        for (IHole object22 : iFilteredCollection) {
            rTree.insert(object22.getBounds(), object22);
        }
        List<IHole> list2 = Collections.synchronizedList(new ArrayList<IHole>(iFilteredCollection));
        List list3 = Collections.synchronizedList(new ArrayList());
        Function<ISignalSink, ControlBridge> function = iSignalSink -> {
            ControlBridge controlBridge;
            if (!iSignalSink.getInputPin().getConnections().isEmpty() && !(controlBridge = (ControlBridge)iSignalSink.getInputPin().getConnectedSources().iterator().next()).getInputPin().getConnections().isEmpty()) {
                return controlBridge;
            }
            return null;
        };
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (int interruptedException = 0; interruptedException < list.size(); ++interruptedException) {
            IPyroObject iPyroObject = list.get(interruptedException);
            if (!(iPyroObject instanceof IObstruction)) continue;
            Serializable serializable = (IObstruction)iPyroObject;
            executorService.submit(() -> FDSRenderer.lambda$splitObstructions$354(rTree, (IObstruction)serializable, list2, iPyroObject, function, list3));
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException hashMap) {
            hashMap.printStackTrace();
        }
        list.removeAll(list2);
        HashMap<Pair, ControlBridge> hashMap = new HashMap<Pair, ControlBridge>();
        for (Serializable serializable : list3) {
            IObstruction iObstruction = (IObstruction)((Pair)serializable).v1;
            IHole iHole = (IHole)((Pair)serializable).v2;
            if (iHole != null) {
                ControlBridge controlBridge = function.apply(iHole);
                assert (controlBridge != null);
                ControlBridge controlBridge2 = function.apply(iObstruction);
                ControlBridge controlBridge3 = hashMap.computeIfAbsent(new Pair<ControlBridge, ControlBridge>(controlBridge2, controlBridge), pair -> {
                    AControl aControl;
                    String string = String.format("%s_invert", controlBridge.getName());
                    AControl aControl2 = new NotOp();
                    aControl2.getInputPin().connect(controlBridge.getInputPin().getConnections().iterator().next());
                    if (controlBridge2 != null) {
                        string = String.format("%s_and_%s", controlBridge2.getName(), string);
                        aControl = new AndOp();
                        ((ALogicOp)aControl).getInputPin().connect(aControl2.getOutputPins().get(0));
                        ((ALogicOp)aControl).getInputPin().connect(controlBridge2.getInputPin().getConnections().iterator().next());
                        aControl2 = aControl;
                    }
                    aControl = new ControlBridge(string);
                    ((ControlBridge)aControl).getInputPin().connect(aControl2.getOutputPins().get(0));
                    return aControl;
                });
                iObstruction.getInputPin().disconnectAll();
                iObstruction.getInputPin().connect(controlBridge3.getOutputPins().get(0));
            }
            list.add(iObstruction);
        }
    }

    protected static void write(File file, String string, boolean bl, Collection<? extends IPyroObject> collection) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(file, string)));){
            AABox aABox = new AABox();
            for (Grid grid : Hierarchy.flatten(collection, Grid.class)) {
                aABox.add(grid.getBounds());
            }
            INIWriter iNIWriter = new INIWriter(aABox);
            iNIWriter.write(bufferedOutputStream, bl, PyroPrefs.getBoolean(PyroPrefs.RESULTS_DISPLAYGE1), !PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS), collection);
        }
    }

    protected static void writeViews(File file, String string, ViewList viewList) {
        try {
            ExportPyroViewsAction.writeViewsFile(new File(file, string), viewList);
        }
        catch (IOException iOException) {
            System.out.println(String.format("Could not write file: %s", string));
        }
    }

    protected static void writeFloors(File file, String string, FloorManager floorManager) {
        try {
            ExportPyroFloorsAction.writeFloorsFile(new File(file, string), floorManager);
        }
        catch (IOException iOException) {
            System.out.println(String.format("Could not write file: %s", string));
        }
    }

    protected static Map<IImage, String> copyImages(MaterialDB materialDB, File file, Collection<? extends IPyroObject> collection) {
        Object object;
        Object object2;
        LinkedIdentityHashMap<IImage, String> linkedIdentityHashMap = new LinkedIdentityHashMap<IImage, String>();
        for (Surface object3 : theUtil.filter(collection, Surface.class)) {
            object2 = object3.getAppearance();
            if (object2 == null || (object = ((Material)object2).getAttributes().getTexture(MatChannel.DIFFUSE)) == null) continue;
            linkedIdentityHashMap.put(((Texture)object).image, null);
        }
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            object2 = (IImage)entry.getKey();
            object = FDSRenderer.writeImage(file, object2.getFilename(), (IImage)object2);
            entry.setValue(object);
        }
        return linkedIdentityHashMap;
    }

    protected static String writeImage(File file, String string, IImage iImage) {
        File file2 = new File(iImage.getFilename());
        String string2 = file2.getName();
        File file3 = new File(file, string2);
        int n = 1;
        if (!file3.exists()) {
            System.out.printf("Saving image %s...", string2);
            iImage.save(file3.getAbsolutePath(), n);
            System.out.println("Done");
        } else if (FDSRenderer.getWriteAlternateImage(iImage, file3)) {
            String string3 = String.format("%d-%dx%d.png", string.hashCode(), iImage.getWidth(), iImage.getHeight());
            file3 = new File(file, string3);
            System.out.printf("A file called \"%s\" already exists! Using alternate name \"%s\"%n", string2, string3);
            iImage.save(file3.getPath(), n);
            string2 = string3;
        }
        return string2;
    }

    private static boolean getWriteAlternateImage(IImage iImage, File file) {
        String string = file.getPath();
        IStreamSrc iStreamSrc = FileSystem.INSTANCE.getStreamSrc(string, 3);
        try {
            Image image = Image.load(string, iStreamSrc);
            if (iImage.makeHashable().equals(image)) {
                System.out.printf("Image \"%s\" already exists and is equal. Write skipped.%n", file.getName());
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public static String getProperCHID(String string, int n) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        File file = new File(string2);
        int n2 = (string2 = file.getName()).lastIndexOf(46);
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        string2 = string2.replace('.', '_');
        if ((string2 = string2.replace(' ', '_')).length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String getProperTitle(String string, int n) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private static /* synthetic */ void lambda$splitObstructions$354(RTree rTree, IObstruction iObstruction, List list, IPyroObject iPyroObject, Function function, List list2) {
        Supplier<Collection<? extends IHole>> supplier = () -> {
            ArrayList arrayList = new ArrayList();
            rTree.find(new AABoxTest(iObstruction.getBounds(), 1.0E-6), (iHole, containment) -> arrayList.add(iHole));
            return arrayList;
        };
        List<Pair<IObstruction, IHole>> list3 = iObstruction.intersectHoles(supplier);
        if (list3.isEmpty()) {
            return;
        }
        list.add(iPyroObject);
        for (Pair<IObstruction, IHole> pair : list3) {
            if (pair.v2 != null && function.apply(pair.v2) == null) continue;
            list2.add(pair);
        }
    }

    public static class Prep {
        public final Collection<? extends IPyroObject> objs;
        public final DepSnapshot deps;

        public Prep(Collection<? extends IPyroObject> collection, DepSnapshot depSnapshot) {
            this.objs = collection;
            this.deps = depSnapshot;
        }
    }

    public static class Filenames {
        public final File dir;
        public final String chid;
        public final String fds;
        public final String ge1;
        public final String geom;
        public final String ini;
        public final String views;
        public final String floors;

        public Filenames(File file) {
            String string;
            this.fds = string = file.getName();
            this.dir = file.getParentFile();
            this.chid = FDSRenderer.getProperCHID(string, 40);
            this.ge1 = this.chid + ".ge1";
            this.geom = this.chid + ".pyrogeom";
            this.ini = this.chid + ".ini";
            this.views = this.chid + '.' + "views";
            this.floors = this.chid + '.' + "pyrofloors";
        }
    }
}

